/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class RayTraceHandler {
    public static RayTraceResult rayTrace(World world, EntityPlayer player, boolean stopOnLiquid) {
        return RayTraceHandler.rayTrace(world, (Entity)player, stopOnLiquid, RayTraceHandler.getEntityRange((EntityLivingBase)player));
    }

    public static RayTraceResult rayTrace(World world, Entity player, boolean stopOnLiquid, double range) {
        Pair<Vec3d, Vec3d> params = RayTraceHandler.getEntityParams(player);
        return RayTraceHandler.rayTrace(world, (Vec3d)params.getLeft(), (Vec3d)params.getRight(), stopOnLiquid, range);
    }

    public static RayTraceResult rayTrace(World world, Vec3d startPos, Vec3d ray, boolean stopOnLiquid, double range) {
        return RayTraceHandler.rayTrace(world, startPos, ray.func_186678_a(range), stopOnLiquid);
    }

    public static RayTraceResult rayTrace(World world, Vec3d startPos, Vec3d ray, boolean stopOnLiquid) {
        Vec3d end = startPos.func_178787_e(ray);
        return world.func_72901_a(startPos, end, stopOnLiquid);
    }

    public static double getEntityRange(EntityLivingBase player) {
        return player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
    }

    public static Pair<Vec3d, Vec3d> getEntityParams(Entity player) {
        float scale = 1.0f;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * scale;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * scale;
        double posX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)scale;
        double posY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)scale;
        if (player instanceof EntityPlayer) {
            posY += (double)((EntityPlayer)player).eyeHeight;
        }
        double posZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)scale;
        Vec3d rayPos = new Vec3d(posX, posY, posZ);
        float zYaw = -MathHelper.func_76134_b((float)(yaw * (float)Math.PI / 180.0f));
        float xYaw = MathHelper.func_76126_a((float)(yaw * (float)Math.PI / 180.0f));
        float pitchMod = -MathHelper.func_76134_b((float)(pitch * (float)Math.PI / 180.0f));
        float azimuth = -MathHelper.func_76126_a((float)(pitch * (float)Math.PI / 180.0f));
        float xLen = xYaw * pitchMod;
        float yLen = zYaw * pitchMod;
        Vec3d ray = new Vec3d((double)xLen, (double)azimuth, (double)yLen);
        return Pair.of((Object)rayPos, (Object)ray);
    }
}

