/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.experimental.lighting;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.quark.experimental.features.ColoredLights;

public class LightSource {
    public final World world;
    public final BlockPos pos;
    public final IBlockState state;
    public final byte brightness;
    public byte[][][] incidences = null;

    public LightSource(World world, BlockPos pos, IBlockState state, int brightness) {
        this.world = world;
        this.pos = pos;
        this.state = state;
        this.brightness = (byte)brightness;
    }

    public void newFrame() {
        this.incidences = null;
    }

    public int getIncidence(BlockPos checkPos) {
        int dist = this.manhattanDistance(checkPos);
        if (dist >= this.brightness) {
            return 0;
        }
        if (ColoredLights.simulateTravel) {
            if (this.incidences == null) {
                this.computeIncidences();
            }
            int[] coords = this.posToIndex(checkPos);
            return this.getIncidenceAtCoords(coords);
        }
        return 15 - dist;
    }

    public boolean isValid(World world) {
        return world.func_175667_e(this.pos) && world.func_180495_p(this.pos).equals(this.state);
    }

    public final int manhattanDistance(BlockPos target) {
        return Math.abs(this.pos.func_177958_n() - target.func_177958_n()) + Math.abs(this.pos.func_177956_o() - target.func_177956_o()) + Math.abs(this.pos.func_177952_p() - target.func_177952_p());
    }

    public void computeIncidences() {
        int size = this.brightness * 2 + 1;
        this.incidences = new byte[size][size][size];
        Edge[] edges = new Edge[size * size * 2];
        Edge[] edges2 = new Edge[edges.length];
        edges[0] = new Edge(this.pos, this.brightness);
        while (edges[0] != null) {
            int newIndex = 0;
            for (Edge edge : edges) {
                if (edge == null) break;
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    int[] coords;
                    byte curr;
                    Edge next = edge.next((IBlockAccess)this.world, face);
                    if (next == null || next.light <= (curr = this.getIncidenceAtCoords(coords = this.posToIndex(next.pos)))) continue;
                    this.pushByteToCoords(coords, next.light);
                    if (newIndex >= edges2.length) {
                        return;
                    }
                    edges2[newIndex++] = next;
                }
            }
            Edge[] tempEdges = edges;
            edges2[newIndex] = null;
            edges = edges2;
            edges2 = tempEdges;
        }
    }

    public int[] posToIndex(BlockPos target) {
        int dX = this.pos.func_177958_n() - target.func_177958_n() + this.brightness;
        int dY = this.pos.func_177956_o() - target.func_177956_o() + this.brightness;
        int dZ = this.pos.func_177952_p() - target.func_177952_p() + this.brightness;
        return new int[]{dX, dY, dZ};
    }

    public byte getIncidenceAtCoords(int[] coords) {
        return this.incidences[coords[0]][coords[1]][coords[2]];
    }

    public void pushByteToCoords(int[] coords, byte b) {
        this.incidences[coords[0]][coords[1]][coords[2]] = b;
    }

    public boolean equals(Object obj) {
        return obj == this || this.pos.equals(obj) || obj != null && obj instanceof LightSource && ((LightSource)obj).pos.equals((Object)this.pos);
    }

    private static class Edge {
        public final BlockPos pos;
        public final byte light;

        public Edge(BlockPos pos, byte light) {
            this.pos = pos;
            this.light = light;
        }

        public Edge next(IBlockAccess world, EnumFacing face) {
            BlockPos nextPos = this.pos.func_177972_a(face);
            byte opacity = (byte)world.func_180495_p(nextPos).getLightOpacity(world, nextPos);
            if (opacity < 0) {
                return null;
            }
            byte nextLight = (byte)(this.light - opacity - 1);
            if (nextLight <= 0) {
                return null;
            }
            return new Edge(nextPos, nextLight);
        }
    }
}

