/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.client.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.util.ItemNBTHelper;

public class ClockTimeGetter
implements IItemPropertyGetter {
    private static final String TAG_CALCULATED = "quark:clock_calculated";
    private double rotation;
    private double rota;
    private long lastUpdateTick;

    public static void tickClock(ItemStack stack) {
        boolean calculated = ClockTimeGetter.isCalculated(stack);
        if (!calculated) {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)true);
        }
    }

    static boolean isCalculated(ItemStack stack) {
        return stack.func_77942_o() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_CALCULATED, (boolean)false);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
        EntityLivingBase entity;
        if (!ClockTimeGetter.isCalculated(stack)) {
            return 0.0f;
        }
        boolean carried = entityIn != null;
        Object object = entity = carried ? entityIn : stack.func_82836_z();
        if (worldIn == null && entity != null) {
            worldIn = entity.field_70170_p;
        }
        if (worldIn == null) {
            return 0.0f;
        }
        double angle = worldIn.field_73011_w.func_76569_d() ? (double)worldIn.func_72826_c(1.0f) : Math.random();
        angle = this.wobble(worldIn, angle);
        return (float)angle;
    }

    private double wobble(World world, double time) {
        if (world.func_82737_E() != this.lastUpdateTick) {
            this.lastUpdateTick = world.func_82737_E();
            double d0 = time - this.rotation;
            d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.rota += d0 * 0.1;
            this.rota *= 0.9;
            this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
        }
        return this.rotation;
    }
}

