/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.network;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;

public abstract class NetworkMessage<REQ extends NetworkMessage>
implements Serializable,
IMessage,
IMessageHandler<REQ, IMessage> {
    private static final HashMap<Class, Pair<Reader, Writer>> handlers = new HashMap();
    private static final HashMap<Class, Field[]> fieldCache = new HashMap();

    public IMessage handleMessage(MessageContext context) {
        return null;
    }

    public final IMessage onMessage(REQ message, MessageContext context) {
        return ((NetworkMessage)message).handleMessage(context);
    }

    public final void fromBytes(ByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = NetworkMessage.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!NetworkMessage.acceptField(f, type)) continue;
                this.readField(f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading packet " + this, e);
        }
    }

    public final void toBytes(ByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = NetworkMessage.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!NetworkMessage.acceptField(f, type)) continue;
                this.writeField(f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing packet " + this, e);
        }
    }

    private static Field[] getClassFields(Class<?> clazz) {
        if (fieldCache.containsKey(clazz)) {
            return fieldCache.get(clazz);
        }
        Field[] fields = clazz.getFields();
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        fieldCache.put(clazz, fields);
        return fields;
    }

    private void writeField(Field f, Class clazz, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = NetworkMessage.getHandler(clazz);
        ((Writer)handler.getRight()).write(f.get(this), buf);
    }

    private void readField(Field f, Class clazz, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = NetworkMessage.getHandler(clazz);
        f.set(this, ((Reader)handler.getLeft()).read(buf));
    }

    private static Pair<Reader, Writer> getHandler(Class<?> clazz) {
        Pair<Reader, Writer> pair = handlers.get(clazz);
        if (pair == null) {
            throw new RuntimeException("No R/W handler for  " + clazz);
        }
        return pair;
    }

    private static boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        return handlers.containsKey(type);
    }

    public static <T> void mapHandler(Class<T> type, Reader<T> reader, Writer<T> writer) {
        handlers.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    private static byte readByte(ByteBuf buf) {
        return buf.readByte();
    }

    private static void writeByte(byte b, ByteBuf buf) {
        buf.writeByte((int)b);
    }

    private static short readShort(ByteBuf buf) {
        return buf.readShort();
    }

    private static void writeShort(short s, ByteBuf buf) {
        buf.writeShort((int)s);
    }

    private static int readInt(ByteBuf buf) {
        return buf.readInt();
    }

    private static void writeInt(int i, ByteBuf buf) {
        buf.writeInt(i);
    }

    private static long readLong(ByteBuf buf) {
        return buf.readLong();
    }

    private static void writeLong(long l, ByteBuf buf) {
        buf.writeLong(l);
    }

    private static float readFloat(ByteBuf buf) {
        return buf.readFloat();
    }

    private static void writeFloat(float f, ByteBuf buf) {
        buf.writeFloat(f);
    }

    private static double readDouble(ByteBuf buf) {
        return buf.readDouble();
    }

    private static void writeDouble(double d, ByteBuf buf) {
        buf.writeDouble(d);
    }

    private static boolean readBoolean(ByteBuf buf) {
        return buf.readBoolean();
    }

    private static void writeBoolean(boolean b, ByteBuf buf) {
        buf.writeBoolean(b);
    }

    private static char readChar(ByteBuf buf) {
        return buf.readChar();
    }

    private static void writeChar(char c, ByteBuf buf) {
        buf.writeChar((int)c);
    }

    private static String readString(ByteBuf buf) {
        return ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    private static void writeString(String s, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
    }

    private static NBTTagCompound readNBT(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    private static void writeNBT(NBTTagCompound cmp, ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)cmp);
    }

    private static ItemStack readItemStack(ByteBuf buf) {
        return new ItemStack(NetworkMessage.readNBT(buf));
    }

    private static void writeItemStack(ItemStack stack, ByteBuf buf) {
        NetworkMessage.writeNBT(stack.serializeNBT(), buf);
    }

    private static BlockPos readBlockPos(ByteBuf buf) {
        return BlockPos.func_177969_a((long)buf.readLong());
    }

    private static void writeBlockPos(BlockPos pos, ByteBuf buf) {
        buf.writeLong(pos.func_177986_g());
    }

    static {
        NetworkMessage.mapHandler(Byte.TYPE, NetworkMessage::readByte, NetworkMessage::writeByte);
        NetworkMessage.mapHandler(Short.TYPE, NetworkMessage::readShort, NetworkMessage::writeShort);
        NetworkMessage.mapHandler(Integer.TYPE, NetworkMessage::readInt, NetworkMessage::writeInt);
        NetworkMessage.mapHandler(Long.TYPE, NetworkMessage::readLong, NetworkMessage::writeLong);
        NetworkMessage.mapHandler(Float.TYPE, NetworkMessage::readFloat, NetworkMessage::writeFloat);
        NetworkMessage.mapHandler(Double.TYPE, NetworkMessage::readDouble, NetworkMessage::writeDouble);
        NetworkMessage.mapHandler(Boolean.TYPE, NetworkMessage::readBoolean, NetworkMessage::writeBoolean);
        NetworkMessage.mapHandler(Character.TYPE, NetworkMessage::readChar, NetworkMessage::writeChar);
        NetworkMessage.mapHandler(String.class, NetworkMessage::readString, NetworkMessage::writeString);
        NetworkMessage.mapHandler(NBTTagCompound.class, NetworkMessage::readNBT, NetworkMessage::writeNBT);
        NetworkMessage.mapHandler(ItemStack.class, NetworkMessage::readItemStack, NetworkMessage::writeItemStack);
        NetworkMessage.mapHandler(BlockPos.class, NetworkMessage::readBlockPos, NetworkMessage::writeBlockPos);
    }

    public static interface Reader<T> {
        public T read(ByteBuf var1);
    }

    public static interface Writer<T> {
        public void write(T var1, ByteBuf var2);
    }
}

