/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.network.message;

import com.mrcrayfish.guns.common.WorkbenchRegistry;
import com.mrcrayfish.guns.common.container.ContainerWorkbench;
import com.mrcrayfish.guns.item.ItemColored;
import com.mrcrayfish.guns.tileentity.TileEntityWorkbench;
import com.mrcrayfish.guns.util.InventoryUtil;
import com.mrcrayfish.guns.util.ItemStackHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.oredict.DyeUtils;

public class MessageCraft
implements IMessage,
IMessageHandler<MessageCraft, IMessage> {
    private ItemStack stack;
    private BlockPos pos;

    public MessageCraft() {
    }

    public MessageCraft(ItemStack stack, BlockPos pos) {
        this.stack = stack;
        this.pos = pos;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ItemStackHelper.writeItemStackToBufIgnoreTag(buf, this.stack);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.stack = ItemStackHelper.readItemStackFromBufIgnoreTag(buf);
    }

    public IMessage onMessage(MessageCraft message, MessageContext ctx) {
        List<ItemStack> materials;
        ContainerWorkbench workbench;
        if (message.stack.func_190926_b() || WorkbenchRegistry.getMaterialsForStack(message.stack) == null) {
            ctx.getServerHandler().field_147369_b.field_71135_a.func_194028_b((ITextComponent)new TextComponentString("Attempted to craft a weapon that didn't exist on the server"));
            return null;
        }
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        World world = player.field_70170_p;
        if (player.field_71070_bA instanceof ContainerWorkbench && (workbench = (ContainerWorkbench)player.field_71070_bA).getPos().equals((Object)message.pos) && (materials = WorkbenchRegistry.getMaterialsForStack(message.stack)) != null) {
            Optional optional;
            for (ItemStack stack : materials) {
                if (InventoryUtil.hasItemStack((EntityPlayer)player, stack)) continue;
                return null;
            }
            for (ItemStack stack : materials) {
                InventoryUtil.removeItemStack((EntityPlayer)player, stack);
            }
            TileEntityWorkbench tileEntityWorkbench = workbench.getWorkbench();
            int color = -1;
            ItemStack dyeStack = (ItemStack)tileEntityWorkbench.getInventory().get(0);
            if (dyeStack.func_77973_b() instanceof ItemDye && (optional = DyeUtils.colorFromStack((ItemStack)dyeStack)).isPresent()) {
                float[] colorComponentValues = ((EnumDyeColor)optional.get()).func_193349_f();
                int red = (int)(colorComponentValues[0] * 255.0f);
                int green = (int)(colorComponentValues[1] * 255.0f);
                int blue = (int)(colorComponentValues[2] * 255.0f);
                color = (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                tileEntityWorkbench.getInventory().set(0, (Object)ItemStack.field_190927_a);
            }
            int finalColor = color;
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                ItemStack stack = message.stack.func_77946_l();
                if (finalColor != -1 && stack.func_77973_b() instanceof ItemColored) {
                    ItemColored colored = (ItemColored)stack.func_77973_b();
                    colored.setColor(stack, finalColor);
                }
                world.func_72838_d((Entity)new EntityItem(world, (double)message.pos.func_177958_n() + 0.5, (double)message.pos.func_177956_o() + 1.125, (double)message.pos.func_177952_p() + 0.5, stack));
            });
        }
        return null;
    }
}

