/*
 * Decompiled with CFR 0.152.
 */
package drzhark.customspawner;

import drzhark.customspawner.utils.CMSUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;

public class CustomDespawner {
    public static boolean debug = false;
    public static int despawnLightLevel = 7;
    public static int despawnTickRate = 111;
    public List<Biome> biomeList = new ArrayList<Biome>();

    public static final int entityDespawnCheck(WorldServer world, EntityLiving entityliving, int minDespawnLightLevel, int maxDespawnLightLevel) {
        if (entityliving instanceof EntityWolf && ((EntityWolf)entityliving).func_70909_n()) {
            return 0;
        }
        if (entityliving instanceof EntityOcelot && ((EntityOcelot)entityliving).func_70909_n()) {
            return 0;
        }
        if (!CustomDespawner.isValidDespawnLightLevel((Entity)entityliving, (World)world, minDespawnLightLevel, maxDespawnLightLevel)) {
            return 0;
        }
        EntityPlayer entityplayer = world.func_72890_a((Entity)entityliving, -1.0);
        if (entityplayer != null) {
            double d = entityplayer.field_70165_t - entityliving.field_70165_t;
            double d1 = entityplayer.field_70163_u - entityliving.field_70163_u;
            double d2 = entityplayer.field_70161_v - entityliving.field_70161_v;
            double d3 = d * d + d1 * d1 + d2 * d2;
            if (d3 > 16384.0) {
                entityliving.func_70106_y();
                return 1;
            }
            if (entityliving.func_70654_ax() > 600 && world.field_73012_v.nextInt(800) == 0 && !(d3 < 1024.0)) {
                entityliving.func_70106_y();
                return 1;
            }
        }
        return 0;
    }

    public static final int countEntities(Class<? extends Entity> class1, World world) {
        int i = 0;
        for (int j = 0; j < world.field_72996_f.size(); ++j) {
            Entity entity = (Entity)world.field_72996_f.get(j);
            if (!class1.isAssignableFrom(entity.getClass())) continue;
            ++i;
        }
        return i;
    }

    public static boolean isValidDespawnLightLevel(Entity entity, World world, int minDespawnLightLevel, int maxDespawnLightLevel) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        int blockLightLevel = 0;
        if (y >= 0) {
            if (y >= 256) {
                y = 255;
            }
            blockLightLevel = CMSUtils.getLightFromNeighbors(world.func_72964_e(x >> 4, z >> 4), x & 0xF, y, z & 0xF);
        }
        if (blockLightLevel < minDespawnLightLevel && maxDespawnLightLevel != -1) {
            return false;
        }
        return blockLightLevel <= maxDespawnLightLevel || maxDespawnLightLevel == -1;
    }
}

