/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.projectile;

import fossilsarcheology.server.item.FAItemRegistry;
import io.netty.buffer.ByteBuf;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class JavelinEntity
extends EntityArrow
implements IEntityAdditionalSpawnData {
    public Item.ToolMaterial material;
    protected int itemDamage;
    protected int newKnockBackStrength;

    public JavelinEntity(World world) {
        super(world);
    }

    public JavelinEntity(World world, Item.ToolMaterial material, int itemDamage, double x, double y, double z) {
        this(world);
        this.itemDamage = itemDamage;
        this.material = material;
        this.func_70239_b(this.getDamageFromMaterial(material));
        this.func_70107_b(x, y, z);
    }

    public JavelinEntity(World world, Item.ToolMaterial material, int damage, EntityLivingBase shooter) {
        this(world, material, damage, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1, shooter.field_70161_v);
        this.field_70250_c = shooter;
        if (shooter instanceof EntityPlayer) {
            this.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        }
        this.func_70239_b(this.getDamageFromMaterial(material));
    }

    public void func_70240_a(int knockbackStrengthIn) {
        this.newKnockBackStrength = knockbackStrengthIn;
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            int i = MathHelper.func_76143_f((double)((double)f * this.getDamageFromMaterial(this.material)));
            if (this.func_70241_g()) {
                i += this.field_70146_Z.nextInt(i / 2 + 2);
            }
            DamageSource damagesource = this.field_70250_c == null ? DamageSource.func_76353_a((EntityArrow)this, (Entity)this) : DamageSource.func_76353_a((EntityArrow)this, (Entity)this.field_70250_c);
            if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
                entity.func_70015_d(5);
            }
            if (entity.func_70097_a(damagesource, (float)i)) {
                if (entity instanceof EntityLivingBase) {
                    float f1;
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (!this.field_70170_p.field_72995_K) {
                        entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                    }
                    if (this.newKnockBackStrength > 0 && (f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                        entitylivingbase.func_70024_g(this.field_70159_w * (double)this.newKnockBackStrength * (double)0.6f / (double)f1, 0.1, this.field_70179_y * (double)this.newKnockBackStrength * (double)0.6f / (double)f1);
                    }
                    if (this.field_70250_c instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.field_70250_c);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entitylivingbase);
                    }
                    this.func_184548_a(entitylivingbase);
                    if (this.field_70250_c != null && entitylivingbase != this.field_70250_c && entitylivingbase instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                    if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                        this.func_70099_a(this.func_184550_j(), 0.1f);
                    }
                    this.func_70106_y();
                }
            }
        } else {
            super.func_184549_a(raytraceResultIn);
        }
    }

    private double getDamageFromMaterial(Item.ToolMaterial material) {
        switch (material) {
            case WOOD: {
                return 2.0;
            }
            case STONE: {
                return 3.0;
            }
            case IRON: {
                return 4.0;
            }
            case GOLD: {
                return 5.0;
            }
            case DIAMOND: {
                return 7.0;
            }
        }
        return 2.0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70252_j = 0;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("Material", (byte)this.material.ordinal());
        compound.func_74768_a("Damage", this.itemDamage);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.material = Item.ToolMaterial.values()[compound.func_74771_c("Material")];
        this.itemDamage = compound.func_74762_e("Damage");
    }

    protected ItemStack func_184550_j() {
        switch (this.material) {
            case WOOD: {
                return new ItemStack((Item)FAItemRegistry.WOODEN_JAVELIN, 1, FAItemRegistry.WOODEN_JAVELIN.func_77612_l() - this.itemDamage);
            }
            case STONE: {
                return new ItemStack((Item)FAItemRegistry.STONE_JAVELIN, 1, FAItemRegistry.STONE_JAVELIN.func_77612_l() - this.itemDamage);
            }
            case IRON: {
                return new ItemStack((Item)FAItemRegistry.IRON_JAVELIN, 1, FAItemRegistry.IRON_JAVELIN.func_77612_l() - this.itemDamage);
            }
            case GOLD: {
                return new ItemStack((Item)FAItemRegistry.GOLD_JAVELIN, 1, FAItemRegistry.GOLD_JAVELIN.func_77612_l() - this.itemDamage);
            }
            case DIAMOND: {
                return new ItemStack((Item)FAItemRegistry.DIAMOND_JAVELIN, 1, FAItemRegistry.DIAMOND_JAVELIN.func_77612_l() - this.itemDamage);
            }
        }
        return null;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte(this.material.ordinal());
    }

    public void readSpawnData(ByteBuf buffer) {
        this.material = Item.ToolMaterial.values()[buffer.readByte()];
    }
}

