/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Alignment;
import de.matthiasmann.twl.BoxLayout;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.FileSelector;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ListBox;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.FileSystemModel;
import de.matthiasmann.twl.model.FileSystemTreeModel;
import de.matthiasmann.twl.model.JavaFileSystemModel;
import de.matthiasmann.twl.model.SimpleListModel;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twl.utils.NaturalSortComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FolderBrowser
extends Widget {
    final FileSystemModel fsm;
    final ListBox<Object> listbox;
    final FolderModel model;
    private final BoxLayout curFolderGroup;
    private Runnable[] selectionChangedCallbacks;
    Comparator<String> folderComparator;
    private Object currentFolder;
    private Runnable[] callbacks;

    public FolderBrowser() {
        this(JavaFileSystemModel.getInstance());
    }

    public FolderBrowser(FileSystemModel fsm) {
        if (fsm == null) {
            throw new NullPointerException("fsm");
        }
        this.fsm = fsm;
        this.model = new FolderModel();
        this.listbox = new ListBox<Object>(this.model);
        this.curFolderGroup = new BoxLayout();
        this.curFolderGroup.setTheme("currentpathbox");
        this.curFolderGroup.setScroll(true);
        this.curFolderGroup.setClip(true);
        this.curFolderGroup.setAlignment(Alignment.BOTTOM);
        this.listbox.addCallback(new CallbackWithReason<ListBox.CallbackReason>(){
            private Object lastSelection;

            @Override
            public void callback(ListBox.CallbackReason reason) {
                Object selection;
                if (FolderBrowser.this.listbox.getSelected() != -1 && reason.actionRequested()) {
                    FolderBrowser.this.setCurrentFolder(FolderBrowser.this.model.getFolder(FolderBrowser.this.listbox.getSelected()));
                }
                if ((selection = FolderBrowser.this.getSelectedFolder()) != this.lastSelection) {
                    this.lastSelection = selection;
                    FolderBrowser.this.fireSelectionChangedCallback();
                }
            }
        });
        this.add(this.listbox);
        this.add(this.curFolderGroup);
        this.setCurrentFolder(null);
    }

    public void addCallback(Runnable cb) {
        this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, cb, Runnable.class);
    }

    public void removeCallback(Runnable cb) {
        this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, cb);
    }

    protected void doCallback() {
        CallbackSupport.fireCallbacks(this.callbacks);
    }

    public Comparator<String> getFolderComparator() {
        return this.folderComparator;
    }

    public void setFolderComparator(Comparator<String> folderComparator) {
        this.folderComparator = folderComparator;
    }

    public FileSystemModel getFileSystemModel() {
        return this.fsm;
    }

    public Object getCurrentFolder() {
        return this.currentFolder;
    }

    public boolean setCurrentFolder(Object folder) {
        if (this.model.listFolders(folder)) {
            if (folder == null && this.model.getNumEntries() == 1 && this.setCurrentFolder(this.model.getFolder(0))) {
                return true;
            }
            this.currentFolder = folder;
            this.listbox.setSelected(-1);
            this.rebuildCurrentFolderGroup();
            this.doCallback();
            return true;
        }
        return false;
    }

    public boolean goToParentFolder() {
        Object current;
        if (this.currentFolder != null && this.setCurrentFolder(this.fsm.getParent(current = this.currentFolder))) {
            this.selectFolder(current);
            return true;
        }
        return false;
    }

    public Object getSelectedFolder() {
        if (this.listbox.getSelected() != -1) {
            return this.model.getFolder(this.listbox.getSelected());
        }
        return null;
    }

    public boolean selectFolder(Object current) {
        int idx = this.model.findFolder(current);
        this.listbox.setSelected(idx);
        return idx != -1;
    }

    public void addSelectionChangedCallback(Runnable cb) {
        this.callbacks = CallbackSupport.addCallbackToList(this.selectionChangedCallbacks, cb, Runnable.class);
    }

    public void removeSelectionChangedCallback(Runnable cb) {
        this.selectionChangedCallbacks = CallbackSupport.removeCallbackFromList(this.selectionChangedCallbacks, cb);
    }

    protected void fireSelectionChangedCallback() {
        CallbackSupport.fireCallbacks(this.selectionChangedCallbacks);
    }

    @Override
    public boolean handleEvent(Event evt) {
        if (evt.isKeyPressedEvent()) {
            switch (evt.getKeyCode()) {
                case 14: {
                    this.goToParentFolder();
                    return true;
                }
            }
        }
        return super.handleEvent(evt);
    }

    private void rebuildCurrentFolderGroup() {
        this.curFolderGroup.removeAllChildren();
        this.recursiveAddFolder(this.currentFolder, null);
    }

    private void recursiveAddFolder(final Object folder, final Object subFolder) {
        String name;
        if (folder != null) {
            this.recursiveAddFolder(this.fsm.getParent(folder), folder);
        }
        if (this.curFolderGroup.getNumChildren() > 0) {
            Label l = new Label(this.fsm.getSeparator());
            l.setTheme("pathseparator");
            this.curFolderGroup.add(l);
        }
        if ((name = this.getFolderName(folder)).endsWith(this.fsm.getSeparator())) {
            name = name.substring(0, name.length() - 1);
        }
        Button btn = new Button(name);
        btn.addCallback(new Runnable(){

            @Override
            public void run() {
                if (FolderBrowser.this.setCurrentFolder(folder)) {
                    FolderBrowser.this.selectFolder(subFolder);
                }
                FolderBrowser.this.listbox.requestKeyboardFocus();
            }
        });
        btn.setTheme("pathbutton");
        this.curFolderGroup.add(btn);
    }

    @Override
    public void adjustSize() {
    }

    @Override
    protected void layout() {
        this.curFolderGroup.setPosition(this.getInnerX(), this.getInnerY());
        this.curFolderGroup.setSize(this.getInnerWidth(), this.curFolderGroup.getHeight());
        this.listbox.setPosition(this.getInnerX(), this.curFolderGroup.getBottom());
        this.listbox.setSize(this.getInnerWidth(), Math.max(0, this.getInnerBottom() - this.listbox.getY()));
    }

    String getFolderName(Object folder) {
        if (folder != null) {
            return this.fsm.getName(folder);
        }
        return "ROOT";
    }

    class FolderModel
    extends SimpleListModel<Object> {
        private Object[] folders = new Object[0];

        FolderModel() {
        }

        public boolean listFolders(Object parent) {
            Object[] newFolders = parent == null ? FolderBrowser.this.fsm.listRoots() : FolderBrowser.this.fsm.listFolder(parent, FileSystemTreeModel.FolderFilter.instance);
            if (newFolders == null) {
                Logger.getLogger(FolderModel.class.getName()).log(Level.WARNING, "can''t list folder: {0}", parent);
                return false;
            }
            Arrays.sort(newFolders, new FileSelector.NameSorter(FolderBrowser.this.fsm, FolderBrowser.this.folderComparator != null ? FolderBrowser.this.folderComparator : NaturalSortComparator.stringComparator));
            this.folders = newFolders;
            this.fireAllChanged();
            return true;
        }

        @Override
        public int getNumEntries() {
            return this.folders.length;
        }

        public Object getFolder(int index) {
            return this.folders[index];
        }

        @Override
        public Object getEntry(int index) {
            Object folder = this.getFolder(index);
            return FolderBrowser.this.getFolderName(folder);
        }

        public int findFolder(Object folder) {
            int idx = FolderBrowser.this.fsm.find(this.folders, folder);
            return idx < 0 ? -1 : idx;
        }
    }
}

