/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.EditFieldModel;
import de.matthiasmann.twl.model.ObservableCharSequence;
import de.matthiasmann.twl.utils.CallbackSupport;

public class DefaultEditFieldModel
implements EditFieldModel {
    private final StringBuilder sb = new StringBuilder();
    private ObservableCharSequence.Callback[] callbacks;

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void addCallback(ObservableCharSequence.Callback callback) {
        this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, callback, ObservableCharSequence.Callback.class);
    }

    @Override
    public void removeCallback(ObservableCharSequence.Callback callback) {
        this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, callback);
    }

    @Override
    public int replace(int start, int count, String replacement) {
        this.checkRange(start, count);
        int replacementLength = replacement.length();
        if (count > 0 || replacementLength > 0) {
            this.sb.replace(start, start + count, replacement);
            this.fireCallback(start, count, replacementLength);
        }
        return replacementLength;
    }

    @Override
    public boolean replace(int start, int count, char replacement) {
        this.checkRange(start, count);
        if (count == 0) {
            this.sb.insert(start, replacement);
        } else {
            this.sb.delete(start, start + count - 1);
            this.sb.setCharAt(start, replacement);
        }
        this.fireCallback(start, count, 1);
        return true;
    }

    @Override
    public String substring(int start, int end) {
        return this.sb.substring(start, end);
    }

    private void checkRange(int start, int count) {
        int len = this.sb.length();
        if (start < 0 || start > len) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (count < 0 || count > len - start) {
            throw new StringIndexOutOfBoundsException();
        }
    }

    private void fireCallback(int start, int oldCount, int newCount) {
        ObservableCharSequence.Callback[] cbs = this.callbacks;
        if (cbs != null) {
            for (ObservableCharSequence.Callback cb : cbs) {
                cb.charactersChanged(start, oldCount, newCount);
            }
        }
    }
}

