/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.utils.HashEntry;

public class CascadedHashMap<K, V> {
    private Entry<K, V>[] table;
    private int size;
    private CascadedHashMap<K, V> fallback;

    public V get(K key) {
        Entry<K, V> entry = CascadedHashMap.getEntry(this, key);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        V oldValue = null;
        if (this.table != null) {
            Entry entry = (Entry)HashEntry.get((HashEntry[])this.table, key);
            if (entry != null) {
                oldValue = entry.value;
                entry.value = value;
                return oldValue;
            }
            if (this.fallback != null) {
                oldValue = this.fallback.get(key);
            }
        }
        this.insertEntry(key, value);
        return oldValue;
    }

    public void collapseAndSetFallback(CascadedHashMap<K, V> map) {
        if (this.fallback != null) {
            this.collapsePutAll(this.fallback);
            this.fallback = null;
        }
        this.fallback = map;
    }

    protected static <K, V> Entry<K, V> getEntry(CascadedHashMap<K, V> map, K key) {
        do {
            Entry entry;
            if (map.table == null || (entry = (Entry)HashEntry.get((HashEntry[])map.table, key)) == null) continue;
            return entry;
        } while ((map = map.fallback) != null);
        return null;
    }

    private void collapsePutAll(CascadedHashMap<K, V> map) {
        do {
            Entry<K, V>[] tab;
            if ((tab = map.table) == null) continue;
            int n = tab.length;
            for (int i = 0; i < n; ++i) {
                Entry e = tab[i];
                while (e != null) {
                    if (HashEntry.get((HashEntry[])this.table, (Object)e.key) == null) {
                        this.insertEntry(e.key, e.value);
                    }
                    e = (Entry)e.next;
                }
            }
        } while ((map = map.fallback) != null);
    }

    private void insertEntry(K key, V value) {
        if (this.table == null) {
            this.table = new Entry[16];
        }
        this.table = (Entry[])HashEntry.maybeResizeTable((HashEntry[])this.table, (int)(++this.size));
        Entry<K, V> entry = new Entry<K, V>(key, value);
        HashEntry.insertEntry((HashEntry[])this.table, entry);
    }

    protected static class Entry<K, V>
    extends HashEntry<K, Entry<K, V>> {
        V value;

        public Entry(K key, V value) {
            super(key);
            this.value = value;
        }
    }
}

