/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.tiles;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.xalcon.torchmaster.common.TorchmasterConfig;
import net.xalcon.torchmaster.common.utils.BlockUtils;

public class TileEntityTerrainLighter
extends TileEntity
implements ITickable {
    private static final GameProfile TERRAIN_LIGHTER_IDENTITY = new GameProfile(UUID.fromString("d80c982d-de38-43e6-8554-de12f86914d9"), "torchmaster:terrain_lighter");
    private static final int FUEL_SLOT = 9;
    private int[] spiralMap = BlockUtils.createSpiralMap(TorchmasterConfig.TerrainLighterTorchCount);
    private ItemStackHandler inventory = new ItemStackHandler(10);
    private int burnTime;
    private int totalBurnTime;
    private int index;
    private int tick;
    private boolean done = false;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("Items"));
        this.index = compound.func_74762_e("Index");
        this.burnTime = compound.func_74762_e("BurnTime");
        this.totalBurnTime = compound.func_74762_e("TotalBurnTime");
        this.done = this.index >= this.getTorchPlacedMax();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Index", this.index);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("TotalBurnTime", this.totalBurnTime);
        compound.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return compound;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("container.torchmaster.terrain_lighter", new Object[0]);
    }

    public void func_73660_a() {
        int torchSlot;
        int burnTime;
        ItemStack fuelStack;
        if (this.isBurningFuel()) {
            --this.burnTime;
        }
        World world = this.func_145831_w();
        if (world.field_72995_K) {
            return;
        }
        if (this.done) {
            return;
        }
        if (this.tick++ % 5 != 0) {
            return;
        }
        if (!this.func_145831_w().func_175640_z(this.field_174879_c)) {
            return;
        }
        boolean updated = false;
        if (this.burnTime <= 0 && !(fuelStack = this.inventory.extractItem(9, 1, true)).func_190926_b() && (burnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelStack)) > 0) {
            this.inventory.extractItem(9, 1, false);
            this.burnTime = this.totalBurnTime = burnTime;
            Item fuelItem = fuelStack.func_77973_b();
            if (!fuelStack.func_190926_b() && fuelItem.hasContainerItem(fuelStack)) {
                ItemStack containerItemStack = fuelItem.getContainerItem(fuelStack);
                this.inventory.setStackInSlot(9, containerItemStack);
            }
            updated = true;
        }
        if ((torchSlot = this.getTorchSlot()) >= 0 && this.burnTime > 0) {
            BlockPos gridPos = this.getPosFromIndex(this.index);
            int height = world.func_175645_m(new BlockPos(gridPos.func_177958_n(), world.func_72940_L(), gridPos.func_177952_p())).func_177956_o();
            int maxY = this.field_174879_c.func_177956_o() + 8;
            int minY = this.field_174879_c.func_177956_o() - 8;
            if (height > minY) {
                if (height > maxY) {
                    height = maxY;
                }
                for (int y = height + 1; y > minY; --y) {
                    BlockPos checkPos = new BlockPos(gridPos.func_177958_n(), y, gridPos.func_177952_p());
                    IBlockState blockState = world.func_180495_p(checkPos);
                    IBlockState upState = world.func_180495_p(checkPos.func_177984_a());
                    if (!blockState.func_177230_c().canPlaceTorchOnTop(blockState, (IBlockAccess)world, checkPos) || !upState.func_185904_a().func_76222_j() || upState.func_185904_a().func_76224_d()) continue;
                    ItemStack stack = this.inventory.extractItem(torchSlot, 1, false);
                    if (stack.func_190926_b()) break;
                    FakePlayer fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)TERRAIN_LIGHTER_IDENTITY);
                    fakePlayer.func_184611_a(EnumHand.MAIN_HAND, stack);
                    fakePlayer.func_70107_b((double)checkPos.func_177958_n() + 0.5, (double)checkPos.func_177956_o() + 1.5, (double)checkPos.func_177952_p() + 0.5);
                    fakePlayer.field_70125_A = 90.0f;
                    EnumActionResult result = stack.func_179546_a((EntityPlayer)fakePlayer, this.field_145850_b, checkPos, EnumHand.MAIN_HAND, EnumFacing.UP, 0.5f, 1.0f, 0.5f);
                    if (result != EnumActionResult.SUCCESS) break;
                    updated = true;
                    break;
                }
            }
            ++this.index;
            if (this.index >= this.getTorchPlacedMax()) {
                this.done = true;
            }
        }
        if (updated) {
            this.func_70296_d();
            IBlockState meState = world.func_180495_p(this.field_174879_c);
            world.func_184138_a(this.field_174879_c, meState, meState, 3);
        }
    }

    private BlockPos getPosFromIndex(int index) {
        int spacing = TorchmasterConfig.TerrainLighterSpacing;
        int x = this.spiralMap[index * 2] * spacing + this.func_174877_v().func_177958_n();
        int z = this.spiralMap[index * 2 + 1] * spacing + this.func_174877_v().func_177952_p();
        return new BlockPos(x, 0, z);
    }

    private int getTorchSlot() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !TileEntityTerrainLighter.isItemAllowed(stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isItemAllowed(ItemStack stack) {
        for (String e : TorchmasterConfig.TerrainLighterTorches) {
            if (!e.equals(stack.func_77973_b().getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isBurningFuel() {
        return this.burnTime > 0;
    }

    public int getTorchesPlaced() {
        return this.index;
    }

    public int getTorchPlacedMax() {
        int torchCount = TorchmasterConfig.TerrainLighterTorchCount * 2 + 1;
        return torchCount * torchCount;
    }

    public int getBurnLeftScaled(int pixel) {
        float p = (float)this.burnTime / (float)this.totalBurnTime;
        return (int)((float)pixel * p);
    }

    public int getProgressScaled(int pixel) {
        float p = (float)this.index / (float)this.getTorchPlacedMax();
        return (int)((float)pixel * p);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : super.getCapability(capability, facing));
    }
}

