/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import de.maxhenkel.corpse.entities.EntityCorpse;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public abstract class EntityCorpseInventoryBase
extends Entity
implements IInventory {
    private static final DataParameter<Integer> INVENTORY_SIZE = EntityDataManager.func_187226_a(EntityCorpse.class, (DataSerializer)DataSerializers.field_187192_b);
    protected IInventory inventory;

    public EntityCorpseInventoryBase(World worldIn) {
        super(worldIn);
    }

    private IInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new InventoryBasic("", false, this.getFittingInventorySize((Integer)this.field_70180_af.func_187225_a(INVENTORY_SIZE)));
        }
        return this.inventory;
    }

    private int getFittingInventorySize(int size) {
        if (size < 54) {
            size = 54;
        }
        if (size % 54 != 0) {
            size += 54 - size % 54;
        }
        return size;
    }

    public void setItems(NonNullList<ItemStack> items) {
        this.field_70180_af.func_187227_b(INVENTORY_SIZE, (Object)items.size());
        for (int i = 0; i < this.func_70302_i_() && i < items.size(); ++i) {
            this.func_70299_a(i, (ItemStack)items.get(i));
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(INVENTORY_SIZE, (Object)54);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        int size = compound.func_74762_e("InventorySize");
        NBTTagList nbttaglist = compound.func_150295_c("Inventory", 10);
        this.inventory = new InventoryBasic("", false, size);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74762_e("Slot");
            if (j < 0 || j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, new ItemStack(nbttagcompound));
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Slot", i);
            this.func_70301_a(i).func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Inventory", (NBTBase)nbttaglist);
        compound.func_74768_a("InventorySize", this.func_70302_i_());
    }

    public int func_70302_i_() {
        return this.getInventory().func_70302_i_();
    }

    public boolean func_191420_l() {
        return this.getInventory().func_191420_l();
    }

    public ItemStack func_70301_a(int index) {
        return this.getInventory().func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.getInventory().func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.getInventory().func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getInventory().func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.getInventory().func_70297_j_();
    }

    public void func_70296_d() {
        this.getInventory().func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.getInventory().func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.getInventory().func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.getInventory().func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.getInventory().func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.getInventory().func_174888_l();
    }
}

