/*
 * Decompiled with CFR 0.152.
 */
package drzhark.customspawner.command;

import drzhark.customspawner.CustomSpawner;
import drzhark.customspawner.biomes.BiomeGroupData;
import drzhark.customspawner.configuration.CMSConfigCategory;
import drzhark.customspawner.configuration.CMSConfiguration;
import drzhark.customspawner.configuration.CMSProperty;
import drzhark.customspawner.entity.EntityData;
import drzhark.customspawner.entity.EntityModData;
import drzhark.customspawner.environment.EnvironmentSettings;
import drzhark.customspawner.type.EntitySpawnType;
import drzhark.customspawner.utils.CMSUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.GameData;

public class CommandCMS
extends CommandBase {
    private static List<String> commands = new ArrayList<String>();
    private static List<String> aliases = new ArrayList<String>();
    private static List<String> tabCompletionStrings = new ArrayList<String>();

    public String func_71517_b() {
        return "customspawner";
    }

    public List<String> func_71514_a() {
        return aliases;
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "commands.customspawner.usage";
    }

    public List<String> addTabCompletionOptions(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        return CommandCMS.func_71530_a((String[])par2ArrayOfStr, (String[])tabCompletionStrings.toArray(new String[tabCompletionStrings.size()]));
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityData entityData;
        String par1 = "";
        if (args.length == 0) {
            this.sendCommandHelp(sender);
            return;
        }
        par1 = args[0];
        String par2 = "";
        if (args.length > 1) {
            par2 = args[1];
        }
        String par3 = "";
        if (args.length > 2) {
            par3 = args[2];
        }
        EnvironmentSettings environment = CMSUtils.getEnvironment(sender.func_130014_f_());
        CMSConfiguration config = environment.CMSEnvironmentConfig;
        boolean saved = false;
        if (par1.equalsIgnoreCase("addbg") && !par2.equals("") && !par3.equals("")) {
            entityData = environment.entityMap.get(par2);
            if (entityData != null) {
                BiomeGroupData biomeGroupData = environment.biomeGroupMap.get(par3);
                if (biomeGroupData == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Invalid Biome Group entered. Please enter a valid biome group.", new Object[0]));
                    return;
                }
                if (biomeGroupData != null && !entityData.getBiomeGroups().contains(biomeGroupData.getBiomeGroupName())) {
                    entityData.addBiomeGroup(biomeGroupData.getBiomeGroupName());
                    Collections.sort(entityData.getBiomeGroups());
                    CustomSpawner.INSTANCE.updateSpawnListBiomes(entityData.getEntityClass(), entityData.getLivingSpawnType(), entityData.getFrequency(), entityData.getMinSpawn(), entityData.getMaxSpawn(), entityData.getBiomeGroupSpawnMap(biomeGroupData.getBiomeGroupName()));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Added biomegroup " + TextFormatting.AQUA + biomeGroupData.getBiomeGroupName() + TextFormatting.WHITE + " to Entity " + TextFormatting.GREEN + par2, new Object[0]));
                    entityData.getEntityConfig().save();
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Biome Group " + biomeGroupData.getBiomeGroupName() + " already exists!!, please choose another from the following list :", new Object[0]));
                }
                return;
            }
        } else if (par1.equalsIgnoreCase("removebg") && !par2.equals("") && !par3.equals("")) {
            entityData = environment.entityMap.get(par2);
            if (entityData != null) {
                BiomeGroupData biomeGroupData = environment.biomeGroupMap.get(par3);
                if (biomeGroupData == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Invalid Biome Group entered. Please enter a valid biome group.", new Object[0]));
                    return;
                }
                if (biomeGroupData != null && entityData.getBiomeGroups().contains(biomeGroupData.getBiomeGroupName())) {
                    entityData.removeBiomeGroup(biomeGroupData.getBiomeGroupName());
                    CustomSpawner.INSTANCE.updateSpawnListBiomes(entityData.getEntityClass(), entityData.getLivingSpawnType(), entityData.getFrequency(), entityData.getMinSpawn(), entityData.getMaxSpawn(), entityData.getBiomeGroupSpawnMap(biomeGroupData.getBiomeGroupName()));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Removed biomegroup " + TextFormatting.AQUA + biomeGroupData.getBiomeGroupName() + TextFormatting.WHITE + " from Entity " + TextFormatting.GREEN + par2, new Object[0]));
                    entityData.getEntityConfig().save();
                    return;
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Biome Group " + biomeGroupData.getBiomeGroupName() + " already exists!!, please choose another from the following list :", new Object[0]));
                for (int i = 0; i < biomeGroupData.getBiomeList().size(); ++i) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(biomeGroupData.getBiomeList().get(i), new Object[0]));
                }
                return;
            }
        } else {
            if (par1.equalsIgnoreCase("biomegroups") || par1.equalsIgnoreCase("bg")) {
                String biomeGroups = "";
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("The following biome groups have been found :", new Object[0]));
                for (Map.Entry<String, BiomeGroupData> biomeGroupEntry : environment.biomeGroupMap.entrySet()) {
                    biomeGroups = biomeGroups + biomeGroupEntry.getKey() + ", ";
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.AQUA + biomeGroups, new Object[0]));
                return;
            }
            if ((par1.equalsIgnoreCase("biomegroups") || par1.equalsIgnoreCase("bg")) && !par2.equals("")) {
                EntityData entityData2 = environment.entityMap.get(par2);
                if (entityData2 != null) {
                    String biomeGroups = "";
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("The following biome groups have been found :", new Object[0]));
                    for (String biomeGroup : entityData2.getBiomeGroups()) {
                        biomeGroups = biomeGroups + biomeGroup + ", ";
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.AQUA + biomeGroups, new Object[0]));
                    return;
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Entity " + TextFormatting.GREEN + par2 + TextFormatting.RED + " is invalid. Please enter a valid entity.", new Object[0]));
                return;
            }
            if (par1.equalsIgnoreCase("countentities")) {
                String title;
                int totalCount = 0;
                World world = sender.func_130014_f_();
                HashMap<String, Integer> countMap = new HashMap<String, Integer>();
                BlockPos pos = sender.func_180425_c();
                if (par2.equalsIgnoreCase("chunk")) {
                    for (EntityData entityData3 : CMSUtils.getEnvironment((World)world).classToEntityMapping.values()) {
                        int count = 0;
                        for (int j = 0; j < world.field_72996_f.size(); ++j) {
                            Entity entity = (Entity)world.field_72996_f.get(j);
                            if (entity.getClass() != entityData3.getEntityClass() || !pos.equals((Object)entity.func_180425_c())) continue;
                            ++count;
                        }
                        if (count == 0) continue;
                        countMap.put(TextFormatting.LIGHT_PURPLE + entityData3.getEntityMod().getModTag() + TextFormatting.WHITE + "|" + TextFormatting.GREEN + entityData3.getEntityName(), count);
                    }
                    title = "Showing total entities in chunk " + TextFormatting.AQUA + pos.func_177958_n() + TextFormatting.WHITE + ", " + TextFormatting.AQUA + pos.func_177952_p() + TextFormatting.WHITE + " ";
                } else if (par2.equalsIgnoreCase("all")) {
                    for (EntityEntry entry : GameData.getEntityRegistry().getValues()) {
                        Class clazz = entry.getEntityClass();
                        int count = 0;
                        for (int i = 0; i < world.field_72996_f.size(); ++i) {
                            Entity entity = (Entity)world.field_72996_f.get(i);
                            if (entity instanceof EntityPlayer || !entity.getClass().isAssignableFrom(clazz)) continue;
                            ++count;
                            ++totalCount;
                        }
                        if (count == 0) continue;
                        countMap.put(TextFormatting.GREEN + clazz.getName(), count);
                    }
                    title = "Showing total entities in dimension " + world.field_73011_w.func_186058_p().func_186068_a();
                } else {
                    for (EntityData entityData3 : CMSUtils.getEnvironment((World)world).classToEntityMapping.values()) {
                        int count = 0;
                        for (int i = 0; i < world.field_72996_f.size(); ++i) {
                            Entity entity = (Entity)world.field_72996_f.get(i);
                            if (entity instanceof EntityPlayer || entity.getClass() != entityData3.getEntityClass()) continue;
                            ++count;
                            ++totalCount;
                        }
                        if (count == 0) continue;
                        countMap.put(TextFormatting.LIGHT_PURPLE + entityData3.getEntityMod().getModTag() + TextFormatting.WHITE + "|" + TextFormatting.GREEN + entityData3.getEntityName(), count);
                    }
                    title = "Showing total entities in dimension " + world.field_73011_w.func_186058_p().func_186068_a();
                }
                Map<String, Integer> sortedMap = CMSUtils.sortByComparator(countMap, false);
                ArrayList<String> countList = new ArrayList<String>();
                if (countMap.size() > 0) {
                    for (Map.Entry<String, Integer> entityEntry : sortedMap.entrySet()) {
                        countList.add(TextFormatting.WHITE + " " + TextFormatting.AQUA + entityEntry.getValue() + " " + entityEntry.getKey());
                    }
                    this.sendPageHelp(sender, (byte)10, countList, args, title);
                    if (!par2.equalsIgnoreCase("chunk")) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.WHITE + "Total entities " + TextFormatting.AQUA + totalCount, new Object[0]));
                    }
                } else if (par2.equalsIgnoreCase("chunk")) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.WHITE + "No entities found in chunk " + TextFormatting.AQUA + pos.func_177958_n() + TextFormatting.WHITE + ", " + TextFormatting.AQUA + pos.func_177952_p() + TextFormatting.WHITE + ".", new Object[0]));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.WHITE + "No entities found in world " + world.func_72912_H().func_76065_j() + " in dimension " + world.field_73011_w.func_186058_p().func_186068_a() + ".", new Object[0]));
                }
                return;
            }
            if (par1.equalsIgnoreCase("killall")) {
                if (!environment.entityMap.containsKey(par2) && args.length == 2 && !par2.equalsIgnoreCase("force") || args.length == 1) {
                    String list = "";
                    ArrayList<String> entityTypes = new ArrayList<String>();
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Must specify a valid entity type to kill. Current types are : ", new Object[0]));
                    for (Map.Entry<String, EntityData> entityEntry : environment.entityMap.entrySet()) {
                        EntityData entityData4 = entityEntry.getValue();
                        entityTypes.add(TextFormatting.LIGHT_PURPLE + entityData4.getEntityMod().getModTag() + TextFormatting.WHITE + "|" + TextFormatting.GREEN + entityData4.getEntityName());
                    }
                    Collections.sort(entityTypes);
                    for (int i = 0; i < entityTypes.size(); ++i) {
                        list = i == entityTypes.size() - 1 ? list + (String)entityTypes.get(i) + "." : list + (String)entityTypes.get(i) + ", ";
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(list, new Object[0]));
                    return;
                }
                if (par2.contains("|")) {
                    EntityData entityData5 = environment.entityMap.get(par2);
                    int count = 0;
                    Integer[] i = DimensionManager.getIDs();
                    int entityEntry = i.length;
                    for (int entityData4 = 0; entityData4 < entityEntry; ++entityData4) {
                        int dimension = i[entityData4];
                        WorldServer world = DimensionManager.getWorld((int)dimension);
                        for (int i2 = 0; i2 < world.field_72996_f.size(); ++i2) {
                            Entity entity = (Entity)world.field_72996_f.get(i2);
                            if (!entityData5.getEntityClass().isInstance(entity) || entity instanceof EntityVillager || CMSUtils.isTamed(entity)) continue;
                            entity.field_70128_L = true;
                            entity.field_70170_p.func_72960_a(entity, (byte)3);
                            ++count;
                        }
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Killed " + TextFormatting.AQUA + count + " " + TextFormatting.LIGHT_PURPLE + entityData5.getEntityMod().getModTag() + TextFormatting.WHITE + "|" + TextFormatting.GREEN + entityData5.getEntityName() + TextFormatting.WHITE + ".", new Object[0]));
                    return;
                }
                if (par2.equalsIgnoreCase("force")) {
                    int count = 0;
                    World world = sender.func_130014_f_();
                    for (int i = 0; i < world.field_72996_f.size(); ++i) {
                        Entity entity = (Entity)world.field_72996_f.get(i);
                        if (entity instanceof EntityPlayer) continue;
                        entity.field_70128_L = true;
                        entity.field_70170_p.func_72960_a(entity, (byte)3);
                        ++count;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Killed " + TextFormatting.AQUA + count + " entities in world " + TextFormatting.LIGHT_PURPLE + world.func_72912_H().func_76065_j() + TextFormatting.WHITE + ".", new Object[0]));
                    return;
                }
                if (par2.equalsIgnoreCase("tamed") && args.length > 2) {
                    String playername = args[2];
                    int count = 0;
                    Integer[] i = DimensionManager.getIDs();
                    int entity = i.length;
                    for (int entityData4 = 0; entityData4 < entity; ++entityData4) {
                        int dimension = i[entityData4];
                        WorldServer world = DimensionManager.getWorld((int)dimension);
                        for (int i3 = 0; i3 < world.field_72996_f.size(); ++i3) {
                            Entity entity2 = (Entity)world.field_72996_f.get(i3);
                            if (!entity2.isCreatureType(EnumCreatureType.CREATURE, false)) continue;
                            NBTTagCompound nbt = new NBTTagCompound();
                            entity2.func_189511_e(nbt);
                            if (nbt == null || !nbt.func_74764_b("Owner") || nbt.func_74779_i("Owner").equals("")) continue;
                            if (nbt.func_74779_i("Owner").equalsIgnoreCase(playername)) {
                                // empty if block
                            }
                            entity2.field_70128_L = true;
                            entity2.field_70170_p.func_72960_a(entity2, (byte)3);
                            ++count;
                            return;
                        }
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Killed " + TextFormatting.AQUA + count + TextFormatting.LIGHT_PURPLE + " tamed" + TextFormatting.WHITE + " pets with owner " + TextFormatting.GREEN + playername + TextFormatting.WHITE + ".", new Object[0]));
                }
            } else if (args.length >= 2 && (par1.equalsIgnoreCase("frequency") || par1.equalsIgnoreCase("min") || par1.equalsIgnoreCase("max") || par1.equalsIgnoreCase("maxchunk") || par1.equalsIgnoreCase("canspawn") || par1.equalsIgnoreCase("biomegroup") || par1.equalsIgnoreCase("bg"))) {
                if (environment.entityMap.get(par2) == null) {
                    return;
                }
                entityData = environment.entityMap.get(par2);
                if (entityData != null) {
                    CMSProperty prop;
                    if (par1.equalsIgnoreCase("frequency")) {
                        if (par3.equals("")) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " frequency is " + TextFormatting.AQUA + entityData.getFrequency() + TextFormatting.WHITE + ".", new Object[0]));
                            return;
                        }
                        try {
                            entityData.setFrequency(Integer.parseInt(par3));
                            prop = entityData.getEntityConfig().get(entityData.getEntityName().toLowerCase(), "frequency");
                            prop.value = par3;
                            saved = true;
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " frequency to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                        }
                        catch (NumberFormatException ex) {
                            this.sendCommandHelp(sender);
                        }
                    } else if (par1.equalsIgnoreCase("min")) {
                        if (par3.equals("")) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " minGroupSpawn is " + TextFormatting.AQUA + entityData.getMinSpawn() + TextFormatting.WHITE + ".", new Object[0]));
                        } else {
                            try {
                                entityData.setMinSpawn(Integer.parseInt(par3));
                                prop = entityData.getEntityConfig().get(entityData.getEntityName(), "min");
                                prop.value = par3;
                                saved = true;
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " minGroupSpawn to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                            }
                            catch (NumberFormatException ex) {
                                this.sendCommandHelp(sender);
                            }
                        }
                    } else if (par1.equalsIgnoreCase("max")) {
                        if (par3.equals("")) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " maxGroupSpawn is " + TextFormatting.AQUA + entityData.getMaxSpawn() + TextFormatting.WHITE + ".", new Object[0]));
                            return;
                        }
                        try {
                            entityData.setMaxSpawn(Integer.parseInt(par3));
                            prop = entityData.getEntityConfig().get(entityData.getEntityName(), "max");
                            prop.value = par3;
                            saved = true;
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " maxGroupSpawn to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                        }
                        catch (NumberFormatException ex) {
                            this.sendCommandHelp(sender);
                        }
                    } else if (par1.equalsIgnoreCase("maxchunk")) {
                        if (par3.equals("")) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " maxInChunk is " + TextFormatting.AQUA + entityData.getMaxInChunk() + TextFormatting.WHITE + ".", new Object[0]));
                            return;
                        }
                        try {
                            entityData.setMaxSpawn(Integer.parseInt(par3));
                            prop = entityData.getEntityConfig().get(entityData.getEntityName(), "maxchunk");
                            prop.value = par3;
                            saved = true;
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " maxInChunk to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                        }
                        catch (NumberFormatException ex) {
                            this.sendCommandHelp(sender);
                        }
                    } else if (par1.equalsIgnoreCase("canspawn")) {
                        if (par3.equals("")) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " canSpawn is " + TextFormatting.AQUA + entityData.getCanSpawn() + TextFormatting.WHITE + ".", new Object[0]));
                            return;
                        }
                        try {
                            entityData.setCanSpawn(Boolean.parseBoolean(par3));
                            prop = entityData.getEntityConfig().get(entityData.getEntityName(), "canSpawn");
                            prop.set(par3);
                            saved = true;
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entityData.getEntityName() + TextFormatting.WHITE + " canSpawn to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                        }
                        catch (NumberFormatException ex) {
                            this.sendCommandHelp(sender);
                        }
                    }
                    if (saved) {
                        CustomSpawner.INSTANCE.updateSpawnListEntry(entityData);
                        entityData.getEntityConfig().save();
                        return;
                    }
                }
            } else {
                if (par1.equalsIgnoreCase("spawntickrate") && args.length <= 3) {
                    config = environment.CMSLivingSpawnTypeConfig;
                    config.load();
                    if (par2.equals("")) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("Please specify a valid LivingSpawnType from the following list :", new Object[0]));
                        for (EntitySpawnType entitySpawnType : environment.entitySpawnTypes.values()) {
                            if (entitySpawnType.name().equals("UNDEFINED")) continue;
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entitySpawnType.name(), new Object[0]));
                        }
                        return;
                    }
                    EntitySpawnType entitySpawnType = environment.entitySpawnTypes.get(par2.toUpperCase());
                    if (entitySpawnType == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "The LivingSpawnType " + par2 + " is not valid.", new Object[0]));
                        return;
                    }
                    if (par3.equals("")) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entitySpawnType.name() + TextFormatting.WHITE + " spawnTickRate is " + TextFormatting.AQUA + entitySpawnType.getSpawnTickRate() + TextFormatting.WHITE + ".", new Object[0]));
                        return;
                    }
                    CMSConfigCategory typeCat = config.getCategory(par2.toLowerCase());
                    CMSProperty prop = typeCat.get(par1.toLowerCase());
                    if (prop != null) {
                        prop.value = par3;
                    }
                    entitySpawnType.setSpawnTickRate(Integer.parseInt(par3));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entitySpawnType.name() + TextFormatting.WHITE + " spawnTickRate to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                    config.save();
                    environment.readConfigValues();
                    return;
                }
                if (par1.equalsIgnoreCase("spawncap") && args.length <= 3) {
                    config = environment.CMSLivingSpawnTypeConfig;
                    if (par2.equals("")) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("Please specify a valid LivingSpawnType from the following list :", new Object[0]));
                        for (EntitySpawnType entitySpawnType : environment.entitySpawnTypes.values()) {
                            if (entitySpawnType.name().equals("UNDEFINED")) continue;
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entitySpawnType.name(), new Object[0]));
                        }
                        return;
                    }
                    EntitySpawnType entitySpawnType = environment.entitySpawnTypes.get(par2.toUpperCase());
                    if (entitySpawnType == null) {
                        return;
                    }
                    if (par3.equals("")) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + entitySpawnType.name() + TextFormatting.WHITE + " spawnCap is " + TextFormatting.AQUA + entitySpawnType.getSpawnCap() + TextFormatting.WHITE + ".", new Object[0]));
                        return;
                    }
                    CMSConfigCategory typeCat = config.getCategory(par2.toLowerCase());
                    CMSProperty prop = typeCat.get(par1.toLowerCase());
                    if (prop != null) {
                        prop.value = par3;
                    }
                    entitySpawnType.setSpawnCap(Integer.parseInt(par3));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + entitySpawnType.name() + TextFormatting.WHITE + " spawnCap to " + TextFormatting.AQUA + par3 + TextFormatting.WHITE + ".", new Object[0]));
                    config.save();
                    environment.readConfigValues();
                    return;
                }
                if (par1.equalsIgnoreCase("tag") || par1.equalsIgnoreCase("tags")) {
                    for (Map.Entry<String, EntityModData> modEntry : environment.entityModMap.entrySet()) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + modEntry.getKey() + TextFormatting.WHITE + " uses tag " + TextFormatting.LIGHT_PURPLE + modEntry.getValue().getModTag(), new Object[0]));
                    }
                    return;
                }
                if (args.length == 1) {
                    for (Map.Entry<String, CMSConfigCategory> catEntry : config.categories.entrySet()) {
                        for (Map.Entry<String, CMSProperty> propEntry : catEntry.getValue().entrySet()) {
                            if (propEntry.getValue() == null || !propEntry.getKey().equalsIgnoreCase(par1)) continue;
                            List<String> propList = propEntry.getValue().valueList;
                            String propValue = propEntry.getValue().value;
                            if (propList == null && propValue == null || !par2.equals("")) continue;
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + propEntry.getKey() + TextFormatting.WHITE + " is " + TextFormatting.AQUA + propValue, new Object[0]));
                            return;
                        }
                    }
                } else {
                    for (Map.Entry<String, CMSConfigCategory> catEntry : config.categories.entrySet()) {
                        for (Map.Entry<String, CMSProperty> propEntry : catEntry.getValue().entrySet()) {
                            if (propEntry.getValue() == null || !propEntry.getKey().equalsIgnoreCase(par1)) continue;
                            CMSProperty property = propEntry.getValue();
                            List<String> propList = propEntry.getValue().valueList;
                            String propValue = propEntry.getValue().value;
                            if (propList == null && propValue == null) continue;
                            if (propEntry.getValue().getType() == CMSProperty.Type.BOOLEAN) {
                                if (!par2.equalsIgnoreCase("true") && !par2.equalsIgnoreCase("false")) continue;
                                property.set(par2);
                                saved = true;
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + propEntry.getKey() + " to " + TextFormatting.AQUA + par2 + ".", new Object[0]));
                                continue;
                            }
                            if (propEntry.getValue().getType() == CMSProperty.Type.INTEGER) {
                                try {
                                    Integer.parseInt(par2);
                                    property.set(par2);
                                    saved = true;
                                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + propEntry.getKey() + " to " + TextFormatting.AQUA + par2 + ".", new Object[0]));
                                }
                                catch (NumberFormatException ex) {
                                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Invalid value entered. Please enter a valid number.", new Object[0]));
                                }
                                continue;
                            }
                            if (propEntry.getValue().getType() != CMSProperty.Type.DOUBLE) continue;
                            try {
                                Double.parseDouble(par2);
                                property.set(par2);
                                saved = true;
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("Set " + TextFormatting.GREEN + propEntry.getKey() + " to " + TextFormatting.AQUA + par2 + ".", new Object[0]));
                            }
                            catch (NumberFormatException ex) {
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.RED + "Invalid value entered. Please enter a valid number.", new Object[0]));
                            }
                        }
                    }
                }
            }
        }
        if (par1.equalsIgnoreCase("help")) {
            List<String> list = this.getSortedPossibleCommands(sender);
            int b0 = 10;
            int i = (list.size() - 1) / b0;
            int j = 0;
            if (args.length > 1) {
                try {
                    j = args.length == 0 ? 0 : CommandCMS.func_175764_a((String)args[1], (int)1, (int)(i + 1)) - 1;
                }
                catch (NumberInvalidException numberinvalidexception) {
                    numberinvalidexception.printStackTrace();
                }
            }
            int k = Math.min((j + 1) * b0, list.size());
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.DARK_GREEN + "--- Showing CustomSpawner help page " + Integer.valueOf(j + 1) + " of " + Integer.valueOf(i + 1) + "(/moc help <page>)---", new Object[0]));
            for (int l = j * b0; l < k; ++l) {
                String command = list.get(l);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(command, new Object[0]));
            }
        }
        if (saved) {
            config.save();
            environment.readConfigValues();
        } else {
            this.sendCommandHelp(sender);
        }
    }

    protected List<String> getSortedPossibleCommands(ICommandSender par1ICommandSender) {
        Collections.sort(commands);
        return commands;
    }

    public void sendCommandHelp(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a72Listing CustomSpawner commands", new Object[0]));
        for (int i = 0; i < commands.size(); ++i) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(commands.get(i), new Object[0]));
        }
    }

    public void sendPageHelp(ICommandSender sender, byte pagelimit, ArrayList<String> list, String[] par2ArrayOfStr, String title) {
        int x = (list.size() - 1) / pagelimit;
        int j = 0;
        if (Character.isDigit(par2ArrayOfStr[par2ArrayOfStr.length - 1].charAt(0))) {
            try {
                j = par2ArrayOfStr.length == 0 ? 0 : CommandCMS.func_175764_a((String)par2ArrayOfStr[par2ArrayOfStr.length - 1], (int)1, (int)(x + 1)) - 1;
            }
            catch (NumberInvalidException numberinvalidexception) {
                numberinvalidexception.printStackTrace();
            }
        }
        int k = Math.min((j + 1) * pagelimit, list.size());
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.WHITE + title + " (pg " + TextFormatting.WHITE + Integer.valueOf(j + 1) + TextFormatting.DARK_GREEN + "/" + TextFormatting.WHITE + Integer.valueOf(x + 1) + ")", new Object[0]));
        for (int l = j * pagelimit; l < k; ++l) {
            String tamedInfo = list.get(l);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(tamedInfo, new Object[0]));
        }
    }

    static {
        commands.add("/cms addbg <tag|entity> <group>");
        commands.add("/cms bg");
        commands.add("/cms bg <tag|entity>");
        commands.add("/cms canspawn <tag|entity> <boolean>");
        commands.add("/cms chunkspawning <boolean>");
        commands.add("/cms countentities");
        commands.add("/cms countentities chunk");
        commands.add("/cms debug <boolean>");
        commands.add("/cms despawnlightlevel <boolean>");
        commands.add("/cms despawntickrate <int>");
        commands.add("/cms enforcemaxspawnlimits <boolean>");
        commands.add("/cms entityspawnrange <int>");
        commands.add("/cms forcedespawns <boolean>");
        commands.add("/cms frequency <tag|name> <int>");
        commands.add("/cms killall");
        commands.add("/cms killall <tag|entity>");
        commands.add("/cms killall force");
        commands.add("/cms killall tamed <playername>");
        commands.add("/cms lightlevel <int>");
        commands.add("/cms min <tag|entity> <int>");
        commands.add("/cms max <tag|entity> <int>");
        commands.add("/cms removebg <tag|entity> <group>");
        commands.add("/cms spawncap <livingtype> <int>");
        commands.add("/cms spawntickrate <livingtype> <int>");
        commands.add("/cms tag");
        aliases.add("cms");
        tabCompletionStrings.add("addbg");
        tabCompletionStrings.add("bg");
        tabCompletionStrings.add("canspawn");
        tabCompletionStrings.add("chunkspawning");
        tabCompletionStrings.add("countentities");
        tabCompletionStrings.add("debug");
        tabCompletionStrings.add("despawnlightlevel");
        tabCompletionStrings.add("despawntickrate");
        tabCompletionStrings.add("enforcemaxspawnlimits");
        tabCompletionStrings.add("entityspawnrange");
        tabCompletionStrings.add("forcedespawns");
        tabCompletionStrings.add("killall");
        tabCompletionStrings.add("lightlevel");
        tabCompletionStrings.add("min");
        tabCompletionStrings.add("max");
        tabCompletionStrings.add("removebg");
        tabCompletionStrings.add("spawncap");
        tabCompletionStrings.add("spawntickrate");
        tabCompletionStrings.add("tag");
    }
}

