/*
 * Decompiled with CFR 0.152.
 */
package drzhark.customspawner.environment;

import com.google.common.collect.Sets;
import drzhark.customspawner.CustomSpawner;
import drzhark.customspawner.biomes.BiomeData;
import drzhark.customspawner.biomes.BiomeGroupData;
import drzhark.customspawner.biomes.BiomeModData;
import drzhark.customspawner.configuration.CMSConfigCategory;
import drzhark.customspawner.configuration.CMSConfiguration;
import drzhark.customspawner.configuration.CMSProperty;
import drzhark.customspawner.entity.EntityData;
import drzhark.customspawner.entity.EntityModData;
import drzhark.customspawner.registry.StructureRegistry;
import drzhark.customspawner.type.EntitySpawnType;
import drzhark.customspawner.utils.CMSLog;
import drzhark.customspawner.utils.CMSUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.GameData;

public class EnvironmentSettings {
    public boolean worldGenCreatureSpawning = true;
    public boolean killallUseLightLevel;
    public boolean killallVillagers;
    public boolean enforceMaxSpawnLimits;
    public int minDespawnLightLevel = 2;
    public int maxDespawnLightLevel = 7;
    public boolean forceDespawns;
    public boolean debug;
    private File ROOT_PATH;
    private String name;
    private Class<? extends WorldProvider> worldProviderClass;
    public Map<String, EntityData> entityMap = new TreeMap<String, EntityData>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, EnumCreatureType> entityTypes = new HashMap<String, EnumCreatureType>();
    public Map<String, BiomeData> biomeMap = new TreeMap<String, BiomeData>();
    public Map<String, BiomeGroupData> biomeGroupMap = new TreeMap<String, BiomeGroupData>(String.CASE_INSENSITIVE_ORDER);
    public Map<String, EntityModData> entityModMap = new TreeMap<String, EntityModData>(String.CASE_INSENSITIVE_ORDER);
    public Map<String, EntityModData> defaultModMap = new TreeMap<String, EntityModData>(String.CASE_INSENSITIVE_ORDER);
    public Map<String, BiomeModData> biomeModMap = new TreeMap<String, BiomeModData>(String.CASE_INSENSITIVE_ORDER);
    public Map<Class<? extends Entity>, EntityData> classToEntityMapping = new HashMap<Class<? extends Entity>, EntityData>();
    public Map<String, EntitySpawnType> entitySpawnTypes = new TreeMap<String, EntitySpawnType>(String.CASE_INSENSITIVE_ORDER);
    public EntitySpawnType LIVINGTYPE_UNDEFINED = new EntitySpawnType(this, "UNDEFINED", 0, 0, 0.0f, false);
    public EntitySpawnType LIVINGTYPE_CREATURE = new EntitySpawnType(this, "CREATURE", 400, 40, 0.1f, true);
    public EntitySpawnType LIVINGTYPE_AMBIENT = new EntitySpawnType(this, "AMBIENT", 100, 20);
    public EntitySpawnType LIVINGTYPE_WATERCREATURE = new EntitySpawnType(this, "WATER_CREATURE", 100, 25, Material.field_151586_h);
    public EntitySpawnType LIVINGTYPE_MONSTER = new EntitySpawnType(this, "MONSTER", 1, 70);
    public EntitySpawnType LIVINGTYPE_UNDERGROUND = new EntitySpawnType(this, "UNDERGROUND", 400, 15, 0, 63, 0.0f, (Boolean)false);
    public Map<String, String> worldEnvironmentMap = new HashMap<String, String>();
    public StructureRegistry structureData = new StructureRegistry();
    private Set<BiomeDictionary.Type> biomeTypes = new HashSet<BiomeDictionary.Type>();
    private static final String CATEGORY_CUSTOMSPAWNER_SETTINGS = "customspawner-settings";
    private static final String CATEGORY_BIOMEGROUP_DEFAULTS = "biomegroup-defaults";
    private static final String CATEGORY_MOD_MAPPINGS = "mod-mappings";
    private static final String CREATURES_FILE_PATH = File.separator + "Creatures" + File.separator;
    private static final String BIOMES_FILE_PATH = File.separator + "Biomes" + File.separator;
    public CMSConfiguration CMSEnvironmentConfig;
    public CMSConfiguration CMSStructureConfig;
    public CMSConfiguration CMSEntityBiomeGroupsConfig;
    public CMSConfiguration CMSLivingSpawnTypeConfig;
    public CMSLog envLog;

    public EnvironmentSettings(File root, String name, Class<? extends WorldProvider> worldProviderClass) {
        this.ROOT_PATH = root;
        this.envLog = new CMSLog(name);
        this.name = name;
        this.worldProviderClass = worldProviderClass;
        this.registerConfigs();
        this.registerLivingSpawnTypes();
        this.genModConfiguration();
        this.readConfigValues();
    }

    public String name() {
        return this.name;
    }

    public Class<? extends WorldProvider> getWorldProviderClass() {
        return this.worldProviderClass;
    }

    private void registerConfigs() {
        this.CMSEnvironmentConfig = new CMSConfiguration(new File(this.ROOT_PATH, "Environment.cfg"));
        this.CMSStructureConfig = new CMSConfiguration(new File(this.ROOT_PATH, "Structures.cfg"));
        this.CMSLivingSpawnTypeConfig = new CMSConfiguration(new File(this.ROOT_PATH, "EntitySpawnTypes.cfg"));
        this.CMSEntityBiomeGroupsConfig = new CMSConfiguration(new File(this.ROOT_PATH, "EntityBiomeGroups.cfg"));
        this.CMSEnvironmentConfig.load();
        this.CMSEntityBiomeGroupsConfig.load();
        this.CMSStructureConfig.load();
        this.CMSLivingSpawnTypeConfig.load();
        this.envLog.logger.info("Initializing WorldSettings Config File at " + this.ROOT_PATH + "...");
    }

    public void registerLivingSpawnTypes() {
        this.entitySpawnTypes.put("UNDEFINED", this.LIVINGTYPE_UNDEFINED);
        this.entitySpawnTypes.put("CREATURE", this.LIVINGTYPE_CREATURE);
        this.entitySpawnTypes.put("AMBIENT", this.LIVINGTYPE_AMBIENT);
        this.entitySpawnTypes.put("MONSTER", this.LIVINGTYPE_MONSTER);
        this.entitySpawnTypes.put("WATER_CREATURE", this.LIVINGTYPE_WATERCREATURE);
        this.entitySpawnTypes.put("UNDERGROUND", this.LIVINGTYPE_UNDERGROUND);
        for (EntitySpawnType entitySpawnType : this.entitySpawnTypes.values()) {
            if (entitySpawnType.name().equalsIgnoreCase("UNDEFINED") || this.CMSLivingSpawnTypeConfig.hasCategory(entitySpawnType.name().toLowerCase())) continue;
            CMSConfigCategory configCat = this.CMSLivingSpawnTypeConfig.getCategory(entitySpawnType.name().toLowerCase());
            configCat.put("SpawnTickRate", new CMSProperty("spawntickrate", Integer.toString(entitySpawnType.getSpawnTickRate()), CMSProperty.Type.INTEGER));
            configCat.put("MobSpawnRange", new CMSProperty("mobspawnrange", Integer.toString(entitySpawnType.getMobSpawnRange()), CMSProperty.Type.INTEGER));
            configCat.put("minSpawnHeight", new CMSProperty("minspawnheight", Integer.toString(entitySpawnType.getMinSpawnHeight()), CMSProperty.Type.INTEGER));
            configCat.put("maxSpawnHeight", new CMSProperty("maxspawnheight", Integer.toString(entitySpawnType.getMaxSpawnHeight()), CMSProperty.Type.INTEGER));
            configCat.put("SpawnCap", new CMSProperty("spawncap", Integer.toString(entitySpawnType.getSpawnCap()), CMSProperty.Type.INTEGER));
            configCat.put("ChunkGenSpawnChance", new CMSProperty("chunkgenspawnchance", Float.toString(entitySpawnType.getChunkSpawnChance()), CMSProperty.Type.DOUBLE));
            configCat.put("ShouldSeeSky", new CMSProperty("shouldseesky", entitySpawnType.getShouldSeeSky() == null ? "UNDEFINED" : Boolean.toString(entitySpawnType.getShouldSeeSky()), CMSProperty.Type.STRING));
        }
        for (CMSConfigCategory spawnCat : this.CMSLivingSpawnTypeConfig.categories.values()) {
            try {
                for (Map.Entry<String, CMSProperty> propEntry : spawnCat.getValues().entrySet()) {
                    EntitySpawnType entitySpawnType = this.entitySpawnTypes.get(spawnCat.getQualifiedName());
                    if (entitySpawnType == null) {
                        entitySpawnType = this.entitySpawnTypes.put(spawnCat.getQualifiedName(), new EntitySpawnType(this, spawnCat.getQualifiedName()));
                    }
                    if (propEntry.getKey().equalsIgnoreCase("chunkgenspawnchance")) {
                        entitySpawnType.setChunkSpawnChance(Float.parseFloat(propEntry.getValue().value));
                        continue;
                    }
                    if (propEntry.getKey().equalsIgnoreCase("mobspawnrange")) {
                        entitySpawnType.setMobSpawnRange(Integer.parseInt(propEntry.getValue().value));
                        continue;
                    }
                    if (propEntry.getKey().equalsIgnoreCase("minspawnheight")) {
                        entitySpawnType.setMinSpawnHeight(Integer.parseInt(propEntry.getValue().value));
                        continue;
                    }
                    if (propEntry.getKey().equalsIgnoreCase("maxspawnheight")) {
                        entitySpawnType.setMaxSpawnHeight(Integer.parseInt(propEntry.getValue().value));
                        continue;
                    }
                    if (propEntry.getKey().equalsIgnoreCase("spawncap")) {
                        entitySpawnType.setSpawnCap(Integer.parseInt(propEntry.getValue().value));
                        continue;
                    }
                    if (propEntry.getKey().equalsIgnoreCase("spawntickrate")) {
                        entitySpawnType.setSpawnTickRate(Integer.parseInt(propEntry.getValue().value));
                        continue;
                    }
                    if (propEntry.getKey().equalsIgnoreCase("spawncap")) {
                        entitySpawnType.setSpawnCap(Integer.parseInt(propEntry.getValue().value));
                        continue;
                    }
                    if (!propEntry.getKey().equalsIgnoreCase("shouldseesky") || propEntry.getValue().value.equalsIgnoreCase("UNDEFINED")) continue;
                    entitySpawnType.setShouldSeeSky(Boolean.parseBoolean(propEntry.getValue().value));
                }
            }
            catch (Throwable throwable) {
            }
        }
        this.CMSLivingSpawnTypeConfig.save();
    }

    public void updateSettings() {
        this.readConfigValues();
        this.CMSEnvironmentConfig.load();
        this.CMSStructureConfig.load();
        this.populateSpawnBiomes();
        this.populateSpawns();
    }

    public void initializeEntities() {
        TreeMap<String, Class> sortedMap = new TreeMap<String, Class>(String.CASE_INSENSITIVE_ORDER);
        for (EntityEntry entityEntry : GameData.getEntityRegistry().getValues()) {
            sortedMap.put(entityEntry.getName(), entityEntry.getEntityClass());
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            Class clazz = (Class)entry.getValue();
            if (this.classToEntityMapping.get(clazz) == null) {
                this.registerEntity(clazz);
                continue;
            }
            this.processEntityConfig(this.classToEntityMapping.get(clazz));
        }
        this.CMSEnvironmentConfig.save();
    }

    public EntityData registerEntity(Class<? extends Entity> clazz) {
        EntityLiving entityliving = null;
        EntityData entityData = null;
        try {
            if (this.debug) {
                this.envLog.logger.info("Attempting to register Entity from class " + clazz + "...");
            }
            entityliving = (EntityLiving)clazz.getConstructor(World.class).newInstance(DimensionManager.getWorld((int)0));
        }
        catch (Throwable throwable) {
            if (this.debug) {
                this.envLog.logger.info(clazz + " is not a valid Entity for registration, Skipping...");
            }
            return null;
        }
        EntityEntry entry = EntityRegistry.getEntry(clazz);
        if (entry == null) {
            return null;
        }
        String entityName = entry.getName();
        String[] parts = entityName.split(":");
        if (parts.length > 1) {
            entityName = parts[1];
        }
        if (this.debug) {
            this.envLog.logger.info("Starting registration for " + entityName);
        }
        if (entityName.contains(".") && entityName.indexOf(".") + 1 < entityName.length()) {
            entityName = entityName.substring(entityName.indexOf(".") + 1, entityName.length());
        }
        entityName = entityName.replaceAll("[^A-Za-z0-9]", "");
        if (clazz != null && EntityLiving.class.isAssignableFrom(clazz)) {
            EntityModData modData;
            if (this.debug) {
                this.envLog.logger.info("Attempting to find a valid type for " + entityName + "...");
            }
            EnumCreatureType creatureType = null;
            Biome.SpawnListEntry spawnListEntry = CustomSpawner.defaultSpawnListEntryMap.get(clazz.getName());
            if (spawnListEntry == null) {
                spawnListEntry = new Biome.SpawnListEntry(clazz, 8, 2, 3);
            }
            if (EntityAnimal.class.isAssignableFrom(clazz) && !entityliving.isCreatureType(EnumCreatureType.AMBIENT, false) || entityliving.isCreatureType(EnumCreatureType.CREATURE, false)) {
                creatureType = EnumCreatureType.CREATURE;
                entityData = new EntityData(this, spawnListEntry, entityName, entityliving.func_145782_y(), creatureType);
            } else if ((IMob.class.isAssignableFrom(clazz) || IRangedAttackMob.class.isAssignableFrom(clazz)) && clazz != EntityMob.class || entityliving.isCreatureType(EnumCreatureType.MONSTER, false)) {
                creatureType = EnumCreatureType.MONSTER;
                entityData = new EntityData(this, spawnListEntry, entityName, entityliving.func_145782_y(), creatureType);
            } else if (EntityAmbientCreature.class.isAssignableFrom(clazz) || entityliving.isCreatureType(EnumCreatureType.AMBIENT, false)) {
                creatureType = EnumCreatureType.AMBIENT;
                entityData = new EntityData(this, spawnListEntry, entityName, entityliving.func_145782_y(), creatureType);
            } else if (EntityWaterMob.class.isAssignableFrom(clazz) || entityliving.isCreatureType(EnumCreatureType.WATER_CREATURE, false)) {
                creatureType = EnumCreatureType.WATER_CREATURE;
                entityData = new EntityData(this, spawnListEntry, entityName, entityliving.func_145782_y(), creatureType);
            } else if (clazz != EntityLiving.class && clazz != EntityMob.class) {
                entityData = new EntityData(this, spawnListEntry, entityName, entityliving.func_145782_y(), creatureType);
                entityData.setCanSpawn(false);
            } else if (entityData == null) {
                if (this.debug) {
                    this.envLog.logger.info("Could not find a valid type for Entity " + entityName + " with class " + clazz + ", skipping...");
                }
                return null;
            }
            if (this.debug) {
                this.envLog.logger.info("Detected type as " + (creatureType == null ? creatureType : creatureType.name().toUpperCase()) + ".");
            }
            entityData.setType(creatureType);
            entityData.setLivingSpawnType(creatureType);
            entityData.setEntityName(entityName);
            entityData.setEntityID(entityliving.func_145782_y());
            try {
                entityData.setMaxInChunk(entityliving.func_70641_bl());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.debug) {
                this.envLog.logger.info("Added " + (creatureType == null ? "UNDEFINED" : creatureType.toString().toUpperCase()) + " " + clazz + " with name " + entityName);
            }
            String entityClass = clazz.getName().toLowerCase();
            CMSConfiguration entityConfig = null;
            boolean undefined = true;
            if (this.debug) {
                this.envLog.logger.info("Attempting to detect mod for Entity " + entityName + "...");
            }
            if (entityClass.contains("net.minecraft.entity") || entityClass.toString().length() <= 3) {
                EntityModData modData2 = this.entityModMap.get("vanilla");
                if (this.debug) {
                    this.envLog.logger.info("Matched mod Vanilla to " + entityName);
                }
                entityData.setEntityMod(modData2);
                entityConfig = modData2.getModConfig();
                entityData.setEntityConfig(entityConfig);
                this.processEntityConfig(entityData);
                if (!modData2.addCreature(entityData)) {
                    entityData = modData2.getCreature(entityData.getLivingSpawnType(), entityName);
                    entityData.setEntityID(entityliving.func_145782_y());
                    entityData.setEntityMod(modData2);
                }
                undefined = false;
            } else {
                for (Map.Entry entry2 : this.entityModMap.entrySet()) {
                    if (!entityClass.contains((CharSequence)entry2.getKey())) continue;
                    modData = (EntityModData)entry2.getValue();
                    if (this.debug) {
                        this.envLog.logger.info("Matched mod " + (String)entry2.getKey() + " to " + entityClass);
                    }
                    entityData.setEntityMod(modData);
                    entityConfig = modData.getModConfig();
                    entityData.setEntityConfig(entityConfig);
                    this.processEntityConfig(entityData);
                    if (!modData.addCreature(entityData)) {
                        entityData = modData.getCreature(entityData.getLivingSpawnType(), entityName);
                        entityData.setEntityID(entityliving.func_145782_y());
                        entityData.setEntityMod(modData);
                    }
                    undefined = false;
                    break;
                }
            }
            if (undefined) {
                String modKey;
                if (this.debug) {
                    this.envLog.logger.info("Detected Undefined Entity Class " + entityClass + ". You must add a mapping for this class in MoCGlobal.cfg.");
                }
                if (!(modKey = CMSUtils.generateModPackage(entityClass)).equals("")) {
                    String string = modKey + ".cfg";
                    if (!this.entityModMap.containsKey(modKey)) {
                        this.entityModMap.put(modKey, new EntityModData(modKey, modKey, new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + string))));
                        if (this.debug) {
                            this.envLog.logger.info("Added Automatic Mod Entity Mapping " + modKey + " to file " + string);
                        }
                        CMSConfigCategory modMapCat = this.CMSEnvironmentConfig.getCategory(CATEGORY_MOD_MAPPINGS);
                        modMapCat.put(modKey, new CMSProperty(modKey, new ArrayList<String>(Arrays.asList(modKey.toUpperCase(), string)), CMSProperty.Type.STRING, "automatically generated"));
                    }
                    modData = this.entityModMap.get(modKey);
                    if (this.debug) {
                        this.envLog.logger.info("Matched mod " + modKey + " to " + entityClass);
                    }
                    entityData.setEntityMod(modData);
                    entityConfig = modData.getModConfig();
                    entityData.setEntityConfig(entityConfig);
                    this.processEntityConfig(entityData);
                    if (!modData.addCreature(entityData)) {
                        entityData = modData.getCreature(entityData.getLivingSpawnType(), entityName);
                        entityData.setEntityID(entityliving.func_145782_y());
                        entityData.setEntityMod(modData);
                    }
                } else {
                    if (this.debug) {
                        this.envLog.logger.info("Could not generate an automatic mod mapping for entity " + entityClass);
                    }
                    return null;
                }
            }
            this.classToEntityMapping.put(clazz, entityData);
            this.entityMap.put(entityData.getEntityMod().getModTag() + "|" + entityData.getEntityName(), entityData);
            return entityData;
        }
        return null;
    }

    public void processEntityConfig(EntityData entityData) {
        String entityName = entityData.getEntityName();
        CMSConfigCategory entityCategory = null;
        entityData.getEntityConfig().load();
        if (!entityData.getEntityConfig().hasCategory(entityName.toLowerCase())) {
            Biome.SpawnListEntry spawnlistentry = CustomSpawner.defaultSpawnListEntryMap.get(entityData.getEntityClass().getName());
            entityCategory = entityData.getEntityConfig().getCategory(entityName.toLowerCase());
            entityCategory.put("type", new CMSProperty("type", entityData.getType() != null ? entityData.getType().name().toUpperCase() : "UNDEFINED", CMSProperty.Type.STRING));
            entityCategory.put("canSpawn", new CMSProperty("canSpawn", Boolean.toString(entityData.getCanSpawn()), CMSProperty.Type.BOOLEAN));
            entityCategory.put("frequency", new CMSProperty("frequency", Integer.toString(spawnlistentry != null ? spawnlistentry.field_76292_a : entityData.getFrequency()), CMSProperty.Type.INTEGER));
            entityCategory.put("minSpawn", new CMSProperty("minSpawn", Integer.toString(spawnlistentry != null ? spawnlistentry.field_76301_c : entityData.getMinSpawn()), CMSProperty.Type.INTEGER));
            entityCategory.put("maxSpawn", new CMSProperty("maxSpawn", Integer.toString(spawnlistentry != null ? spawnlistentry.field_76299_d : entityData.getMaxSpawn()), CMSProperty.Type.INTEGER));
            entityCategory.put("maxChunk", new CMSProperty("maxChunk", Integer.toString(entityData.getMaxInChunk()), CMSProperty.Type.INTEGER));
            entityCategory.put("minSpawnHeight", new CMSProperty("minSpawnHeight", Integer.toString(entityData.getMinSpawnHeight()), CMSProperty.Type.INTEGER));
            entityCategory.put("maxSpawnHeight", new CMSProperty("maxSpawnHeight", Integer.toString(entityData.getMaxSpawnHeight()), CMSProperty.Type.INTEGER));
            entityCategory.put("minLightlevel", new CMSProperty("minLightlevel", Integer.toString(entityData.getMinLightLevel()), CMSProperty.Type.INTEGER));
            entityCategory.put("maxLightlevel", new CMSProperty("maxLightlevel", Integer.toString(entityData.getMaxLightLevel()), CMSProperty.Type.INTEGER));
            entityCategory.put("opaqueBlock", new CMSProperty("opaqueBlock", entityData.getOpaqueBlock() == null ? "all" : entityData.getOpaqueBlock().toString(), CMSProperty.Type.STRING));
            entityCategory.put("spawnBlockBlacklist", new CMSProperty("spawnBlockBlacklist", entityData.getSpawnBlockBlacklist(), CMSProperty.Type.STRING));
            entityData.getEntityConfig().save();
        } else {
            entityCategory = entityData.getEntityConfig().getCategory(entityName.toLowerCase());
            for (Map.Entry<String, CMSProperty> propEntry : entityCategory.getValues().entrySet()) {
                CMSProperty property = propEntry.getValue();
                if (property == null) continue;
                if (propEntry.getKey().equalsIgnoreCase("type")) {
                    entityData.setLivingSpawnType(this.entitySpawnTypes.get(property.value.toUpperCase()));
                    continue;
                }
                if (propEntry.getKey().equalsIgnoreCase("canSpawn")) {
                    entityData.setCanSpawn(Boolean.parseBoolean(property.value));
                    if (entityData.getLivingSpawnType().getSpawnCap() == 0 || !entityData.getLivingSpawnType().allowSpawning()) {
                        entityData.setCanSpawn(false);
                    }
                    if (!entityData.getLivingSpawnType().name().equalsIgnoreCase("UNDEFINED") && entityData.getFrequency() > 0 && entityData.getMaxSpawn() > 0 && entityData.getMaxInChunk() > 0) continue;
                    entityData.setCanSpawn(false);
                    continue;
                }
                if (propEntry.getKey().equalsIgnoreCase("frequency")) {
                    entityData.setFrequency(Integer.parseInt(property.value));
                    continue;
                }
                if (propEntry.getKey().equalsIgnoreCase("minSpawn")) {
                    entityData.setMinSpawn(Integer.parseInt(property.value));
                    continue;
                }
                if (propEntry.getKey().equalsIgnoreCase("maxSpawn")) {
                    entityData.setMaxSpawn(Integer.parseInt(property.value));
                    continue;
                }
                if (propEntry.getKey().equalsIgnoreCase("maxChunk")) {
                    entityData.setMaxInChunk(Integer.parseInt(property.value));
                    continue;
                }
                if (propEntry.getKey().equalsIgnoreCase("minLightLevel")) {
                    entityData.setMinLightLevel(Integer.parseInt(property.value));
                    continue;
                }
                if (propEntry.getKey().equalsIgnoreCase("opaqueBlock")) {
                    if (property.value.equalsIgnoreCase("all")) {
                        entityData.setOpaqueBlock(null);
                        continue;
                    }
                    entityData.setOpaqueBlock(Boolean.parseBoolean(property.value));
                    continue;
                }
                if (!propEntry.getKey().equalsIgnoreCase("spawnblockblacklist") || property.valueList == null) continue;
                for (int i = 0; i < property.valueList.size(); ++i) {
                    String bannedBlock = property.valueList.get(i);
                    try {
                        int blockID;
                        if (bannedBlock.indexOf("-") == -1) {
                            blockID = Integer.parseInt(bannedBlock);
                            entityData.addSpawnBlockToBanlist(Integer.toString(blockID));
                            if (!this.debug) continue;
                            this.envLog.logger.info("Added spawnblock ID " + bannedBlock + " to blacklist.");
                            continue;
                        }
                        blockID = Integer.parseInt(bannedBlock.substring(0, bannedBlock.indexOf("-")));
                        int blockMeta = Integer.parseInt(bannedBlock.substring(bannedBlock.indexOf("-"), bannedBlock.length()));
                        String block = Integer.toString(blockID) + "-" + Integer.toString(blockMeta);
                        entityData.addSpawnBlockToBanlist(block);
                        if (!this.debug) continue;
                        this.envLog.logger.info("Added spawnblock ID-Meta " + bannedBlock + " to blacklist.");
                        continue;
                    }
                    catch (Throwable e) {
                        if (!this.debug) continue;
                        this.envLog.logger.info("Failed to blacklist spawnblock " + bannedBlock + ", invalid format. Format needs to be id-meta");
                    }
                }
            }
        }
    }

    public void initializeBiomes() {
        Iterator iterator = Biome.field_185377_q.iterator();
        HashSet biomeList = Sets.newHashSet((Iterator)iterator);
        biomeList.addAll(Biome.field_185377_q.field_148758_b.keySet());
        for (Biome biome : biomeList) {
            String modKey;
            BiomeModData modData;
            if (biome == null) continue;
            String biomeName = biome.field_76791_y;
            String biomeClass = biome.getClass().getName();
            BiomeData biomeData = new BiomeData(biome);
            Set types = BiomeDictionary.getTypes((Biome)biome);
            this.biomeTypes.addAll(types);
            biomeData.setTypes(types);
            if (this.debug) {
                this.envLog.logger.info("Detected Biome " + biomeName + " with class " + biomeClass + " with biomeID " + Biome.func_185362_a((Biome)biome) + " with types " + types);
            }
            boolean found = false;
            for (Map.Entry<String, BiomeModData> modEntry : this.biomeModMap.entrySet()) {
                if (biomeClass.contains(modEntry.getKey())) {
                    modData = modEntry.getValue();
                    biomeData.setTag(modData.getModTag());
                    biomeData.setDefined(true);
                    modData.addBiome(biomeData);
                    found = true;
                    break;
                }
                if (!biomeClass.contains("net.minecraft") && biomeClass.length() > 3 || !modEntry.getKey().equalsIgnoreCase("vanilla")) continue;
                if (this.debug) {
                    this.envLog.logger.info("Matched mod " + modEntry.getKey() + " to " + biomeClass);
                }
                modData = modEntry.getValue();
                biomeData.setTag(modData.getModTag());
                biomeData.setDefined(true);
                modData.addBiome(biomeData);
                found = true;
                break;
            }
            if (found) continue;
            if (this.debug) {
                this.envLog.logger.info("Detected Undefined Biome Class " + biomeClass + ". Generating automatic mapping for this class in Environment.cfg ...");
            }
            if ((modKey = CMSUtils.generateModPackage(biomeClass)).equals("")) continue;
            String configName = modKey + ".cfg";
            modData = new BiomeModData(modKey, modKey, new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), BIOMES_FILE_PATH + configName)));
            if (this.debug) {
                this.envLog.logger.info("Added Automatic Mod Biome Mapping " + modKey + " with tag " + modKey + " to file " + configName);
            }
            CMSConfigCategory modMapCat = this.CMSEnvironmentConfig.getCategory(CATEGORY_MOD_MAPPINGS);
            modMapCat.put(modKey, new CMSProperty(modKey, new ArrayList<String>(Arrays.asList(modKey.toUpperCase(), configName)), CMSProperty.Type.STRING, "automatically generated"));
            biomeData.setTag(modData.getModTag());
            biomeData.setDefined(true);
            modData.addBiome(biomeData);
            this.biomeModMap.put(modKey, modData);
        }
        for (Map.Entry entry : this.biomeModMap.entrySet()) {
            for (BiomeDictionary.Type type : this.biomeTypes) {
                BiomeModData modData = (BiomeModData)entry.getValue();
                CMSProperty prop = modData.getModConfig().get("biomegroups", "biomegroups");
                if (prop != null && prop.valueList != null) {
                    prop.valueList = modData.getBiomes();
                } else {
                    modData.getModConfig().get("biomegroups", type.getName(), modData.getBiomesForType(type));
                }
                modData.getModConfig().save();
            }
        }
        this.CMSEnvironmentConfig.addCustomCategoryComment(CATEGORY_MOD_MAPPINGS, "Mod Biome Mappings\nYou may change tag values but do NOT change the default keys since they are used to generate our defaults.\nFor example, 'twilightforest=TL:TwilightForest.cfg' may be changed to 'twilightforest=TWL:TWL.cfg' but may NOT be changed to 'twilight=TWL:TWL.cfg'");
        this.CMSEnvironmentConfig.save();
        this.initDefaultGroups();
    }

    public void initDefaultGroups() {
        for (BiomeDictionary.Type type : this.biomeTypes) {
            ArrayList<String> biomes = new ArrayList<String>();
            block1: for (Biome biome : BiomeDictionary.getBiomes((BiomeDictionary.Type)type)) {
                for (Map.Entry<String, BiomeModData> modEntry : this.biomeModMap.entrySet()) {
                    BiomeModData biomeModData = modEntry.getValue();
                    if (!biomeModData.hasBiome(biome)) continue;
                    biomes.add(biomeModData.getModTag() + "|" + biome.field_76791_y);
                    continue block1;
                }
            }
            CMSProperty prop = new CMSProperty(type.getName(), biomes, CMSProperty.Type.STRING);
            if (!biomes.isEmpty()) {
                if (this.biomeGroupMap.containsKey(type.getName())) {
                    this.biomeGroupMap.remove(type.getName());
                }
                this.biomeGroupMap.put(type.getName(), new BiomeGroupData(type.getName(), biomes));
                Collections.sort(biomes);
                prop.valueList = biomes;
                if (this.debug) {
                    this.envLog.logger.info("Successfully added Biome Group " + type.getName());
                }
            }
            this.CMSEntityBiomeGroupsConfig.getCategory(CATEGORY_BIOMEGROUP_DEFAULTS).put(type.getName(), prop);
            this.CMSEntityBiomeGroupsConfig.save();
        }
    }

    public void populateSpawnBiomes() {
        if (this.debug) {
            this.envLog.logger.info("Populating spawn biomes for environment " + this.name);
        }
        this.CMSEntityBiomeGroupsConfig.load();
        for (EntityData entityData : this.entityMap.values()) {
            if (this.debug) {
                this.envLog.logger.info("generating biome spawn list for entity " + entityData.getEntityName());
            }
            entityData.getEntityConfig().load();
            CMSConfigCategory entityCategory = entityData.getEntityConfig().getCategory(entityData.getEntityName().toLowerCase());
            if (entityCategory.containsKey("biomegroups")) {
                List<String> biomeGroups = entityCategory.get((String)"biomegroups").valueList;
                for (int i = 0; i < biomeGroups.size(); ++i) {
                    String biomeGroupName = biomeGroups.get(i);
                    ArrayList spawnBiomes = new ArrayList();
                    if (this.CMSEntityBiomeGroupsConfig.getCategory(CATEGORY_BIOMEGROUP_DEFAULTS).containsKey(entityData.getEntityMod().getModTag().toUpperCase() + "_" + biomeGroupName)) {
                        biomeGroupName = entityData.getEntityMod().getModTag().toUpperCase() + "_" + biomeGroups.get(i);
                        CMSProperty cMSProperty = this.CMSEntityBiomeGroupsConfig.getCategory(CATEGORY_BIOMEGROUP_DEFAULTS).get(biomeGroupName);
                        for (int j = 0; j < cMSProperty.valueList.size(); ++j) {
                            List<String> biomeParts = CMSUtils.parseName(cMSProperty.valueList.get(j));
                            BiomeModData biomeModData = CMSUtils.getBiomeModData(this.biomeModMap, biomeParts.get(0));
                            if (biomeModData == null) continue;
                            if (this.debug) {
                                this.envLog.logger.info("adding spawn biome " + cMSProperty.valueList.get(j) + " for entity " + entityData.getEntityName());
                            }
                            spawnBiomes.add(biomeModData.getBiome(cMSProperty.valueList.get(j)));
                            entityData.addSpawnBiome(biomeModData.getBiome(cMSProperty.valueList.get(j)));
                        }
                        entityData.addBiomeGroupSpawnMap(biomeGroupName, spawnBiomes);
                        continue;
                    }
                    for (Map.Entry<String, BiomeModData> modEntry : this.biomeModMap.entrySet()) {
                        BiomeModData biomeModData = modEntry.getValue();
                        CMSConfigCategory cat = biomeModData.getModConfig().getCategory("biomegroups");
                        if (!cat.containsKey(biomeGroupName)) continue;
                        CMSProperty biomeProps = cat.get(biomeGroupName);
                        for (int j = 0; j < biomeProps.valueList.size(); ++j) {
                            Biome biome;
                            if (spawnBiomes.contains(biomeModData.getBiome(biomeModData.getModTag() + "|" + biomeProps.valueList.get(j))) || (biome = biomeModData.getBiome(biomeModData.getModTag() + "|" + biomeProps.valueList.get(j))) == null) continue;
                            spawnBiomes.add(biome);
                            entityData.addSpawnBiome(biome);
                        }
                    }
                    entityData.addBiomeGroupSpawnMap(biomeGroupName, spawnBiomes);
                }
                entityData.setBiomeGroups(biomeGroups);
            } else {
                CMSConfigCategory entityBiomeGroupCat;
                if (this.debug) {
                    this.envLog.logger.info("Could not find existing biomegroups for entity " + entityData.getEntityName() + ", generating defaults...");
                }
                ArrayList<String> biomes = new ArrayList<String>();
                ArrayList<Biome> entryBiomes = CustomSpawner.entityDefaultSpawnBiomes.get(entityData.getEntityClass().getName());
                if (entryBiomes != null) {
                    for (int i = 0; i < entryBiomes.size(); ++i) {
                        for (Map.Entry entry : this.biomeModMap.entrySet()) {
                            BiomeModData biomeModData = (BiomeModData)entry.getValue();
                            if (!biomeModData.hasBiome(entryBiomes.get(i))) continue;
                            if (this.debug) {
                                this.envLog.logger.info("Adding biome " + biomeModData.getModTag() + "|" + entryBiomes.get((int)i).field_76791_y + " to biomegroups for entity " + entityData.getEntityName() + " in environment " + this.name());
                            }
                            biomes.add(biomeModData.getModTag() + "|" + entryBiomes.get((int)i).field_76791_y);
                            entityData.addSpawnBiome(entryBiomes.get(i));
                        }
                    }
                } else if (this.debug) {
                    this.envLog.logger.info("No default biomes found for entity " + entityData.getEntityName());
                }
                if (!(entityBiomeGroupCat = this.CMSEntityBiomeGroupsConfig.getCategory(CATEGORY_BIOMEGROUP_DEFAULTS)).containsKey(entityData.getEntityMod().getModTag() + "_" + entityData.getEntityName().toUpperCase() + "_DEFAULT")) {
                    CMSProperty prop = new CMSProperty(entityData.getEntityMod().getModTag() + "_" + entityData.getEntityName().toUpperCase() + "_DEFAULT", biomes, CMSProperty.Type.STRING);
                    this.CMSEntityBiomeGroupsConfig.getCategory(CATEGORY_BIOMEGROUP_DEFAULTS).put(entityData.getEntityMod().getModTag() + "_" + entityData.getEntityName().toUpperCase() + "_DEFAULT", prop);
                    entityCategory.put("biomegroups", new CMSProperty("biomegroups", new ArrayList<String>(Arrays.asList(entityData.getEntityName().toUpperCase() + "_DEFAULT")), CMSProperty.Type.STRING));
                    entityData.setBiomeGroups(prop.valueList);
                    this.biomeGroupMap.put(entityData.getEntityMod().getModTag() + "_" + entityData.getEntityName().toUpperCase() + "_DEFAULT", new BiomeGroupData(entityData.getEntityMod().getModTag() + "_" + entityData.getEntityName().toUpperCase() + "_DEFAULT", biomes));
                }
            }
            entityData.getEntityConfig().save();
        }
        this.CMSEntityBiomeGroupsConfig.save();
    }

    public void populateSpawns() {
        if (this.debug) {
            this.envLog.logger.info("Populating spawns...");
        }
        if (this.debug) {
            this.envLog.logger.info("Scanning mod configs for entities...");
        }
        for (Map.Entry<String, EntityModData> modEntry : this.entityModMap.entrySet()) {
            for (EntitySpawnType entitySpawnType : this.entitySpawnTypes.values()) {
                if (entitySpawnType.name().equalsIgnoreCase("UNDEFINED") || modEntry.getValue().getSpawnListFromType(entitySpawnType) == null) continue;
                for (Map.Entry<String, EntityData> entityEntry : modEntry.getValue().getSpawnListFromType(entitySpawnType).entrySet()) {
                    EntityData entityData = entityEntry.getValue();
                    if (entityData.getSpawnBiomes() != null && entityData.getSpawnBiomes().size() > 0 && entityData.getLivingSpawnType() != null) {
                        Biome[] biomesToSpawn = new Biome[entityData.getSpawnBiomes().size()];
                        biomesToSpawn = entityData.getSpawnBiomes().toArray(biomesToSpawn);
                        if (this.debug) {
                            this.envLog.logger.info(entityData.getEntityName() + " canSpawn = " + entityData.getCanSpawn());
                        }
                        if (entityData.getCanSpawn()) {
                            CustomSpawner.instance().AddCustomSpawn(entityData.getEntityClass(), entityData.getFrequency(), entityData.getMinSpawn(), entityData.getMaxSpawn(), entityData.getLivingSpawnType(), biomesToSpawn);
                            if (!this.debug) continue;
                            this.envLog.logger.info("Added " + entityData.getEntityClass() + " to CustomSpawner spawn lists");
                            continue;
                        }
                        if (this.debug) {
                            this.envLog.logger.info("Removing " + entityData.getEntityClass() + " from CustomSpawner spawn lists");
                        }
                        CustomSpawner.instance().RemoveCustomSpawn(entityData.getEntityClass(), entityData.getLivingSpawnType(), biomesToSpawn);
                        continue;
                    }
                    if (!this.debug) continue;
                    this.envLog.logger.info("Skipping " + entityData.getEntityClass() + " spawn!!" + ", spawnbiomes = " + entityData.getSpawnBiomes());
                }
            }
        }
    }

    public void genModConfiguration() {
        this.entityTypes.put("UNDEFINED", null);
        this.entityTypes.put("CREATURE", EnumCreatureType.CREATURE);
        this.entityTypes.put("MONSTER", EnumCreatureType.MONSTER);
        this.entityTypes.put("WATER_CREATURE", EnumCreatureType.WATER_CREATURE);
        this.entityTypes.put("AMBIENT", EnumCreatureType.AMBIENT);
        CMSConfigCategory modMapCat = this.CMSEnvironmentConfig.getCategory(CATEGORY_MOD_MAPPINGS);
        this.defaultModMap.put("vanilla", new EntityModData("vanilla", "MC", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "Vanilla.cfg"))));
        this.defaultModMap.put("undefined", new EntityModData("undefined", "U", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "Undefined.cfg"))));
        if (Loader.isModLoaded((String)"mocreatures")) {
            this.defaultModMap.put("drzhark", new EntityModData("drzhark", "MOC", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "MoCreatures.cfg"))));
        }
        if (Loader.isModLoaded((String)"biomesoplenty")) {
            this.defaultModMap.put("biomesop", new EntityModData("biomesop", "BOP", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "BiomesOPlenty.cfg"))));
        }
        if (Loader.isModLoaded((String)"bwg4")) {
            this.defaultModMap.put("ted80", new EntityModData("ted80", "BWG", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "BWG.cfg"))));
        }
        if (Loader.isModLoaded((String)"extrabiomesxl")) {
            this.defaultModMap.put("extrabiomes", new EntityModData("extrabiomes", "XL", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "ExtraBiomesXL.cfg"))));
        }
        if (Loader.isModLoaded((String)"twilightforest")) {
            this.defaultModMap.put("twilightforest", new EntityModData("twilightforest", "TF", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "TwilightForest.cfg"))));
        }
        if (Loader.isModLoaded((String)"grimoiregaia")) {
            this.defaultModMap.put("gaia", new EntityModData("gaia", "GAIA", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "GrimoireOfGaia.cfg"))));
        }
        if (Loader.isModLoaded((String)"infernalmobs")) {
            this.defaultModMap.put("atomicstryker", new EntityModData("atomicstryker", "IM", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "InfernalMobs.cfg"))));
        }
        if (Loader.isModLoaded((String)"arsmagica2")) {
            this.defaultModMap.put("arsmagica", new EntityModData("arsmagica", "ARS", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "ArsMagica.cfg"))));
        }
        if (Loader.isModLoaded((String)"projectzulu|core") || Loader.isModLoaded((String)"ProjectZulu|Mob")) {
            this.defaultModMap.put("projectzulu", new EntityModData("projectzulu", "PZ", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "ProjectZulu.cfg"))));
        }
        if (Loader.isModLoaded((String)"thaumcraft")) {
            this.defaultModMap.put("thaumcraft", new EntityModData("thaumcraft", "TC", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "Thaumcraft.cfg"))));
        }
        if (Loader.isModLoaded((String)"Highlands")) {
            this.defaultModMap.put("highlands", new EntityModData("highlands", "HL", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "Highlands.cfg"))));
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            this.defaultModMap.put("tinker", new EntityModData("tinker", "TC", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "TinkerConstruct.cfg"))));
        }
        if (Loader.isModLoaded((String)"atum")) {
            this.defaultModMap.put("atum", new EntityModData("atum", "ATUM", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "Atum.cfg"))));
        }
        if (Loader.isModLoaded((String)"angrycreatures")) {
            this.defaultModMap.put("advancedglowstone", new EntityModData("advancedglowstone", "AC", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "AngryCreatures.cfg"))));
        }
        if (Loader.isModLoaded((String)"minefantasy")) {
            this.defaultModMap.put("minefantasy", new EntityModData("minefantasy", "MF", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "MineFantasy.cfg"))));
        }
        if (Loader.isModLoaded((String)"primitivemobs")) {
            this.defaultModMap.put("primitivemobs", new EntityModData("primitivemobs", "PM", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "PrimitiveMobs.cfg"))));
        }
        if (Loader.isModLoaded((String)"atmosmobs")) {
            this.defaultModMap.put("atmosmobs", new EntityModData("atmosmobs", "ATMOS", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "AtmosMobs.cfg"))));
        }
        if (Loader.isModLoaded((String)"farlanders")) {
            this.defaultModMap.put("farlanders", new EntityModData("farlanders", "FL", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + "Farlanders.cfg"))));
        }
        if (Loader.isModLoaded((String)"terraincontrol")) {
            this.biomeModMap.put("terraincontrol", new BiomeModData("terraincontrol", "TC", new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), BIOMES_FILE_PATH + "terraincontrol.cfg"))));
        }
        for (Map.Entry<String, EntityModData> entry : this.defaultModMap.entrySet()) {
            ArrayList<String> values = new ArrayList<String>(Arrays.asList(entry.getValue().getModTag(), entry.getValue().getModConfig().getFileName() + ".cfg"));
            modMapCat.put(entry.getKey(), new CMSProperty(entry.getKey(), values, CMSProperty.Type.STRING));
            this.biomeModMap.put(entry.getKey(), new BiomeModData(entry.getKey(), entry.getValue().getModTag(), new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), BIOMES_FILE_PATH + entry.getValue().getModConfig().getFileName() + ".cfg"))));
            this.entityModMap.put(entry.getKey(), new EntityModData(entry.getKey(), entry.getValue().getModTag(), new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + entry.getValue().getModConfig().getFileName() + ".cfg"))));
            if (this.debug) {
                this.envLog.logger.info("Added Mod Entity Mapping " + entry.getKey() + " to file " + entry.getValue().getModConfig().getFileName() + ".cfg");
            }
            if (!this.debug) continue;
            this.envLog.logger.info("Added Mod Biome Mapping " + entry.getKey() + " with tag " + entry.getValue().getModTag() + " to file " + entry.getValue().getModConfig().getFileName() + ".cfg");
        }
        for (Map.Entry<String, Object> entry : modMapCat.entrySet()) {
            CMSProperty prop = (CMSProperty)entry.getValue();
            if (prop == null || this.biomeModMap.containsKey(entry.getKey()) || prop.valueList.size() != 2) continue;
            this.biomeModMap.put(entry.getKey(), new BiomeModData(entry.getKey(), prop.valueList.get(0), new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), BIOMES_FILE_PATH + prop.valueList.get(1)))));
            if (this.debug) {
                this.envLog.logger.info("Added Custom Mod Biome Mapping " + entry.getKey() + " with tag " + prop.valueList.get(0) + " to file " + prop.valueList.get(1));
            }
            this.entityModMap.put(entry.getKey(), new EntityModData(entry.getKey(), prop.valueList.get(0), new CMSConfiguration(new File(this.CMSEnvironmentConfig.file.getParent(), CREATURES_FILE_PATH + prop.valueList.get(1)))));
            if (!this.debug) continue;
            this.envLog.logger.info("Added Custom Mod Entity Mapping " + entry.getKey() + " with tag " + prop.valueList.get(0) + " to file " + prop.valueList.get(1));
        }
        this.CMSEnvironmentConfig.save();
    }

    public void readConfigValues() {
        this.worldGenCreatureSpawning = this.CMSEnvironmentConfig.get(CATEGORY_CUSTOMSPAWNER_SETTINGS, "worldGenCreatureSpawning", true, "Allows spawns during world chunk generation.").getBoolean(true);
        this.minDespawnLightLevel = this.CMSEnvironmentConfig.get(CATEGORY_CUSTOMSPAWNER_SETTINGS, "minDespawnLightLevel", this.minDespawnLightLevel, "The minimum light level threshold used to determine whether or not to despawn a farm animal.").getInt();
        this.maxDespawnLightLevel = this.CMSEnvironmentConfig.get(CATEGORY_CUSTOMSPAWNER_SETTINGS, "maxDespawnLightLevel", this.minDespawnLightLevel, "The maximum light level threshold used to determine whether or not to despawn a farm animal.").getInt();
        this.killallUseLightLevel = this.CMSEnvironmentConfig.get(CATEGORY_CUSTOMSPAWNER_SETTINGS, "killallUseLightLevel", true, "Turns on check for lightLevel before killing an entity during a killall. If entity is under lightLevel threshold, it will be killed.").getBoolean(false);
        this.enforceMaxSpawnLimits = this.CMSEnvironmentConfig.get(CATEGORY_CUSTOMSPAWNER_SETTINGS, "enforceMaxSpawnLimits", false, "If enabled, all spawns will stop when max spawn limits have been reached for type.").getBoolean(false);
        this.debug = this.CMSEnvironmentConfig.get(CATEGORY_CUSTOMSPAWNER_SETTINGS, "debug", false, "Turns on CustomMobSpawner debug logging.").getBoolean(false);
        this.killallVillagers = this.CMSEnvironmentConfig.get(CATEGORY_CUSTOMSPAWNER_SETTINGS, "killAllVillagers", false).getBoolean(false);
        this.forceDespawns = this.CMSEnvironmentConfig.get(CATEGORY_CUSTOMSPAWNER_SETTINGS, "forceDespawns", false, "If true, Custom Spawner will attempt to despawn all creatures including vanilla. It will attempt to prevent despawning of villagers, tamed creatures, and farm animals. The purpose of this setting is to provide a more dynamic experience.").getBoolean(false);
        this.CMSEnvironmentConfig.save();
    }
}

