/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.common.inventory;

import com.mrcrayfish.vehicle.common.container.ContainerStorage;
import com.mrcrayfish.vehicle.common.inventory.IStorage;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageStorageWindow;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StorageInventory
extends InventoryBasic {
    private IStorage wrapper;

    public StorageInventory(String title, boolean customName, int slotCount, IStorage wrapper) {
        super(title, customName, slotCount);
        this.wrapper = wrapper;
    }

    public boolean addItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        try {
            int i;
            if (stack.func_77951_h()) {
                int slot = this.getFirstEmptyStack();
                if (slot >= 0) {
                    this.func_70299_a(slot, stack.func_77946_l());
                    stack.func_190920_e(0);
                    return true;
                }
                return false;
            }
            do {
                i = stack.func_190916_E();
                stack.func_190920_e(this.storePartialItemStack(stack));
            } while (!stack.func_190926_b() && stack.func_190916_E() < i);
            return stack.func_190916_E() < i;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Adding item to inventory");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being added");
            crashreportcategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)stack.func_77973_b()));
            crashreportcategory.func_71507_a("Item data", (Object)stack.func_77960_j());
            crashreportcategory.func_189529_a("Item name", () -> ((ItemStack)stack).func_82833_r());
            throw new ReportedException(crashreport);
        }
    }

    private int getFirstEmptyStack() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack itemStackIn) {
        int i = this.storeItemStack(itemStackIn);
        if (i == -1) {
            i = this.getFirstEmptyStack();
        }
        return i == -1 ? itemStackIn.func_190916_E() : this.addResource(i, itemStackIn);
    }

    private int storeItemStack(ItemStack itemStackIn) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.canMergeStacks(this.func_70301_a(i), itemStackIn)) continue;
            return i;
        }
        return -1;
    }

    private boolean canMergeStacks(ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && this.stackEqualExact(stack1, stack2) && stack1.func_77985_e() && stack1.func_190916_E() < stack1.func_77976_d() && stack1.func_190916_E() < this.func_70297_j_();
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private int addResource(int slot, ItemStack stack) {
        int i = stack.func_190916_E();
        ItemStack itemstack = this.func_70301_a(slot);
        if (itemstack.func_190926_b()) {
            itemstack = stack.func_77946_l();
            itemstack.func_190920_e(0);
            if (stack.func_77942_o()) {
                itemstack.func_77982_d(stack.func_77978_p().func_74737_b());
            }
            this.func_70299_a(slot, itemstack);
        }
        int j = i;
        if (i > itemstack.func_77976_d() - itemstack.func_190916_E()) {
            j = itemstack.func_77976_d() - itemstack.func_190916_E();
        }
        if (j > this.func_70297_j_() - itemstack.func_190916_E()) {
            j = this.func_70297_j_() - itemstack.func_190916_E();
        }
        if (j == 0) {
            return i;
        }
        itemstack.func_190917_f(j);
        itemstack.func_190915_d(5);
        return i -= j;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(slotTag);
            tagList.func_74742_a((NBTBase)slotTag);
        }
        tagCompound.func_74782_a("inventory", (NBTBase)tagList);
        return tagCompound;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_150297_b("inventory", 9)) {
            this.func_174888_l();
            NBTTagList tagList = tagCompound.func_150295_c("inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound slotTag = tagList.func_150305_b(i);
                byte slot = slotTag.func_74771_c("Slot");
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.func_70299_a(slot, new ItemStack(slotTag));
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.wrapper instanceof Entity) {
            Entity entity = (Entity)this.wrapper;
            return player.func_70068_e(entity) <= 8.0;
        }
        return true;
    }

    public boolean isStorageItem(ItemStack stack) {
        return this.wrapper.isStorageItem(stack);
    }

    public void openGui(EntityPlayerMP player, Entity entity) {
        if (entity instanceof IStorage) {
            if (this instanceof ILootContainer && player.func_175149_v()) {
                player.func_146105_b(new TextComponentTranslation("container.spectatorCantOpen", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
            } else {
                ILockableContainer lockableContainer;
                if (player.field_71070_bA != player.field_71069_bz) {
                    player.func_71053_j();
                }
                if (this instanceof ILockableContainer && (lockableContainer = (ILockableContainer)this).func_174893_q_() && !player.func_175146_a(lockableContainer.func_174891_i()) && !player.func_175149_v()) {
                    player.field_71135_a.func_147359_a((Packet)new SPacketChat((ITextComponent)new TextComponentTranslation("container.isLocked", new Object[]{this.func_145748_c_()}), ChatType.GAME_INFO));
                    player.field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(SoundEvents.field_187654_U, SoundCategory.BLOCKS, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 1.0f));
                    return;
                }
                player.func_71117_bO();
                PacketHandler.INSTANCE.sendTo((IMessage)new MessageStorageWindow(player.field_71139_cq, entity.func_145782_y()), player);
                player.field_71070_bA = new ContainerStorage((IInventory)player.field_71071_by, this, (EntityPlayer)player);
                player.field_71070_bA.field_75152_c = player.field_71139_cq;
                player.field_71070_bA.func_75132_a((IContainerListener)player);
                MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)player, player.field_71070_bA));
            }
        }
    }
}

