/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.HAlignment;
import de.matthiasmann.twl.renderer.FontCache;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLFontCache;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLTexture;
import de.matthiasmann.twl.renderer.lwjgl.TextureAreaBase;
import de.matthiasmann.twl.utils.ParameterStringParser;
import de.matthiasmann.twl.utils.TextUtil;
import de.matthiasmann.twl.utils.XMLParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.HashMap;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.Util;
import org.xmlpull.v1.XmlPullParserException;

public class BitmapFont {
    private static final int LOG2_PAGE_SIZE = 9;
    private static final int PAGE_SIZE = 512;
    private static final int PAGES = 128;
    private final LWJGLTexture texture;
    private final Glyph[][] glyphs;
    private final int lineHeight;
    private final int baseLine;
    private final int spaceWidth;
    private final int ex;
    private final boolean proportional;

    public BitmapFont(LWJGLRenderer renderer, XMLParser xmlp, URL baseUrl) throws XmlPullParserException, IOException {
        xmlp.require(2, null, "font");
        xmlp.nextTag();
        xmlp.require(2, null, "info");
        xmlp.ignoreOtherAttributes();
        xmlp.nextTag();
        xmlp.require(3, null, "info");
        xmlp.nextTag();
        xmlp.require(2, null, "common");
        this.lineHeight = xmlp.parseIntFromAttribute("lineHeight");
        this.baseLine = xmlp.parseIntFromAttribute("base");
        if (xmlp.parseIntFromAttribute("pages", 1) != 1) {
            throw new UnsupportedOperationException("multi page fonts not supported");
        }
        if (xmlp.parseIntFromAttribute("packed", 0) != 0) {
            throw new UnsupportedOperationException("packed fonts not supported");
        }
        xmlp.ignoreOtherAttributes();
        xmlp.nextTag();
        xmlp.require(3, null, "common");
        xmlp.nextTag();
        xmlp.require(2, null, "pages");
        xmlp.nextTag();
        xmlp.require(2, null, "page");
        int pageId = Integer.parseInt(xmlp.getAttributeValue(null, "id"));
        if (pageId != 0) {
            throw new UnsupportedOperationException("only page id 0 supported");
        }
        String textureName = xmlp.getAttributeValue(null, "file");
        Util.checkGLError();
        this.texture = renderer.load(new URL(baseUrl, textureName), LWJGLTexture.Format.ALPHA, LWJGLTexture.Filter.NEAREST);
        Util.checkGLError();
        xmlp.nextTag();
        xmlp.require(3, null, "page");
        xmlp.nextTag();
        xmlp.require(3, null, "pages");
        xmlp.nextTag();
        xmlp.require(2, null, "chars");
        xmlp.ignoreOtherAttributes();
        xmlp.nextTag();
        int n = Integer.MIN_VALUE;
        boolean prop = true;
        this.glyphs = new Glyph[128][];
        while (!xmlp.isEndTag()) {
            short s;
            xmlp.require(2, null, "char");
            int idx = xmlp.parseIntFromAttribute("id");
            int x = xmlp.parseIntFromAttribute("x");
            int y = xmlp.parseIntFromAttribute("y");
            int w = xmlp.parseIntFromAttribute("width");
            int h = xmlp.parseIntFromAttribute("height");
            if (xmlp.parseIntFromAttribute("page", 0) != 0) {
                throw xmlp.error("Multiple pages not supported");
            }
            int chnl = xmlp.parseIntFromAttribute("chnl", 0);
            Glyph g = new Glyph(x, y, w, h, this.texture.getTexWidth(), this.texture.getTexHeight());
            g.xoffset = Short.parseShort(xmlp.getAttributeNotNull("xoffset"));
            g.yoffset = Short.parseShort(xmlp.getAttributeNotNull("yoffset"));
            g.xadvance = Short.parseShort(xmlp.getAttributeNotNull("xadvance"));
            this.addGlyph(idx, g);
            xmlp.nextTag();
            xmlp.require(3, null, "char");
            xmlp.nextTag();
            if (g.xadvance == s || g.xadvance <= 0) continue;
            if (s == Integer.MIN_VALUE) {
                s = g.xadvance;
                continue;
            }
            prop = false;
        }
        xmlp.require(3, null, "chars");
        xmlp.nextTag();
        if (xmlp.isStartTag()) {
            xmlp.require(2, null, "kernings");
            xmlp.ignoreOtherAttributes();
            xmlp.nextTag();
            while (!xmlp.isEndTag()) {
                xmlp.require(2, null, "kerning");
                int first = xmlp.parseIntFromAttribute("first");
                int second = xmlp.parseIntFromAttribute("second");
                int amount = xmlp.parseIntFromAttribute("amount");
                this.addKerning(first, second, amount);
                xmlp.nextTag();
                xmlp.require(3, null, "kerning");
                xmlp.nextTag();
            }
            xmlp.require(3, null, "kernings");
            xmlp.nextTag();
        }
        xmlp.require(3, null, "font");
        Glyph g = this.getGlyph(' ');
        this.spaceWidth = g != null ? g.xadvance + g.width : 1;
        Glyph gx = this.getGlyph('x');
        this.ex = gx != null ? gx.height : (short)1;
        this.proportional = prop;
    }

    public BitmapFont(LWJGLRenderer renderer, Reader reader, URL baseUrl) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        HashMap<String, String> params = new HashMap<String, String>();
        BitmapFont.parseFntLine(br, "info");
        BitmapFont.parseFntLine(BitmapFont.parseFntLine(br, "common"), params);
        this.lineHeight = BitmapFont.parseInt(params, "lineHeight");
        this.baseLine = BitmapFont.parseInt(params, "base");
        if (BitmapFont.parseInt(params, "pages", 1) != 1) {
            throw new UnsupportedOperationException("multi page fonts not supported");
        }
        if (BitmapFont.parseInt(params, "packed", 0) != 0) {
            throw new UnsupportedOperationException("packed fonts not supported");
        }
        BitmapFont.parseFntLine(BitmapFont.parseFntLine(br, "page"), params);
        if (BitmapFont.parseInt(params, "id", 0) != 0) {
            throw new UnsupportedOperationException("only page id 0 supported");
        }
        this.texture = renderer.load(new URL(baseUrl, BitmapFont.getParam(params, "file")), LWJGLTexture.Format.ALPHA, LWJGLTexture.Filter.NEAREST);
        this.glyphs = new Glyph[128][];
        BitmapFont.parseFntLine(BitmapFont.parseFntLine(br, "chars"), params);
        int charCount = BitmapFont.parseInt(params, "count");
        int n = Integer.MIN_VALUE;
        boolean prop = true;
        for (int charIdx = 0; charIdx < charCount; ++charIdx) {
            short s;
            BitmapFont.parseFntLine(BitmapFont.parseFntLine(br, "char"), params);
            int idx = BitmapFont.parseInt(params, "id");
            int x = BitmapFont.parseInt(params, "x");
            int y = BitmapFont.parseInt(params, "y");
            int w = BitmapFont.parseInt(params, "width");
            int h = BitmapFont.parseInt(params, "height");
            if (BitmapFont.parseInt(params, "page", 0) != 0) {
                throw new IOException("Multiple pages not supported");
            }
            Glyph g = new Glyph(x, y, w, h, this.texture.getTexWidth(), this.texture.getTexHeight());
            g.xoffset = BitmapFont.parseShort(params, "xoffset");
            g.yoffset = BitmapFont.parseShort(params, "yoffset");
            g.xadvance = BitmapFont.parseShort(params, "xadvance");
            this.addGlyph(idx, g);
            if (g.xadvance == s || g.xadvance <= 0) continue;
            if (s == Integer.MIN_VALUE) {
                s = g.xadvance;
                continue;
            }
            prop = false;
        }
        BitmapFont.parseFntLine(BitmapFont.parseFntLine(br, "kernings"), params);
        int kerningCount = BitmapFont.parseInt(params, "count");
        for (int kerningIdx = 0; kerningIdx < kerningCount; ++kerningIdx) {
            BitmapFont.parseFntLine(BitmapFont.parseFntLine(br, "kerning"), params);
            int first = BitmapFont.parseInt(params, "first");
            int second = BitmapFont.parseInt(params, "second");
            int amount = BitmapFont.parseInt(params, "amount");
            this.addKerning(first, second, amount);
        }
        Glyph g = this.getGlyph(' ');
        this.spaceWidth = g != null ? g.xadvance + g.width : 1;
        Glyph gx = this.getGlyph('x');
        this.ex = gx != null ? gx.height : (short)1;
        this.proportional = prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BitmapFont loadFont(LWJGLRenderer renderer, URL url) throws IOException {
        BitmapFont bitmapFont;
        boolean startTagSeen = false;
        XMLParser xmlp = new XMLParser(url);
        try {
            xmlp.require(0, null, null);
            xmlp.nextTag();
            startTagSeen = true;
            Util.checkGLError();
            bitmapFont = new BitmapFont(renderer, xmlp, url);
        }
        catch (Throwable throwable) {
            try {
                xmlp.close();
                throw throwable;
            }
            catch (XmlPullParserException ex) {
                if (startTagSeen) {
                    throw (IOException)new IOException().initCause(ex);
                }
                InputStream is = url.openStream();
                try {
                    InputStreamReader isr = new InputStreamReader(is, "UTF8");
                    BitmapFont bitmapFont2 = new BitmapFont(renderer, isr, url);
                    return bitmapFont2;
                }
                finally {
                    is.close();
                }
            }
        }
        xmlp.close();
        return bitmapFont;
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public int getBaseLine() {
        return this.baseLine;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int getSpaceWidth() {
        return this.spaceWidth;
    }

    public int getEM() {
        return this.lineHeight;
    }

    public int getEX() {
        return this.ex;
    }

    public void destroy() {
        this.texture.destroy();
    }

    private void addGlyph(int idx, Glyph g) {
        if (idx <= 65535) {
            Glyph[] page = this.glyphs[idx >> 9];
            if (page == null) {
                page = new Glyph[512];
                this.glyphs[idx >> 9] = page;
            }
            page[idx & 0x1FF] = g;
        }
    }

    private void addKerning(int first, int second, int amount) {
        Glyph g;
        if (first >= 0 && first <= 65535 && second >= 0 && second <= 65535 && (g = this.getGlyph((char)first)) != null) {
            g.setKerning(second, amount);
        }
    }

    final Glyph getGlyph(char ch) {
        Glyph[] page = this.glyphs[ch >> 9];
        if (page != null) {
            return page[ch & 0x1FF];
        }
        return null;
    }

    public int computeTextWidth(CharSequence str, int start, int end) {
        int width = 0;
        Glyph lastGlyph = null;
        while (start < end) {
            if ((lastGlyph = this.getGlyph(str.charAt(start++))) == null) continue;
            width = lastGlyph.xadvance;
            break;
        }
        while (start < end) {
            char ch;
            Glyph g;
            if ((g = this.getGlyph(ch = str.charAt(start++))) == null) continue;
            width += lastGlyph.getKerning(ch);
            lastGlyph = g;
            width += g.xadvance;
        }
        return width;
    }

    public int computeVisibleGlpyhs(CharSequence str, int start, int end, int availWidth) {
        int index;
        int width = 0;
        Glyph lastGlyph = null;
        for (index = start; index < end; ++index) {
            char ch = str.charAt(index);
            Glyph g = this.getGlyph(ch);
            if (g == null) continue;
            if (lastGlyph != null) {
                width += lastGlyph.getKerning(ch);
            }
            lastGlyph = g;
            if (this.proportional) {
                if ((width += g.xadvance) <= availWidth) continue;
                break;
            }
            if (width + g.width + g.xoffset > availWidth) break;
            width += g.xadvance;
        }
        return index - start;
    }

    protected int drawText(int x, int y, CharSequence str, int start, int end) {
        int startX = x;
        Glyph lastGlyph = null;
        while (start < end) {
            if ((lastGlyph = this.getGlyph(str.charAt(start++))) == null) continue;
            if (lastGlyph.width > 0) {
                lastGlyph.draw(x, y);
            }
            x += lastGlyph.xadvance;
            break;
        }
        while (start < end) {
            char ch;
            Glyph g;
            if ((g = this.getGlyph(ch = str.charAt(start++))) == null) continue;
            x += lastGlyph.getKerning(ch);
            lastGlyph = g;
            if (g.width > 0) {
                g.draw(x, y);
            }
            x += g.xadvance;
        }
        return x - startX;
    }

    protected int drawMultiLineText(int x, int y, CharSequence str, int width, HAlignment align) {
        int start = 0;
        int numLines = 0;
        while (start < str.length()) {
            int lineEnd = TextUtil.indexOf(str, '\n', start);
            int xoff = 0;
            if (align != HAlignment.LEFT) {
                int lineWidth = this.computeTextWidth(str, start, lineEnd);
                xoff = width - lineWidth;
                if (align == HAlignment.CENTER) {
                    xoff /= 2;
                }
            }
            this.drawText(x + xoff, y, str, start, lineEnd);
            start = lineEnd + 1;
            y += this.lineHeight;
            ++numLines;
        }
        return numLines;
    }

    public void computeMultiLineInfo(CharSequence str, int width, HAlignment align, int[] multiLineInfo) {
        int start = 0;
        int idx = 0;
        while (start < str.length()) {
            int lineEnd = TextUtil.indexOf(str, '\n', start);
            int lineWidth = this.computeTextWidth(str, start, lineEnd);
            int xoff = width - lineWidth;
            if (align == HAlignment.LEFT) {
                xoff = 0;
            } else if (align == HAlignment.CENTER) {
                xoff /= 2;
            }
            multiLineInfo[idx++] = lineWidth << 16 | xoff & 0xFFFF;
            start = lineEnd + 1;
        }
    }

    protected void beginLine() {
        GL11.glDisable((int)3553);
        GL11.glBegin((int)7);
    }

    protected void endLine() {
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMultiLineLines(int x, int y, int[] multiLineInfo, int numLines) {
        this.beginLine();
        try {
            for (int i = 0; i < numLines; ++i) {
                int info = multiLineInfo[i];
                int xoff = x + (short)info;
                int lineWidth = info >>> 16;
                GL11.glVertex2i((int)xoff, (int)y);
                GL11.glVertex2i((int)(xoff + lineWidth), (int)y);
                GL11.glVertex2i((int)(xoff + lineWidth), (int)(y + 1));
                GL11.glVertex2i((int)xoff, (int)(y + 1));
                y += this.lineHeight;
            }
        }
        finally {
            this.endLine();
        }
    }

    public void drawLine(int x0, int y, int x1) {
        this.beginLine();
        GL11.glVertex2i((int)x0, (int)y);
        GL11.glVertex2i((int)x1, (int)y);
        GL11.glVertex2i((int)x1, (int)(y + 1));
        GL11.glVertex2i((int)x0, (int)(y + 1));
        this.endLine();
    }

    public int computeMultiLineTextWidth(CharSequence str) {
        int start = 0;
        int width = 0;
        while (start < str.length()) {
            int lineEnd = TextUtil.indexOf(str, '\n', start);
            int lineWidth = this.computeTextWidth(str, start, lineEnd);
            width = Math.max(width, lineWidth);
            start = lineEnd + 1;
        }
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontCache cacheMultiLineText(LWJGLFontCache cache, CharSequence str, int width, HAlignment align) {
        if (cache.startCompile()) {
            block7: {
                int numLines = 0;
                try {
                    if (!this.prepare()) break block7;
                    try {
                        numLines = this.drawMultiLineText(0, 0, str, width, align);
                    }
                    finally {
                        this.cleanup();
                    }
                    this.computeMultiLineInfo(str, width, align, cache.getMultiLineInfo(numLines));
                }
                finally {
                    cache.endCompile(width, numLines * this.lineHeight);
                }
            }
            return cache;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontCache cacheText(LWJGLFontCache cache, CharSequence str, int start, int end) {
        if (cache.startCompile()) {
            block7: {
                int width = 0;
                try {
                    if (!this.prepare()) break block7;
                    try {
                        width = this.drawText(0, 0, str, start, end);
                    }
                    finally {
                        this.cleanup();
                    }
                }
                finally {
                    cache.endCompile(width, this.getLineHeight());
                }
            }
            return cache;
        }
        return null;
    }

    boolean bind() {
        return this.texture.bind();
    }

    protected boolean prepare() {
        if (this.texture.bind()) {
            GL11.glBegin((int)7);
            return true;
        }
        return false;
    }

    protected void cleanup() {
        GL11.glEnd();
    }

    private static String parseFntLine(BufferedReader br, String tag) throws IOException {
        String line = br.readLine();
        if (line == null || line.length() <= tag.length() || line.charAt(tag.length()) != ' ' || !line.startsWith(tag)) {
            throw new IOException("'" + tag + "' line expected");
        }
        return line;
    }

    private static void parseFntLine(String line, HashMap<String, String> params) {
        params.clear();
        ParameterStringParser psp = new ParameterStringParser(line, ' ', '=');
        while (psp.next()) {
            params.put(psp.getKey(), psp.getValue());
        }
    }

    private static String getParam(HashMap<String, String> params, String key) throws IOException {
        String value = params.get(key);
        if (value == null) {
            throw new IOException("Required parameter '" + key + "' not found");
        }
        return value;
    }

    private static int parseInt(HashMap<String, String> params, String key) throws IOException {
        String value = BitmapFont.getParam(params, key);
        try {
            return Integer.parseInt(value);
        }
        catch (IllegalArgumentException ex) {
            throw BitmapFont.canParseParam(key, value, ex);
        }
    }

    private static int parseInt(HashMap<String, String> params, String key, int defaultValue) throws IOException {
        String value = params.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (IllegalArgumentException ex) {
            throw BitmapFont.canParseParam(key, value, ex);
        }
    }

    private static short parseShort(HashMap<String, String> params, String key) throws IOException {
        String value = BitmapFont.getParam(params, key);
        try {
            return Short.parseShort(value);
        }
        catch (IllegalArgumentException ex) {
            throw BitmapFont.canParseParam(key, value, ex);
        }
    }

    private static IOException canParseParam(String key, String value, IllegalArgumentException ex) {
        return (IOException)new IOException("Can't parse parameter: " + key + '=' + value).initCause(ex);
    }

    static class Glyph
    extends TextureAreaBase {
        short xoffset;
        short yoffset;
        short xadvance;
        byte[][] kerning;

        public Glyph(int x, int y, int width, int height, int texWidth, int texHeight) {
            super(x, y, height <= 0 ? 0 : width, height, texWidth, texHeight);
        }

        void draw(int x, int y) {
            this.drawQuad(x + this.xoffset, y + this.yoffset, this.width, this.height);
        }

        void draw(FloatBuffer va, int x, int y) {
            va.put(this.tx0).put(this.ty0).put(x += this.xoffset).put(y += this.yoffset);
            va.put(this.tx0).put(this.ty1).put(x).put(y + this.height);
            va.put(this.tx1).put(this.ty1).put(x + this.width).put(y + this.height);
            va.put(this.tx1).put(this.ty0).put(x + this.width).put(y);
        }

        int getKerning(char ch) {
            byte[] page;
            if (this.kerning != null && (page = this.kerning[ch >>> 9]) != null) {
                return page[ch & 0x1FF];
            }
            return 0;
        }

        void setKerning(int ch, int value) {
            byte[] page;
            if (this.kerning == null) {
                this.kerning = new byte[128][];
            }
            if ((page = this.kerning[ch >>> 9]) == null) {
                page = new byte[512];
                this.kerning[ch >>> 9] = page;
            }
            page[ch & 0x1FF] = (byte)value;
        }
    }
}

