/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.textarea;

public final class Value {
    public final float value;
    public final Unit unit;
    public static final Value ZERO_PX = new Value(0.0f, Unit.PX);
    public static final Value AUTO = new Value(0.0f, Unit.AUTO);

    public Value(float value, Unit unit) {
        this.value = value;
        this.unit = unit;
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (unit == Unit.AUTO && value != 0.0f) {
            throw new IllegalArgumentException("value must be 0 for Unit.AUTO");
        }
    }

    public String toString() {
        if (this.unit == Unit.AUTO) {
            return this.unit.getPostfix();
        }
        return this.value + this.unit.getPostfix();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value) {
            Value other = (Value)obj;
            return this.value == other.value && this.unit == other.unit;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + Float.floatToIntBits(this.value);
        hash = 17 * hash + this.unit.hashCode();
        return hash;
    }

    public static enum Unit {
        PX(false, "px"),
        PT(false, "pt"),
        EM(true, "em"),
        EX(true, "ex"),
        PERCENT(false, "%"),
        AUTO(false, "auto");

        final boolean fontBased;
        final String postfix;

        private Unit(boolean fontBased, String postfix) {
            this.fontBased = fontBased;
            this.postfix = postfix;
        }

        public boolean isFontBased() {
            return this.fontBased;
        }

        public String getPostfix() {
            return this.postfix;
        }
    }
}

