/*
 * Decompiled with CFR 0.152.
 */
package drzhark.guiapi.widget;

import de.matthiasmann.twl.model.SimpleFloatModel;
import drzhark.guiapi.ModSettingScreen;
import drzhark.guiapi.setting.SettingFloat;
import drzhark.guiapi.widget.WidgetSetting;
import drzhark.guiapi.widget.WidgetSlider;

public class WidgetFloat
extends WidgetSetting
implements Runnable {
    public int decimalPlaces;
    public SettingFloat settingReference;
    public WidgetSlider slider;

    public WidgetFloat(SettingFloat setting, String title) {
        this(setting, title, 2);
    }

    public WidgetFloat(SettingFloat setting, String title, int _decimalPlaces) {
        super(title);
        this.setTheme("");
        this.decimalPlaces = _decimalPlaces;
        this.settingReference = setting;
        this.settingReference.displayWidget = this;
        SimpleFloatModel smodel = new SimpleFloatModel(this.settingReference.minimumValue, this.settingReference.maximumValue, ((Float)this.settingReference.get()).floatValue());
        smodel.addCallback(this);
        this.slider = new WidgetSlider(smodel);
        if (this.settingReference.stepValue > 0.0f && this.settingReference.stepValue <= this.settingReference.maximumValue) {
            this.slider.setStepSize(this.settingReference.stepValue);
        }
        this.slider.setFormat(String.format("%s: %%.%df", this.niceName, this.decimalPlaces));
        this.add(this.slider);
        this.update();
    }

    @Override
    public void addCallback(Runnable paramRunnable) {
        this.slider.getModel().addCallback(paramRunnable);
    }

    @Override
    public void removeCallback(Runnable paramRunnable) {
        this.slider.getModel().removeCallback(paramRunnable);
    }

    @Override
    public void run() {
        this.settingReference.set(Float.valueOf(this.slider.getValue()), ModSettingScreen.guiContext);
    }

    @Override
    public void update() {
        this.slider.setValue(this.settingReference.get(ModSettingScreen.guiContext).floatValue());
        this.slider.setMinMaxValue(this.settingReference.minimumValue, this.settingReference.maximumValue);
        this.slider.setFormat(String.format("%s: %%.%df", this.niceName, this.decimalPlaces));
    }

    @Override
    public String userString() {
        String l = String.format("%02d", this.decimalPlaces);
        return String.format("%s: %." + l + "f", this.niceName, this.settingReference);
    }
}

