/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures;

import drzhark.customspawner.utils.CMSUtils;
import drzhark.mocreatures.MoCPetMapData;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.util.MoCLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MoCEventHooks {
    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_73011_w.func_186058_p().func_186068_a() == 0) {
            MoCreatures.proxy.worldInitDone = false;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        GameRules gameRule;
        if (DimensionManager.getWorld((int)0) != null && !MoCreatures.proxy.worldInitDone) {
            MoCPetMapData data = (MoCPetMapData)DimensionManager.getWorld((int)0).func_175693_T().func_75742_a(MoCPetMapData.class, "mocreatures");
            if (data == null) {
                data = new MoCPetMapData("mocreatures");
            }
            DimensionManager.getWorld((int)0).func_175693_T().func_75745_a("mocreatures", (WorldSavedData)data);
            DimensionManager.getWorld((int)0).func_175693_T().func_75744_a();
            MoCreatures.instance.mapData = data;
            MoCreatures.proxy.worldInitDone = true;
        }
        if ((gameRule = event.getWorld().func_82736_K()) != null && !MoCreatures.isCustomSpawnerLoaded) {
            gameRule.func_82764_b("doMobSpawning", "true");
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && IMoCTameable.class.isAssignableFrom(event.getEntityLiving().getClass())) {
            IMoCTameable mocEntity = (IMoCTameable)event.getEntityLiving();
            if (mocEntity.getIsTamed() && mocEntity.getPetHealth() > 0.0f && !mocEntity.isRiderDisconnecting()) {
                return;
            }
            if (mocEntity.getOwnerPetId() != -1) {
                MoCreatures.instance.mapData.removeOwnerPet(mocEntity, mocEntity.getOwnerPetId());
            }
        }
    }

    @SubscribeEvent
    public void onLivingDespawn(LivingSpawnEvent.AllowDespawn event) {
        if (MoCreatures.proxy.forceDespawns && !MoCreatures.isCustomSpawnerLoaded) {
            if (IMob.class.isAssignableFrom(event.getEntityLiving().getClass()) || IRangedAttackMob.class.isAssignableFrom(event.getEntityLiving().getClass()) || event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false)) {
                return;
            }
            if (event.getEntityLiving() instanceof EntityTameable && ((EntityTameable)event.getEntityLiving()).func_70909_n()) {
                return;
            }
            if ((event.getEntityLiving() instanceof EntitySheep || event.getEntityLiving() instanceof EntityPig || event.getEntityLiving() instanceof EntityCow || event.getEntityLiving() instanceof EntityChicken) && this.isValidDespawnLightLevel(event.getEntity(), event.getWorld(), MoCreatures.proxy.minDespawnLightLevel, MoCreatures.proxy.maxDespawnLightLevel)) {
                return;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            event.getEntityLiving().func_189511_e(nbt);
            if (nbt != null) {
                if (nbt.func_74764_b("Owner") && !nbt.func_74779_i("Owner").equals("")) {
                    return;
                }
                if (nbt.func_74764_b("Tamed") && nbt.func_74767_n("Tamed")) {
                    return;
                }
            }
            if (event.getEntityLiving().func_70654_ax() > 600) {
                event.setResult(Event.Result.ALLOW);
            }
            if (MoCreatures.proxy.debug) {
                int x = MathHelper.func_76128_c((double)event.getEntity().field_70165_t);
                int y = MathHelper.func_76128_c((double)event.getEntity().func_174813_aQ().field_72338_b);
                int z = MathHelper.func_76128_c((double)event.getEntity().field_70161_v);
                MoCLog.logger.info("Forced Despawn of entity " + event.getEntityLiving() + " at " + x + ", " + y + ", " + z + ". To prevent forced despawns, use /moc forceDespawns false.");
            }
        }
    }

    private boolean isValidDespawnLightLevel(Entity entity, World world, int minDespawnLightLevel, int maxDespawnLightLevel) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        int blockLightLevel = 0;
        if (y >= 0) {
            if (y >= 256) {
                y = 255;
            }
            blockLightLevel = CMSUtils.getLightFromNeighbors((Chunk)world.func_72964_e(x >> 4, z >> 4), (int)(x & 0xF), (int)y, (int)(z & 0xF));
        }
        if (blockLightLevel < minDespawnLightLevel && maxDespawnLightLevel != -1) {
            return false;
        }
        return blockLightLevel <= maxDespawnLightLevel || maxDespawnLightLevel == -1;
    }
}

