/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.SimpleListModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class SimpleChangableListModel<T>
extends SimpleListModel<T> {
    private final ArrayList<T> content;

    public SimpleChangableListModel() {
        this.content = new ArrayList();
    }

    public SimpleChangableListModel(Collection<T> content) {
        this.content = new ArrayList<T>(content);
    }

    public SimpleChangableListModel(T ... content) {
        this.content = new ArrayList<T>(Arrays.asList(content));
    }

    @Override
    public T getEntry(int index) {
        return this.content.get(index);
    }

    @Override
    public int getNumEntries() {
        return this.content.size();
    }

    public void addElement(T element) {
        this.insertElement(this.getNumEntries(), element);
    }

    public void addElements(Collection<T> elements) {
        this.insertElements(this.getNumEntries(), elements);
    }

    public void addElements(T ... elements) {
        this.insertElements(this.getNumEntries(), elements);
    }

    public void insertElement(int idx, T element) {
        this.content.add(idx, element);
        this.fireEntriesInserted(idx, idx);
    }

    public void insertElements(int idx, Collection<T> elements) {
        this.content.addAll(idx, elements);
        this.fireEntriesInserted(idx, idx + elements.size() - 1);
    }

    public void insertElements(int idx, T ... elements) {
        this.insertElements(idx, (Collection<T>)Arrays.asList(elements));
    }

    public T removeElement(int idx) {
        T result = this.content.remove(idx);
        this.fireEntriesDeleted(idx, idx);
        return result;
    }

    public T setElement(int idx, T element) {
        T result = this.content.set(idx, element);
        this.fireEntriesChanged(idx, idx);
        return result;
    }

    public int findElement(Object element) {
        return this.content.indexOf(element);
    }

    public void clear() {
        this.content.clear();
        this.fireAllChanged();
    }
}

