/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.textarea;

import de.matthiasmann.twl.renderer.FontMapper;
import de.matthiasmann.twl.textarea.CSSStyle;
import de.matthiasmann.twl.textarea.Parser;
import de.matthiasmann.twl.textarea.Style;
import de.matthiasmann.twl.textarea.StyleAttribute;
import de.matthiasmann.twl.textarea.StyleSheetKey;
import de.matthiasmann.twl.textarea.StyleSheetResolver;
import de.matthiasmann.twl.utils.StringList;
import de.matthiasmann.twl.utils.TextUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StyleSheet
implements StyleSheetResolver {
    static final Object NULL = new Object();
    private final ArrayList<Selector> rules = new ArrayList();
    private final IdentityHashMap<Style, Object> cache = new IdentityHashMap();
    private ArrayList<AtRule> atrules;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            this.parse(new InputStreamReader(is, "UTF8"));
        }
        finally {
            is.close();
        }
    }

    public void parse(String style) throws IOException {
        this.parse(new StringReader(style));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Reader r) throws IOException {
        Parser parser = new Parser(r);
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        int what;
        block17: while ((what = parser.yylex()) != 0) {
            if (what == 11) {
                parser.expect(1);
                AtRule atrule = new AtRule(parser.yytext());
                parser.expect(7);
                while ((what = parser.yylex()) != 8) {
                    if (what != 1) {
                        parser.unexpected();
                    }
                    String key = parser.yytext();
                    parser.expect(9);
                    what = parser.yylex();
                    if (what != 10 && what != 8) {
                        parser.unexpected();
                    }
                    String value = TextUtil.trim(parser.sb, 0);
                    try {
                        atrule.entries.put(key, value);
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                    if (what != 8) continue;
                }
                if (this.atrules == null) {
                    this.atrules = new ArrayList();
                }
                this.atrules.add(atrule);
                continue;
            }
            Selector selector = null;
            block19: while (true) {
                void var9_15;
                String element = null;
                String className = null;
                String pseudoClass = null;
                Object var9_14 = null;
                parser.sawWhitespace = false;
                switch (what) {
                    default: {
                        parser.unexpected();
                    }
                    case 3: 
                    case 4: 
                    case 9: {
                        break;
                    }
                    case 1: {
                        element = parser.yytext();
                    }
                    case 2: {
                        what = parser.yylex();
                    }
                }
                while (!(what != 3 && what != 4 && what != 9 || parser.sawWhitespace)) {
                    parser.expect(1);
                    String text = parser.yytext();
                    if (what == 3) {
                        className = text;
                    } else if (what == 9) {
                        pseudoClass = text;
                    } else {
                        String string = text;
                    }
                    what = parser.yylex();
                }
                selector = new Selector(element, className, (String)var9_15, pseudoClass, selector);
                switch (what) {
                    case 5: {
                        selector.directChild = true;
                        what = parser.yylex();
                        break;
                    }
                    case 6: 
                    case 7: {
                        break block19;
                    }
                }
            }
            selector.directChild = true;
            selectors.add(selector);
            switch (what) {
                default: {
                    parser.unexpected();
                }
                case 7: {
                    CSSStyle style = new CSSStyle();
                    while ((what = parser.yylex()) != 8) {
                        if (what != 1) {
                            parser.unexpected();
                        }
                        String key = parser.yytext();
                        parser.expect(9);
                        what = parser.yylex();
                        if (what != 10 && what != 8) {
                            parser.unexpected();
                        }
                        String value = TextUtil.trim(parser.sb, 0);
                        try {
                            style.parseCSSAttribute(key, value);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        if (what != 8) continue;
                    }
                    int n = selectors.size();
                    for (int i = 0; i < n; ++i) {
                        void var9_21;
                        CSSStyle cSSStyle = style;
                        selector = (Selector)selectors.get(i);
                        if (selector.pseudoClass != null) {
                            Style style2 = this.transformStyle(style, selector.pseudoClass);
                        }
                        this.rules.add(selector);
                        int score = 0;
                        Selector s = selector;
                        while (s != null) {
                            if (s.directChild) {
                                ++score;
                            }
                            if (s.element != null) {
                                score += 256;
                            }
                            if (s.className != null) {
                                score += 65536;
                            }
                            if (s.id != null) {
                                score += 0x1000000;
                            }
                            s = s.tail;
                        }
                        selector.score = score;
                        selector.style = var9_21;
                    }
                    selectors.clear();
                    continue block17;
                }
                case 6: 
            }
        }
        return;
    }

    public int getNumAtRules() {
        return this.atrules != null ? this.atrules.size() : 0;
    }

    public AtRule getAtRule(int idx) {
        if (this.atrules == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.atrules.get(idx);
    }

    public void registerFonts(FontMapper fontMapper, URL baseUrl) {
        if (this.atrules == null) {
            return;
        }
        for (AtRule atrule : this.atrules) {
            if (!"font-face".equals(atrule.name)) continue;
            String family = atrule.get("font-family");
            String src = atrule.get("src");
            if (family == null || src == null) continue;
            for (StringList srcs = CSSStyle.parseList(src, 0); srcs != null; srcs = srcs.getNext()) {
                String url = CSSStyle.stripURL(srcs.getValue());
                try {
                    fontMapper.registerFont(family, new URL(baseUrl, url));
                    continue;
                }
                catch (IOException ex) {
                    Logger.getLogger(StyleSheet.class.getName()).log(Level.SEVERE, "Could not register font: " + url, ex);
                }
            }
        }
    }

    @Override
    public void layoutFinished() {
        this.cache.clear();
    }

    @Override
    public void startLayout() {
        this.cache.clear();
    }

    @Override
    public Style resolve(Style style) {
        Object cacheData = this.cache.get(style);
        if (cacheData == null) {
            return this.resolveSlow(style);
        }
        if (cacheData == NULL) {
            return null;
        }
        return (Style)cacheData;
    }

    private Style resolveSlow(Style style) {
        Object[] candidates = new Selector[this.rules.size()];
        int numCandidates = 0;
        int n = this.rules.size();
        for (int i = 0; i < n; ++i) {
            Selector selector = this.rules.get(i);
            if (!this.matches(selector, style)) continue;
            candidates[numCandidates++] = selector;
        }
        if (numCandidates > 1) {
            Arrays.sort(candidates, 0, numCandidates);
        }
        Style result = null;
        boolean copy = true;
        int n2 = numCandidates;
        for (int i = 0; i < n2; ++i) {
            Style ruleStyle = ((Selector)candidates[i]).style;
            if (result == null) {
                result = ruleStyle;
                continue;
            }
            if (copy) {
                result = new Style(result);
                copy = false;
            }
            result.putAll(ruleStyle);
        }
        this.putIntoCache(style, result);
        return result;
    }

    private void putIntoCache(Style key, Style style) {
        this.cache.put(key, style == null ? NULL : style);
    }

    private boolean matches(Selector selector, Style style) {
        do {
            StyleSheetKey styleSheetKey;
            if ((styleSheetKey = style.getStyleSheetKey()) == null) continue;
            if (selector.matches(styleSheetKey)) {
                selector = selector.tail;
                if (selector != null) continue;
                return true;
            }
            if (!selector.directChild) continue;
            return false;
        } while ((style = style.getParent()) != null);
        return false;
    }

    private Style transformStyle(CSSStyle style, String pseudoClass) {
        Style result = new Style(style.getParent(), style.getStyleSheetKey());
        if ("hover".equals(pseudoClass)) {
            result.put(StyleAttribute.COLOR_HOVER, style.getRaw(StyleAttribute.COLOR));
            result.put(StyleAttribute.BACKGROUND_COLOR_HOVER, style.getRaw(StyleAttribute.BACKGROUND_COLOR));
            result.put(StyleAttribute.TEXT_DECORATION_HOVER, (Object)style.getRaw(StyleAttribute.TEXT_DECORATION));
        }
        return result;
    }

    public static class AtRule
    implements Iterable<Map.Entry<String, String>> {
        final String name;
        final HashMap<String, String> entries;

        public AtRule(String name) {
            this.name = name;
            this.entries = new HashMap();
        }

        public String getName() {
            return this.name;
        }

        public String get(String key) {
            return this.entries.get(key);
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return Collections.unmodifiableSet(this.entries.entrySet()).iterator();
        }
    }

    static class Selector
    extends StyleSheetKey
    implements Comparable<Selector> {
        final String pseudoClass;
        final Selector tail;
        boolean directChild;
        Style style;
        int score;

        Selector(String element, String className, String id, String pseudoClass, Selector tail) {
            super(element, className, id);
            this.pseudoClass = pseudoClass;
            this.tail = tail;
        }

        @Override
        public int compareTo(Selector other) {
            return this.score - other.score;
        }
    }
}

