/*
 * Decompiled with CFR 0.152.
 */
package drzhark.guiapi.widget;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.Widget;
import drzhark.guiapi.widget.IWidgetAlwaysDraw;
import java.util.HashMap;
import java.util.Map;

public class WidgetClassicTwocolumn
extends Widget {
    public int childDefaultHeight = 20;
    public int childDefaultWidth = 150;
    public int defaultPadding = 4;
    public Map<Widget, Integer> heightOverrideExceptions = new HashMap<Widget, Integer>();
    public boolean overrideHeight = true;
    public int splitDistance = 10;
    public int verticalPadding = 0;
    public Map<Widget, Integer> widthOverrideExceptions = new HashMap<Widget, Integer>();

    @Override
    protected void paintChildren(GUI gui) {
        ScrollPane pane = ScrollPane.getContainingScrollPane(this);
        boolean isScrolling = pane != null;
        int minY = 0;
        int maxY = 0;
        if (isScrolling) {
            minY = this.getParent().getY();
            maxY = minY + pane.getContentAreaHeight();
        }
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            boolean draw;
            Widget child = this.getChild(i);
            if (!child.isVisible()) continue;
            boolean bl = draw = !isScrolling;
            if (!draw) {
                if (child instanceof IWidgetAlwaysDraw) {
                    draw = true;
                } else if (child.getY() + child.getHeight() >= minY && child.getY() <= maxY) {
                    draw = true;
                }
            }
            if (!draw) continue;
            this.paintChild(gui, child);
        }
    }

    public WidgetClassicTwocolumn(Widget ... widgets) {
        for (int i = 0; i < widgets.length; ++i) {
            this.add(widgets[i]);
        }
        this.setTheme("");
    }

    @Override
    public int getPreferredHeight() {
        int totalheight = this.verticalPadding;
        for (int i = 0; i < this.getNumChildren(); i += 2) {
            Widget w = this.getChild(i);
            Widget w2 = null;
            if (i + 1 != this.getNumChildren()) {
                w2 = this.getChild(i + 1);
            }
            int height = this.childDefaultHeight;
            if (!this.overrideHeight) {
                height = w.getPreferredHeight();
            }
            if (this.heightOverrideExceptions.containsKey(w)) {
                Integer heightSet = this.heightOverrideExceptions.get(w);
                if (heightSet < 1) {
                    height = w.getPreferredHeight();
                    if ((heightSet = Integer.valueOf(-heightSet.intValue())) != 0 && heightSet > height) {
                        height = heightSet;
                    }
                } else {
                    height = heightSet;
                }
            }
            if (w2 != null) {
                int temp = height;
                if (!this.overrideHeight) {
                    temp = w2.getPreferredHeight();
                }
                if (this.heightOverrideExceptions.containsKey(w2)) {
                    Integer heightSet = this.heightOverrideExceptions.get(w2);
                    if (heightSet < 1) {
                        height = w.getPreferredHeight();
                        if ((heightSet = Integer.valueOf(-heightSet.intValue())) != 0 && heightSet > height) {
                            height = heightSet;
                        }
                    } else {
                        height = heightSet;
                    }
                }
                if (temp > height) {
                    height = temp;
                }
            }
            totalheight += height + this.defaultPadding;
        }
        return totalheight;
    }

    @Override
    public int getPreferredWidth() {
        return this.getParent().getWidth();
    }

    @Override
    public void layout() {
        if (this.getParent().getTheme().equals("scrollpane-notch")) {
            this.verticalPadding = 10;
        }
        int totalheight = this.verticalPadding;
        for (int i = 0; i < this.getNumChildren(); i += 2) {
            Widget w = this.getChild(i);
            Widget w2 = null;
            try {
                w2 = this.getChild(i + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            int height = this.childDefaultHeight;
            int width = this.childDefaultWidth;
            if (!this.overrideHeight) {
                height = w.getPreferredHeight();
            }
            if (this.heightOverrideExceptions.containsKey(w)) {
                Integer heightSet = this.heightOverrideExceptions.get(w);
                if (heightSet < 1) {
                    height = w.getPreferredHeight();
                    if ((heightSet = Integer.valueOf(-heightSet.intValue())) != 0 && heightSet > height) {
                        height = heightSet;
                    }
                } else {
                    height = heightSet;
                }
            }
            if (this.widthOverrideExceptions.containsKey(w)) {
                Integer widthSet = this.widthOverrideExceptions.get(w);
                if (widthSet < 1) {
                    width = w.getPreferredWidth();
                    if ((widthSet = Integer.valueOf(-widthSet.intValue())) != 0 && widthSet > width) {
                        width = widthSet;
                    }
                } else {
                    width = widthSet;
                }
            }
            if (w2 != null) {
                int temph = height;
                int tempw = width;
                if (!this.overrideHeight) {
                    temph = w2.getPreferredHeight();
                }
                if (this.heightOverrideExceptions.containsKey(w2)) {
                    Integer heightSet = this.heightOverrideExceptions.get(w2);
                    if (heightSet < 1) {
                        height = w.getPreferredHeight();
                        if ((heightSet = Integer.valueOf(-heightSet.intValue())) != 0 && heightSet > height) {
                            height = heightSet;
                        }
                    } else {
                        height = heightSet;
                    }
                }
                if (this.widthOverrideExceptions.containsKey(w2)) {
                    Integer widthSet = this.widthOverrideExceptions.get(w2);
                    if (widthSet < 1) {
                        width = w2.getPreferredWidth();
                        if ((widthSet = Integer.valueOf(-widthSet.intValue())) != 0 && widthSet > width) {
                            width = widthSet;
                        }
                    } else {
                        width = widthSet;
                    }
                }
                if (temph > height) {
                    height = temph;
                }
                if (tempw > width) {
                    width = tempw;
                }
            }
            w.setSize(width, height);
            w.setPosition(this.getX() + this.getWidth() / 2 - (width + this.splitDistance / 2), this.getY() + totalheight);
            if (w2 != null) {
                w2.setSize(width, height);
                w2.setPosition(this.getX() + this.getWidth() / 2 + this.splitDistance / 2, this.getY() + totalheight);
            }
            totalheight += height + this.defaultPadding;
        }
    }
}

