/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BlastFurnaceRecipe {
    public final Object input;
    public final ItemStack output;
    @Nonnull
    public final ItemStack slag;
    public final int time;
    public static ArrayList<BlastFurnaceRecipe> recipeList = new ArrayList();
    public static ArrayList<BlastFurnaceFuel> blastFuels = new ArrayList();

    public BlastFurnaceRecipe(ItemStack output, Object input, int time, @Nonnull ItemStack slag) {
        this.output = output;
        this.input = ApiUtils.convertToValidRecipeInput(input);
        this.time = time;
        this.slag = slag;
    }

    public static void addRecipe(ItemStack output, Object input, int time, @Nonnull ItemStack slag) {
        BlastFurnaceRecipe recipe = new BlastFurnaceRecipe(output, input, time, slag);
        if (recipe.input != null) {
            recipeList.add(recipe);
        }
    }

    public static BlastFurnaceRecipe findRecipe(ItemStack input) {
        for (BlastFurnaceRecipe recipe : recipeList) {
            if (!ApiUtils.stackMatchesObject(input, recipe.input)) continue;
            return recipe;
        }
        return null;
    }

    public static List<BlastFurnaceRecipe> removeRecipes(ItemStack stack) {
        ArrayList<BlastFurnaceRecipe> list = new ArrayList<BlastFurnaceRecipe>();
        Iterator<BlastFurnaceRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            BlastFurnaceRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static BlastFurnaceFuel addBlastFuel(Object fuel, int burnTime) {
        BlastFurnaceFuel entry = new BlastFurnaceFuel(ApiUtils.createIngredientStack(fuel), burnTime);
        blastFuels.add(entry);
        return entry;
    }

    public static int getBlastFuelTime(ItemStack stack) {
        for (BlastFurnaceFuel e : blastFuels) {
            if (!e.input.matchesItemStack(stack)) continue;
            return e.burnTime;
        }
        return 0;
    }

    public static boolean isValidBlastFuel(ItemStack stack) {
        return BlastFurnaceRecipe.getBlastFuelTime(stack) > 0;
    }

    public static class BlastFurnaceFuel {
        public final IngredientStack input;
        public final int burnTime;

        public BlastFurnaceFuel(IngredientStack input, int burnTime) {
            this.input = input;
            this.burnTime = burnTime;
        }
    }
}

