/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockDieselGenerator;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityDieselGenerator
extends TileEntityMultiblockMetal<TileEntityDieselGenerator, IMultiblockRecipe>
implements IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.ISoundTile,
IEBlockInterfaces.IFaceShape {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(24000)};
    public boolean active = false;
    public float animation_fanRotationStep = 0.0f;
    public float animation_fanRotation = 0.0f;
    public int animation_fanFadeIn = 0;
    public int animation_fanFadeOut = 0;

    public TileEntityDieselGenerator() {
        super(MultiblockDieselGenerator.instance, new int[]{3, 5, 3}, 0, true);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.active = nbt.func_74767_n("active");
        this.animation_fanRotation = nbt.func_74760_g("animation_fanRotation");
        this.animation_fanFadeIn = nbt.func_74762_e("animation_fanFadeIn");
        this.animation_fanFadeOut = nbt.func_74762_e("animation_fanFadeOut");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("active", this.active);
        nbt.func_74776_a("animation_fanRotation", this.animation_fanRotation);
        nbt.func_74768_a("animation_fanFadeIn", this.animation_fanFadeIn);
        nbt.func_74768_a("animation_fanFadeOut", this.animation_fanFadeOut);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isDummy()) {
            return;
        }
        if (this.active || this.animation_fanFadeIn > 0 || this.animation_fanFadeOut > 0) {
            float step;
            float base = 18.0f;
            float f = step = this.active ? base : 0.0f;
            if (this.animation_fanFadeIn > 0) {
                step -= (float)this.animation_fanFadeIn / 80.0f * base;
                --this.animation_fanFadeIn;
            }
            if (this.animation_fanFadeOut > 0) {
                step += (float)this.animation_fanFadeOut / 80.0f * base;
                --this.animation_fanFadeOut;
            }
            this.animation_fanRotationStep = step;
            this.animation_fanRotation += step;
            this.animation_fanRotation %= 360.0f;
        }
        if (this.field_145850_b.field_72995_K) {
            ImmersiveEngineering.proxy.handleTileSound(IESounds.dieselGenerator, this, this.active, 0.5f, 1.0f);
            if (this.active && this.field_145850_b.func_82737_E() % 4L == 0L) {
                BlockPos exhaust = this.getBlockPosForPos(38);
                EnumFacing fl = this.facing;
                EnumFacing fw = this.facing.func_176746_e();
                if (this.mirrored) {
                    fw = fw.func_176734_d();
                }
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)exhaust.func_177958_n() + 0.5 + (double)((float)fl.func_82601_c() * 0.3125f) + (double)((float)(-fw.func_82601_c()) * 0.3125f), (double)exhaust.func_177956_o() + 1.25, (double)exhaust.func_177952_p() + 0.5 + (double)((float)fl.func_82599_e() * 0.3125f) + (double)((float)(-fw.func_82599_e()) * 0.3125f), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            boolean prevActive = this.active;
            if (!this.isRSDisabled() && this.tanks[0].getFluid() != null && this.tanks[0].getFluid().getFluid() != null) {
                int burnTime = DieselHandler.getBurnTime(this.tanks[0].getFluid().getFluid());
                if (burnTime > 0) {
                    int fluidConsumed = 1000 / burnTime;
                    int output = Config.IEConfig.Machines.dieselGen_output;
                    int connected = 0;
                    TileEntity[] receivers = new TileEntity[3];
                    for (int i = 0; i < 3; ++i) {
                        receivers[i] = this.getEnergyOutput(i == 1 ? -1 : (i == 2 ? 1 : 0));
                        if (receivers[i] == null || EnergyHelper.insertFlux(receivers[i], EnumFacing.DOWN, 4096, true) <= 0) continue;
                        ++connected;
                    }
                    if (connected > 0 && this.tanks[0].getFluidAmount() >= fluidConsumed) {
                        if (!this.active) {
                            this.active = true;
                            this.animation_fanFadeIn = 80;
                        }
                        this.tanks[0].drain(fluidConsumed, true);
                        int splitOutput = output / connected;
                        int leftover = output % connected;
                        for (int i = 0; i < 3; ++i) {
                            if (receivers[i] == null) continue;
                            EnergyHelper.insertFlux(receivers[i], EnumFacing.DOWN, splitOutput + (leftover-- > 0 ? 1 : 0), false);
                        }
                    } else if (this.active) {
                        this.active = false;
                        this.animation_fanFadeOut = 80;
                    }
                }
            } else if (this.active) {
                this.active = false;
                this.animation_fanFadeOut = 80;
            }
            if (prevActive != this.active) {
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
        }
    }

    @Nullable
    TileEntity getEnergyOutput(int w) {
        BlockPos outPos = this.getBlockPosForPos(16 + w).func_177982_a(0, 1, 0);
        TileEntity eTile = Utils.getExistingTileEntity(this.field_145850_b, outPos);
        if (EnergyHelper.isFluxReceiver(eTile, EnumFacing.DOWN)) {
            return eTile;
        }
        return null;
    }

    @Override
    public float[] getBlockBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.func_176746_e();
        if (this.mirrored) {
            fw = fw.func_176734_d();
        }
        if (this.field_174879_c == 1) {
            return new float[]{fl == EnumFacing.WEST ? -0.625f : 0.0f, 0.5f, fl == EnumFacing.NORTH ? -0.625f : 0.0f, fl == EnumFacing.EAST ? 1.375f : 1.0f, 1.5f, fl == EnumFacing.SOUTH ? 1.375f : 1.0f};
        }
        if (this.field_174879_c == 0 || this.field_174879_c == 29 || this.field_174879_c == 44) {
            float[] fArray = new float[6];
            fArray[0] = fw == EnumFacing.WEST ? 0.5f : (this.field_174879_c % 15 > 11 && fl == EnumFacing.EAST ? -0.125f : 0.0f);
            fArray[1] = 0.0f;
            float f = fw == EnumFacing.NORTH ? 0.5f : (fArray[2] = this.field_174879_c % 15 > 11 && fl == EnumFacing.SOUTH ? -0.125f : 0.0f);
            fArray[3] = fw == EnumFacing.EAST ? 0.5f : (this.field_174879_c % 15 > 11 && fl == EnumFacing.WEST ? 1.125f : 1.0f);
            float f2 = fArray[4] = this.field_174879_c > 30 ? 0.8125f : 1.0f;
            fArray[5] = fw == EnumFacing.SOUTH ? 0.5f : (this.field_174879_c % 15 > 11 && fl == EnumFacing.NORTH ? 1.125f : 1.0f);
            return fArray;
        }
        if (this.field_174879_c == 2 || this.field_174879_c == 27 || this.field_174879_c == 42) {
            float[] fArray = new float[6];
            fArray[0] = fw == EnumFacing.EAST ? 0.5f : (this.field_174879_c % 15 > 11 && fl == EnumFacing.EAST ? -0.125f : 0.0f);
            fArray[1] = 0.0f;
            float f = fw == EnumFacing.SOUTH ? 0.5f : (fArray[2] = this.field_174879_c % 15 > 11 && fl == EnumFacing.SOUTH ? -0.125f : 0.0f);
            fArray[3] = fw == EnumFacing.WEST ? 0.5f : (this.field_174879_c % 15 > 11 && fl == EnumFacing.WEST ? 1.125f : 1.0f);
            float f3 = fArray[4] = this.field_174879_c > 30 ? 0.8125f : 1.0f;
            fArray[5] = fw == EnumFacing.NORTH ? 0.5f : (this.field_174879_c % 15 > 11 && fl == EnumFacing.NORTH ? 1.125f : 1.0f);
            return fArray;
        }
        if (this.field_174879_c == 43) {
            return new float[]{this.field_174879_c % 15 > 11 && fl == EnumFacing.EAST ? 0.375f : 0.0f, 0.0f, this.field_174879_c % 15 > 11 && fl == EnumFacing.SOUTH ? 0.375f : 0.0f, this.field_174879_c % 15 > 11 && fl == EnumFacing.WEST ? 0.625f : 1.0f, this.field_174879_c > 30 ? 0.8125f : 1.0f, this.field_174879_c % 15 > 11 && fl == EnumFacing.NORTH ? 0.625f : 1.0f};
        }
        if (this.field_174879_c >= 15 && this.field_174879_c <= 17) {
            return new float[]{0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.field_174879_c == 19 || this.field_174879_c == 34) {
            float[] fArray = new float[6];
            fArray[0] = fl == EnumFacing.EAST ? 0.375f : (fl.func_176740_k() == EnumFacing.Axis.Z ? 0.0625f : 0.0f);
            fArray[1] = 0.0f;
            float f = fl == EnumFacing.SOUTH ? 0.375f : (fArray[2] = fl.func_176740_k() == EnumFacing.Axis.X ? 0.0625f : 0.0f);
            fArray[3] = fl == EnumFacing.WEST ? 0.625f : (fl.func_176740_k() == EnumFacing.Axis.Z ? 0.9375f : 1.0f);
            float f4 = fArray[4] = this.field_174879_c > 30 ? 0.3125f : 1.0f;
            fArray[5] = fl == EnumFacing.NORTH ? 0.625f : (fl.func_176740_k() == EnumFacing.Axis.X ? 0.9375f : 1.0f);
            return fArray;
        }
        if (this.field_174879_c == 37 || this.field_174879_c == 40) {
            return new float[]{fl.func_176740_k() == EnumFacing.Axis.Z ? 0.0625f : 0.0f, 0.0f, fl.func_176740_k() == EnumFacing.Axis.X ? 0.0625f : 0.0f, fl.func_176740_k() == EnumFacing.Axis.Z ? 0.9375f : 1.0f, 0.3125f, fl.func_176740_k() == EnumFacing.Axis.X ? 0.9375f : 1.0f};
        }
        if (this.field_174879_c < 15 && this.field_174879_c % 3 != 1) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.field_174879_c < 30 && this.field_174879_c % 3 == 0) {
            float[] fArray = new float[6];
            fArray[0] = fw == EnumFacing.EAST ? 0.9375f : (this.field_174879_c < 21 && fl == EnumFacing.EAST ? 0.375f : 0.0f);
            fArray[1] = -0.5f;
            float f = fw == EnumFacing.SOUTH ? 0.9375f : (fArray[2] = this.field_174879_c < 21 && fl == EnumFacing.SOUTH ? 0.375f : 0.0f);
            fArray[3] = fw == EnumFacing.WEST ? 0.0625f : (this.field_174879_c < 21 && fl == EnumFacing.WEST ? 0.625f : 1.0f);
            fArray[4] = 0.625f;
            fArray[5] = fw == EnumFacing.NORTH ? 0.0625f : (this.field_174879_c < 21 && fl == EnumFacing.NORTH ? 0.625f : 1.0f);
            return fArray;
        }
        if (this.field_174879_c < 30 && this.field_174879_c % 3 == 2) {
            float[] fArray = new float[6];
            fArray[0] = fw == EnumFacing.WEST ? 0.9375f : (this.field_174879_c < 21 && fl == EnumFacing.EAST ? 0.375f : 0.0f);
            fArray[1] = -0.5f;
            float f = fw == EnumFacing.NORTH ? 0.9375f : (fArray[2] = this.field_174879_c < 21 && fl == EnumFacing.SOUTH ? 0.375f : 0.0f);
            fArray[3] = fw == EnumFacing.EAST ? 0.0625f : (this.field_174879_c < 21 && fl == EnumFacing.WEST ? 0.625f : 1.0f);
            fArray[4] = 0.625f;
            fArray[5] = fw == EnumFacing.SOUTH ? 0.0625f : (this.field_174879_c < 21 && fl == EnumFacing.NORTH ? 0.625f : 1.0f);
            return fArray;
        }
        if (this.field_174879_c == 36 || this.field_174879_c == 38) {
            float minZ;
            float maxX;
            float minX;
            if (this.field_174879_c == 38) {
                fw = fw.func_176734_d();
            }
            float f = fl == EnumFacing.WEST ? -0.0625f : (fl == EnumFacing.EAST ? 0.5625f : (minX = fw == EnumFacing.WEST ? -0.0625f : 0.5625f));
            float f5 = fl == EnumFacing.WEST ? 0.4375f : (fl == EnumFacing.EAST ? 1.0625f : (maxX = fw == EnumFacing.WEST ? 0.4375f : 1.0625f));
            float f6 = fl == EnumFacing.NORTH ? -0.0625f : (fl == EnumFacing.SOUTH ? 0.5625f : (minZ = fw == EnumFacing.NORTH ? -0.0625f : 0.5625f));
            float maxZ = fl == EnumFacing.NORTH ? 0.4375f : (fl == EnumFacing.SOUTH ? 1.0625f : (fw == EnumFacing.NORTH ? 0.4375f : 1.0625f));
            return new float[]{minX, 0.0f, minZ, maxX, this.field_174879_c == 38 ? 1.125f : 0.75f, maxZ};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.func_176746_e();
        if (this.mirrored) {
            fw = fw.func_176734_d();
        }
        if (this.field_174879_c == 16) {
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()), new AxisAlignedBB(fl == EnumFacing.WEST ? -0.625 : 0.0, -0.5, fl == EnumFacing.NORTH ? -0.625 : 0.0, fl == EnumFacing.EAST ? 1.375 : 1.0, 0.5, fl == EnumFacing.SOUTH ? 1.375 : 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
        }
        if (this.field_174879_c == 15 || this.field_174879_c == 17) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            if (this.field_174879_c == 17) {
                fw = fw.func_176734_d();
            }
            list.add(new AxisAlignedBB(fw == EnumFacing.EAST ? 0.125 : (fw == EnumFacing.WEST ? 0.625 : 0.125), 0.0, fw == EnumFacing.SOUTH ? 0.125 : (fw == EnumFacing.NORTH ? 0.625 : 0.125), fw == EnumFacing.EAST ? 0.375 : (fw == EnumFacing.WEST ? 0.875 : 0.375), 0.5, fw == EnumFacing.SOUTH ? 0.375 : (fw == EnumFacing.NORTH ? 0.875 : 0.375)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            list.add(new AxisAlignedBB(fw == EnumFacing.EAST ? 0.125 : (fw == EnumFacing.WEST ? 0.625 : 0.625), 0.0, fw == EnumFacing.SOUTH ? 0.125 : (fw == EnumFacing.NORTH ? 0.625 : 0.625), fw == EnumFacing.EAST ? 0.375 : (fw == EnumFacing.WEST ? 0.875 : 0.875), 0.5, fw == EnumFacing.SOUTH ? 0.375 : (fw == EnumFacing.NORTH ? 0.875 : 0.875)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 23) {
            float[] defaultBounds = this.getBlockBounds();
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)defaultBounds[0], (double)defaultBounds[1], (double)defaultBounds[2], (double)defaultBounds[3], (double)defaultBounds[4], (double)defaultBounds[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            list.add(new AxisAlignedBB(fw == EnumFacing.EAST ? 0.5 : (fw == EnumFacing.WEST ? 0.0 : 0.3125), 0.25, fw == EnumFacing.SOUTH ? 0.5 : (fw == EnumFacing.NORTH ? 0.0 : 0.3125), fw == EnumFacing.EAST ? 1.0 : (fw == EnumFacing.WEST ? 0.5 : 0.6875), 0.75, fw == EnumFacing.SOUTH ? 1.0 : (fw == EnumFacing.NORTH ? 0.5 : 0.6875)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            list.add(new AxisAlignedBB(fw == EnumFacing.EAST ? 0.6875 : (fw == EnumFacing.WEST ? 0.1875 : 0.4375), -0.5, fw == EnumFacing.SOUTH ? 0.6875 : (fw == EnumFacing.NORTH ? 0.1875 : 0.4375), fw == EnumFacing.EAST ? 0.8125 : (fw == EnumFacing.WEST ? 0.3125 : 0.5625), 0.25, fw == EnumFacing.SOUTH ? 0.8125 : (fw == EnumFacing.NORTH ? 0.3125 : 0.5625)).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c > 2 && this.field_174879_c < 15 && this.field_174879_c % 3 != 1) {
            float maxZ;
            float minZ;
            float maxX;
            float minX;
            float[] defaultBounds = this.getBlockBounds();
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)defaultBounds[0], (double)defaultBounds[1], (double)defaultBounds[2], (double)defaultBounds[3], (double)defaultBounds[4], (double)defaultBounds[5]).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            if (this.field_174879_c % 3 == 2) {
                fw = fw.func_176734_d();
            }
            if (this.field_174879_c < 6) {
                float f = fw == EnumFacing.WEST ? 0.0f : (fw == EnumFacing.EAST ? 0.125f : (minX = fl == EnumFacing.WEST ? 0.25f : 0.5f));
                float f2 = fw == EnumFacing.WEST ? 0.875f : (fw == EnumFacing.EAST ? 1.0f : (maxX = fl == EnumFacing.EAST ? 0.75f : 0.5f));
                float f3 = fw == EnumFacing.NORTH ? 0.0f : (fw == EnumFacing.SOUTH ? 0.125f : (minZ = fl == EnumFacing.NORTH ? 0.25f : 0.5f));
                maxZ = fw == EnumFacing.NORTH ? 0.875f : (fw == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.SOUTH ? 0.75f : 0.5f));
                list.add(new AxisAlignedBB((double)minX, 0.5625, (double)minZ, (double)maxX, 0.8125, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                float f4 = fw == EnumFacing.WEST ? 0.625f : (fw == EnumFacing.EAST ? 0.125f : (minX = fl == EnumFacing.EAST ? 0.0f : 0.5f));
                float f5 = fw == EnumFacing.WEST ? 0.875f : (fw == EnumFacing.EAST ? 0.375f : (maxX = fl == EnumFacing.WEST ? 1.0f : 0.5f));
                float f6 = fw == EnumFacing.NORTH ? 0.625f : (fw == EnumFacing.SOUTH ? 0.125f : (minZ = fl == EnumFacing.SOUTH ? 0.0f : 0.5f));
                maxZ = fw == EnumFacing.NORTH ? 0.875f : (fw == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 1.0f : 0.5f));
                list.add(new AxisAlignedBB((double)minX, 0.5625, (double)minZ, (double)maxX, 0.8125, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            } else if (this.field_174879_c < 12) {
                minX = (fw == EnumFacing.WEST ? 0.0f : (fw == EnumFacing.EAST ? 0.4375f : (fl == EnumFacing.EAST ? 0.25f : -0.5625f))) + (float)(this.field_174879_c <= 8 ? 0 : (fl == EnumFacing.WEST ? 1 : (fl == EnumFacing.EAST ? -1 : 0)));
                maxX = (fw == EnumFacing.WEST ? 0.5626f : (fw == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.75f : 1.4375f))) + (float)(this.field_174879_c <= 8 ? 0 : (fl == EnumFacing.WEST ? 1 : (fl == EnumFacing.EAST ? -1 : 0)));
                minZ = (fw == EnumFacing.NORTH ? 0.0f : (fw == EnumFacing.SOUTH ? 0.4375f : (fl == EnumFacing.SOUTH ? 0.25f : -0.5625f))) + (float)(this.field_174879_c <= 8 ? 0 : (fl == EnumFacing.NORTH ? 1 : (fl == EnumFacing.SOUTH ? -1 : 0)));
                maxZ = (fw == EnumFacing.NORTH ? 0.5625f : (fw == EnumFacing.SOUTH ? 1.0f : (fl == EnumFacing.NORTH ? 0.75f : 1.4375f))) + (float)(this.field_174879_c <= 8 ? 0 : (fl == EnumFacing.NORTH ? 1 : (fl == EnumFacing.SOUTH ? -1 : 0)));
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            if (this.field_174879_c > 8) {
                minX = (fw == EnumFacing.WEST ? 0.5625f : (fw == EnumFacing.EAST ? 0.375f : (fl == EnumFacing.WEST ? 0.5625f : 0.1875f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.WEST ? 1 : (fl == EnumFacing.EAST ? -1 : 0)));
                maxX = (fw == EnumFacing.WEST ? 0.625f : (fw == EnumFacing.EAST ? 0.4375f : (fl == EnumFacing.EAST ? 0.4375f : 0.8125f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.WEST ? 1 : (fl == EnumFacing.EAST ? -1 : 0)));
                minZ = (fw == EnumFacing.NORTH ? 0.5625f : (fw == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.5625f : 0.1875f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.NORTH ? 1 : (fl == EnumFacing.SOUTH ? -1 : 0)));
                maxZ = (fw == EnumFacing.NORTH ? 0.625f : (fw == EnumFacing.SOUTH ? 0.4375f : (fl == EnumFacing.SOUTH ? 0.4375f : 0.8125f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.NORTH ? 1 : (fl == EnumFacing.SOUTH ? -1 : 0)));
                list.add(new AxisAlignedBB((double)minX, 0.5625, (double)minZ, (double)maxX, 0.8125, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                minX = (fw == EnumFacing.WEST ? 0.5f : (fw == EnumFacing.EAST ? 0.375f : (fl == EnumFacing.WEST ? -0.875f : 1.625f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.WEST ? 1 : (fl == EnumFacing.EAST ? -1 : 0)));
                maxX = (fw == EnumFacing.WEST ? 0.625f : (fw == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.EAST ? 1.875f : -0.625f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.WEST ? 1 : (fl == EnumFacing.EAST ? -1 : 0)));
                minZ = (fw == EnumFacing.NORTH ? 0.5f : (fw == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? -0.875f : 1.625f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.NORTH ? 1 : (fl == EnumFacing.SOUTH ? -1 : 0)));
                maxZ = (fw == EnumFacing.NORTH ? 0.625f : (fw == EnumFacing.SOUTH ? 0.5f : (fl == EnumFacing.SOUTH ? 1.875f : -0.625f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.NORTH ? 1 : (fl == EnumFacing.SOUTH ? -1 : 0)));
                list.add(new AxisAlignedBB((double)minX, 0.5625, (double)minZ, (double)maxX, 0.8125, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
                minX = (fw == EnumFacing.WEST ? 0.625f : (fw == EnumFacing.EAST ? 0.125f : (fl == EnumFacing.EAST ? 0.1875f : -0.875f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.WEST ? 1 : (fl == EnumFacing.EAST ? -1 : 0)));
                maxX = (fw == EnumFacing.WEST ? 0.875f : (fw == EnumFacing.EAST ? 0.375f : (fl == EnumFacing.WEST ? 0.8125f : 1.875f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.WEST ? 1 : (fl == EnumFacing.EAST ? -1 : 0)));
                minZ = (fw == EnumFacing.NORTH ? 0.625f : (fw == EnumFacing.SOUTH ? 0.125f : (fl == EnumFacing.SOUTH ? 0.1875f : -0.875f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.NORTH ? 1 : (fl == EnumFacing.SOUTH ? -1 : 0)));
                maxZ = (fw == EnumFacing.NORTH ? 0.875f : (fw == EnumFacing.SOUTH ? 0.375f : (fl == EnumFacing.NORTH ? 0.8125f : 1.875f))) + (float)(this.field_174879_c <= 11 ? 0 : (fl == EnumFacing.NORTH ? 1 : (fl == EnumFacing.SOUTH ? -1 : 0)));
                list.add(new AxisAlignedBB((double)minX, 0.5625, (double)minZ, (double)maxX, 0.8125, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            }
            return list;
        }
        return null;
    }

    @Override
    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    @Override
    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    @Override
    public int[] getEnergyPos() {
        return new int[]{15, 16, 17};
    }

    @Override
    public int[] getRedstonePos() {
        return new int[]{23};
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 0;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 0;
    }

    @Override
    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<IMultiblockRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntityDieselGenerator master = (TileEntityDieselGenerator)this.master();
        if (!(master == null || this.field_174879_c != 0 && this.field_174879_c != 2 || side != null && side.func_176740_k() != this.facing.func_176735_f().func_176740_k())) {
            return master.tanks;
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        if (resources == null) {
            return false;
        }
        return DieselHandler.isValidFuel(resources.getFluid());
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public IMultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected IMultiblockRecipe readRecipeFromNBT(NBTTagCompound tag) {
        return null;
    }

    @Override
    public boolean canOpenGui() {
        return false;
    }

    @Override
    public int getGuiID() {
        return -1;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public boolean shoudlPlaySound(String sound) {
        return this.active;
    }

    @Override
    public BlockFaceShape getFaceShape(EnumFacing side) {
        if (this.field_174879_c == 0 || this.field_174879_c == 2) {
            return side.func_176740_k() == this.facing.func_176746_e().func_176740_k() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
        }
        if (this.field_174879_c >= 15 && this.field_174879_c <= 17) {
            return side == EnumFacing.UP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
        }
        if (this.field_174879_c == 23) {
            return side.func_176740_k() == this.facing.func_176746_e().func_176740_k() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

