/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.model.TRSRTransformation;

public class TileEntityBreakerSwitch
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IAdvancedDirectionalTile,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IRedstoneOutput,
IOBJModelCallback<IBlockState> {
    public int rotation = 0;
    public EnumFacing facing = EnumFacing.NORTH;
    public int wires = 0;
    public boolean active = false;
    public boolean inverted = false;
    public BlockPos endOfLeftConnection = null;

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    protected boolean canTakeMV() {
        return true;
    }

    @Override
    protected boolean canTakeHV() {
        return false;
    }

    @Override
    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return this.active;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target, Vec3i offset) {
        if (!cableType.isEnergyWire() && !"REDSTONE".equals(cableType.getCategory())) {
            return false;
        }
        if ("HV".equals(cableType.getCategory()) && !this.canTakeHV()) {
            return false;
        }
        if (this.wires >= 2) {
            return false;
        }
        return this.limitType == null || WireApi.canMix(cableType, this.limitType);
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target, IImmersiveConnectable other) {
        if (this.limitType == null) {
            this.limitType = cableType;
        }
        ++this.wires;
        this.onConnectionChange();
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        return this.limitType;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        this.wires = type == null ? 0 : --this.wires;
        if (this.wires <= 0) {
            this.limitType = null;
        }
        this.onConnectionChange();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing.ordinal());
        nbt.func_74768_a("rotation", this.rotation);
        nbt.func_74768_a("wires", this.wires);
        nbt.func_74757_a("active", this.active);
        nbt.func_74757_a("inverted", this.inverted);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.rotation = nbt.func_74762_e("rotation");
        this.wires = nbt.func_74762_e("wires");
        this.active = nbt.func_74767_n("active");
        this.inverted = nbt.func_74767_n("inverted");
        this.onConnectionChange();
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        Matrix4 mat = new Matrix4(this.facing);
        mat.translate(0.5, 0.5, 0.0).rotate(1.5707963267948966 * (double)this.rotation, 0.0, 0.0, 1.0).translate(-0.5, -0.5, 0.0);
        if (this.endOfLeftConnection == null) {
            this.calculateLeftConn(mat);
        }
        boolean isLeft = con.end.equals((Object)this.endOfLeftConnection) || con.start.equals((Object)this.endOfLeftConnection);
        Vec3d ret = mat.apply(new Vec3d(isLeft ? 0.25 : 0.75, 0.5, 0.125));
        return ret;
    }

    protected void calculateLeftConn(Matrix4 transform) {
        Vec3d leftVec = transform.apply(new Vec3d(-1.0, 0.5, 0.5)).func_178786_a(0.0, 0.5, 0.5);
        EnumFacing dir = EnumFacing.func_176737_a((float)((float)leftVec.field_72450_a), (float)((float)leftVec.field_72448_b), (float)((float)leftVec.field_72449_c));
        int maxDiff = Integer.MIN_VALUE;
        Set<ImmersiveNetHandler.Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, this.field_174879_c);
        if (conns != null) {
            for (ImmersiveNetHandler.Connection c : conns) {
                BlockPos diff = this.field_174879_c.equals((Object)c.start) ? c.end.func_177973_b((Vec3i)this.field_174879_c) : c.start.func_177973_b((Vec3i)this.field_174879_c);
                int val = 0;
                switch (dir.func_176740_k()) {
                    case X: {
                        val = diff.func_177958_n();
                        break;
                    }
                    case Y: {
                        val = diff.func_177956_o();
                        break;
                    }
                    case Z: {
                        val = diff.func_177952_p();
                    }
                }
                if ((val *= dir.func_176743_c().func_179524_a()) <= maxDiff) continue;
                maxDiff = val;
                this.endOfLeftConnection = this.field_174879_c == c.end ? c.start : c.end;
            }
        }
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.inverted = !this.inverted;
            ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.rsSignal." + (this.inverted ? "invertedOn" : "invertedOff"), new Object[0])});
            if (this.wires > 1) {
                ImmersiveNetHandler.INSTANCE.resetCachedIndirectConnections(this.field_145850_b, this.field_174879_c);
            }
            this.notifyNeighbours();
        } else {
            this.rotation = (this.rotation + 3) % 4;
            this.onConnectionChange();
        }
        return true;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (!Utils.isHammer(heldItem)) {
            this.active = !this.active;
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), IESounds.direSwitch, SoundCategory.BLOCKS, 2.5f, 1.0f);
            if (this.wires > 1) {
                ImmersiveNetHandler.INSTANCE.resetCachedIndirectConnections(this.field_145850_b, this.field_174879_c);
            }
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), this.active ? 1 : 0, 0);
            this.notifyNeighbours();
        }
        return true;
    }

    public void notifyNeighbours() {
        this.func_70296_d();
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            this.field_145850_b.func_175685_c(this.func_174877_v().func_177972_a(f), this.func_145838_q(), true);
        }
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (super.func_145842_c(id, arg)) {
            return true;
        }
        this.active = id == 1;
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 0;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public float[] getBlockBounds() {
        Vec3d start = new Vec3d(0.25, 0.1875, 0.0);
        Vec3d end = new Vec3d(0.75, 0.8125, 0.5);
        Matrix4 mat = new Matrix4(this.facing);
        mat.translate(0.5, 0.5, 0.0).rotate(1.5707963267948966 * (double)this.rotation, 0.0, 0.0, 1.0).translate(-0.5, -0.5, 0.0);
        start = mat.apply(start);
        end = mat.apply(end);
        return new float[]{(float)start.field_72450_a, (float)start.field_72448_b, (float)start.field_72449_c, (float)end.field_72450_a, (float)end.field_72448_b, (float)end.field_72449_c};
    }

    @Override
    public int getWeakRSOutput(IBlockState state, EnumFacing side) {
        return this.active ^ this.inverted ? 15 : 0;
    }

    @Override
    public int getStrongRSOutput(IBlockState state, EnumFacing side) {
        return side.func_176734_d() == this.facing && this.active ^ this.inverted ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, EnumFacing side) {
        return true;
    }

    @Override
    public Optional<TRSRTransformation> applyTransformations(IBlockState object, String group, Optional<TRSRTransformation> transform) {
        Matrix4 mat = transform.isPresent() ? new Matrix4(transform.get().getMatrix()) : new Matrix4();
        mat = mat.translate(0.5, 0.0, 0.5).rotate(1.5707963267948966 * (double)this.rotation, 0.0, 1.0, 0.0).translate(-0.5, 0.0, -0.5);
        transform = Optional.of(new TRSRTransformation(mat.toMatrix4f()));
        return transform;
    }

    @Override
    public String getCacheKey(IBlockState object) {
        return this.rotation + "," + this.facing.func_176745_a() + "," + this.active;
    }

    @Override
    public void onDirectionalPlacement(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        EnumFacing f = EnumFacing.SOUTH;
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            float xFromMid = hitX - 0.5f;
            float zFromMid = hitZ - 0.5f;
            float max = Math.max(Math.abs(xFromMid), Math.abs(zFromMid));
            if (max == Math.abs(xFromMid)) {
                f = xFromMid < 0.0f ? EnumFacing.WEST : EnumFacing.EAST;
            } else {
                EnumFacing enumFacing = f = zFromMid < 0.0f ? EnumFacing.NORTH : EnumFacing.SOUTH;
            }
            if (side == EnumFacing.UP && f.func_176740_k() == EnumFacing.Axis.Z || side == EnumFacing.DOWN) {
                f = f.func_176734_d();
            }
        }
        this.rotation = f.func_176736_b();
    }

    protected void onConnectionChange() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.endOfLeftConnection = null;
            ImmersiveEngineering.proxy.clearConnectionModelCache();
            Set<ImmersiveNetHandler.Connection> conns = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, this.field_174879_c);
            if (conns != null) {
                for (ImmersiveNetHandler.Connection c : conns) {
                    c.catenaryVertices = null;
                    this.field_145850_b.func_175704_b(c.end, c.end);
                    Set<ImmersiveNetHandler.Connection> connsThere = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, c.end);
                    if (connsThere == null) continue;
                    for (ImmersiveNetHandler.Connection c2 : connsThere) {
                        if (!c2.end.equals((Object)this.field_174879_c)) continue;
                        c2.catenaryVertices = null;
                    }
                }
            }
        }
        if (this.field_145850_b != null) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public boolean moveConnectionTo(ImmersiveNetHandler.Connection c, BlockPos newEnd) {
        if (c.end.equals((Object)this.endOfLeftConnection)) {
            this.endOfLeftConnection = newEnd;
        }
        return true;
    }
}

