/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.client.gui.dinopedia;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import fossilsarcheology.Revival;
import fossilsarcheology.client.gui.dinopedia.ButtonDinopedia;
import fossilsarcheology.client.gui.dinopedia.ButtonDinopediaPage;
import fossilsarcheology.server.entity.EntityDinosaurEgg;
import fossilsarcheology.server.entity.EntityFishBase;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.EntityQuagga;
import fossilsarcheology.server.entity.utility.FossilsMammalProperties;
import fossilsarcheology.server.util.FoodMappings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.util.ClientUtils;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiPedia
extends GuiScreen {
    private static final ResourceLocation background_image = new ResourceLocation("fossil", "textures/gui/dinopedia.png");
    private static final ResourceLocation moods = new ResourceLocation("fossil", "textures/gui/dinopedia_mood.png");
    public final int xGui = 390;
    public final int yGui = 320;
    public final int bookPagesTotal = 1;
    private final FoodSorter sorter = new FoodSorter();
    public ButtonDinopediaPage buttonNextPage;
    public ButtonDinopediaPage buttonPreviousPage;
    public int bookPages;
    public ButtonDinopedia buttonIcon;
    protected int xSize = 390;
    protected int ySize = 245;
    protected int guiLeft;
    protected int guiTop;
    int left = 0;
    int right = 0;
    int items = 0;
    private RenderItem itemRender;
    private float mouseX;
    private float mouseY;
    private String renderText = "";

    public static void renderDinosaur(int posX, int posY, int scaleValue, float renderPitch, EntityLivingBase mob) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        scaleValue = (int)((float)scaleValue - (float)scaleValue * 0.25f);
        if (mob instanceof EntityPrehistoric) {
            GlStateManager.func_179152_a((float)(-scaleValue), (float)(-((float)scaleValue)), (float)scaleValue);
        } else {
            GlStateManager.func_179152_a((float)scaleValue, (float)scaleValue, (float)scaleValue);
        }
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(renderPitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)((float)mob.func_70033_W()), (float)0.0f);
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        if (mob instanceof EntityPrehistoric) {
            EntityPrehistoric prehistoric = (EntityPrehistoric)mob;
            float scale = prehistoric.getGender() == 1 ? prehistoric.getMaleSize() * prehistoric.getAgeScale() : 1.0f * prehistoric.getAgeScale();
            GlStateManager.func_179152_a((float)(1.0f / scale), (float)(-1.0f / scale), (float)(-1.0f / scale));
        }
        GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)1.0f, (float)-0.1f);
        float partialTicks = LLibrary.PROXY.getPartialTicks();
        GlStateManager.func_179114_b((float)ClientUtils.interpolate((float)mob.field_70760_ar, (float)mob.field_70761_aq, (float)partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)mob, 0.0, 0.0, 0.0, 0.0f, partialTicks, false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void renderEgg(int posX, int posY, int scaleValue, float renderYaw, float renderPitch, Entity mob) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)scaleValue, (float)scaleValue, (float)scaleValue);
        float f3 = mob.field_70177_z;
        float f4 = mob.field_70125_A;
        GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(renderPitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        mob.field_70177_z = (float)Math.atan(renderYaw / 40.0f) * 40.0f;
        mob.field_70125_A = -((float)Math.atan(renderPitch / 40.0f)) * 20.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)((float)mob.func_70033_W()), (float)0.0f);
        GlStateManager.func_179114_b((float)mob.field_70173_aa, (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(mob, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
        mob.field_70177_z = f3;
        mob.field_70125_A = f4;
        GlStateManager.func_179097_i();
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        int centerX = (this.field_146294_l - this.xGui) / 2;
        int centerY = (this.field_146295_m - this.yGui) / 2;
        this.buttonNextPage = new ButtonDinopediaPage(0, centerX + 350, centerY + 240, true, this.bookPages);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new ButtonDinopediaPage(1, centerX + 7, centerY + 240, false, this.bookPages);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.itemRender = Minecraft.func_71410_x().func_175599_af();
        this.addButtonByPage(this.bookPages);
        super.func_73866_w_();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.field_146297_k.field_71439_g.func_70089_S() || this.field_146297_k.field_71439_g.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.renderText = "";
    }

    public void reset() {
        this.left = 0;
        this.right = 0;
        this.items = 0;
    }

    public void addStringLR(String string, boolean left0) {
        int n;
        int n2 = 30 + (left0 ? 0 : 121);
        if (left0) {
            int n3 = this.left;
            n = n3;
            this.left = n3 + 1;
        } else {
            int n4 = this.right;
            n = n4;
            this.right = n4 + 1;
        }
        this.field_146289_q.func_78276_b(string, n2, 12 * (n + 1), 0x404040);
    }

    public void addStringLR(String string, int marginOffset, boolean left0) {
        int n;
        int n2 = 30 + (left0 ? marginOffset : 121 + marginOffset);
        if (left0) {
            int n3 = this.left;
            n = n3;
            this.left = n3 + 1;
        } else {
            int n4 = this.right;
            n = n4;
            this.right = n4 + 1;
        }
        this.field_146289_q.func_78276_b(string, n2, 12 * (n + 1), 10321511);
    }

    public void addStringLR(String string, boolean left0, int r, int g, int b) {
        int n;
        int col = r << 16 | g << 8 | b;
        int n2 = 30 + (left0 ? 0 : 121);
        if (left0) {
            int n3 = this.left;
            n = n3;
            this.left = n3 + 1;
        } else {
            int n4 = this.right;
            n = n4;
            this.right = n4 + 1;
        }
        this.field_146289_q.func_78276_b(string, n2, 12 * (n + 1), col);
    }

    public void printStringXY(String str0, int x0, int y0, int r, int g, int b) {
        int col = r << 16 | g << 8 | b;
        this.field_146289_q.func_78276_b(str0, x0, y0, col);
    }

    public boolean printItemXY(ItemStack item, int x, int y, int zoom) {
        if (!(item.func_77973_b() instanceof ItemBlock)) {
            ScaledResolution scaledResolution = new ScaledResolution(this.field_146297_k);
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int guiLeft = (width - this.xSize) / 2;
            int guiTop = (height - this.ySize) / 2;
            int mouseX = Mouse.getX() * width / this.field_146297_k.field_71443_c - guiLeft;
            int mouseY = height - Mouse.getY() * height / this.field_146297_k.field_71440_d - 1 - guiTop;
            int drawSize = zoom * 16;
            if (!item.func_190926_b()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                FontRenderer font = null;
                ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
                if (mesher instanceof ItemModelMesherForge && ((ItemModelMesherForge)mesher).getLocation(item) == ModelBakery.field_177604_a) {
                    return false;
                }
                this.itemRender.func_180450_b(item, x, y);
                this.itemRender.func_180453_a(font, item, x, y, null);
                if (mouseX > x && mouseX < x + drawSize && mouseY > y && mouseY < y + drawSize) {
                    this.renderText = item.func_82833_r();
                }
                return true;
            }
            if (drawSize < 0) {
                drawSize = 4;
            }
            if (drawSize == 0) {
                drawSize = 8;
            }
            if (drawSize > 160) {
                drawSize = 160;
            }
        }
        return false;
    }

    public void addMiniItem(ItemStack item) {
        if (this.printItemXY(item, 230 + 16 * (this.items % 8), 70 + 16 * (this.items / 8), 1)) {
            ++this.items;
        }
    }

    public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        if (this.field_146297_k == null || this.field_146297_k.field_71441_e == null) {
            return;
        }
        this.func_146276_q_();
        int k = this.guiLeft;
        int l = this.guiTop;
        this.drawGuiContainerBackgroundLayer(p_73863_3_, p_73863_1_, p_73863_2_);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        super.func_73863_a(p_73863_1_, p_73863_2_, p_73863_3_);
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)k, (float)l, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        this.drawGuiContainerForegroundLayer(p_73863_1_, p_73863_2_);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        if (!this.renderText.isEmpty()) {
            this.drawHoveringText(Lists.newArrayList((Object[])new String[]{this.renderText}), p_73863_1_, p_73863_2_, this.field_146289_q);
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        boolean flag = false;
        if (Revival.PEDIA_OBJECT instanceof EntityPrehistoric || Revival.PEDIA_OBJECT instanceof EntityFishBase || Revival.PEDIA_OBJECT instanceof EntityQuagga) {
            this.buttonNextPage.field_146124_l = true;
        }
        if (this.bookPages == 0) {
            FossilsMammalProperties properties;
            if (Revival.PEDIA_OBJECT instanceof EntityAnimal && (properties = (FossilsMammalProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)((EntityAnimal)Revival.PEDIA_OBJECT), FossilsMammalProperties.class)) != null && properties.isPregnant()) {
                flag = true;
                EntityAnimal entity = (EntityAnimal)Revival.PEDIA_OBJECT;
                String s1 = I18n.func_135052_a((String)entity.func_70005_c_(), (Object[])new Object[0]);
                String s2 = "prehistoric.pregnant";
                int quot = (int)Math.floor((float)properties.embryoProgress / (float)(Revival.CONFIG_OPTIONS.pregnancyTime + 1) * 100.0f);
                String s3 = I18n.func_135052_a((String)"prehistoric.pregnantTime", (Object[])new Object[0]) + " " + quot + "%";
                this.printStringXY(s3, -this.field_146289_q.func_78256_a(s3) / 2 + 100, 110, 157, 126, 103);
                GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
                this.printStringXY(I18n.func_135052_a((String)s2, (Object[])new Object[0]) + " " + entity.func_70005_c_(), -this.field_146289_q.func_78256_a(I18n.func_135052_a((String)s2, (Object[])new Object[0]) + entity.func_70005_c_()) / 2 + 65, 60, 66, 48, 36);
                return;
            }
            if (Revival.PEDIA_OBJECT instanceof EntityLivingBase) {
                this.renderFirstPage((Entity)((EntityLivingBase)Revival.PEDIA_OBJECT));
            } else if (Revival.PEDIA_OBJECT instanceof EntityDinosaurEgg) {
                this.renderFirstPage((Entity)((EntityDinosaurEgg)((Object)Revival.PEDIA_OBJECT)));
            } else if (Revival.PEDIA_OBJECT instanceof EntityFishBase) {
                this.renderFirstPage((Entity)((EntityFishBase)((Object)Revival.PEDIA_OBJECT)));
            }
        } else if (Revival.PEDIA_OBJECT instanceof EntityPrehistoric) {
            this.showPrehistoricBio(((EntityPrehistoric)Revival.PEDIA_OBJECT).type.resourceName);
        } else if (Revival.PEDIA_OBJECT instanceof EntityFishBase) {
            this.showPrehistoricBio(((EntityFishBase)((Object)Revival.PEDIA_OBJECT)).selfType.resourceName);
        } else if (Revival.PEDIA_OBJECT instanceof EntityQuagga) {
            this.showPrehistoricBio("quagga");
        }
    }

    public void showPrehistoricBio(String mobName) {
        this.reset();
        this.addStringLR("", 150, false);
        String translatePath = "dinopedia/" + Minecraft.func_71410_x().field_71474_y.field_74363_ab.toLowerCase() + "/";
        String bioFile = mobName + ".txt";
        if (((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(translatePath) == null) {
            translatePath = "dinopedia/en_us/";
        }
        try {
            String line;
            IResource resource = this.field_146297_k.func_110442_L().func_110536_a(new ResourceLocation("fossil", translatePath + bioFile));
            InputStream fileReader = resource.func_110527_b();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileReader, StandardCharsets.UTF_8));
            int linenumber = 0;
            this.addStringLR("", 250, true);
            while ((line = bufferedReader.readLine()) != null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                if (linenumber <= 20) {
                    this.addStringLR(line, -125, false);
                } else {
                    this.addStringLR(line, 250, true);
                }
                ++linenumber;
                GlStateManager.func_179121_F();
            }
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.addStringLR("File not found.", -125, false);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            this.addStringLR(translatePath + bioFile, 0, false);
            GlStateManager.func_179121_F();
        }
    }

    public void renderFirstPage(Entity entity) {
        String s1;
        String s;
        this.reset();
        int wordLength = 90;
        if (entity instanceof EntityPrehistoric) {
            ArrayList<String> text;
            EntityPrehistoric dino = (EntityPrehistoric)entity;
            this.renderFirstPageRight((EntityLivingBase)dino);
            GlStateManager.func_179094_E();
            s = I18n.func_135052_a((String)entity.func_70005_c_(), (Object[])new Object[0]);
            GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
            this.printStringXY(I18n.func_135052_a((String)entity.func_70005_c_(), (Object[])new Object[0]), -this.field_146289_q.func_78256_a(s) / 2 + 65, 60, 66, 48, 36);
            GlStateManager.func_179121_F();
            String s12 = I18n.func_135052_a((String)"pedia.age", (Object[])new Object[0]) + " " + dino.getAgeInDays();
            this.printStringXY(s12, wordLength / 2, 110, 157, 126, 103);
            s12 = I18n.func_135052_a((String)"pedia.health", (Object[])new Object[0]) + " " + Math.min((float)Math.round(dino.func_110143_aJ()), dino.func_110138_aP()) + "/" + dino.func_110138_aP();
            this.printStringXY(s12, wordLength / 2, 120, 157, 126, 103);
            s12 = I18n.func_135052_a((String)"pedia.hunger", (Object[])new Object[0]) + " " + dino.getHunger() + "/" + dino.getMaxHunger();
            this.printStringXY(s12, wordLength / 2, 130, 157, 126, 103);
            ScaledResolution scaledResolution = new ScaledResolution(this.field_146297_k);
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int mouseX = Mouse.getX() * width / this.field_146297_k.field_71443_c - this.guiLeft;
            int mouseY = height - Mouse.getY() * height / this.field_146297_k.field_71440_d - 1 - this.guiTop;
            String s13 = I18n.func_135052_a((String)"pedia.diet", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("pedia.diet." + dino.type.diet.toString().toLowerCase()), (Object[])new Object[0]);
            int x = wordLength / 2;
            int y = 140;
            this.printStringXY(s13, x, y, 157, 126, 103);
            if (mouseX > x && mouseX < x + this.field_146289_q.func_78256_a(s13) && mouseY > y && mouseY < y + 10) {
                text = new ArrayList<String>();
                text.add(I18n.func_135052_a((String)("pedia.diet." + dino.type.diet.toString().toLowerCase() + ".desc"), (Object[])new Object[0]));
                GlStateManager.func_179094_E();
                this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
                GlStateManager.func_179121_F();
            }
            scaledResolution = new ScaledResolution(this.field_146297_k);
            width = scaledResolution.func_78326_a();
            height = scaledResolution.func_78328_b();
            mouseX = Mouse.getX() * width / this.field_146297_k.field_71443_c - this.guiLeft;
            mouseY = height - Mouse.getY() * height / this.field_146297_k.field_71440_d - 1 - this.guiTop;
            s13 = I18n.func_135052_a((String)"pedia.temperament", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)dino.getTempermentString(), (Object[])new Object[0]);
            x = wordLength / 2;
            y = 150;
            this.printStringXY(s13, x, y, 157, 126, 103);
            if (mouseX > x && mouseX < x + this.field_146289_q.func_78256_a(s13) && mouseY > y && mouseY < y + 10) {
                text = new ArrayList();
                text.add(I18n.func_135052_a((String)(dino.getTempermentString() + ".desc"), (Object[])new Object[0]));
                GlStateManager.func_179094_E();
                this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
                GlStateManager.func_179121_F();
            }
            s12 = I18n.func_135052_a((String)"pedia.gender", (Object[])new Object[0]) + " " + (dino.getGender() == 0 ? I18n.func_135052_a((String)"pedia.gender.female", (Object[])new Object[0]) : I18n.func_135052_a((String)"pedia.gender.male", (Object[])new Object[0]));
            this.printStringXY(s12, wordLength / 2, 160, 157, 126, 103);
            String name = dino.func_70902_q() == null ? "" : dino.func_70902_q().func_70005_c_();
            String s14 = I18n.func_135052_a((String)"pedia.untame", (Object[])new Object[0]);
            String s2 = I18n.func_135052_a((String)"pedia.owner", (Object[])new Object[0]) + " " + name;
            this.printStringXY(!name.equals("") ? s2 : s14, wordLength / 2, 170, 157, 126, 103);
            scaledResolution = new ScaledResolution(this.field_146297_k);
            width = scaledResolution.func_78326_a();
            height = scaledResolution.func_78328_b();
            mouseX = Mouse.getX() * width / this.field_146297_k.field_71443_c - this.guiLeft;
            mouseY = height - Mouse.getY() * height / this.field_146297_k.field_71440_d - 1 - this.guiTop;
            s13 = I18n.func_135052_a((String)"pedia.order", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("pedia.order." + dino.currentOrder.toString().toLowerCase()), (Object[])new Object[0]);
            x = wordLength / 2;
            y = 180;
            this.printStringXY(s13, x, y, 157, 126, 103);
            if (mouseX > x && mouseX < x + this.field_146289_q.func_78256_a(s13) && mouseY > y && mouseY < y + 10) {
                text = new ArrayList();
                text.add(I18n.func_135052_a((String)I18n.func_135052_a((String)("pedia.order." + dino.currentOrder.toString().toLowerCase() + ".desc"), (Object[])new Object[0]), (Object[])new Object[0]));
                GlStateManager.func_179094_E();
                this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
                GlStateManager.func_179121_F();
            }
            scaledResolution = new ScaledResolution(this.field_146297_k);
            width = scaledResolution.func_78326_a();
            height = scaledResolution.func_78328_b();
            mouseX = Mouse.getX() * width / this.field_146297_k.field_71443_c - this.guiLeft;
            mouseY = height - Mouse.getY() * height / this.field_146297_k.field_71440_d - 1 - this.guiTop;
            s13 = I18n.func_135052_a((String)"pedia.order.item", (Object[])new Object[0]) + ": " + new ItemStack(dino.getOrderItem()).func_82833_r();
            x = wordLength / 2;
            y = 190;
            this.printStringXY(s13, x, y, 157, 126, 103);
            scaledResolution = new ScaledResolution(this.field_146297_k);
            width = scaledResolution.func_78326_a();
            height = scaledResolution.func_78328_b();
            mouseX = Mouse.getX() * width / this.field_146297_k.field_71443_c - this.guiLeft;
            mouseY = height - Mouse.getY() * height / this.field_146297_k.field_71440_d - 1 - this.guiTop;
            s13 = I18n.func_135052_a((String)"pedia.activity", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("pedia.activity." + dino.aiActivityType().toString().toLowerCase()), (Object[])new Object[0]);
            x = wordLength / 2;
            y = 200;
            this.printStringXY(s13, x, y, 157, 126, 103);
            if (mouseX > x && mouseX < x + this.field_146289_q.func_78256_a(s13) && mouseY > y && mouseY < y + 10) {
                text = new ArrayList();
                text.add(I18n.func_135052_a((String)I18n.func_135052_a((String)("pedia.activity." + dino.aiActivityType().toString().toLowerCase() + ".desc"), (Object[])new Object[0]), (Object[])new Object[0]));
                GlStateManager.func_179094_E();
                this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
                GlStateManager.func_179121_F();
            }
        }
        if (entity instanceof EntityDinosaurEgg) {
            EntityDinosaurEgg egg = (EntityDinosaurEgg)entity;
            GlStateManager.func_179094_E();
            s = I18n.func_135052_a((String)(egg.selfType.friendlyName + " " + I18n.func_135052_a((String)"pedia.egg", (Object[])new Object[0])), (Object[])new Object[0]);
            GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
            this.printStringXY(s, -this.field_146289_q.func_78256_a(s) / 2 + 65, 60, 66, 48, 36);
            GlStateManager.func_179121_F();
            int time = (int)Math.floor((float)egg.getBirthTick() / (float)egg.totalHatchTime * 100.0f);
            String s15 = I18n.func_135052_a((String)"pedia.egg.time", (Object[])new Object[0]) + " " + Math.max(time, 0) + "%";
            this.printStringXY(s15, wordLength / 2, 120, 157, 126, 103);
            String s16 = egg.func_70090_H() ? I18n.func_135052_a((String)("pedia.egg.status " + ChatFormatting.AQUA + I18n.func_135052_a((String)"pedia.egg.status.wet", (Object[])new Object[0])), (Object[])new Object[0]) : (!egg.isCold() ? I18n.func_135052_a((String)"pedia.egg.status", (Object[])new Object[0]) + " " + ChatFormatting.GOLD + I18n.func_135052_a((String)"pedia.egg.status.warm", (Object[])new Object[0]) : I18n.func_135052_a((String)"pedia.egg.status", (Object[])new Object[0]) + " " + ChatFormatting.BLUE + I18n.func_135052_a((String)"pedia.egg.status.cold", (Object[])new Object[0]));
            this.printStringXY(s16, wordLength / 2, 140, 157, 126, 103);
        }
        if (entity instanceof EntityFishBase) {
            s1 = I18n.func_135052_a((String)entity.func_70005_c_(), (Object[])new Object[0]);
            GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
            this.printStringXY(I18n.func_135052_a((String)entity.func_70005_c_(), (Object[])new Object[0]), -this.field_146289_q.func_78256_a(s1) / 2 + 65, 60, 66, 48, 36);
        }
        if (entity instanceof EntityQuagga) {
            s1 = I18n.func_135052_a((String)entity.func_70005_c_(), (Object[])new Object[0]);
            GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
            this.printStringXY(I18n.func_135052_a((String)entity.func_70005_c_(), (Object[])new Object[0]), -this.field_146289_q.func_78256_a(s1) / 2 + 65, 60, 66, 48, 36);
        }
    }

    private void renderFirstPageRight(EntityLivingBase entity) {
        if (entity instanceof EntityPrehistoric) {
            ItemStack[] keyArray;
            ArrayList<String> text;
            EntityPrehistoric dino = (EntityPrehistoric)entity;
            float scale = 1.75f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(moods);
            this.func_73729_b(160, 7, dino.getMoodFace().uv, 10, 16, 15);
            GlStateManager.func_179121_F();
            scale = 0.75f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(moods);
            this.func_73729_b(290, 60, 0, 0, 206, 9);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(moods);
            this.func_73729_b(293 - dino.getScaledMood(), 43, 0, 26, 4, 10);
            GlStateManager.func_179121_F();
            ScaledResolution scaledResolution = new ScaledResolution(this.field_146297_k);
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int mouseX = Mouse.getX() * width / this.field_146297_k.field_71443_c - this.guiLeft;
            int mouseY = height - Mouse.getY() * height / this.field_146297_k.field_71440_d - 1 - this.guiTop;
            int x = 218;
            int y = 40;
            if (mouseX > x && mouseX < x + 154 && mouseY > y && mouseY < y + 13) {
                text = new ArrayList<String>();
                text.add(I18n.func_135052_a((String)"pedia.moodstatus", (Object[])new Object[0]) + " " + dino.getMoodFace().color + dino.getMood());
                GlStateManager.func_179094_E();
                this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
                GlStateManager.func_179121_F();
            }
            x = 280;
            y = 10;
            if (mouseX > x && mouseX < x + 28 && mouseY > y && mouseY < y + 28) {
                text = new ArrayList();
                text.add(dino.getMoodFace().color + I18n.func_135052_a((String)(I18n.func_135052_a((String)"pedia.", (Object[])new Object[0]) + dino.getMoodFace().toString().toLowerCase()), (Object[])new Object[0]));
                text.add(ChatFormatting.GRAY + I18n.func_135052_a((String)(I18n.func_135052_a((String)"pedia.", (Object[])new Object[0]) + dino.getMoodFace().toString().toLowerCase() + I18n.func_135052_a((String)".desc", (Object[])new Object[0])), (Object[])new Object[0]));
                GlStateManager.func_179094_E();
                this.drawHoveringText(text, mouseX, mouseY, this.field_146289_q);
                GlStateManager.func_179121_F();
            }
            Map<ItemStack, Integer> foodMap = FoodMappings.INSTANCE.getFoodRenderList(dino.type.diet);
            ArrayList<ItemStack> keys = Collections.list(Collections.enumeration(foodMap.keySet()));
            ArrayList<ItemStack> displayedKeys = new ArrayList<ItemStack>();
            keys.sort(this.sorter);
            for (ItemStack item : keyArray = keys.toArray(new ItemStack[0])) {
                if (item.func_190926_b() || !this.shouldShowItem(item, displayedKeys) || this.items >= 64) continue;
                this.addMiniItem(item);
                displayedKeys.add(item);
            }
        }
    }

    private boolean shouldShowItem(ItemStack item, List<ItemStack> keys) {
        for (ItemStack stack : keys) {
            if (stack.func_77973_b() != item.func_77973_b() || stack.func_77960_j() != item.func_77960_j()) continue;
            return false;
        }
        return true;
    }

    public void renderSecondPage(EntityLivingBase entity) {
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background_image);
        int k = (this.field_146294_l - this.xSize) / 2;
        int l = (this.field_146295_m - this.ySize) / 2;
        GuiPedia.func_146110_a((int)k, (int)l, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (float)390.625f, (float)390.625f);
        if (this.bookPages == 0) {
            GlStateManager.func_179094_E();
            if (Revival.PEDIA_OBJECT instanceof EntityDinosaurEgg) {
                GuiPedia.renderEgg(k + 100, l + 80, 150, 0.0f, 0.0f, (Entity)((EntityDinosaurEgg)((Object)Revival.PEDIA_OBJECT)));
            } else if (Revival.PEDIA_OBJECT instanceof EntityLivingBase) {
                if (Revival.PEDIA_OBJECT instanceof EntityPrehistoric) {
                    GuiPedia.renderDinosaur(k + 100, l + 80 - ((EntityPrehistoric)Revival.PEDIA_OBJECT).pediaY, Math.round(2.0f * ((EntityPrehistoric)Revival.PEDIA_OBJECT).pediaScale), 0.0f, (EntityLivingBase)Revival.PEDIA_OBJECT);
                } else if (Revival.PEDIA_OBJECT instanceof AbstractHorse) {
                    GuiPedia.renderDinosaur(k + 100, l + 80, 60, 0.0f, (EntityLivingBase)Revival.PEDIA_OBJECT);
                } else {
                    GuiPedia.renderDinosaur(k + 100, l + 80, 80, 0.0f, (EntityLivingBase)Revival.PEDIA_OBJECT);
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public void addButtonByPage(int page) {
        int centerX = (this.field_146294_l - this.xSize) / 2;
        int centerY = (this.field_146295_m - this.ySize) / 2;
        if (page == 0) {
            this.buttonIcon = new ButtonDinopedia(2, centerX + 35, centerY + 55, 0);
            this.field_146292_n.add(this.buttonIcon);
            this.buttonIcon = new ButtonDinopedia(3, centerX + 75, centerY + 55, 2);
            this.field_146292_n.add(this.buttonIcon);
            this.buttonIcon = new ButtonDinopedia(4, centerX + 115, centerY + 55, 4);
            this.field_146292_n.add(this.buttonIcon);
            this.buttonIcon = new ButtonDinopedia(5, centerX + 55, centerY + 95, 6);
            this.field_146292_n.add(this.buttonIcon);
            this.buttonIcon = new ButtonDinopedia(6, centerX + 95, centerY + 95, 8);
            this.field_146292_n.add(this.buttonIcon);
        }
    }

    public void triggerButtons(GuiButton button) {
        switch (button.field_146127_k) {
            case 2: {
                this.bookPages = 1;
                break;
            }
            case 3: {
                this.bookPages = 2;
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 && this.bookPages < 1) {
            ++this.bookPages;
        } else if (button.field_146127_k == 1 && this.bookPages > 0) {
            --this.bookPages;
        }
        this.triggerButtons(button);
        this.func_73866_w_();
        this.func_73876_c();
    }

    public class FoodSorter
    implements Comparator<ItemStack> {
        @Override
        public int compare(ItemStack stack1, ItemStack stack2) {
            int stackId2;
            int stackId1 = Item.func_150891_b((Item)stack1.func_77973_b());
            if (stackId1 == (stackId2 = Item.func_150891_b((Item)stack2.func_77973_b()))) {
                return Double.compare(stack1.func_77952_i(), stack2.func_77952_i());
            }
            return Integer.compare(stackId1, stackId2);
        }
    }
}

