/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.Revival;
import fossilsarcheology.server.api.DefaultRenderedItem;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.item.FAItemRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FernsBlock
extends BlockBush
implements DefaultRenderedItem {
    public static final PropertyInteger GROWTH = PropertyInteger.func_177719_a((String)"growth", (int)0, (int)7);
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)1);
    protected static final AxisAlignedBB FERN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public FernsBlock() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149649_H();
        this.func_149663_c("fern_block");
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(0)));
    }

    public static boolean checkUnderTree(World var0, BlockPos pos) {
        for (int i = 0; i <= 128; ++i) {
            if (var0.func_180495_p(pos.func_177981_b(i)).func_185904_a() != Material.field_151584_j) continue;
            return true;
        }
        return false;
    }

    public static boolean canGrowOn(IBlockState state) {
        return state.func_185904_a() == Material.field_151577_b || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c().func_149739_a().contains("dirt");
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FERN_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149738_a(World worldIn) {
        return 1;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        IBlockState currentState = world.func_180495_p(pos);
        int var6 = currentState.func_177230_c().func_176201_c(currentState);
        if (FernsBlock.checkUnderTree(world, pos) && this.canGrow(var6) && rand.nextInt(Revival.CONFIG_OPTIONS.fernTickRate) == 0 && (world.func_180495_p(pos.func_177977_b()).func_177230_c() != this || var6 < 2)) {
            if (this.getLv2(++var6)) {
                if (!world.func_175623_d(pos.func_177984_a())) {
                    --var6;
                } else {
                    world.func_175656_a(pos.func_177984_a(), FABlockRegistry.FERNS.func_176203_a(this.checkSubType(var6) == 0 ? var6 + 2 : var6 + 1));
                }
            } else if (this.hasLv2(var6)) {
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == FABlockRegistry.FERNS) {
                    world.func_175656_a(pos.func_177984_a(), FABlockRegistry.FERNS.func_176203_a(this.checkSubType(var6) == 0 ? var6 + 2 : var6 + 1));
                } else {
                    var6 = this.checkSubType(var6) == 0 ? 3 : 10;
                }
            }
            world.func_175656_a(pos, currentState.func_177230_c().func_176203_a(var6));
        }
        if (var6 % 7 >= 3) {
            for (int var8 = -1; var8 <= 1; ++var8) {
                for (int var9 = -1; var9 <= 1; ++var9) {
                    for (int var10 = -1; var10 <= 1; ++var10) {
                        if (var8 == 0 && var10 == 0 && var9 == 0 || !this.canPlaceBlockOn(world.func_180495_p(pos.func_177982_a(var8, var9 - 1, var10)).func_177230_c()) || !world.func_175623_d(pos.func_177982_a(var8, var9, var10)) && world.func_180495_p(pos.func_177982_a(var8, var9, var10)).func_177230_c() != Blocks.field_150329_H || !FernsBlock.checkUnderTree(world, pos.func_177982_a(var8, var9, var10)) || new Random().nextInt(10) > 9) continue;
                        world.func_175656_a(pos.func_177982_a(var8, var9, var10), FABlockRegistry.FERNS.func_176203_a(8 * this.checkSubType(var6)));
                    }
                }
            }
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState currentState = world.func_180495_p(pos);
        int meta = currentState.func_177230_c().func_176201_c(currentState);
        return (FernsBlock.canGrowOn(world.func_180495_p(pos.func_177977_b())) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) && FernsBlock.checkUnderTree(world, pos.func_177984_a());
    }

    public boolean checkLevel(int meta) {
        return meta >= 6 && meta <= 7 || meta == 12;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (rand.nextInt(4) == 0) {
            return FAItemRegistry.FERN_SEED;
        }
        return null;
    }

    public int checkSubType(int meta) {
        return meta > 7 ? 1 : 0;
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block.func_149739_a().contains("dirt");
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canPlaceBlockOn(worldIn.func_180495_p(pos).func_177230_c());
    }

    public boolean canGrow(int meta) {
        return meta >= 0 && meta < 5 || meta >= 8 && meta < 11;
    }

    public boolean hasLv2(int meta) {
        return meta >= 4 && meta <= 5 || meta >= 11 && meta <= 11;
    }

    public boolean getLv2(int meta) {
        return meta == 4 || meta == 11;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta / 8)).func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(meta < 8 ? meta : meta - 8));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPE) == 0 ? (Integer)state.func_177229_b((IProperty)GROWTH) : (Integer)state.func_177229_b((IProperty)GROWTH) + 7;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, GROWTH});
    }
}

