/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.server.api.DefaultRenderedItem;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.item.DinosaurBoneItem;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.item.variant.DinosaurBoneType;
import fossilsarcheology.server.tab.FATabRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class FossilBlock
extends Block
implements DefaultRenderedItem {
    private int randomMeta;

    public FossilBlock() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("fossil");
        this.func_149647_a(FATabRegistry.BLOCKS);
        this.setHarvestLevel("pickaxe", 2);
        this.randomMeta = 0;
    }

    public static ItemStack getItemDroppedWithEnchants(IBlockState state, Random rand, int paleo_level, int archeo_level) {
        int i = rand.nextInt(1100);
        if (i < 1 + (archeo_level - 1) * 5) {
            return new ItemStack((Item)FAItemRegistry.SCARAB_GEM);
        }
        if (i < 3 + 3 * archeo_level) {
            return new ItemStack((Item)FAItemRegistry.BROKEN_SWORD);
        }
        if (i < 6 + 5 * archeo_level) {
            return new ItemStack((Item)FAItemRegistry.BROKEN_HELMET);
        }
        if ((float)i < 13.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.LEG_BONE, 1, dropRandom);
        }
        if ((float)i < 15.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.SKULL, 1, dropRandom);
        }
        if ((float)i < 17.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.UNIQUE_ITEM, 1, dropRandom);
        }
        if ((float)i < 19.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.FOOT, 1, dropRandom);
        }
        if ((float)i < 21.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.VERTEBRAE, 1, dropRandom);
        }
        if ((float)i < 23.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.ARM_BONE, 1, dropRandom);
        }
        if ((float)i < 25.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return new ItemStack((Item)FAItemRegistry.RIBCAGE, 1, dropRandom);
        }
        if ((float)i < 50.0f * ((float)Math.max(paleo_level, archeo_level) * 1.5f)) {
            return new ItemStack((Block)FABlockRegistry.SKULL_BLOCK);
        }
        if ((float)i < 350.0f * (0.5f + (float)paleo_level * 0.5f)) {
            return new ItemStack((Item)FAItemRegistry.BIOFOSSIL);
        }
        if ((float)i < 550.0f * (0.5f + (float)archeo_level * 0.5f)) {
            return new ItemStack((Item)FAItemRegistry.RELIC_SCRAP);
        }
        if ((float)i < 900.0f * (0.5f + (float)paleo_level * 0.5f)) {
            return new ItemStack(Items.field_151103_aS);
        }
        if ((float)i < 1200.0f * (0.5f + (float)paleo_level * 0.5f)) {
            return new ItemStack((Item)FAItemRegistry.PLANT_FOSSIL);
        }
        return new ItemStack(Blocks.field_150347_e);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int i = rand.nextInt(1100);
        int paleo_level = 1;
        int archeo_level = 1;
        if (i < archeo_level) {
            this.randomMeta = 0;
            return FAItemRegistry.SCARAB_GEM;
        }
        if (i < 3 + 3 * archeo_level) {
            this.randomMeta = 0;
            return FAItemRegistry.BROKEN_SWORD;
        }
        if (i < 6 + 5 * archeo_level) {
            this.randomMeta = 0;
            return FAItemRegistry.BROKEN_HELMET;
        }
        if ((float)i < 13.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom;
            this.randomMeta = dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return FAItemRegistry.LEG_BONE;
        }
        if ((float)i < 15.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom;
            this.randomMeta = dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return FAItemRegistry.SKULL;
        }
        if ((float)i < 17.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom;
            this.randomMeta = dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return FAItemRegistry.UNIQUE_ITEM;
        }
        if ((float)i < 19.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom;
            this.randomMeta = dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return FAItemRegistry.FOOT;
        }
        if ((float)i < 21.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom;
            this.randomMeta = dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return FAItemRegistry.VERTEBRAE;
        }
        if ((float)i < 23.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom;
            this.randomMeta = dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return FAItemRegistry.ARM_BONE;
        }
        if ((float)i < 25.0f * ((float)paleo_level * 1.5f)) {
            int dropRandom;
            this.randomMeta = dropRandom = rand.nextInt(DinosaurBoneType.values().length);
            return FAItemRegistry.RIBCAGE;
        }
        if ((float)i < 50.0f * ((float)Math.max(paleo_level, archeo_level) * 1.5f)) {
            this.randomMeta = 0;
            return Item.func_150898_a((Block)FABlockRegistry.SKULL_BLOCK);
        }
        if ((float)i < 350.0f * (0.5f + (float)paleo_level * 0.5f)) {
            this.randomMeta = 0;
            return FAItemRegistry.BIOFOSSIL;
        }
        if ((float)i < 550.0f * (0.5f + (float)archeo_level * 0.5f)) {
            this.randomMeta = 0;
            return FAItemRegistry.RELIC_SCRAP;
        }
        if ((float)i < 900.0f * (0.5f + (float)paleo_level * 0.5f)) {
            this.randomMeta = 0;
            return Items.field_151103_aS;
        }
        if ((float)i < 1200.0f * (0.5f + (float)paleo_level * 0.5f)) {
            this.randomMeta = 0;
            return FAItemRegistry.PLANT_FOSSIL;
        }
        this.randomMeta = 0;
        return Item.func_150898_a((Block)Blocks.field_150347_e);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Random random = new Random();
        int count = this.quantityDropped(state, fortune, random);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, random, fortune);
            if (item == null) continue;
            int meta = this.randomMeta;
            if (item instanceof DinosaurBoneItem) {
                meta = random.nextInt(DinosaurBoneType.values().length);
            }
            drops.add(new ItemStack(item, 1, meta));
        }
        return drops;
    }
}

