/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.server.api.DefaultRenderedItem;
import fossilsarcheology.server.tab.FATabRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FossilLeavesBlock
extends BlockLeaves
implements DefaultRenderedItem {
    private byte[] adjacentTreeBlocks;
    private Block sapling;

    public FossilLeavesBlock(String name, Block sapling) {
        this.func_149647_a(FATabRegistry.BLOCKS);
        this.func_149752_b(1.0f);
        this.func_149663_c(name);
        this.sapling = sapling;
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Collections.singletonList(new ItemStack((Block)this));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176237_a, field_176236_b});
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            int scanArea = 6;
            int i = scanArea + 2;
            int size = 32;
            int sizeSquared = size * size;
            int center = size / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new byte[size * size * size];
            }
            if (world.func_175707_a(pos.func_177982_a(-i, -i, -i), pos.func_177982_a(i, i, i))) {
                for (int offsetX = -scanArea; offsetX <= scanArea; ++offsetX) {
                    for (int offsetY = -scanArea; offsetY <= scanArea; ++offsetY) {
                        for (int offsetZ = -scanArea; offsetZ <= scanArea; ++offsetZ) {
                            Block block = world.func_180495_p(pos.func_177982_a(offsetX, offsetY, offsetZ)).func_177230_c();
                            if (!block.canSustainLeaves(world.func_180495_p(pos.func_177982_a(offsetX, offsetY, offsetZ)), (IBlockAccess)world, pos.func_177982_a(offsetX, offsetY, offsetZ))) {
                                if (block.isLeaves(world.func_180495_p(pos.func_177982_a(offsetX, offsetY, offsetZ)), (IBlockAccess)world, pos.func_177982_a(offsetX, offsetY, offsetZ))) {
                                    this.adjacentTreeBlocks[(offsetX + center) * sizeSquared + (offsetY + center) * size + offsetZ + center] = -2;
                                    continue;
                                }
                                this.adjacentTreeBlocks[(offsetX + center) * sizeSquared + (offsetY + center) * size + offsetZ + center] = -1;
                                continue;
                            }
                            this.adjacentTreeBlocks[(offsetX + center) * sizeSquared + (offsetY + center) * size + offsetZ + center] = 0;
                        }
                    }
                }
                for (int blockType = 1; blockType <= 4; ++blockType) {
                    for (int offsetX = -scanArea; offsetX <= scanArea; ++offsetX) {
                        for (int offsetY = -scanArea; offsetY <= scanArea; ++offsetY) {
                            for (int offsetZ = -scanArea; offsetZ <= scanArea; ++offsetZ) {
                                if (this.adjacentTreeBlocks[(offsetX + center) * sizeSquared + (offsetY + center) * size + offsetZ + center] != blockType - 1) continue;
                                for (int adjacentX = -1; adjacentX <= 1; ++adjacentX) {
                                    for (int adjacentY = -1; adjacentY <= 1; ++adjacentY) {
                                        for (int adjacentZ = -1; adjacentZ <= 1; ++adjacentZ) {
                                            int index = (offsetX + center + adjacentX) * sizeSquared + (offsetY + center + adjacentY) * size + offsetZ + center + adjacentZ;
                                            if (this.adjacentTreeBlocks[index] != -2) continue;
                                            this.adjacentTreeBlocks[index] = (byte)blockType;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (this.adjacentTreeBlocks[center * sizeSquared + center * size + center] >= 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.FALSE), 4);
            } else {
                this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
                world.func_175698_g(pos);
                if (new Random().nextInt(5) == 0) {
                    FossilLeavesBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(this.sapling));
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.sapling);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }
}

