/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.FossilSlabBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class FossilPlanksSlabBlock
extends FossilSlabBlock {
    private String name;

    public FossilPlanksSlabBlock(Block parent, String name, float hardness, float resistance, SoundType soundType) {
        super(name, hardness, resistance, soundType, Material.field_151575_d, parent);
        this.name = name;
    }

    protected BlockSlab singleSlab() {
        if (this.name.contains("palm")) {
            return FABlockRegistry.PALM_PLANKS_SINGLESLAB;
        }
        if (this.name.contains("calamites")) {
            return FABlockRegistry.CALAMITES_PLANKS_SINGLESLAB;
        }
        if (this.name.contains("sigillaria")) {
            return FABlockRegistry.SIGILLARIA_PLANKS_SINGLESLAB;
        }
        if (this.name.contains("cordaites")) {
            return FABlockRegistry.CORDAITES_PLANKS_SINGLESLAB;
        }
        return FABlockRegistry.CALAMITES_PLANKS_SINGLESLAB;
    }

    protected BlockSlab doubleSlab() {
        if (this.name.contains("palm")) {
            return FABlockRegistry.PALM_PLANKS_DOUBLESLAB;
        }
        if (this.name.contains("calamites")) {
            return FABlockRegistry.CALAMITES_PLANKS_DOUBLESLAB;
        }
        if (this.name.contains("sigillaria")) {
            return FABlockRegistry.SIGILLARIA_PLANKS_DOUBLESLAB;
        }
        if (this.name.contains("cordaites")) {
            return FABlockRegistry.CORDAITES_PLANKS_DOUBLESLAB;
        }
        return FABlockRegistry.CALAMITES_PLANKS_SINGLESLAB;
    }

    @Override
    public ItemBlock getItemBlock() {
        return new FossilSlabBlock.FossilSlabBlockItem(this, (Block)this, this.singleSlab(), this.doubleSlab());
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public static class Half
    extends FossilPlanksSlabBlock {
        public Half(Block parent, String name, float hardness, float resistance, SoundType soundType) {
            super(parent, name, hardness, resistance, soundType);
        }

        public boolean func_176552_j() {
            return false;
        }

        @Override
        public ItemBlock getItemBlock() {
            return new FossilSlabBlock.FossilSlabBlockItem(this, (Block)this, this.singleSlab(), this.doubleSlab());
        }

        @Override
        public Item getSlabItem() {
            return Item.func_150898_a((Block)this.singleSlab());
        }
    }

    public static class Double
    extends FossilPlanksSlabBlock {
        public Double(Block parent, String name, float hardness, float resistance, SoundType soundType) {
            super(parent, name, hardness, resistance, soundType);
        }

        public boolean func_176552_j() {
            return true;
        }

        @Override
        public ItemBlock getItemBlock() {
            return new FossilSlabBlock.FossilSlabBlockItem(this, (Block)this, this.singleSlab(), this.doubleSlab());
        }

        @Override
        public Item getSlabItem() {
            return Item.func_150898_a((Block)this.singleSlab());
        }
    }
}

