/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.Revival;
import fossilsarcheology.server.api.BlockEntity;
import fossilsarcheology.server.api.DefaultRenderedItem;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.entity.TileEntitySifter;
import fossilsarcheology.server.tab.FATabRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SifterBlock
extends BlockContainer
implements DefaultRenderedItem,
BlockEntity {
    private static boolean keepInventory = false;

    public SifterBlock(boolean isActive) {
        super(Material.field_151575_d);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185852_e);
        if (isActive) {
            this.func_149663_c("sifter_active");
        } else {
            this.func_149663_c("sifter");
            this.func_149647_a(FATabRegistry.BLOCKS);
        }
    }

    public static void setState(boolean isActive, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        keepInventory = true;
        if (isActive) {
            world.func_175656_a(pos, FABlockRegistry.SIFTER_ACTIVE.func_176223_P());
        } else {
            world.func_175656_a(pos, FABlockRegistry.SIFTER_IDLE.func_176223_P());
        }
        keepInventory = false;
        if (tile != null) {
            tile.func_145829_t();
            world.func_175690_a(pos, tile);
        }
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Item.func_150898_a((Block)FABlockRegistry.SIFTER_IDLE);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)Revival.INSTANCE, 4, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!keepInventory || !(world.func_180495_p(pos).func_177230_c() instanceof SifterBlock)) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity == null) {
                return;
            }
            if (entity instanceof TileEntitySifter) {
                TileEntitySifter analyzer = (TileEntitySifter)entity;
                for (int i = 0; i < analyzer.func_70302_i_(); ++i) {
                    ItemStack stack = analyzer.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
                }
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntitySifter();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_175625_s(pos)));
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)FABlockRegistry.SIFTER_IDLE);
    }

    @Override
    public Class<? extends TileEntity> getEntity() {
        return TileEntitySifter.class;
    }
}

