/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.client.render.ArthropleuraBuffer;
import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.entity.ai.DinoAIEatFeedersAndBlocks;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFleeBattle;
import fossilsarcheology.server.entity.ai.DinoAIFollowOwner;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIPanic;
import fossilsarcheology.server.entity.ai.DinoAIWander;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.entity.ai.DinoMeleeAttackAI;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityArthropleura
extends EntityPrehistoric {
    @SideOnly(value=Side.CLIENT)
    public ArthropleuraBuffer bodyBuffer;

    public EntityArthropleura(World world) {
        super(world, PrehistoricEntityType.ARTHROPLEURA, 1.0, 4.0, 10.0, 34.0, 0.15, 0.2, 5.0, 15.0);
        this.teenAge = 4;
        this.setActualSize(3.0f, 1.0f);
        this.minSize = 0.1f;
        this.maxSize = 0.4f;
        this.developsResistance = true;
        this.hasTeenTexture = true;
        this.pediaScale = 40.0f;
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.bodyBuffer = new ArthropleuraBuffer();
        }
    }

    protected EntityBodyHelper func_184650_s() {
        return new BodyHelper(this);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrehistoricEntityType.BONELESS_LOOT;
    }

    @Override
    public String getTexture() {
        String gender;
        String string = this.func_70631_g_() ? "_baby" : (gender = this.getGender() == 0 ? "_female" : "_male");
        if (this.isTeen()) {
            gender = "_teen";
        }
        if (this.isSkeleton()) {
            return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + this.type.toString().toLowerCase() + "_skeleton.png";
        }
        return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + this.type.toString().toLowerCase() + gender + ".png";
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIFleeBattle(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoMeleeAttackAI(this, 1.0, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIWander(this, 1.0, 5));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIEatFeedersAndBlocks(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new DinoAIEatItems(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIPanic(this, 1.5));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(4, new DinoAIHunt<EntityLivingBase>(this, EntityLivingBase.class, true, (Predicate<EntityLivingBase>)((com.google.common.base.Predicate)entity -> entity instanceof EntityLivingBase)));
    }

    @Override
    public int getAttackLength() {
        return 25;
    }

    @Override
    public void setSpawnValues() {
    }

    @Override
    public PrehistoricEntityTypeAI.Activity aiActivityType() {
        return PrehistoricEntityTypeAI.Activity.DIURINAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Attacking aiAttackType() {
        return PrehistoricEntityTypeAI.Attacking.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Climbing aiClimbType() {
        return PrehistoricEntityTypeAI.Climbing.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Following aiFollowType() {
        return PrehistoricEntityTypeAI.Following.NORMAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Jumping aiJumpType() {
        return PrehistoricEntityTypeAI.Jumping.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Response aiResponseType() {
        return PrehistoricEntityTypeAI.Response.SCARED;
    }

    @Override
    public PrehistoricEntityTypeAI.Stalking aiStalkType() {
        return PrehistoricEntityTypeAI.Stalking.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Taming aiTameType() {
        return PrehistoricEntityTypeAI.Taming.FEEDING;
    }

    @Override
    public PrehistoricEntityTypeAI.Untaming aiUntameType() {
        return PrehistoricEntityTypeAI.Untaming.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Moving aiMovingType() {
        return PrehistoricEntityTypeAI.Moving.WALK;
    }

    @Override
    public PrehistoricEntityTypeAI.WaterAbility aiWaterAbilityType() {
        return PrehistoricEntityTypeAI.WaterAbility.NONE;
    }

    @Override
    public boolean doesFlock() {
        return false;
    }

    @Override
    public Item getOrderItem() {
        return Items.field_151055_y;
    }

    @Override
    public int getAdultAge() {
        return 7;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && !this.func_175446_cd()) {
            this.bodyBuffer.calculateChainSwingBuffer(120.0f, 10, 2.5f, this);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() == 12 && this.func_70638_az() != null) {
            this.doAttack();
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.getAnimation() != this.ATTACK_ANIMATION) {
            this.setAnimation(this.ATTACK_ANIMATION);
        }
        return false;
    }

    @Override
    public int getMaxHunger() {
        return 125;
    }

    @Override
    public boolean canBeRidden() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return FASoundRegistry.ARTHROPLEURA_LIVING;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FASoundRegistry.ARTHROPLEURA_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return FASoundRegistry.ARTHROPLEURA_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(FASoundRegistry.ARTHROPLEURA_WALK, 0.15f, 1.0f);
    }

    public boolean isMoving() {
        double d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        return d0 * d0 + d1 * d1 > 5.00000277905201E-8;
    }

    public class BodyHelper
    extends EntityBodyHelper {
        private EntityArthropleura living;
        private int rotationTickCounter;
        private float prevRenderYawHead;

        public BodyHelper(EntityArthropleura arthropleura) {
            super((EntityLivingBase)arthropleura);
            this.living = arthropleura;
        }

        public void func_75664_a() {
            double d0 = this.living.field_70165_t - this.living.field_70169_q;
            double d1 = this.living.field_70161_v - this.living.field_70166_s;
            if (d0 * d0 + d1 * d1 > 1.500000277905201E-7) {
                this.living.field_70761_aq = this.living.field_70177_z;
                this.prevRenderYawHead = this.living.field_70759_as = this.computeAngleWithBound(this.living.field_70761_aq, this.living.field_70759_as, 100.0f);
                this.rotationTickCounter = 0;
            } else if (this.living.func_184188_bt().isEmpty() || !(this.living.func_184188_bt().get(0) instanceof EntityLiving)) {
                float f = 75.0f;
                if (Math.abs(this.living.field_70759_as - this.prevRenderYawHead) > 15.0f) {
                    this.rotationTickCounter = 0;
                    this.prevRenderYawHead = this.living.field_70759_as;
                } else {
                    ++this.rotationTickCounter;
                    int i = 10;
                    if (this.rotationTickCounter > 10) {
                        f = Math.max(1.0f - (float)(this.rotationTickCounter - 10) / 10.0f, 0.0f) * 75.0f;
                    }
                }
                this.living.field_70761_aq = this.computeAngleWithBound(this.living.field_70759_as, this.living.field_70761_aq, f);
            }
        }

        private float computeAngleWithBound(float p_75665_1_, float p_75665_2_, float p_75665_3_) {
            float f = MathHelper.func_76142_g((float)(p_75665_1_ - p_75665_2_));
            if (f < -p_75665_3_) {
                f = -p_75665_3_;
            }
            if (f >= p_75665_3_) {
                f = p_75665_3_;
            }
            return p_75665_1_ - f;
        }
    }

    class MoveHelper
    extends EntityMoveHelper {
        public MoveHelper(EntityLiving entitylivingIn) {
            super(entitylivingIn);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.STRAFE) {
                NodeProcessor nodeprocessor;
                float f = (float)this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                float f1 = (float)this.field_75645_e * f;
                float f2 = this.field_188489_f;
                float f3 = this.field_188490_g;
                float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = f1 / f4;
                float f5 = MathHelper.func_76126_a((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f6 = MathHelper.func_76134_b((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                float f8 = f3 * f6 + f2 * f5;
                PathNavigate pathnavigate = this.field_75648_a.func_70661_as();
                if (pathnavigate != null && (nodeprocessor = pathnavigate.func_189566_q()) != null && nodeprocessor.func_186330_a((IBlockAccess)this.field_75648_a.field_70170_p, MathHelper.func_76128_c((double)(this.field_75648_a.field_70165_t + (double)f7)), MathHelper.func_76128_c((double)this.field_75648_a.field_70163_u), MathHelper.func_76128_c((double)(this.field_75648_a.field_70161_v + (double)f8))) != PathNodeType.WALKABLE) {
                    this.field_188489_f = 1.0f;
                    this.field_188490_g = 0.0f;
                    f1 = f;
                }
                this.field_75648_a.func_70659_e(f1);
                this.field_75648_a.func_191989_p(this.field_188489_f);
                this.field_75648_a.func_184646_p(this.field_188490_g);
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            } else if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d2 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d1 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float f9 = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f9, 90.0f);
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (d2 > (double)this.field_75648_a.field_70138_W && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.field_75648_a.field_70130_N)) {
                    this.field_75648_a.func_70683_ar().func_75660_a();
                    this.field_188491_h = EntityMoveHelper.Action.JUMPING;
                }
            } else if (this.field_188491_h == EntityMoveHelper.Action.JUMPING) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (this.field_75648_a.field_70122_E) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                }
            } else {
                this.field_75648_a.func_191989_p(0.0f);
            }
        }
    }
}

