/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.entity.ai.DinoAIEatFeedersAndBlocks;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFollowOwner;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAIHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtTarget;
import fossilsarcheology.server.entity.ai.DinoAIRiding;
import fossilsarcheology.server.entity.ai.DinoAIWander;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.entity.ai.DinoMeleeAttackAI;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.IScaryDinosaur;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import fossilsarcheology.server.item.FAItemRegistry;
import java.util.function.Predicate;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityMegalania
extends EntityPrehistoric
implements IScaryDinosaur {
    public static final Animation ANIMATION_FIGHT = Animation.create((int)40);
    private int ticksSinceLastFight;

    public EntityMegalania(World world) {
        super(world, PrehistoricEntityType.MEGALANIA, 2.0, 10.0, 10.0, 50.0, 0.25, 0.5, 4.0, 8.0);
        this.setActualSize(2.1f, 1.2f);
        this.pediaScale = 35.0f;
        this.nearByMobsAllowed = 5;
        this.minSize = 0.2f;
        this.maxSize = 0.95f;
        this.developsResistance = true;
        this.teenAge = 5;
        this.ridingY = 1.7f;
    }

    @Override
    public float getTargetScale() {
        return 1.5f;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoMeleeAttackAI(this, 1.0, false));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIEatFeedersAndBlocks(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new DinoAIEatItems(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIRiding(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new DinoAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new DinoAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new DinoAIHurtByTarget(this));
        this.field_70715_bh.func_75776_a(4, new DinoAIHunt<EntityLivingBase>(this, EntityLivingBase.class, true, (Predicate<EntityLivingBase>)((com.google.common.base.Predicate)entity -> entity instanceof EntityLivingBase)));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("FightTicks", this.ticksSinceLastFight);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.ticksSinceLastFight = compound.func_74762_e("FightTicks");
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.canFight() && entityIn instanceof EntityMegalania && ((EntityMegalania)entityIn).canFight()) {
            this.setAnimation(ANIMATION_FIGHT);
            EntityMegalania megalania = (EntityMegalania)entityIn;
            this.ticksSinceLastFight = 0;
            megalania.ticksSinceLastFight = 0;
            megalania.setAnimation(ANIMATION_FIGHT);
            this.func_70625_a(entityIn, 180.0f, 180.0f);
            megalania.func_70625_a((Entity)this, 180.0f, 180.0f);
            this.field_70759_as = this.field_70177_z;
        }
        super.func_82167_n(entityIn);
    }

    public boolean canFight() {
        return !this.func_70631_g_() && this.ticksSinceLastFight > 600 && !this.isMovementBlockedSoft();
    }

    @Override
    public int getAttackLength() {
        return 30;
    }

    @Override
    public int getAdultAge() {
        return 10;
    }

    @Override
    public void setSpawnValues() {
    }

    @Override
    public PrehistoricEntityTypeAI.Activity aiActivityType() {
        return PrehistoricEntityTypeAI.Activity.DIURINAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Attacking aiAttackType() {
        return PrehistoricEntityTypeAI.Attacking.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Climbing aiClimbType() {
        return PrehistoricEntityTypeAI.Climbing.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Following aiFollowType() {
        return PrehistoricEntityTypeAI.Following.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Jumping aiJumpType() {
        return PrehistoricEntityTypeAI.Jumping.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Response aiResponseType() {
        return PrehistoricEntityTypeAI.Response.TERITORIAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Stalking aiStalkType() {
        return PrehistoricEntityTypeAI.Stalking.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Taming aiTameType() {
        return PrehistoricEntityTypeAI.Taming.GEM;
    }

    @Override
    public PrehistoricEntityTypeAI.Untaming aiUntameType() {
        return PrehistoricEntityTypeAI.Untaming.ATTACK;
    }

    @Override
    public PrehistoricEntityTypeAI.Moving aiMovingType() {
        return PrehistoricEntityTypeAI.Moving.WALK;
    }

    @Override
    public PrehistoricEntityTypeAI.WaterAbility aiWaterAbilityType() {
        return PrehistoricEntityTypeAI.WaterAbility.NONE;
    }

    @Override
    public boolean doesFlock() {
        return false;
    }

    @Override
    public Item getOrderItem() {
        return FAItemRegistry.SKULL_STICK;
    }

    @Override
    public int getTailSegments() {
        return 3;
    }

    @Override
    public float getMaleSize() {
        return 1.15f;
    }

    @Override
    public boolean func_70610_aX() {
        return this.getAnimation() == ANIMATION_FIGHT || super.func_70610_aX();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAnimation() == ANIMATION_FIGHT) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70761_aq = this.field_70177_z;
        }
        ++this.ticksSinceLastFight;
        if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() == 12 && this.func_70638_az() != null) {
            this.doAttack();
            this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200));
            this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 600));
        }
    }

    @Override
    public AxisAlignedBB getAttackBounds() {
        return this.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0);
    }

    public boolean func_70652_k(Entity entity) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.ATTACK_ANIMATION);
            return false;
        }
        if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() > 10 && this.getAnimationTick() < 13) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
            boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)iattributeinstance.func_111126_e());
            if (entity.func_184187_bx() != null && entity.func_184187_bx() == this) {
                entity.func_184210_p();
            }
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200));
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 600));
            }
            entity.field_70181_x += 0.1000000059604645;
            entity.field_70160_al = false;
            return flag;
        }
        return false;
    }

    @Override
    public int getMaxHunger() {
        return 125;
    }

    @Override
    public boolean canBeRidden() {
        return true;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return FASoundRegistry.MEGALANIA_LIVING;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FASoundRegistry.MEGALANIA_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return FASoundRegistry.MEGALANIA_DEATH;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{this.SPEAK_ANIMATION, this.ATTACK_ANIMATION, ANIMATION_FIGHT};
    }
}

