/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.entity.ai.DinoAIEatFeedersAndBlocks;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFindWaterTarget;
import fossilsarcheology.server.entity.ai.DinoAIFollowOwner;
import fossilsarcheology.server.entity.ai.DinoAIGetInWater;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAIHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIRiding;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.entity.ai.DinoMeleeAttackAI;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoricSwimming;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import fossilsarcheology.server.entity.utility.EntityToyBase;
import fossilsarcheology.server.item.FAItemRegistry;
import java.util.function.Predicate;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityMosasaurus
extends EntityPrehistoricSwimming {
    public static final Animation SHAKE_ANIMATION = Animation.create((int)50);

    public EntityMosasaurus(World world) {
        super(world, PrehistoricEntityType.MOSASAURUS, 2.0, 9.0, 12.0, 70.0, 0.3, 0.35, 4.0, 10.0);
        this.hasBabyTexture = false;
        this.setActualSize(1.5f, 0.6f);
        this.minSize = 0.6f;
        this.maxSize = 3.4f;
        this.teenAge = 5;
        this.developsResistance = true;
        this.breaksBlocks = true;
        this.hasBabyTexture = false;
        this.pediaScale = 30.0f;
        this.ridingY = 0.8f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    @Override
    public boolean canHuntMobsOnLand() {
        return false;
    }

    @Override
    public boolean canDinoHunt(Entity target, boolean hunger) {
        return super.canDinoHunt(target, hunger);
    }

    @Override
    public float getTargetScale() {
        return 2.0f;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoMeleeAttackAI(this, 1.0, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoAIGetInWater(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIFindWaterTarget((EntityCreature)this, 10, true));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIEatFeedersAndBlocks(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new DinoAIEatItems(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIRiding(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new DinoAIHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, new DinoAIHunt<EntityLivingBase>(this, EntityLivingBase.class, true, (Predicate<EntityLivingBase>)((com.google.common.base.Predicate)entity -> entity instanceof EntityLivingBase)));
    }

    @Override
    public boolean doesBreachAttack() {
        return true;
    }

    @Override
    public void setSpawnValues() {
    }

    @Override
    public PrehistoricEntityTypeAI.Activity aiActivityType() {
        return PrehistoricEntityTypeAI.Activity.DIURINAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Attacking aiAttackType() {
        return PrehistoricEntityTypeAI.Attacking.DROWN;
    }

    @Override
    public PrehistoricEntityTypeAI.Climbing aiClimbType() {
        return PrehistoricEntityTypeAI.Climbing.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Following aiFollowType() {
        return PrehistoricEntityTypeAI.Following.AGRESSIVE;
    }

    @Override
    public PrehistoricEntityTypeAI.Jumping aiJumpType() {
        return PrehistoricEntityTypeAI.Jumping.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Response aiResponseType() {
        return PrehistoricEntityTypeAI.Response.AGRESSIVE;
    }

    @Override
    public PrehistoricEntityTypeAI.Stalking aiStalkType() {
        return PrehistoricEntityTypeAI.Stalking.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Taming aiTameType() {
        return PrehistoricEntityTypeAI.Taming.BLUEGEM;
    }

    @Override
    public PrehistoricEntityTypeAI.Untaming aiUntameType() {
        return PrehistoricEntityTypeAI.Untaming.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Moving aiMovingType() {
        return PrehistoricEntityTypeAI.Moving.AQUATIC;
    }

    @Override
    public PrehistoricEntityTypeAI.WaterAbility aiWaterAbilityType() {
        return PrehistoricEntityTypeAI.WaterAbility.ATTACK;
    }

    @Override
    public boolean doesFlock() {
        return false;
    }

    @Override
    public Item getOrderItem() {
        return FAItemRegistry.SKULL_STICK;
    }

    @Override
    public int getAdultAge() {
        return 11;
    }

    @Override
    public double swimSpeed() {
        return 1.2;
    }

    public boolean breaksBoats() {
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && this.canReachPrey()) {
            this.func_70652_k((Entity)this.func_70638_az());
            if (!EntityMosasaurus.isEntitySmallerThan((Entity)this.func_70638_az(), 2.0f * (this.getAgeScale() / this.maxSize)) || this.func_70681_au().nextInt(5) != 0) {
                if (this.getAnimation() != this.ATTACK_ANIMATION && this.getAnimation() != SHAKE_ANIMATION) {
                    this.setAnimation(this.ATTACK_ANIMATION);
                }
                this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                if (this.getAnimation() == this.ATTACK_ANIMATION && (this.getAnimationTick() == 5 || this.getAnimationTick() == 6)) {
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    this.destroyBoat((Entity)this.func_70638_az());
                }
            } else if (this.getAnimation() != this.ATTACK_ANIMATION) {
                this.destroyBoat((Entity)this.func_70638_az());
                this.func_70638_az().func_184220_m((Entity)this);
                if (this.getAnimation() != SHAKE_ANIMATION) {
                    this.setAnimation(SHAKE_ANIMATION);
                }
            }
        }
    }

    @Override
    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLivingBase && this.getRidingPlayer() == null || this.getRidingPlayer() != null && passenger != this.getRidingPlayer()) {
            Entity riddenByEntity = passenger;
            if (this.getAnimationTick() > 55 || this.getAnimation() == NO_ANIMATION) {
                if (riddenByEntity instanceof EntityToyBase) {
                    riddenByEntity.func_184210_p();
                    this.func_70624_b(null);
                    this.doPlayBonus(((EntityToyBase)riddenByEntity).toyBonus);
                    return;
                }
                if (passenger instanceof EntityLivingBase) {
                    riddenByEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getStrongAttackPower());
                }
                this.func_70074_a((EntityLivingBase)riddenByEntity);
            }
            float modTick_1 = 5.0f * MathHelper.func_76126_a((float)((float)(Math.PI + (double)((float)this.getAnimationTick() * 0.275f))));
            this.field_70177_z = this.field_70761_aq;
            float radius = 0.5f * (0.7f * this.getAgeScale()) * -3.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq + 3.15f + modTick_1 * 1.75f * 0.05f;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = 0.05f * this.getAgeScale();
            riddenByEntity.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ);
        }
    }

    public void func_70098_U() {
        if (this.getRidingPlayer() != null && this.func_152114_e((EntityLivingBase)this.getRidingPlayer())) {
            super.func_70098_U();
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    @Override
    public int getMaxHunger() {
        return 125;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{this.SPEAK_ANIMATION, this.ATTACK_ANIMATION, SHAKE_ANIMATION};
    }

    @Override
    public boolean canBeRidden() {
        return true;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.func_70090_H() ? FASoundRegistry.MOSASAURUS_LIVING_INSIDE : FASoundRegistry.MOSASAURUS_LIVING_OUTSIDE;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FASoundRegistry.MOSASAURUS_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return FASoundRegistry.MOSASAURUS_DEATH;
    }
}

