/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import com.google.common.base.Predicate;
import fossilsarcheology.Revival;
import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.IDinoUnbreakable;
import fossilsarcheology.server.block.entity.TileEntityFeeder;
import fossilsarcheology.server.entity.EntityDinosaurEgg;
import fossilsarcheology.server.entity.FoodHelper;
import fossilsarcheology.server.entity.ai.DinoMoveHelper;
import fossilsarcheology.server.entity.ai.PathNavigateDinosaur;
import fossilsarcheology.server.entity.prehistoric.Diet;
import fossilsarcheology.server.entity.prehistoric.EntityDeinonychus;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoricSwimming;
import fossilsarcheology.server.entity.prehistoric.EntitySpinosaurus;
import fossilsarcheology.server.entity.prehistoric.EntityVelociraptor;
import fossilsarcheology.server.entity.prehistoric.IPrehistoricAI;
import fossilsarcheology.server.entity.prehistoric.MobType;
import fossilsarcheology.server.entity.prehistoric.OrderType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import fossilsarcheology.server.entity.prehistoric.PrehistoricMoodType;
import fossilsarcheology.server.entity.prehistoric.SituationType;
import fossilsarcheology.server.entity.prehistoric.TimePeriod;
import fossilsarcheology.server.entity.utility.EntityToyBase;
import fossilsarcheology.server.entity.utility.FossilsPlayerProperties;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.message.MessageFoodParticles;
import fossilsarcheology.server.message.MessageHappyParticles;
import fossilsarcheology.server.message.MessageUpdateEgg;
import fossilsarcheology.server.util.FoodMappings;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.client.model.tools.ChainBuffer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityPrehistoric
extends EntityTameable
implements IPrehistoricAI,
IAnimatedEntity,
IJumpingMount {
    private static final DataParameter<Integer> AGETICK = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HUNGER = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> MODELIZED = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLEEING = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SUBSPECIES = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GENDER = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MOOD = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> OWNERDISPLAYNAME = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> AGINGDISABLED = EntityDataManager.func_187226_a(EntityPrehistoric.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final Predicate PREHISTORIC_PREDICATE = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity != null && entity instanceof EntityPrehistoric;
        }
    };
    public final Animation SPEAK_ANIMATION;
    public final PrehistoricEntityType type;
    public final double baseDamage;
    public final double maxDamage;
    public final double baseHealth;
    public final double maxHealth;
    public final double baseSpeed;
    public final double maxSpeed;
    public final double baseArmor;
    public final double maxArmor;
    public Animation ATTACK_ANIMATION;
    public float minSize;
    public float maxSize;
    public int teenAge;
    public ItemStack ItemInMouth = ItemStack.field_190927_a;
    public OrderType currentOrder;
    public boolean hasFeatherToggle = false;
    public boolean featherToggle;
    public boolean hasTeenTexture = false;
    public boolean hasBabyTexture;
    public float weakProgress;
    public float sitProgress;
    public int ticksSitted;
    public float sleepProgress;
    public float climbProgress;
    public int ticksSlept;
    @SideOnly(value=Side.CLIENT)
    public ChainBuffer chainBuffer;
    public float pediaScale;
    public int pediaY = 0;
    public int ticksTillPlay;
    public int ticksTillMate;
    public boolean isDaytime;
    public float ridingXZ;
    public float ridingY = 1.0f;
    public float actualWidth;
    public boolean shouldWander = true;
    public boolean isRunningAway = false;
    protected boolean isSitting;
    protected boolean isSleeping;
    protected boolean developsResistance;
    protected boolean breaksBlocks;
    protected int nearByMobsAllowed;
    protected float jumpPower;
    protected boolean horseJumping;
    private Animation currentAnimation;
    private boolean droppedBiofossil = false;
    private int animTick;
    private int fleeTicks = 0;
    private int moodCheckCooldown = 0;
    private int cathermalSleepCooldown = 0;
    private int ticksClimbing = 0;

    public EntityPrehistoric(World world, PrehistoricEntityType type, double baseDamage, double maxDamage, double baseHealth, double maxHealth, double baseSpeed, double maxSpeed, double baseArmor, double maxArmor) {
        super(world);
        this.field_70765_h = new DinoMoveHelper((EntityLiving)this);
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.setHunger(this.getMaxHunger() / 2);
        this.func_98054_a(false);
        this.SPEAK_ANIMATION = Animation.create((int)this.getSpeakLength());
        this.ATTACK_ANIMATION = Animation.create((int)this.getAttackLength());
        this.hasBabyTexture = true;
        this.type = type;
        this.pediaScale = 1.0f;
        this.nearByMobsAllowed = 15;
        this.currentOrder = OrderType.WANDER;
        if (this.ticksTillMate == 0) {
            this.ticksTillMate = this.field_70146_Z.nextInt(6000) + 6000;
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.chainBuffer = new ChainBuffer();
        }
        this.baseDamage = baseDamage;
        this.maxDamage = maxDamage;
        this.baseHealth = baseHealth;
        this.maxHealth = maxHealth;
        this.baseSpeed = baseSpeed;
        this.maxSpeed = maxSpeed;
        this.baseArmor = baseArmor;
        this.maxArmor = maxArmor;
        this.updateAbilities();
        if (!(this instanceof EntityPrehistoricSwimming)) {
            this.func_184644_a(PathNodeType.WATER, -1.0f);
            this.func_70661_as().func_189566_q().func_186316_c(true);
            this.func_70661_as().func_189566_q().func_186316_c(true);
        }
    }

    public static boolean isCannibalistic() {
        return false;
    }

    public static boolean isEntitySmallerThan(Entity entity, float size) {
        if (entity instanceof EntityPrehistoric) {
            return ((EntityPrehistoric)entity).getActualWidth() <= size;
        }
        return entity.field_70130_N <= size;
    }

    public static void knockBackMob(Entity entity, double xMotion, double yMotion, double zMotion) {
        entity.field_70160_al = true;
        float f1 = MathHelper.func_76133_a((double)(xMotion * xMotion + zMotion * zMotion));
        entity.field_70159_w /= 2.0;
        entity.field_70181_x /= 2.0;
        entity.field_70179_y /= 2.0;
        entity.field_70159_w -= xMotion / (double)f1;
        entity.field_70181_x += yMotion;
        entity.field_70179_y -= zMotion / (double)f1;
    }

    public static boolean canBreak(Block block) {
        return !(block instanceof IDinoUnbreakable) && block != Blocks.field_180401_cv && block != Blocks.field_150343_Z && block != Blocks.field_150377_bs && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI && block != Blocks.field_185776_dc && block != Blocks.field_185777_dd && block != Blocks.field_150411_aY && block != Blocks.field_185775_db || block == Blocks.field_150392_bi;
    }

    public boolean func_70072_I() {
        if (this.func_184187_bx() instanceof EntityBoat) {
            this.field_70171_ac = false;
        } else if (this.field_70170_p.func_72918_a(this.func_174813_aQ().func_186664_h(0.001), Material.field_151586_h, (Entity)this)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        return this.field_70171_ac;
    }

    public int getSpeakLength() {
        return 20;
    }

    public int getAttackLength() {
        return 10;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGETICK, (Object)0);
        this.field_70180_af.func_187214_a(HUNGER, (Object)0);
        this.field_70180_af.func_187214_a(MODELIZED, (Object)false);
        this.field_70180_af.func_187214_a(ANGRY, (Object)false);
        this.field_70180_af.func_187214_a(FLEEING, (Object)false);
        this.field_70180_af.func_187214_a(SUBSPECIES, (Object)0);
        this.field_70180_af.func_187214_a(GENDER, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(MOOD, (Object)0);
        this.field_70180_af.func_187214_a(OWNERDISPLAYNAME, (Object)"");
        this.field_70180_af.func_187214_a(AGINGDISABLED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("AgeTick", this.getAgeInTicks());
        compound.func_74768_a("Hunger", this.getHunger());
        compound.func_74757_a("isModelized", this.isSkeleton());
        compound.func_74757_a("Angry", this.isAngry());
        compound.func_74757_a("DinoTamed", this.func_70909_n());
        compound.func_74757_a("Fleeing", this.isFleeingFlag());
        compound.func_74768_a("SubSpecies", this.getSubSpecies());
        compound.func_74768_a("Gender", this.getGender());
        compound.func_74757_a("Sleeping", this.isSleeping);
        compound.func_74768_a("Mood", this.getMood());
        compound.func_74757_a("Sitting", this.isSitting);
        compound.func_74768_a("TicksSincePlay", this.ticksTillPlay);
        compound.func_74768_a("TicksSlept", this.ticksSlept);
        compound.func_74768_a("TicksSinceMate", this.ticksTillMate);
        compound.func_74768_a("TicksClimbing", this.ticksClimbing);
        compound.func_74774_a("currentOrder", (byte)this.currentOrder.ordinal());
        compound.func_74778_a("OwnerDisplayName", this.getOwnerDisplayName());
        compound.func_74776_a("YawRotation", this.field_70177_z);
        compound.func_74776_a("HeadRotation", this.field_70759_as);
        compound.func_74757_a("AgingDisabled", this.isAgingDisabled());
        compound.func_74768_a("CathermalTimer", this.cathermalSleepCooldown);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setAgeinTicks(compound.func_74762_e("AgeTick"));
        this.setHunger(compound.func_74762_e("Hunger"));
        this.setFleeingFlag(compound.func_74767_n("Fleeing"));
        this.setSkeleton(compound.func_74767_n("isModelized"));
        this.setAngry(compound.func_74767_n("Angry"));
        this.func_70903_f(compound.func_74767_n("DinoTamed"));
        this.setSubSpecies(compound.func_74762_e("SubSpecies"));
        this.setGender(compound.func_74762_e("Gender"));
        this.setSleeping(compound.func_74767_n("Sleeping"));
        this.func_70904_g(compound.func_74767_n("Sitting"));
        this.setAgingDisabled(compound.func_74767_n("AgingDisabled"));
        this.setMood(compound.func_74762_e("Mood"));
        if (compound.func_74764_b("currentOrder")) {
            this.setOrder(OrderType.values()[compound.func_74771_c("currentOrder")]);
        }
        this.ticksTillPlay = compound.func_74762_e("TicksSincePlay");
        this.ticksClimbing = compound.func_74762_e("TicksClimbing");
        this.ticksTillMate = compound.func_74762_e("TicksSinceMate");
        this.ticksSlept = compound.func_74762_e("TicksSlept");
        this.field_70177_z = compound.func_74762_e("YawRotation");
        this.field_70759_as = compound.func_74762_e("HeadRotation");
        String s = "";
        if (compound.func_150297_b("Owner", 8)) {
            s = compound.func_74779_i("Owner");
            this.setOwnerDisplayName(s);
        } else {
            this.setOwnerDisplayName(compound.func_74779_i("OwnerDisplayName"));
        }
        this.cathermalSleepCooldown = compound.func_74762_e("CathermalTimer");
    }

    public String getOwnerDisplayName() {
        return (String)this.field_70180_af.func_187225_a(OWNERDISPLAYNAME);
    }

    public void setOwnerDisplayName(String displayName) {
        this.field_70180_af.func_187227_b(OWNERDISPLAYNAME, (Object)displayName);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.maxSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.maxArmor);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(EntityLivingBase.SWIM_SPEED).func_111128_a(1.0);
    }

    public AxisAlignedBB getAttackBounds() {
        float size = this.func_70603_bj() * 0.25f;
        return this.func_174813_aQ().func_72314_b((double)(2.0f + size), (double)(2.0f + size), (double)(2.0f + size));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        Random random = new Random();
        this.setAgeInDays(this.getAdultAge());
        this.setSpawnValues();
        this.setGender(random.nextInt(2));
        this.updateAbilities();
        this.ticksTillPlay = 0;
        this.ticksTillMate = 24000;
        this.field_70122_E = true;
        this.func_70691_i(this.func_110138_aP());
        this.currentOrder = OrderType.WANDER;
        this.grow(0);
        this.func_94061_f(false);
        return livingdata;
    }

    public void setActualSize(float width, float height) {
        this.actualWidth = width;
        this.func_70105_a(width, height);
    }

    public boolean func_175446_cd() {
        return this.isSkeleton() || super.func_175446_cd();
    }

    public void doPlayBonus(int playBonus) {
        if (this.ticksTillPlay == 0) {
            this.setMood(this.getMood() + playBonus);
            if (!this.field_70170_p.field_72995_K) {
                Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageHappyParticles(this.func_145782_y()));
            }
            this.ticksTillPlay = this.field_70146_Z.nextInt(600) + 600;
        }
    }

    public abstract void setSpawnValues();

    public OrderType getOrderType() {
        return this.currentOrder;
    }

    public boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.func_70906_o() || this.isSkeleton() || this.isActuallyWeak() || this.func_184207_aI();
    }

    public boolean isMovementBlockedSoft() {
        return this.func_70610_aX() || this.isSleeping();
    }

    public boolean isSleeping() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSleeping;
            this.isSleeping = isSleeping = ((Boolean)this.field_70180_af.func_187225_a(SLEEPING)).booleanValue();
            return isSleeping;
        }
        return this.isSleeping;
    }

    public void setSleeping(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
        if (!this.field_70170_p.field_72995_K) {
            this.isSleeping = sleeping;
        }
        if (!sleeping) {
            this.cathermalSleepCooldown = 10000 + this.field_70146_Z.nextInt(6000);
        }
    }

    public BlockPos getBlockToEat(int range) {
        for (int r = 1; r <= range; ++r) {
            int z;
            int y;
            int x;
            int dy;
            int ds;
            for (ds = -r; ds <= r; ++ds) {
                for (dy = 4; dy > -5; --dy) {
                    x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)ds));
                    y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy));
                    z = MathHelper.func_76128_c((double)(this.field_70161_v - (double)r));
                    if (this.field_70163_u + (double)dy >= 0.0 && this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K() && FoodMappings.INSTANCE.getBlockFoodAmount(this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c(), this.type.diet) != 0) {
                        BlockPos pos = new BlockPos(x, y, z);
                        return pos;
                    }
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || FoodMappings.INSTANCE.getBlockFoodAmount(this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c(), this.type.diet) == 0) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    return pos;
                }
            }
            for (ds = -r + 1; ds <= r - 1; ++ds) {
                for (dy = 4; dy > -5; --dy) {
                    x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)ds));
                    y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy));
                    z = MathHelper.func_76128_c((double)(this.field_70161_v - (double)r));
                    if (this.field_70163_u + (double)dy >= 0.0 && this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K() && FoodMappings.INSTANCE.getBlockFoodAmount(this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c(), this.type.diet) != 0) {
                        BlockPos pos = new BlockPos(x, y, z);
                        return pos;
                    }
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || FoodMappings.INSTANCE.getBlockFoodAmount(this.field_70170_p.func_180495_p(new BlockPos(x, y, z)).func_177230_c(), this.type.diet) == 0) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    return pos;
                }
            }
        }
        return null;
    }

    public void setOrder(OrderType var1) {
        this.currentOrder = var1;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public TileEntityFeeder getNearestFeeder(int feederRange) {
        for (int dx = -2; dx != -(feederRange + 1); dx += dx < 0 ? dx * -2 : -(2 * dx + 1)) {
            for (int dy = -5; dy < 4; ++dy) {
                for (int dz = -2; dz != -(feederRange + 1); dz += dz < 0 ? dz * -2 : -(2 * dz + 1)) {
                    TileEntity feeder;
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || !((feeder = this.field_70170_p.func_175625_s(new BlockPos(MathHelper.func_76128_c((double)(this.field_70165_t + (double)dx)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)dz))))) instanceof TileEntityFeeder) || ((TileEntityFeeder)feeder).isEmpty(this.type)) continue;
                    return (TileEntityFeeder)feeder;
                }
            }
        }
        return null;
    }

    public float getActualWidth() {
        return this.actualWidth * this.getAgeScale();
    }

    public boolean arePlantsNearby(int range) {
        for (int i = MathHelper.func_76128_c((double)(this.field_70165_t - (double)range)); i < MathHelper.func_76143_f((double)(this.field_70165_t + (double)range)); ++i) {
            for (int j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)(range / 2))); j < MathHelper.func_76143_f((double)(this.field_70163_u + (double)(range / 2))); ++j) {
                for (int k = MathHelper.func_76128_c((double)(this.field_70161_v - (double)range)); k < MathHelper.func_76143_f((double)(this.field_70161_v + (double)range)); ++k) {
                    if (!((double)j <= (double)this.field_70170_p.func_72800_K() + 1.0) || !this.isPlantBlock(this.field_70170_p.func_180495_p(new BlockPos(i, j, k)))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_70104_M() {
        return !this.isSkeleton() && super.func_70104_M();
    }

    public boolean isPlantBlock(IBlockState block) {
        return block.func_185904_a() == Material.field_151577_b || block.func_185904_a() == Material.field_151585_k || block.func_185904_a() == Material.field_151584_j;
    }

    public boolean canSleep() {
        if (this.aiActivityType() == PrehistoricEntityTypeAI.Activity.DIURINAL) {
            return !this.isDaytime();
        }
        if (this.aiActivityType() == PrehistoricEntityTypeAI.Activity.NOCTURNAL) {
            return this.isDaytime() && !this.field_70170_p.func_175678_i(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.field_70161_v)));
        }
        return this.aiActivityType() == PrehistoricEntityTypeAI.Activity.BOTH;
    }

    public boolean canWakeUp() {
        if (this.aiActivityType() == PrehistoricEntityTypeAI.Activity.DIURINAL) {
            return this.isDaytime();
        }
        if (this.aiActivityType() == PrehistoricEntityTypeAI.Activity.NOCTURNAL) {
            return !this.isDaytime() || this.field_70170_p.func_175678_i(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.field_70161_v)));
        }
        return this.ticksSlept > 4000;
    }

    public boolean isDaytime() {
        return this.field_70170_p.func_72935_r();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isSkeleton()) {
            this.field_70159_w *= 0.0;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if ((this.func_70638_az() != null || this.func_70643_av() != null) && this.isSleeping()) {
            this.setSleeping(false);
        }
        if (this.func_70902_q() != null && this.getOwnerDisplayName().equals("")) {
            this.setOwnerDisplayName(this.func_70902_q().func_145748_c_().toString());
        }
        if (this.getHunger() > this.getMaxHunger()) {
            this.setHunger(this.getMaxHunger());
        }
        if (this.getMood() > 100) {
            this.setMood(100);
        }
        if (this.getMood() < -100) {
            this.setMood(-100);
        }
        if (this.isDeadlyHungry() && this.getMood() > -50) {
            this.setMood(-50);
        }
        if (this.ticksTillPlay > 0) {
            --this.ticksTillPlay;
        }
        if (this.ticksTillMate > 0) {
            --this.ticksTillMate;
        }
        if (this.getRidingPlayer() != null) {
            this.field_70138_W = 1.0f;
        }
        if (Revival.CONFIG_OPTIONS.dinosaurBreeding && !this.field_70170_p.field_72995_K && this.ticksTillMate == 0 && this.getGender() == 1 && this.getMood() > 50) {
            float cramDist = 30.0f;
            List crammedList = this.field_70170_p.func_72872_a(this.getClass(), new AxisAlignedBB(this.field_70165_t - (double)cramDist, this.field_70163_u - (double)(cramDist / 2.0f), this.field_70161_v - (double)cramDist, this.field_70165_t + (double)cramDist, this.field_70163_u + (double)cramDist, this.field_70161_v + (double)cramDist));
            if (crammedList.size() > this.getMaxPopulation()) {
                this.ticksTillMate = this.field_70146_Z.nextInt(6000) + 6000;
            } else {
                this.mate();
            }
        }
        if (Revival.CONFIG_OPTIONS.healingDinos && !this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(500) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.moodCheckCooldown-- <= 0) {
            this.doMoodCheck();
            this.moodCheckCooldown = 3000 + this.func_70681_au().nextInt(5000);
        }
        if (this.isSleeping() && (this.func_70638_az() != null && this.func_70638_az().func_70089_S() || this.func_70643_av() != null && this.func_70643_av().func_70089_S())) {
            this.setSleeping(false);
        }
        if (this.func_70906_o()) {
            ++this.ticksSitted;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.ticksSlept = this.isSleeping() ? ++this.ticksSlept : 0;
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70090_H() || this.func_184207_aI() || this.func_70906_o() || this.func_70681_au().nextInt(1000) != 1 || this.func_184218_aH() || this.getAnimation() != NO_ANIMATION && this.getAnimation() != this.SPEAK_ANIMATION || this.isSleeping())) {
            this.func_70904_g(true);
            this.ticksSitted = 0;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70090_H() && (this.func_70906_o() && this.ticksSitted > 100 && this.func_70681_au().nextInt(100) == 1 || this.func_70638_az() != null) && !this.isSleeping()) {
            this.func_70904_g(false);
            this.ticksSitted = 0;
        }
        if (this.cathermalSleepCooldown > 0) {
            --this.cathermalSleepCooldown;
        }
        if (!this.field_70170_p.field_72995_K && this.wantsToSleep()) {
            if (this.aiActivityType() == PrehistoricEntityTypeAI.Activity.BOTH) {
                if (this.cathermalSleepCooldown == 0 && this.func_70681_au().nextInt(1200) == 1 && !this.isSleeping()) {
                    this.func_70904_g(false);
                    this.setSleeping(true);
                }
            } else if (this.aiActivityType() != PrehistoricEntityTypeAI.Activity.NOSLEEP && this.func_70681_au().nextInt(200) == 1 && !this.isSleeping()) {
                this.func_70904_g(false);
                this.setSleeping(true);
            }
        }
        if (!(this.field_70170_p.field_72995_K || this.wantsToSleep() && this.canSleep() && !this.canWakeUp())) {
            this.func_70904_g(false);
            this.setSleeping(false);
        }
        if (this.currentOrder == OrderType.STAY && !this.func_70906_o() && !this.isActuallyWeak()) {
            this.func_70904_g(true);
            this.setSleeping(false);
        }
        if (this.breaksBlocks && this.getMood() < 0) {
            this.breakBlock(5.0f);
        }
        if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityToyBase && (this.isPreyBlocked((Entity)this.func_70638_az()) || this.ticksTillPlay > 0)) {
            this.func_70624_b(null);
        }
        if (this.isFleeingFlag()) {
            ++this.fleeTicks;
            if (this.fleeTicks > this.getFleeingCooldown()) {
                this.setFleeingFlag(false);
                this.fleeTicks = 0;
            }
        }
    }

    protected void doMoodCheck() {
        int overallMoodAddition = 0;
        overallMoodAddition = this.arePlantsNearby(16) ? (overallMoodAddition += 50) : (overallMoodAddition -= 50);
        overallMoodAddition = !this.isThereNearbyTypes() ? (overallMoodAddition += 50) : (overallMoodAddition -= 50);
        this.setMood(this.getMood() + overallMoodAddition);
    }

    public int getMaxPopulation() {
        return this.nearByMobsAllowed;
    }

    public boolean wantsToSleep() {
        if (!this.field_70170_p.field_72995_K && this.aiActivityType() == PrehistoricEntityTypeAI.Activity.BOTH && this.ticksSlept > 8000) {
            return false;
        }
        return !this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.func_70643_av() == null && !this.func_70090_H() && !this.func_184207_aI() && !this.isActuallyWeak() && this.canSleep() && this.canSleepWhileHunting() && (this.getAnimation() == NO_ANIMATION || this.getAnimation() == this.SPEAK_ANIMATION) && this.getOrderType() != OrderType.FOLLOW;
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
    }

    private boolean canSleepWhileHunting() {
        return this.func_70638_az() == null || this.func_70638_az() instanceof EntityToyBase;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public Block getBlockUnder() {
        int blockX = MathHelper.func_76128_c((double)this.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1;
        int blockZ = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.field_70170_p.func_180495_p(new BlockPos(blockX, blockY, blockZ)).func_177230_c();
    }

    public EntityPlayer getRidingPlayer() {
        if (this.func_184179_bs() instanceof EntityPlayer) {
            return (EntityPlayer)this.func_184179_bs();
        }
        return null;
    }

    public void setRidingPlayer(EntityPlayer player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        player.func_184220_m((Entity)this);
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        EntityLivingBase controller;
        if ((this.func_70906_o() || this.isMovementBlockedSoft()) && !this.func_184207_aI()) {
            super.func_191986_a(0.0f, 0.0f, 0.0f);
            return;
        }
        if (this.func_184207_aI() && this.func_82171_bF() && (controller = (EntityLivingBase)this.func_184179_bs()) != null) {
            if (this.func_70638_az() != null) {
                this.func_70624_b(null);
                this.func_70661_as().func_75499_g();
            }
            strafe = controller.field_70702_br * 0.5f;
            forward = controller.field_191988_bg;
            if (this.jumpPower > 0.0f && !this.isDinoJumping() && this.field_70122_E) {
                this.field_70181_x = this.getJumpStrength() * (double)this.jumpPower;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.setDinoJumping(true);
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f1 * this.jumpPower);
                    this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
                }
                this.jumpPower = 0.0f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            this.field_70143_R = 0.0f;
            this.field_70703_bu = false;
            this.func_70659_e(this.field_70122_E ? (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() : 2.0f);
            if (this.field_70122_E) {
                this.jumpPower = 0.0f;
                this.setDinoJumping(false);
            }
            super.func_191986_a(strafe, vertical, forward);
            return;
        }
        this.field_70747_aH = 0.02f;
        super.func_191986_a(strafe, vertical, forward);
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof EntityPlayer) || this.func_70638_az() == passenger) continue;
            EntityPlayer player = (EntityPlayer)passenger;
            if (!this.func_70909_n() || !this.func_152114_e((EntityLivingBase)player)) continue;
            return player;
        }
        return null;
    }

    public void func_70071_h_() {
        boolean weak;
        boolean climbing;
        boolean sleeping;
        boolean sitting;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.func_98054_a(false);
        }
        if (this.func_70874_b() < 0) {
            this.func_70873_a(0);
        }
        if (!this.isSkeleton()) {
            if (!this.isAgingDisabled()) {
                this.setAgeinTicks(this.getAgeInTicks() + 1);
                if (this.getAgeInTicks() % 24000 == 0) {
                    this.updateAbilities();
                    this.grow(0);
                }
            }
            if (this.field_70173_aa % 1200 == 0 && this.getHunger() > 0 && Revival.CONFIG_OPTIONS.starvingDinos) {
                this.setHunger(this.getHunger() - 1);
            }
            if (this.func_110143_aJ() > this.func_110138_aP() / 2.0f && this.getHunger() == 0 && this.field_70173_aa % 40 == 0) {
                this.func_70097_a(DamageSource.field_76366_f, 1.0f);
            }
        }
        if ((sitting = this.func_70906_o()) && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
            if (this.sleepProgress != 0.0f) {
                this.sleepProgress = 0.0f;
            }
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
            if (this.sleepProgress != 0.0f) {
                this.sleepProgress = 0.0f;
            }
        }
        if ((sleeping = this.isSleeping()) && this.sleepProgress < 20.0f) {
            this.sleepProgress += 0.5f;
            if (this.sitProgress != 0.0f) {
                this.sitProgress = 0.0f;
            }
        } else if (!sleeping && this.sleepProgress > 0.0f) {
            this.sleepProgress -= 0.5f;
            if (this.sitProgress != 0.0f) {
                this.sitProgress = 0.0f;
            }
        }
        boolean bl = climbing = this.aiClimbType() == PrehistoricEntityTypeAI.Climbing.ARTHROPOD && this.isBesideClimbableBlock() && !this.field_70122_E;
        if (climbing && this.climbProgress < 20.0f) {
            this.climbProgress += 2.0f;
            if (this.sitProgress != 0.0f) {
                this.sitProgress = 0.0f;
            }
        } else if (!climbing && this.climbProgress > 0.0f) {
            this.climbProgress -= 2.0f;
            if (this.sitProgress != 0.0f) {
                this.sitProgress = 0.0f;
            }
        }
        if ((weak = this.isActuallyWeak()) && this.weakProgress < 20.0f) {
            this.weakProgress += 0.5f;
            this.sitProgress = 0.0f;
            this.sleepProgress = 0.0f;
        } else if (!weak && this.weakProgress > 0.0f) {
            this.weakProgress -= 0.5f;
            this.sitProgress = 0.0f;
            this.sleepProgress = 0.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.aiClimbType() == PrehistoricEntityTypeAI.Climbing.ARTHROPOD && !this.wantsToSleep() && !this.isSleeping() && this.ticksClimbing >= 0 && this.ticksClimbing < 100) {
                this.setBesideClimbableBlock(this.field_70123_F);
            } else {
                this.setBesideClimbableBlock(false);
                if (this.ticksClimbing >= 100) {
                    this.ticksClimbing = -900;
                }
            }
            if (this.func_70617_f_() || this.ticksClimbing < 0) {
                ++this.ticksClimbing;
                if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177984_a()).func_185904_a().func_76220_a()) {
                    this.ticksClimbing = 200;
                }
            }
        }
        Revival.PROXY.calculateChainBuffer(this);
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private boolean isAboveGround() {
        BlockPos blockPos = new BlockPos((Entity)this);
        while (this.field_70170_p.func_175623_d(blockPos) && blockPos.func_177956_o() > 1) {
            blockPos = blockPos.func_177977_b();
        }
        return this.func_174813_aQ().field_72338_b > (double)blockPos.func_177956_o();
    }

    @Override
    public abstract PrehistoricEntityTypeAI.Activity aiActivityType();

    @Override
    public abstract PrehistoricEntityTypeAI.Attacking aiAttackType();

    @Override
    public abstract PrehistoricEntityTypeAI.Climbing aiClimbType();

    @Override
    public abstract PrehistoricEntityTypeAI.Following aiFollowType();

    @Override
    public abstract PrehistoricEntityTypeAI.Jumping aiJumpType();

    @Override
    public abstract PrehistoricEntityTypeAI.Response aiResponseType();

    @Override
    public abstract PrehistoricEntityTypeAI.Stalking aiStalkType();

    @Override
    public abstract PrehistoricEntityTypeAI.Taming aiTameType();

    @Override
    public abstract PrehistoricEntityTypeAI.Untaming aiUntameType();

    @Override
    public abstract PrehistoricEntityTypeAI.Moving aiMovingType();

    @Override
    public abstract PrehistoricEntityTypeAI.WaterAbility aiWaterAbilityType();

    public abstract int getAdultAge();

    public boolean doesFlock() {
        return false;
    }

    public boolean func_70686_a(Class clazz) {
        return this.getClass() != clazz && clazz != EntityDinosaurEgg.class;
    }

    public float getAgeScale() {
        float step = (this.maxSize - this.minSize) / (float)(this.getAdultAge() * 24000 + 1);
        if (this.getAgeInTicks() > this.getAdultAge() * 24000) {
            return this.minSize + step * (float)this.getAdultAge() * 24000.0f;
        }
        return this.minSize + step * (float)this.getAgeInTicks();
    }

    protected int func_70693_a(EntityPlayer par1EntityPlayer) {
        float base = 6.0f * this.getActualWidth() * (this.type.diet == Diet.HERBIVORE ? 1.0f : 2.0f) * (this.aiTameType() == PrehistoricEntityTypeAI.Taming.GEM ? 1.0f : 2.0f) * (this.aiAttackType() == PrehistoricEntityTypeAI.Attacking.BASIC ? 1.0f : 1.25f);
        return MathHelper.func_76141_d((float)((float)Math.min(this.getAdultAge(), this.getAgeInDays()) * base));
    }

    public void updateAbilities() {
        double healthStep = (this.maxHealth - this.baseHealth) / (double)this.getAdultAge();
        double attackStep = (this.maxDamage - this.baseDamage) / (double)this.getAdultAge();
        double speedStep = (this.maxSpeed - this.baseSpeed) / (double)this.getAdultAge();
        double armorStep = (this.maxArmor - this.baseArmor) / (double)this.getAdultAge();
        if (this.getAgeInDays() <= this.getAdultAge()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(this.baseHealth + healthStep * (double)this.getAgeInDays()));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(this.baseDamage + attackStep * (double)this.getAgeInDays()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.baseSpeed + speedStep * (double)this.getAgeInDays());
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.baseArmor + armorStep * (double)this.getAgeInDays());
            if (this.developsResistance) {
                if (this.isTeen()) {
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
                } else if (this.isAdult()) {
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
                } else {
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
                }
            }
        }
        this.func_70691_i((float)healthStep);
    }

    public void breakBlock(float hardness) {
        if (Revival.CONFIG_OPTIONS.dinoBlockBreaking && !this.isSkeleton() && this.isAdult() && this.isHungry() && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            for (int a = (int)Math.round(this.func_174813_aQ().field_72340_a) - 1; a <= (int)Math.round(this.func_174813_aQ().field_72336_d) + 1; ++a) {
                for (int b = (int)Math.round(this.func_174813_aQ().field_72338_b) + 1; b <= (int)Math.round(this.func_174813_aQ().field_72337_e) + 2 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.func_174813_aQ().field_72339_c) - 1; c <= (int)Math.round(this.func_174813_aQ().field_72334_f) + 1; ++c) {
                        IBlockState state;
                        Block block;
                        BlockPos pos = new BlockPos(a, b, c);
                        if (this.field_70170_p.func_175623_d(pos) || !(!((block = (state = this.field_70170_p.func_180495_p(pos)).func_177230_c()) instanceof BlockBush) && !(block instanceof BlockLiquid) && state.func_185887_b(this.field_70170_p, new BlockPos(a, b, c)) < hardness && EntityPrehistoric.canBreak(state.func_177230_c())) && block != Blocks.field_150392_bi) continue;
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        if (this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_175655_b(new BlockPos(a, b, c), true);
                    }
                }
            }
        }
    }

    public void func_98054_a(boolean child) {
        this.func_98055_j(Math.min(this.getAgeScale() * 0.85f, 4.0f));
    }

    public Entity createEgg(EntityAgeable entity) {
        Object baby = null;
        if (this.type.mobType == MobType.MAMMAL) {
            baby = this.type.invokeClass(this.field_70170_p);
        }
        if (this.type.mobType == MobType.BIRD) {
            baby = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(this.type.birdEggItem));
        }
        if (this.type.mobType == MobType.DINOSAUR || this.type.mobType == MobType.DINOSAUR_AQUATIC) {
            if (Revival.CONFIG_OPTIONS.eggsLikeChickens || this.type.isVivariousAquatic()) {
                baby = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(this.type.eggItem));
            } else {
                baby = new EntityDinosaurEgg(this.field_70170_p, this.type);
                ((EntityDinosaurEgg)((Object)baby)).selfType = this.type;
            }
        }
        return baby;
    }

    public boolean isAdult() {
        return this.getAgeInDays() >= this.getAdultAge();
    }

    public boolean isTeen() {
        return this.getAgeInDays() >= this.teenAge && this.getAgeInDays() < this.getAdultAge();
    }

    public boolean func_70631_g_() {
        return this.getAgeInDays() < this.teenAge && !this.isSkeleton();
    }

    public abstract int getMaxHunger();

    public boolean isSkeleton() {
        return (Boolean)this.field_70180_af.func_187225_a(MODELIZED);
    }

    public void setSkeleton(boolean skeleton) {
        this.field_70180_af.func_187227_b(MODELIZED, (Object)skeleton);
    }

    public int getAgeInDays() {
        return (Integer)this.field_70180_af.func_187225_a(AGETICK) / 24000;
    }

    public void setAgeInDays(int days) {
        this.field_70180_af.func_187227_b(AGETICK, (Object)(days * 24000));
    }

    public int getAgeInTicks() {
        return (Integer)this.field_70180_af.func_187225_a(AGETICK);
    }

    public void setAgeinTicks(int ticks) {
        this.field_70180_af.func_187227_b(AGETICK, (Object)ticks);
    }

    public int getHunger() {
        return (Integer)this.field_70180_af.func_187225_a(HUNGER);
    }

    public void setHunger(int hunger) {
        if (this.getHunger() > this.getMaxHunger()) {
            this.field_70180_af.func_187227_b(HUNGER, (Object)this.getMaxHunger());
        } else {
            this.field_70180_af.func_187227_b(HUNGER, (Object)hunger);
        }
    }

    public boolean isAgingDisabled() {
        return (Boolean)this.field_70180_af.func_187225_a(AGINGDISABLED);
    }

    public void setAgingDisabled(boolean isAgingDisabled) {
        this.field_70180_af.func_187227_b(AGINGDISABLED, (Object)isAgingDisabled);
    }

    public boolean increaseHunger(int hunger) {
        if (this.getHunger() >= this.getMaxHunger()) {
            return false;
        }
        this.setHunger(this.getHunger() + hunger);
        if (this.getHunger() > this.getMaxHunger()) {
            this.setHunger(this.getMaxHunger());
        }
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187537_bA, SoundCategory.NEUTRAL, this.func_70599_aP(), this.func_70647_i());
        return true;
    }

    public void func_70074_a(EntityLivingBase var1) {
        super.func_70074_a(var1);
        if (this.type.diet != Diet.HERBIVORE) {
            this.increaseHunger(FoodHelper.getMobFoodPoints(var1, this.type.diet));
            this.func_70691_i(FoodHelper.getMobFoodPoints(var1, this.type.diet) / 3);
            this.setMood(this.getMood() + 25);
        }
    }

    public boolean isHungry() {
        return (float)this.getHunger() < (float)this.getMaxHunger() * 0.75f;
    }

    public boolean isDeadlyHungry() {
        return (float)this.getHunger() < (float)this.getMaxHunger() * 0.25f;
    }

    public void sendStatusMessage(SituationType var1) {
        if (this.func_70902_q() != null && this.func_70032_d((Entity)this.func_70902_q()) < 50.0f) {
            TextComponentString itextcomponent = new TextComponentString(this.func_70005_c_());
            ((EntityPlayer)this.func_70902_q()).func_146105_b((ITextComponent)new TextComponentTranslation(var1 == SituationType.Betrayed ? "prehistoric.betrayed" : "prehistoric.full", new Object[]{itextcomponent}), true);
        }
    }

    public boolean func_70617_f_() {
        if (this.aiMovingType() == PrehistoricEntityTypeAI.Moving.AQUATIC || this.aiMovingType() == PrehistoricEntityTypeAI.Moving.SEMIAQUATIC) {
            return false;
        }
        return this.aiClimbType() == PrehistoricEntityTypeAI.Climbing.ARTHROPOD && this.isBesideClimbableBlock() && !this.isMovementBlockedSoft();
    }

    public boolean isAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.field_70180_af.func_187227_b(ANGRY, (Object)angry);
    }

    public int getSubSpecies() {
        return (Integer)this.field_70180_af.func_187225_a(SUBSPECIES);
    }

    public void setSubSpecies(int subspecies) {
        this.field_70180_af.func_187227_b(SUBSPECIES, (Object)subspecies);
    }

    public int getGender() {
        return (Integer)this.field_70180_af.func_187225_a(GENDER);
    }

    public void setGender(int gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)gender);
    }

    public int getMood() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(MOOD)), (int)-100, (int)100);
    }

    public void setMood(int mood) {
        this.field_70180_af.func_187227_b(MOOD, (Object)MathHelper.func_76125_a((int)mood, (int)-100, (int)100));
    }

    public PrehistoricMoodType getMoodFace() {
        if (this.getMood() == 100) {
            return PrehistoricMoodType.HAPPY;
        }
        if (this.getMood() >= 50) {
            return PrehistoricMoodType.CONTENT;
        }
        if (this.getMood() == -100) {
            return PrehistoricMoodType.ANGRY;
        }
        if (this.getMood() <= -50) {
            return PrehistoricMoodType.SAD;
        }
        return PrehistoricMoodType.CALM;
    }

    public int getScaledMood() {
        return (int)(71.0 * -((double)this.getMood() * 0.01));
    }

    public boolean func_70906_o() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting = (Boolean)this.field_70180_af.func_187225_a(SITTING);
            if (isSitting != this.isSitting) {
                this.ticksSitted = 0;
            }
            this.isSitting = isSitting;
            return isSitting;
        }
        return this.isSitting;
    }

    public void func_70904_g(boolean sitting) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sitting);
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean func_70097_a(DamageSource dmg, float i) {
        if (dmg == DamageSource.field_76368_d) {
            return false;
        }
        if (i > 0.0f && this.isSkeleton()) {
            EntityPlayer player;
            FossilsPlayerProperties properties;
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187864_fh, SoundCategory.NEUTRAL, this.func_70599_aP(), this.func_70647_i());
            if (!this.field_70170_p.field_72995_K && !this.droppedBiofossil) {
                if (this.type.timePeriod == TimePeriod.CENOZOIC) {
                    this.func_145779_a(FAItemRegistry.TAR_FOSSIL, 1);
                } else {
                    this.func_145779_a(FAItemRegistry.BIOFOSSIL, 1);
                }
                this.func_70099_a(new ItemStack(Items.field_151103_aS, Math.min(this.getAgeInDays(), this.getAdultAge())), 1.0f);
                this.droppedBiofossil = true;
            }
            if (dmg.func_76346_g() != null && dmg.func_76346_g() instanceof EntityPlayer && (properties = (FossilsPlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)(player = (EntityPlayer)dmg.func_76346_g()), FossilsPlayerProperties.class)) != null) {
                properties.killedBiofossilCooldown = 5;
            }
            this.func_70106_y();
            return true;
        }
        if (this.func_110144_aD() instanceof EntityPlayer && this.func_70902_q() == this.func_110144_aD()) {
            this.func_70903_f(false);
            this.setMood(this.getMood() - 15);
            this.sendStatusMessage(SituationType.Betrayed);
        }
        if (i > 0.0f) {
            this.func_70904_g(false);
            this.setSleeping(false);
        }
        if (dmg.func_76346_g() != null) {
            this.setMood(this.getMood() - 5);
        }
        if (this.func_184601_bQ(DamageSource.field_76377_j) != null && i >= 1.0f && dmg != DamageSource.field_76368_d && this.getAnimation() != null && this.getAnimation() == NO_ANIMATION && this.field_70170_p.field_72995_K) {
            this.setAnimation(this.SPEAK_ANIMATION);
        }
        return super.func_70097_a(dmg, i);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.aiClimbType() != PrehistoricEntityTypeAI.Climbing.ARTHROPOD && this.aiMovingType() != PrehistoricEntityTypeAI.Moving.WALKANDGLIDE && this.aiMovingType() != PrehistoricEntityTypeAI.Moving.FLIGHT) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.isSkeleton()) {
            if (itemstack.func_190926_b()) {
                if (player.func_70093_af()) {
                    this.nudgeEntity(player);
                } else {
                    float f;
                    double d0 = player.field_70165_t - this.field_70165_t;
                    double d2 = player.field_70161_v - this.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                    this.field_70759_as = f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                    this.field_70177_z = f;
                    this.field_70761_aq = f;
                }
            } else if (itemstack.func_77973_b() == Items.field_151103_aS && this.getAgeInDays() < this.getAdultAge()) {
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187854_fc, SoundCategory.NEUTRAL, 0.8f, 1.0f);
                this.setAgeInDays(this.getAgeInDays() + 1);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
        } else if (!itemstack.func_190926_b()) {
            if ((this.aiTameType() == PrehistoricEntityTypeAI.Taming.GEM && itemstack.func_77973_b() == FAItemRegistry.SCARAB_GEM || this.aiTameType() == PrehistoricEntityTypeAI.Taming.BLUEGEM && itemstack.func_77973_b() == FAItemRegistry.AQUATIC_SCARAB_GEM) && !this.func_70909_n() && !this.func_152114_e((EntityLivingBase)player) && this.isActuallyWeak()) {
                this.triggerTamingAcheivement(player);
                this.func_70691_i(200.0f);
                this.setMood(100);
                this.increaseHunger(500);
                this.func_70661_as().func_75499_g();
                this.func_70624_b(null);
                this.func_70604_c(null);
                this.func_70903_f(true);
                this.func_184754_b(player.func_110124_au());
                this.field_70170_p.func_72960_a((Entity)this, (byte)35);
                itemstack.func_190918_g(1);
                return true;
            }
            if (itemstack.func_77973_b() == FAItemRegistry.CHICKEN_ESSENCE && this.aiTameType() != PrehistoricEntityTypeAI.Taming.GEM && this.aiTameType() != PrehistoricEntityTypeAI.Taming.BLUEGEM && !player.field_70170_p.field_72995_K) {
                if (this.getAgeInDays() < this.getAdultAge() && this.getHunger() > 0 && this.getHunger() > 0) {
                    itemstack.func_190918_g(1);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo, 1));
                    }
                    Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), Item.func_150891_b((Item)FAItemRegistry.CHICKEN_ESSENCE)));
                    this.grow(1);
                    this.setHunger(1 + new Random().nextInt(this.getHunger()));
                    return true;
                }
                if (!this.field_70170_p.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("prehistoric.essencefail", new Object[0]), true);
                }
                return false;
            }
            if (itemstack.func_77973_b() == FAItemRegistry.STUNTED_ESSENCE && !this.isAgingDisabled()) {
                this.setHunger(this.getHunger() + 20);
                this.func_70691_i(this.func_110138_aP());
                this.func_184185_a(SoundEvents.field_187942_hp, this.func_70599_aP(), this.func_70647_i());
                this.spawnItemCrackParticles(itemstack.func_77973_b());
                this.spawnItemCrackParticles(itemstack.func_77973_b());
                this.spawnItemCrackParticles(Items.field_151170_bI);
                this.spawnItemCrackParticles(Items.field_151170_bI);
                this.spawnItemCrackParticles(Items.field_151110_aK);
                this.setAgingDisabled(true);
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            if (FoodMappings.INSTANCE.getItemFoodAmount(itemstack, this.type.diet) != 0) {
                if (!player.field_70170_p.field_72995_K) {
                    if (this.getHunger() < this.getMaxHunger() || this.func_110143_aJ() < this.func_110138_aP() && Revival.CONFIG_OPTIONS.healingDinos || !this.func_70909_n() && this.aiTameType() == PrehistoricEntityTypeAI.Taming.FEEDING) {
                        this.setHunger(this.getHunger() + FoodMappings.INSTANCE.getItemFoodAmount(itemstack, this.type.diet));
                        if (!this.field_70170_p.field_72995_K) {
                            this.eatItem(itemstack);
                        }
                        if (Revival.CONFIG_OPTIONS.healingDinos) {
                            this.func_70691_i(3.0f);
                        }
                        if (this.getHunger() >= this.getMaxHunger() && this.func_70909_n()) {
                            this.sendStatusMessage(SituationType.Full);
                        }
                        itemstack.func_190918_g(1);
                        if (this.aiTameType() == PrehistoricEntityTypeAI.Taming.FEEDING && !this.func_70909_n() && this.type.isTameable() && new Random().nextInt(10) == 1) {
                            this.func_70903_f(true);
                            this.func_184754_b(player.func_110124_au());
                            this.field_70170_p.func_72960_a((Entity)this, (byte)35);
                        }
                        return true;
                    }
                    return this.ItemInMouth.func_190926_b();
                }
                return false;
            }
            if (itemstack.func_77973_b() == Items.field_151058_ca && this.func_70909_n() && this.func_152114_e((EntityLivingBase)player)) {
                this.func_110162_b((Entity)player, true);
                itemstack.func_190918_g(1);
                return true;
            }
            if (FMLCommonHandler.instance().getSide().isClient() && itemstack.func_77973_b() == FAItemRegistry.DINOPEDIA) {
                this.setPedia();
                player.openGui((Object)Revival.INSTANCE, 6, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
                return true;
            }
            if (itemstack.func_77973_b() == FAItemRegistry.WHIP && this.aiTameType() != PrehistoricEntityTypeAI.Taming.NONE && this.isAdult()) {
                if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && this.canBeRidden()) {
                    if (this.getRidingPlayer() == null) {
                        if (!this.field_70170_p.field_72995_K) {
                            Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), FABlockRegistry.VOLCANIC_ROCK));
                            this.setRidingPlayer(player);
                        }
                        this.setOrder(OrderType.WANDER);
                        this.func_70904_g(false);
                        this.setSleeping(false);
                    } else if (this.getRidingPlayer() == player) {
                        this.func_70031_b(true);
                        if (!this.field_70170_p.field_72995_K) {
                            Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), FABlockRegistry.VOLCANIC_ROCK));
                        }
                        this.setMood(this.getMood() - 5);
                    }
                } else if (!this.func_70909_n() && this.aiTameType() != PrehistoricEntityTypeAI.Taming.BLUEGEM && this.aiTameType() != PrehistoricEntityTypeAI.Taming.GEM) {
                    this.setMood(this.getMood() - 5);
                    Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), FABlockRegistry.VOLCANIC_ROCK));
                    if (this.func_70681_au().nextInt(5) == 0) {
                        TextComponentString itextcomponent = new TextComponentString(this.func_70005_c_());
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("prehistoric.autotame", new Object[]{itextcomponent}), true);
                        this.setMood(this.getMood() - 25);
                        this.func_70903_f(true);
                        Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), Item.func_150891_b((Item)Items.field_151043_k)));
                        this.func_184754_b(player.func_110124_au());
                    }
                }
                this.func_70904_g(false);
            }
            if (this.getOrderItem() != null && itemstack.func_77973_b() == this.getOrderItem() && this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && !player.func_184218_aH()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70703_bu = false;
                    this.func_70661_as().func_75499_g();
                    this.currentOrder = OrderType.values()[(this.currentOrder.ordinal() + 1) % 3];
                    this.sendOrderMessage(this.currentOrder);
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public abstract Item getOrderItem();

    private void triggerTamingAcheivement(EntityPlayer player) {
    }

    public void grow(int ageInDays) {
        if (this.isAgingDisabled()) {
            return;
        }
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.func_98054_a(false);
        int i = 0;
        while ((float)i < this.getAgeScale() * 4.0f) {
            double motionX = this.func_70681_au().nextGaussian() * 0.07;
            double motionY = this.func_70681_au().nextGaussian() * 0.07;
            double motionZ = this.func_70681_au().nextGaussian() * 0.07;
            float f = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a) + this.func_174813_aQ().field_72340_a);
            float f1 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) + this.func_174813_aQ().field_72338_b);
            float f2 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c) + this.func_174813_aQ().field_72339_c);
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)f, (double)f1, (double)f2, motionX, motionY, motionZ, new int[0]);
            }
            ++i;
        }
        this.updateAbilities();
    }

    public boolean isWeak() {
        return this.func_110143_aJ() < 8.0f && this.getAgeInDays() >= this.getAdultAge() && !this.func_70909_n();
    }

    protected void setPedia() {
        Revival.PEDIA_OBJECT = this;
    }

    private void sendOrderMessage(OrderType var1) {
        String s = "dino.order." + var1.name().toLowerCase();
        TextComponentString itextcomponent = new TextComponentString(this.func_70005_c_());
        if (this.func_70902_q() instanceof EntityPlayer) {
            ((EntityPlayer)this.func_70902_q()).func_146105_b((ITextComponent)new TextComponentTranslation(s, new Object[]{itextcomponent}), true);
        }
    }

    public void nudgeEntity(EntityPlayer player) {
        this.func_70634_a(this.field_70165_t + (player.field_70165_t - this.field_70165_t) * (double)0.01f, this.field_70163_u, this.field_70161_v + (player.field_70161_v - this.field_70161_v) * (double)0.01f);
    }

    public ArrayList<Class<? extends Entity>> preyList() {
        return new ArrayList<Class<? extends Entity>>();
    }

    public ArrayList<Class<? extends Entity>> preyBlacklist() {
        return new ArrayList<Class<? extends Entity>>();
    }

    public void playerRoar(EntityPlayer player) {
    }

    public void playerAttack(EntityPlayer player) {
    }

    public void playerJump(EntityPlayer player) {
    }

    public void playerFlyUp(EntityPlayer player) {
    }

    public void playerFlyDown(EntityPlayer player) {
    }

    public String getTexture() {
        String sleeping;
        String gender;
        if (this.isSkeleton()) {
            return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + this.type.toString().toLowerCase() + "_skeleton.png";
        }
        if (this.hasBabyTexture) {
            String sleeping2;
            String gender2;
            boolean isBaby;
            String toggle = this.hasFeatherToggle ? (this.featherToggle ? "feathered/" : "scaled/") : "";
            boolean bl = isBaby = this.func_70631_g_() && this.hasBabyTexture;
            String string = this.hasTeenTexture ? (this.isTeen() ? "_teen" : (isBaby ? "_baby" : (this.getGender() == 0 ? "_female" : "_male"))) : (this.func_70631_g_() ? "_baby" : (gender2 = this.getGender() == 0 ? "_female" : "_male"));
            String string2 = !this.isSleeping() ? (this.isActuallyWeak() ? "_sleeping" : "") : (sleeping2 = "_sleeping");
            String toggleList = this.hasFeatherToggle ? (this.featherToggle ? "_feathered" : "_scaled") : "";
            return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + toggle + this.type.toString().toLowerCase() + gender2 + toggleList + sleeping2 + ".png";
        }
        String toggle = this.hasFeatherToggle ? (this.featherToggle ? "feathered/" : "scaled/") : "";
        String string = gender = this.getGender() == 0 ? "_female" : "_male";
        String string3 = !this.isSleeping() ? (this.isActuallyWeak() ? "_sleeping" : "") : (sleeping = "_sleeping");
        String toggleList = this.hasFeatherToggle ? (this.featherToggle ? "_feathered" : "_scaled") : "";
        return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + toggle + this.type.toString().toLowerCase() + gender + toggleList + sleeping + ".png";
    }

    public boolean isActuallyWeak() {
        return (this.aiTameType() == PrehistoricEntityTypeAI.Taming.BLUEGEM || this.aiTameType() == PrehistoricEntityTypeAI.Taming.GEM) && this.isWeak();
    }

    public int getTailSegments() {
        return 3;
    }

    private double getSpeed() {
        return 0.4;
    }

    public float getMaleSize() {
        return 1.0f;
    }

    public String getOverlayTexture() {
        return "fossil:textures/blank.png";
    }

    public int getAnimationTick() {
        return this.animTick;
    }

    public void setAnimationTick(int tick) {
        this.animTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation == null ? NO_ANIMATION : this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{this.SPEAK_ANIMATION, this.ATTACK_ANIMATION};
    }

    public void func_70642_aH() {
        if (!this.isSleeping() && !this.isSkeleton()) {
            super.func_70642_aH();
            if (this.getAnimation() != null && this.getAnimation() == NO_ANIMATION && !this.field_70170_p.field_72995_K) {
                this.setAnimation(this.SPEAK_ANIMATION);
            }
        }
    }

    public void knockbackEntity(Entity knockBackMob, float knockbackStrength, float knockbackStrengthUp) {
        if (!(knockBackMob instanceof EntityToyBase) && knockBackMob instanceof EntityLivingBase) {
            double resistance = ((EntityLivingBase)knockBackMob).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
            double reversed = 1.0 - resistance;
            knockBackMob.field_70181_x += (double)0.4f * reversed + 0.1;
            if (resistance < 1.0) {
                EntityPrehistoric.knockBackMob(knockBackMob, 0.25, 0.2, 0.25);
            }
        }
    }

    public void func_70653_a(Entity entity, float f, double x, double z) {
        if (entity instanceof EntityPrehistoric) {
            if (this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e() <= 0.0 && this.field_70122_E) {
                this.field_70133_I = false;
            }
        } else {
            super.func_70653_a(entity, f, x, z);
        }
    }

    public boolean canDinoHunt(Entity target, boolean hunger) {
        if (target instanceof EntityToyBase) {
            return true;
        }
        boolean isAnotherDino = target instanceof EntityPrehistoric;
        boolean b = true;
        if (target instanceof EntityLivingBase) {
            boolean bl = b = FoodHelper.getMobFoodPoints((EntityLivingBase)target, this.type.diet) > 0;
        }
        if (this.type.diet != Diet.HERBIVORE && this.type.diet != Diet.NONE && b && this.func_70686_a(target.getClass()) && (isAnotherDino ? this.getActualWidth() * this.getTargetScale() >= ((EntityPrehistoric)target).getActualWidth() : this.getActualWidth() * this.getTargetScale() >= target.field_70130_N)) {
            if (hunger) {
                return this.isHungry();
            }
            return true;
        }
        return false;
    }

    public float getTargetScale() {
        return 1.0f;
    }

    public boolean isMad() {
        return this.getMoodFace() == PrehistoricMoodType.SAD;
    }

    public void mate() {
        EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)this);
        double d0 = 64.0;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(d0, 4.0, d0), PREHISTORIC_PREDICATE);
        list.sort(theNearestAttackableTargetSorter);
        ArrayList<EntityPrehistoric> listOfFemales = new ArrayList<EntityPrehistoric>();
        if (!list.isEmpty()) {
            for (Entity e : list) {
                EntityPrehistoric mob = (EntityPrehistoric)e;
                if (mob.func_70028_i((Entity)this) || mob.type != this.type || !mob.isAdult() || mob.getGender() != 0 || mob.ticksTillMate != 0) continue;
                listOfFemales.add(mob);
            }
        }
        if (!listOfFemales.isEmpty() && this.ticksTillMate == 0) {
            EntityPrehistoric prehistoric = (EntityPrehistoric)listOfFemales.get(0);
            if (prehistoric.ticksTillMate == 0) {
                this.func_70661_as().func_75497_a((Entity)prehistoric, 1.0);
                double distance = this.field_70130_N * 8.0f * this.field_70130_N * 8.0f + prehistoric.field_70130_N;
                if (this.func_70092_e(prehistoric.field_70165_t, prehistoric.func_174813_aQ().field_72338_b, prehistoric.field_70161_v) <= distance && prehistoric.field_70122_E && this.field_70122_E && this.isAdult() && prehistoric.isAdult()) {
                    prehistoric.procreate(this);
                    this.ticksTillMate = this.field_70146_Z.nextInt(6000) + 6000;
                    prehistoric.ticksTillMate = this.field_70146_Z.nextInt(12000) + 24000;
                }
            }
        }
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return this.aiClimbType() == PrehistoricEntityTypeAI.Climbing.ARTHROPOD ? new PathNavigateClimber((EntityLiving)this, worldIn) : new PathNavigateDinosaur(this, worldIn);
    }

    public abstract boolean canBeRidden();

    public boolean func_82171_bF() {
        return this.canBeRidden() && this.func_184179_bs() instanceof EntityLivingBase && this.func_152114_e((EntityLivingBase)this.func_184179_bs());
    }

    public void procreate(EntityPrehistoric mob) {
        Entity hatchling;
        for (int i = 0; i < 7; ++i) {
            double dd = this.field_70146_Z.nextGaussian() * 0.02;
            double dd1 = this.field_70146_Z.nextGaussian() * 0.02;
            double dd2 = this.field_70146_Z.nextGaussian() * 0.02;
            Revival.PROXY.spawnPacketHeartParticles(this.field_70170_p, (float)(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N), (float)(this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O)), (float)(this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N), dd, dd1, dd2);
            Revival.PROXY.spawnPacketHeartParticles(mob.field_70170_p, (float)(mob.field_70165_t + (double)(mob.field_70146_Z.nextFloat() * mob.field_70130_N * 2.0f) - (double)mob.field_70130_N), (float)(mob.field_70163_u + 0.5 + (double)(mob.field_70146_Z.nextFloat() * mob.field_70131_O)), (float)(mob.field_70161_v + (double)(mob.field_70146_Z.nextFloat() * mob.field_70130_N * 2.0f) - (double)mob.field_70130_N), dd, dd1, dd2);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (this.field_70146_Z.nextInt(100) == 0 || calendar.get(2) + 1 == 4 && calendar.get(5) == 1) {
            this.func_184185_a(FASoundRegistry.MUSIC_MATING, 1.0f, 1.0f);
        }
        if ((hatchling = this.createEgg((EntityAgeable)mob)) != null && !this.field_70170_p.field_72995_K) {
            this.func_70624_b(null);
            mob.func_70624_b(null);
            hatchling.func_70080_a(mob.field_70165_t, mob.field_70163_u + 1.0, mob.field_70161_v, mob.field_70177_z, 0.0f);
            if (hatchling instanceof EntityDinosaurEgg) {
                Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdateEgg(hatchling.func_145782_y(), this.type.ordinal()));
            } else if (hatchling instanceof EntityPrehistoric) {
                ((EntityPrehistoric)hatchling).func_180482_a(null, null);
                ((EntityPrehistoric)hatchling).grow(1);
                ((EntityPrehistoric)hatchling).func_70606_j((float)this.baseHealth);
            }
            this.field_70170_p.func_72838_d(hatchling);
        }
    }

    public boolean isThereNearbyTypes() {
        double d0 = 40.0;
        List list = this.field_70170_p.func_175647_a(this.getClass(), this.func_174813_aQ().func_72321_a(d0, 4.0, d0), null);
        if (list.isEmpty()) {
            return false;
        }
        ArrayList<EntityPrehistoric> listOfType = new ArrayList<EntityPrehistoric>();
        for (EntityPrehistoric mob : list) {
            if (mob == this || mob.type != this.type || !mob.isAdult()) continue;
            listOfType.add(mob);
        }
        return listOfType.size() > this.nearByMobsAllowed;
    }

    public void doFoodEffect(Item item) {
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187537_bA, SoundCategory.NEUTRAL, this.func_70599_aP(), this.func_70647_i());
        if (item != null) {
            if (item instanceof ItemBlock) {
                this.spawnItemParticle(item, true);
            } else {
                this.spawnItemParticle(item, false);
            }
        }
    }

    public void doFoodEffect() {
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187537_bA, SoundCategory.NEUTRAL, this.func_70599_aP(), this.func_70647_i());
        switch (this.type.diet) {
            case HERBIVORE: {
                this.spawnItemParticle(Items.field_151014_N, false);
                break;
            }
            case OMNIVORE: {
                this.spawnItemParticle(Items.field_151025_P, false);
                break;
            }
            case PISCIVORE: {
                this.spawnItemParticle(Items.field_151115_aP, false);
                break;
            }
            default: {
                this.spawnItemParticle(Items.field_151082_bd, false);
            }
        }
    }

    public void spawnItemCrackParticles(Item item) {
        for (int i = 0; i < 15; ++i) {
            double motionX = this.func_70681_au().nextGaussian() * 0.07;
            double motionY = this.func_70681_au().nextGaussian() * 0.07;
            double motionZ = this.func_70681_au().nextGaussian() * 0.07;
            float f = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a) + this.func_174813_aQ().field_72340_a);
            float f1 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) + this.func_174813_aQ().field_72338_b);
            float f2 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c) + this.func_174813_aQ().field_72339_c);
            if (!this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)f, (double)f1, (double)f2, motionX, motionY, motionZ, new int[]{Item.func_150891_b((Item)item)});
        }
    }

    public void spawnItemParticle(Item item, boolean itemBlock) {
        if (!this.field_70170_p.field_72995_K) {
            double motionX = this.field_70146_Z.nextGaussian() * 0.07;
            double motionY = this.field_70146_Z.nextGaussian() * 0.07;
            double motionZ = this.field_70146_Z.nextGaussian() * 0.07;
            float f = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a) + this.func_174813_aQ().field_72340_a);
            float f1 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) + this.func_174813_aQ().field_72338_b);
            float f2 = (float)((double)this.func_70681_au().nextFloat() * (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c) + this.func_174813_aQ().field_72339_c);
            if (itemBlock && item instanceof ItemBlock) {
                Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), Block.func_149682_b((Block)((ItemBlock)item).func_179223_d())));
            } else {
                Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), Item.func_150891_b((Item)item)));
            }
        }
    }

    public boolean isInWaterMaterial() {
        int k;
        int j;
        double d0 = this.field_70163_u;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        IBlockState blockState = this.field_70170_p.func_180495_p(new BlockPos(i, j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d0)), k = MathHelper.func_76128_c((double)this.field_70161_v)));
        if (blockState.func_185904_a() == Material.field_151586_h) {
            double filled = 1.0;
            if (blockState.func_177230_c() instanceof IFluidBlock) {
                filled = ((IFluidBlock)blockState.func_177230_c()).getFilledPercentage(this.field_70170_p, new BlockPos(i, j, k));
            }
            if (filled < 0.0) {
                return d0 > (double)j + (1.0 - (filled *= -1.0));
            }
            return d0 < (double)j + filled;
        }
        return false;
    }

    public void eatItem(ItemStack stack) {
        if (stack != null && stack.func_77973_b() != null && FoodMappings.INSTANCE.getItemFoodAmount(stack, this.type.diet) != 0) {
            this.setMood(this.getMood() + 5);
            this.doFoodEffect(stack.func_77973_b());
            Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), Item.func_150891_b((Item)stack.func_77973_b())));
            this.setHunger(this.getHunger() + FoodMappings.INSTANCE.getItemFoodAmount(stack, this.type.diet));
            stack.func_190918_g(1);
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(this.SPEAK_ANIMATION);
            }
        }
    }

    public String getTempermentString() {
        String s = null;
        if (this.aiResponseType() == PrehistoricEntityTypeAI.Response.AGRESSIVE || this.aiResponseType() == PrehistoricEntityTypeAI.Response.WATERAGRESSIVE) {
            s = "agressive";
        } else if (this.aiResponseType() == PrehistoricEntityTypeAI.Response.SCARED) {
            s = "scared";
        } else if (this.aiResponseType() == PrehistoricEntityTypeAI.Response.NONE || this.aiResponseType() == PrehistoricEntityTypeAI.Response.WATERCALM) {
            s = "none";
        } else if (this.aiResponseType() == PrehistoricEntityTypeAI.Response.TERITORIAL) {
            s = "territorial";
        }
        return "pedia.temperament." + s;
    }

    public boolean canRunFrom(Entity entity) {
        if (this.field_70130_N <= entity.field_70130_N) {
            if (entity instanceof EntityPrehistoric) {
                EntityPrehistoric mob = (EntityPrehistoric)entity;
                return mob.type.diet != Diet.HERBIVORE;
            }
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                return !this.func_152114_e((EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrehistoricEntityType.DINOSAUR_LOOT;
    }

    public double func_70042_X() {
        return super.func_70042_X();
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z = passenger.field_70177_z;
        }
        if (this.getRidingPlayer() != null && this.getRidingPlayer() instanceof EntityPlayer && this.func_152114_e((EntityLivingBase)this.getRidingPlayer()) && this.func_70638_az() != this.getRidingPlayer()) {
            this.field_70177_z = this.field_70761_aq;
            this.field_70177_z = this.getRidingPlayer().field_70177_z;
            this.field_70759_as = this.getRidingPlayer().field_70177_z;
            float radius = this.ridingXZ * (0.7f * this.getAgeScale()) * -3.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = this.ridingY * this.getAgeScale();
            float spinosaurusAddition = 0.0f;
            if (this instanceof EntitySpinosaurus) {
                spinosaurusAddition = -(((EntitySpinosaurus)this).swimProgress * 0.1f);
            }
            this.getRidingPlayer().func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY + (double)spinosaurusAddition - 1.75, this.field_70161_v + extraZ);
        }
        if (passenger instanceof EntityVelociraptor || passenger instanceof EntityDeinonychus) {
            double extraY = Math.min((double)(this.ridingY * this.getAgeScale()) - 1.0, 0.5);
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + extraY, this.field_70161_v);
        }
    }

    private double getJumpStrength() {
        return 3.0;
    }

    protected boolean isDinoJumping() {
        return this.horseJumping;
    }

    protected void setDinoJumping(boolean jump) {
        this.horseJumping = jump;
    }

    public EntityAgeable func_90011_a(EntityAgeable entity) {
        Entity baby = this.type.invokeClass(this.field_70170_p);
        if (entity instanceof EntityPrehistoric) {
            EntityPrehistoric prehistoric = (EntityPrehistoric)baby;
            prehistoric.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)prehistoric)), null);
            prehistoric.setAgeInDays(0);
            prehistoric.grow(0);
            prehistoric.updateAbilities();
            prehistoric.func_94061_f(false);
            return (EntityPrehistoric)baby;
        }
        return null;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public boolean isAquatic() {
        return this instanceof EntityPrehistoricSwimming;
    }

    public void onWhipRightClick() {
    }

    public boolean canReachPrey() {
        return this.func_70638_az() != null && this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ()) && !this.isPreyBlocked((Entity)this.func_70638_az());
    }

    public boolean isPreyBlocked(Entity prey) {
        RayTraceResult rayTrace = this.field_70170_p.func_72901_a(this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0), prey.func_174791_d().func_72441_c(0.0, (double)(prey.field_70131_O / 2.0f), 0.0), false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            if (!this.field_70170_p.func_175623_d(pos) || !this.field_70170_p.func_175623_d(sidePos)) {
                return true;
            }
            return rayTrace.field_72313_a != RayTraceResult.Type.MISS;
        }
        return false;
    }

    public boolean rayTraceFeeder(BlockPos position, boolean leaves) {
        RayTraceResult rayTrace = this.field_70170_p.func_72901_a(this.func_174791_d(), new Vec3d((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5), false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            if (this.isFeeder(pos, leaves) || this.isFeeder(sidePos, leaves)) {
                return true;
            }
            return rayTrace.field_72313_a == RayTraceResult.Type.MISS;
        }
        return true;
    }

    private boolean isFeeder(BlockPos pos, boolean leaves) {
        if (leaves) {
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            return FoodMappings.INSTANCE.getBlockFoodAmount(state.func_177230_c(), this.type.diet) > 0;
        }
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        TileEntity entity = this.field_70170_p.func_175625_s(pos);
        return entity instanceof TileEntityFeeder;
    }

    public float getDeathRotation() {
        return 90.0f;
    }

    protected float func_70599_aP() {
        return this.func_70631_g_() ? super.func_70599_aP() * 0.75f : 1.0f;
    }

    protected void doAttackKnockback(float strength) {
        if (this.func_70638_az() != null) {
            if (this.func_70638_az().func_184187_bx() != null && this.func_70638_az().func_184187_bx() == this) {
                this.func_70638_az().func_184210_p();
            }
            this.knockbackEntity((Entity)this.func_70638_az(), strength, 0.1f);
            this.func_70638_az().field_70160_al = false;
        }
    }

    public void doAttack() {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (this.func_70638_az() != null) {
            boolean b = this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)iattributeinstance.func_111126_e());
            this.setFleeingFlag(b);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            this.spawnItemParticle(Items.field_151014_N);
            this.spawnItemParticle(Items.field_151014_N);
            this.spawnItemParticle(Items.field_151014_N);
        } else if (id == 46) {
            this.spawnItemParticle(Items.field_151025_P);
            this.spawnItemParticle(Items.field_151025_P);
            this.spawnItemParticle(Items.field_151025_P);
        } else if (id == 47) {
            this.spawnItemParticle(Items.field_151082_bd);
            this.spawnItemParticle(Items.field_151082_bd);
            this.spawnItemParticle(Items.field_151082_bd);
        } else {
            super.func_70103_a(id);
        }
    }

    public void spawnItemParticle(Item item) {
        Random rand = new Random();
        double motionX = rand.nextGaussian() * 0.07;
        double motionY = rand.nextGaussian() * 0.07;
        double motionZ = rand.nextGaussian() * 0.07;
        float f = (float)((double)rand.nextFloat() * (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a) + this.func_174813_aQ().field_72340_a);
        float f1 = (float)((double)rand.nextFloat() * (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) + this.func_174813_aQ().field_72338_b);
        float f2 = (float)((double)rand.nextFloat() * (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c) + this.func_174813_aQ().field_72339_c);
        this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)f, (double)f1, (double)f2, motionX, motionY, motionZ, new int[]{Item.func_150891_b((Item)item)});
    }

    public float getMaxTurnDistancePerTick() {
        return MathHelper.func_76131_a((float)(90.0f - this.getActualWidth() * 20.0f), (float)10.0f, (float)90.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_110206_u(int jumpPowerIn) {
        if (this.func_184207_aI()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return this.func_184207_aI();
    }

    public void func_184775_b(int i) {
    }

    public void func_184777_r_() {
    }

    public float getProximityToNextPathSkip() {
        return this.field_70130_N > 0.75f ? this.field_70130_N / 2.0f : 0.75f - this.field_70130_N / 2.0f;
    }

    public Animation getExtraAnimation(int i) {
        return NO_ANIMATION;
    }

    public boolean useSpecialAttack() {
        return false;
    }

    public boolean isFleeingFlag() {
        return (Boolean)this.field_70180_af.func_187225_a(FLEEING);
    }

    public void setFleeingFlag(boolean fleeing) {
        this.field_70180_af.func_187227_b(FLEEING, (Object)fleeing);
    }

    public boolean isFleeing() {
        return this.isFleeingFlag() && this.type.diet == Diet.HERBIVORE;
    }

    protected int getFleeingCooldown() {
        if (this.func_70643_av() != null) {
            int i = (int)(Math.max(this.func_70643_av().field_70130_N / 2.0f, 1.0f) * 95.0f);
            int j = (int)(Math.min((double)(this.field_70130_N / 2.0f), 0.5) * 50.0);
            return i - j;
        }
        return 100;
    }
}

