/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.server.entity.ai.LargeSwimNodeProcessor;
import fossilsarcheology.server.entity.ai.PathNavigateAmphibious;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class EntityPrehistoricSwimming
extends EntityPrehistoric {
    protected static final DataParameter<Boolean> IS_BREACHING = EntityDataManager.func_187226_a(EntityPrehistoricSwimming.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> BREACHING_PITCH = EntityDataManager.func_187226_a(EntityPrehistoricSwimming.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final int MAX_TIME_ON_LAND = 1000;
    private static final int MAX_TIME_IN_WATER = 1000;
    public boolean movesOnLand;
    public Animation FISH_ANIMATION;
    public float onLandProgress;
    public int timeInWater = 0;
    public int timeOnLand = 0;
    public float flyProgress;
    public float prevBreachPitch;
    protected boolean isAmphibious = false;
    protected boolean isLandNavigator;
    protected int breachCooldown = 0;
    protected boolean isGoingDownAfterBreach = false;
    protected float jumpX;
    protected float jumpY;
    protected float jumpZ;

    public EntityPrehistoricSwimming(World world, PrehistoricEntityType type, double baseDamage, double maxDamage, double baseHealth, double maxHealth, double baseSpeed, double maxSpeed, double baseArmor, double maxArmor) {
        super(world, type, baseDamage, maxDamage, baseHealth, maxHealth, baseSpeed, maxSpeed, baseArmor, maxArmor);
        this.switchNavigator(true);
        this.hasBabyTexture = false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_BREACHING, (Object)false);
        this.field_70180_af.func_187214_a(BREACHING_PITCH, (Object)Float.valueOf(0.0f));
    }

    public boolean doesBreachAttack() {
        return false;
    }

    public boolean isBreaching() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BREACHING);
    }

    public void setBreaching(boolean breaching) {
        this.field_70180_af.func_187227_b(IS_BREACHING, (Object)breaching);
    }

    public float getBreachPitch() {
        return ((Float)this.field_70180_af.func_187225_a(BREACHING_PITCH)).floatValue();
    }

    public void setBreachPitch(float pitch) {
        this.field_70180_af.func_187227_b(BREACHING_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementBreachPitch(float pitch) {
        this.field_70180_af.func_187227_b(BREACHING_PITCH, (Object)Float.valueOf(this.getBreachPitch() + pitch));
    }

    public void decrementBreachPitch(float pitch) {
        this.field_70180_af.func_187227_b(BREACHING_PITCH, (Object)Float.valueOf(this.getBreachPitch() - pitch));
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70699_by = new PathNavigateAmphibious((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new SwimmingMoveHelper();
            this.field_70699_by = new PathNavigateLargeSwimmer((EntityLiving)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public boolean shouldLeaveWater() {
        return this.isAmphibious && this.timeInWater > 1000 && this.timeOnLand < 1000;
    }

    public boolean shouldEnterWater() {
        if (!this.isAmphibious) {
            return true;
        }
        return this.timeInWater == 0 && this.timeOnLand > 1000;
    }

    protected double getStrongAttackPower() {
        return this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 2.0;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public abstract double swimSpeed();

    private double getScaledSwimSpeed() {
        return (double)(this.getAgeScale() / this.maxSize) * this.swimSpeed();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public boolean func_70617_f_() {
        return false;
    }

    public void destroyBoat(Entity sailor) {
        if (sailor.func_184187_bx() != null && sailor.func_184187_bx() instanceof EntityBoat && !this.field_70170_p.field_72995_K) {
            EntityBoat boat = (EntityBoat)sailor.func_184187_bx();
            boat.func_70106_y();
            if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                for (int i = 0; i < 3; ++i) {
                    boat.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150344_f), 1, boat.func_184453_r().func_184982_b()), 0.0f);
                }
                for (int j = 0; j < 2; ++j) {
                    boat.func_145778_a(Items.field_151055_y, 1, 0.0f);
                }
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.prevBreachPitch = this.getBreachPitch();
        if (this.breachCooldown > 0) {
            --this.breachCooldown;
        }
        if (this.doesBreachAttack()) {
            if (this.func_70638_az() != null) {
                if (this.canReachPrey() && this.isBreaching()) {
                    this.isGoingDownAfterBreach = true;
                    this.setBreaching(false);
                }
                if (!this.isEntitySubmerged(this.func_70638_az()) && this.func_70638_az().func_191953_am() && this.func_70090_H() && !this.func_70638_az().func_184215_y((Entity)this) && this.breachCooldown == 0) {
                    this.setBreaching(true);
                    this.isGoingDownAfterBreach = false;
                    this.breachCooldown = 120;
                    this.jumpX = (float)this.func_70638_az().field_70165_t;
                    this.jumpY = (float)this.func_70638_az().field_70163_u + 1.0f;
                    this.jumpZ = (float)this.func_70638_az().field_70161_v;
                }
                if (this.isEntitySubmerged(this.func_70638_az()) || !this.func_70638_az().func_191953_am()) {
                    this.setBreaching(false);
                    this.isGoingDownAfterBreach = false;
                }
                if (this.isBreaching() && !this.isGoingDownAfterBreach) {
                    double targetX = (double)this.jumpX - this.field_70165_t;
                    double targetY = (double)this.jumpY - this.field_70163_u;
                    double targetZ = (double)this.jumpZ - this.field_70161_v;
                    this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.100000000372529 * 2.0;
                    this.field_70181_x += (Math.signum(targetY) * 0.5 - this.field_70181_x) * 0.100000000372529 * 5.0;
                    this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.100000000372529 * 2.0;
                    float angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                    float rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
                    this.field_191988_bg = 0.5f;
                    this.field_70177_z += rotation;
                    double dist = this.func_70011_f(this.jumpX, this.jumpY, this.jumpZ);
                    if (dist < 2.5) {
                        this.setBreaching(false);
                        this.isGoingDownAfterBreach = true;
                    }
                }
                if (!this.isEntitySubmerged(this.func_70638_az()) && !this.func_70638_az().func_191953_am()) {
                    this.func_70624_b(null);
                }
            }
            if (this.func_70090_H()) {
                this.isGoingDownAfterBreach = false;
            }
            if (!this.field_70122_E || !this.func_70090_H()) {
                double ydist = this.field_70167_r - this.field_70163_u;
                float BreachDist = (float)((Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y)) * 2.0);
                this.incrementBreachPitch((float)ydist * 15.0f);
                this.setBreachPitch(MathHelper.func_76131_a((float)this.getBreachPitch(), (float)-60.0f, (float)60.0f));
                float plateau = 0.0f;
                if (this.getBreachPitch() > plateau) {
                    this.decrementBreachPitch(1.0f);
                } else if (this.getBreachPitch() < -plateau) {
                    this.incrementBreachPitch(1.0f);
                }
            } else {
                this.setBreachPitch(0.0f);
            }
        }
        if (this.func_70090_H() && this.useSwimAI() && this.isLandNavigator && !this.field_70170_p.field_72995_K) {
            this.switchNavigator(false);
        }
        if (!(this.func_70090_H() || this.useSwimAI() || this.isLandNavigator || this.field_70170_p.field_72995_K)) {
            this.switchNavigator(true);
        }
        this.field_70761_aq = this.field_70177_z;
        if ((this.func_70906_o() || this.isSleeping()) && this.func_70090_H()) {
            this.func_70904_g(false);
            this.setSleeping(false);
        }
        if (this.getRidingPlayer() != null && this.func_70090_H()) {
            if (this.getRidingPlayer().field_70125_A > 45.0f) {
                this.field_70181_x -= 0.2 * this.swimSpeed();
            }
            if (this.getRidingPlayer().field_70125_A < -45.0f) {
                this.field_70181_x += 0.2 * this.swimSpeed();
            }
        }
        if (this.isInWaterMaterial()) {
            ++this.timeInWater;
            this.timeOnLand = 0;
        }
        if (this.field_70122_E && !this.isInWaterMaterial()) {
            this.timeInWater = 0;
            ++this.timeOnLand;
        }
    }

    public boolean func_191953_am() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72314_b(0.0, -50.0, 0.0).func_186664_h(0.001), Material.field_151586_h, (Entity)this);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("TimeOnLand", this.timeOnLand);
        compound.func_74768_a("TimeInWater", this.timeInWater);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.timeOnLand = compound.func_74762_e("TimeOnLand");
        this.timeInWater = compound.func_74762_e("TimeInWater");
    }

    protected boolean useSwimAI() {
        return this.func_70090_H();
    }

    public boolean func_70090_H() {
        return super.func_70090_H() || this.func_70055_a(Material.field_151586_h) || this.func_70055_a(Material.field_151589_v);
    }

    @Override
    public boolean func_82171_bF() {
        return this.type.isVivariousAquatic() ? this.func_70090_H() && super.func_82171_bF() : super.func_82171_bF();
    }

    public boolean isEntitySubmerged(EntityLivingBase entity) {
        return this.field_70170_p.func_180495_p(new BlockPos((Entity)entity).func_177984_a()).func_185904_a() == Material.field_151586_h;
    }

    @Override
    public void func_191986_a(float strafe, float vertical, float forward) {
        EntityLivingBase controller;
        if (this.func_70906_o() || !this.isAmphibious && !this.isInWaterMaterial()) {
            super.func_191986_a(0.0f, 0.0f, 0.0f);
            return;
        }
        if (this.func_184207_aI() && this.func_82171_bF() && (controller = (EntityLivingBase)this.func_184179_bs()) != null) {
            strafe = controller.field_70702_br * 0.5f;
            forward = controller.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            this.field_70143_R = 0.0f;
            if (this.func_70090_H()) {
                forward = controller.field_191988_bg * 0.25f;
                strafe = controller.field_70702_br * 0.125f;
                this.func_191958_b(strafe, vertical, forward, 1.0f);
                float f4 = 0.01f;
                double d0 = this.getScaledSwimSpeed() * 0.5;
                if (!this.field_70122_E) {
                    d0 *= 0.5;
                }
                if (d0 > 0.0) {
                    f4 = (float)((double)f4 + (double)(0.54600006f - f4) * d0 / 3.0);
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f4;
                this.field_70159_w *= 0.900000011920929;
                this.field_70181_x *= 0.900000011920929;
                this.field_70181_x *= (double)f4;
                this.field_70179_y *= 0.900000011920929;
                this.field_70179_y *= (double)f4;
                this.field_70181_x += 0.01185;
            } else {
                forward = controller.field_191988_bg * 0.25f;
                strafe = controller.field_70702_br * 0.125f;
                this.func_70659_e(1.0f);
                super.func_191986_a(strafe, vertical, forward);
                return;
            }
            this.func_70659_e(1.0f);
            vertical = 0.0f;
            super.func_191986_a(strafe, 0.0f, forward);
            this.field_184618_aE = this.field_70721_aZ;
            double deltaX = this.field_70165_t - this.field_70169_q;
            double deltaZ = this.field_70161_v - this.field_70166_s;
            double deltaY = this.field_70163_u - this.field_70167_r;
            float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) * 4.0f;
            if (delta > 1.0f) {
                delta = 1.0f;
            }
            this.field_70721_aZ += (delta - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
            return;
        }
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe * (float)this.swimSpeed(), vertical * (float)this.swimSpeed(), forward * (float)this.swimSpeed(), 0.1f);
                float f4 = 0.8f;
                float speedModifier = EnchantmentHelper.func_185294_d((EntityLivingBase)this);
                if (speedModifier > 3.0f) {
                    speedModifier = 3.0f;
                }
                if (!this.field_70122_E) {
                    speedModifier *= 0.15f;
                }
                if (speedModifier > 0.0f) {
                    f4 += (0.54600006f - f4) * speedModifier / 3.0f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f4;
                this.field_70159_w *= 0.9;
                this.field_70181_x *= 0.9;
                this.field_70179_y *= 0.9;
                this.field_70181_x *= (double)f4;
                this.field_70179_y *= (double)f4;
            } else {
                super.func_191986_a(strafe, vertical, forward);
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double deltaX = this.field_70165_t - this.field_70169_q;
        double deltaY = this.field_70163_u - this.field_70167_r;
        double deltaZ = this.field_70161_v - this.field_70166_s;
        float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) * 4.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        this.field_70721_aZ += (delta - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public Vec3d func_174791_d() {
        return new Vec3d(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (!this.canBreathOnLand()) {
            if (this.func_70089_S() && !this.func_70090_H()) {
                this.func_70050_g(--i);
                if (this.func_70086_ai() == -40) {
                    this.func_70050_g(0);
                    this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            } else {
                this.func_70050_g(500);
            }
        }
    }

    public boolean canBreathOnLand() {
        return true;
    }

    @Override
    public boolean canDinoHunt(Entity target, boolean hunger) {
        if (this.doesBreachAttack() && target.func_191953_am()) {
            return super.canDinoHunt(target, hunger);
        }
        return super.canDinoHunt(target, hunger) && (target.func_70090_H() || this.canHuntMobsOnLand());
    }

    public boolean canHuntMobsOnLand() {
        return true;
    }

    class SwimmingMoveHelper
    extends EntityMoveHelper {
        private final EntityPrehistoricSwimming dinosaur;

        public SwimmingMoveHelper() {
            super((EntityLiving)EntityPrehistoricSwimming.this);
            this.dinosaur = EntityPrehistoricSwimming.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.dinosaur.func_184207_aI()) {
                double distanceX = this.field_75646_b - this.dinosaur.field_70165_t;
                double distanceY = this.field_75647_c - this.dinosaur.field_70163_u;
                double distanceZ = this.field_75644_d - this.dinosaur.field_70161_v;
                double distance = Math.abs(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
                distance = MathHelper.func_76133_a((double)distance);
                distanceY /= distance;
                float angle = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                float maxChange = this.dinosaur.getMaxTurnDistancePerTick();
                if (distance > (double)0.2f) {
                    this.dinosaur.field_70177_z = this.func_75639_a(this.dinosaur.field_70177_z, angle, maxChange);
                }
                this.dinosaur.func_70659_e(0.65f);
                this.dinosaur.field_70181_x += (double)this.dinosaur.func_70689_ay() * distanceY * 0.1;
            } else if (this.field_188491_h == EntityMoveHelper.Action.JUMPING) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (this.field_75648_a.field_70122_E) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                }
            } else {
                this.dinosaur.func_70659_e(0.0f);
            }
        }
    }

    class PathNavigateLargeSwimmer
    extends PathNavigateSwimmer {
        public PathNavigateLargeSwimmer(EntityLiving entitylivingIn, World worldIn) {
            super(entitylivingIn, worldIn);
        }

        protected PathFinder func_179679_a() {
            return new PathFinder((NodeProcessor)new LargeSwimNodeProcessor());
        }

        protected Vec3d func_75502_i() {
            return new Vec3d(this.field_75515_a.field_70165_t, this.field_75515_a.field_70163_u + (double)0.49f, this.field_75515_a.field_70161_v);
        }

        protected boolean func_75485_k() {
            return this.field_75515_a.func_70090_H();
        }

        protected boolean func_75493_a(Vec3d posVec31, Vec3d posVec32, int sizeX, int sizeY, int sizeZ) {
            RayTraceResult raytraceresult = this.field_75513_b.func_147447_a(posVec31, new Vec3d(posVec32.field_72450_a, posVec32.field_72448_b + (double)0.49f, posVec32.field_72449_c), false, true, false);
            return raytraceresult == null || raytraceresult.field_72313_a == RayTraceResult.Type.MISS;
        }
    }
}

