/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.recipe;

import com.google.common.collect.Maps;
import fossilsarcheology.server.block.EnumFossilPlant;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.entity.TileEntityCultivate;
import fossilsarcheology.server.block.entity.TileEntitySifter;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.TimePeriod;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.item.variant.DinosaurBoneType;
import fossilsarcheology.server.recipe.RecipeAnalyzer;
import fossilsarcheology.server.recipe.RecipeWorktable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class FAMachineRecipeRegistry {
    public static List<RecipeAnalyzer> analyzerRecipes = new ArrayList<RecipeAnalyzer>();
    public static List<ItemStack> toBeRemovedAnalyzer = new ArrayList<ItemStack>();
    public static List<RecipeAnalyzer> sifterRecipes = new ArrayList<RecipeAnalyzer>();
    public static List<ItemStack> toBeRemovedSifter = new ArrayList<ItemStack>();
    public static Map<ItemStack, ItemStack> cultivateRecipes = Maps.newHashMap();
    public static List<ItemStack> toBeRemovedCultivate = new ArrayList<ItemStack>();
    public static Map<ItemStack, Integer> cultivateFuelValues = Maps.newHashMap();
    public static List<RecipeWorktable> worktableRecipes = new ArrayList<RecipeWorktable>();
    public static List<ItemStack> toBeRemovedWorktable = new ArrayList<ItemStack>();

    public static void init() {
        int i;
        RecipeAnalyzer plantFossil = new RecipeAnalyzer(FAItemRegistry.PLANT_FOSSIL).addOutput(new ItemStack((Block)Blocks.field_150354_m, 2), 35.0f).addOutput(new ItemStack(Items.field_151100_aR, 1, 2), 20.0f).addOutput(new ItemStack((Item)FAItemRegistry.FOSSIL_SEED_FERN, 1), 5.0f).addOutput(new ItemStack((Item)FAItemRegistry.PALAE_SAPLING_FOSSIL, 1), 2.5f).addOutput(new ItemStack((Item)FAItemRegistry.CALAMITES_SAPLING_FOSSIL, 1), 2.5f).addOutput(new ItemStack((Item)FAItemRegistry.SIGILLARIA_SAPLING_FOSSIL, 1), 2.5f).addOutput(new ItemStack((Item)FAItemRegistry.CORDAITES_SAPLING_FOSSIL, 1), 2.5f);
        float seedWeight = (100.0f - plantFossil.getTotalWeight()) / (float)EnumFossilPlant.values().length;
        for (int i2 = 0; i2 < EnumFossilPlant.values().length; ++i2) {
            plantFossil.addOutput(new ItemStack((Item)FAItemRegistry.FOSSIL_SEED, 1, i2), seedWeight);
        }
        FAMachineRecipeRegistry.registerAnalyzer(plantFossil);
        RecipeAnalyzer bioFossil = new RecipeAnalyzer(FAItemRegistry.BIOFOSSIL).addOutput(new ItemStack(Items.field_151100_aR, 1, 15), 50.0f).addOutput(new ItemStack((Block)Blocks.field_150354_m, 2), 35.0f);
        List<PrehistoricEntityType> bioFossilEntityList = PrehistoricEntityType.getTimePeriodList(TimePeriod.MESOZOIC, TimePeriod.PALEOZOIC);
        float bioFossilDNAChance = 15.0f / (float)bioFossilEntityList.size();
        for (int i3 = 0; i3 < bioFossilEntityList.size(); ++i3) {
            bioFossil.addOutput(new ItemStack(bioFossilEntityList.get((int)i3).dnaItem), bioFossilDNAChance);
        }
        FAMachineRecipeRegistry.registerAnalyzer(bioFossil);
        for (DinosaurBoneType type : DinosaurBoneType.values()) {
            FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack((Item)FAItemRegistry.LEG_BONE, 1, type.ordinal())).addOutput(new ItemStack(Items.field_151100_aR, 1, 15), 30.0f).addOutput(new ItemStack(Items.field_151103_aS), 35.0f).addOutput(new ItemStack(DinosaurBoneType.getEntity((DinosaurBoneType)DinosaurBoneType.values()[type.ordinal()]).dnaItem), 35.0f));
            FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack((Item)FAItemRegistry.UNIQUE_ITEM, 1, type.ordinal())).addOutput(new ItemStack(Items.field_151100_aR, 1, 15), 30.0f).addOutput(new ItemStack(Items.field_151103_aS), 35.0f).addOutput(new ItemStack(DinosaurBoneType.getEntity((DinosaurBoneType)DinosaurBoneType.values()[type.ordinal()]).dnaItem), 35.0f));
            FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack((Item)FAItemRegistry.FOOT, 1, type.ordinal())).addOutput(new ItemStack(Items.field_151100_aR, 1, 15), 30.0f).addOutput(new ItemStack(Items.field_151103_aS), 35.0f).addOutput(new ItemStack(DinosaurBoneType.getEntity((DinosaurBoneType)DinosaurBoneType.values()[type.ordinal()]).dnaItem), 35.0f));
            FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack((Item)FAItemRegistry.SKULL, 1, type.ordinal())).addOutput(new ItemStack(Items.field_151100_aR, 1, 15), 30.0f).addOutput(new ItemStack(Items.field_151103_aS), 35.0f).addOutput(new ItemStack(DinosaurBoneType.getEntity((DinosaurBoneType)DinosaurBoneType.values()[type.ordinal()]).dnaItem), 35.0f));
            FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack((Item)FAItemRegistry.ARM_BONE, 1, type.ordinal())).addOutput(new ItemStack(Items.field_151100_aR, 1, 15), 30.0f).addOutput(new ItemStack(Items.field_151103_aS), 35.0f).addOutput(new ItemStack(DinosaurBoneType.getEntity((DinosaurBoneType)DinosaurBoneType.values()[type.ordinal()]).dnaItem), 35.0f));
            FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack((Item)FAItemRegistry.RIBCAGE, 1, type.ordinal())).addOutput(new ItemStack(Items.field_151100_aR, 1, 15), 30.0f).addOutput(new ItemStack(Items.field_151103_aS), 35.0f).addOutput(new ItemStack(DinosaurBoneType.getEntity((DinosaurBoneType)DinosaurBoneType.values()[type.ordinal()]).dnaItem), 35.0f));
            FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack((Item)FAItemRegistry.VERTEBRAE, 1, type.ordinal())).addOutput(new ItemStack(Items.field_151100_aR, 1, 15), 30.0f).addOutput(new ItemStack(Items.field_151103_aS), 35.0f).addOutput(new ItemStack(DinosaurBoneType.getEntity((DinosaurBoneType)DinosaurBoneType.values()[type.ordinal()]).dnaItem), 35.0f));
        }
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack((Item)FAItemRegistry.TARDROP)).addOutput(new ItemStack(Items.field_151044_h), 20.0f).addOutput(new ItemStack(Items.field_151044_h, 1, 1), 20.0f).addOutput(new ItemStack((Item)FAItemRegistry.TAR_FOSSIL), 45.0f).addOutput(new ItemStack((Block)FABlockRegistry.VOLCANIC_ROCK), 15.0f));
        RecipeAnalyzer tarFossil = new RecipeAnalyzer(FAItemRegistry.TAR_FOSSIL).addOutput(new ItemStack(Items.field_151100_aR, 3, 15), 50.0f).addOutput(new ItemStack((Block)FABlockRegistry.VOLCANIC_ROCK), 30.0f);
        List<PrehistoricEntityType> tarFossilEntityList = PrehistoricEntityType.getTimePeriodList(TimePeriod.CENOZOIC);
        float tarFossilDNAChance = 20.0f / (float)tarFossilEntityList.size();
        for (PrehistoricEntityType type : tarFossilEntityList) {
            tarFossil.addOutput(new ItemStack(type.dnaItem), tarFossilDNAChance);
        }
        FAMachineRecipeRegistry.registerAnalyzer(tarFossil);
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Blocks.field_150325_L)).addOutput(new ItemStack(Items.field_151007_F, 3), 60.0f).addOutput(new ItemStack(PrehistoricEntityType.SHEEP.dnaItem), 27.0f).addOutput(new ItemStack(PrehistoricEntityType.LLAMA.dnaItem), 13.0f));
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Items.field_151147_al)).addOutput(new ItemStack(PrehistoricEntityType.PIG.dnaItem), 100.0f));
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Items.field_151082_bd)).addOutput(new ItemStack(PrehistoricEntityType.COW.dnaItem), 100.0f));
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Items.field_179561_bm)).addOutput(new ItemStack(PrehistoricEntityType.SHEEP.dnaItem), 100.0f));
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Items.field_151076_bf)).addOutput(new ItemStack(PrehistoricEntityType.CHICKEN.dnaItem), 100.0f));
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Items.field_151110_aK)).addOutput(new ItemStack(PrehistoricEntityType.CHICKEN.dnaItem), 100.0f));
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Items.field_151008_G)).addOutput(new ItemStack(PrehistoricEntityType.CHICKEN.dnaItem), 95.0f).addOutput(new ItemStack(PrehistoricEntityType.PARROT.dnaItem), 5.0f));
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Items.field_179558_bo)).addOutput(new ItemStack(PrehistoricEntityType.RABBIT.dnaItem), 100.0f));
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Items.field_179556_br)).addOutput(new ItemStack(PrehistoricEntityType.RABBIT.dnaItem), 100.0f));
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Items.field_179555_bs)).addOutput(new ItemStack(PrehistoricEntityType.RABBIT.dnaItem), 100.0f));
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Items.field_151115_aP)).addOutput(new ItemStack(PrehistoricEntityType.POLARBEAR.dnaItem), 10.0f).addOutput(new ItemStack(Items.field_179563_cD), 15.0f).addOutput(new ItemStack(Items.field_151100_aR, 1, 15), 75.0f));
        RecipeAnalyzer failuresaurusFlesh = new RecipeAnalyzer(FAItemRegistry.FAILURESAURUS_FLESH).addOutput(new ItemStack(Items.field_151078_bh), 33.0f);
        float failuresaurusDNAChance = 67.0f / (float)PrehistoricEntityType.values().length;
        for (PrehistoricEntityType type : PrehistoricEntityType.values()) {
            failuresaurusFlesh.addOutput(new ItemStack(type.dnaItem), failuresaurusDNAChance);
            if (type.foodItem != null) {
                FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(type.foodItem)).addOutput(new ItemStack(type.dnaItem), 100.0f));
            }
            if (type.eggItem != null) {
                FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(type.eggItem)).addOutput(new ItemStack(type.dnaItem), 100.0f));
            }
            if (type.birdEggItem != null) {
                FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(type.birdEggItem)).addOutput(new ItemStack(type.dnaItem), 100.0f));
            }
            if (type.bestBirdEggItem != null) {
                FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(type.bestBirdEggItem)).addOutput(new ItemStack(type.dnaItem), 100.0f));
            }
            if (type.fishItem != null) {
                FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(type.fishItem)).addOutput(new ItemStack(type.dnaItem), 100.0f));
            }
            if (type.embryoItem == null) continue;
            FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(type.embryoItem)).addOutput(new ItemStack(type.dnaItem), 100.0f));
        }
        FAMachineRecipeRegistry.registerAnalyzer(failuresaurusFlesh);
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack((Item)FAItemRegistry.SHELL)).addOutput(new ItemStack(PrehistoricEntityType.NAUTILUS.dnaItem), 100.0f));
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(new ItemStack(Items.field_151116_aA)).addOutput(new ItemStack(PrehistoricEntityType.COW.dnaItem), 60.0f).addOutput(new ItemStack(PrehistoricEntityType.DONKEY.dnaItem), 10.0f).addOutput(new ItemStack(PrehistoricEntityType.HORSE.dnaItem), 30.0f));
        RecipeAnalyzer icedMeat = new RecipeAnalyzer((Item)FAItemRegistry.ICED_MEAT);
        icedMeat.addOutput(new ItemStack(Items.field_151076_bf), 15.0f);
        icedMeat.addOutput(new ItemStack(Items.field_179561_bm), 15.0f);
        icedMeat.addOutput(new ItemStack(Items.field_151082_bd), 15.0f);
        icedMeat.addOutput(new ItemStack(Items.field_151147_al), 15.0f);
        icedMeat.addOutput(new ItemStack((Item)FAItemRegistry.TAR_FOSSIL), 20.0f);
        for (PrehistoricEntityType type : tarFossilEntityList) {
            icedMeat.addOutput(new ItemStack(type.dnaItem), tarFossilDNAChance);
        }
        FAMachineRecipeRegistry.registerAnalyzer(icedMeat);
        RecipeAnalyzer relicScrap = new RecipeAnalyzer(FAItemRegistry.RELIC_SCRAP);
        relicScrap.addOutput(new ItemStack(Blocks.field_150351_n), 30.0f);
        relicScrap.addOutput(new ItemStack((Item)FAItemRegistry.STONE_TABLET), 30.0f);
        relicScrap.addOutput(new ItemStack(Items.field_151145_ak), 18.0f);
        relicScrap.addOutput(new ItemStack((Item)FAItemRegistry.POTTERY_SHARD), 4.0f);
        relicScrap.addOutput(new ItemStack((Item)FAItemRegistry.BROKEN_HELMET), 4.0f);
        relicScrap.addOutput(new ItemStack((Item)FAItemRegistry.BROKEN_SWORD), 4.0f);
        float damagedFigureWeight = (100.0f - relicScrap.getTotalWeight()) / 5.0f;
        for (int i4 = 0; i4 <= 5; ++i4) {
            relicScrap.addOutput(new ItemStack((Block)FABlockRegistry.FIGURINE, 1, 5 + i4), damagedFigureWeight);
        }
        float brokenFigureWeight = (100.0f - relicScrap.getTotalWeight()) / 5.0f;
        for (int i5 = 0; i5 <= 5; ++i5) {
            relicScrap.addOutput(new ItemStack((Block)FABlockRegistry.FIGURINE, 1, 10 + i5), brokenFigureWeight);
        }
        FAMachineRecipeRegistry.registerAnalyzer(relicScrap);
        FAMachineRecipeRegistry.registerAnalyzer(new RecipeAnalyzer(FAItemRegistry.DOMINICAN_AMBER).addOutput(new ItemStack(Items.field_151070_bp), 9.0f).addOutput(new ItemStack(Items.field_151007_F), 10.0f).addOutput(new ItemStack(Blocks.field_150346_d), 25.0f).addOutput(new ItemStack(Blocks.field_150351_n), 25.0f).addOutput(new ItemStack((Item)FAItemRegistry.FOSSIL_SEED_FERN), 1.0f).addOutput(new ItemStack((Item)FAItemRegistry.PALAE_SAPLING_FOSSIL), 1.0f).addOutput(new ItemStack((Item)FAItemRegistry.CALAMITES_SAPLING_FOSSIL), 1.0f).addOutput(new ItemStack((Item)FAItemRegistry.SIGILLARIA_SAPLING_FOSSIL), 1.0f).addOutput(new ItemStack((Item)FAItemRegistry.CORDAITES_SAPLING_FOSSIL), 1.0f).addOutput(new ItemStack(Items.field_151014_N), 1.0f).addOutput(new ItemStack(Items.field_185163_cU), 1.0f).addOutput(new ItemStack(Items.field_151080_bb), 1.0f).addOutput(new ItemStack(Items.field_151081_bc), 1.0f));
        ArrayList sediment = new ArrayList();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemBlock) || TileEntitySifter.getSiftTypeFromStack(new ItemStack(item)) == TileEntitySifter.EnumSiftType.NONE) continue;
            NonNullList items = NonNullList.func_191196_a();
            if (item.func_77640_w() == null) continue;
            item.func_150895_a(item.func_77640_w(), items);
            sediment.addAll(items);
        }
        for (ItemStack itemstack : sediment) {
            RecipeAnalyzer sifterRecipe = new RecipeAnalyzer(itemstack);
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m)) {
                sifterRecipe.addOutput(new ItemStack((Block)Blocks.field_150354_m), 25.0f);
            } else {
                sifterRecipe.addOutput(new ItemStack((Block)Blocks.field_150354_m), 20.0f);
            }
            sifterRecipe.addOutput(new ItemStack((Item)FAItemRegistry.DOMINICAN_AMBER), 1.0f);
            sifterRecipe.addOutput(new ItemStack((Item)FAItemRegistry.PLANT_FOSSIL), 14.0f);
            sifterRecipe.addOutput(new ItemStack(Items.field_151174_bG), 15.0f);
            sifterRecipe.addOutput(new ItemStack(Items.field_151172_bF), 10.0f);
            sifterRecipe.addOutput(new ItemStack(Items.field_151100_aR, 1, 15), 20.0f);
            sifterRecipe.addOutput(new ItemStack((Item)FAItemRegistry.FOSSIL_SEED_FERN), 10.0f);
            sifterRecipe.addOutput(new ItemStack((Item)FAItemRegistry.POTTERY_SHARD), 5.0f);
            sifterRecipe.addOutput(new ItemStack((Item)FAItemRegistry.BIOFOSSIL), 2.0f);
            FAMachineRecipeRegistry.registerSifter(sifterRecipe);
        }
        for (PrehistoricEntityType type : PrehistoricEntityType.values()) {
            FAMachineRecipeRegistry.registerCultivate(new ItemStack(type.dnaItem), TileEntityCultivate.getCultivationOutput(new ItemStack(type.dnaItem)));
        }
        for (i = 0; i < EnumFossilPlant.values().length; ++i) {
            FAMachineRecipeRegistry.registerCultivate(new ItemStack((Item)FAItemRegistry.FOSSIL_SEED, 1, i), new ItemStack((Item)FAItemRegistry.SEED, 1, i));
        }
        FAMachineRecipeRegistry.registerCultivate(new ItemStack((Item)FAItemRegistry.FOSSIL_SEED_FERN), new ItemStack((Item)FAItemRegistry.FERN_SEED));
        FAMachineRecipeRegistry.registerCultivate(new ItemStack((Item)FAItemRegistry.PALAE_SAPLING_FOSSIL), new ItemStack((Block)FABlockRegistry.PALM_SAPLING));
        FAMachineRecipeRegistry.registerCultivate(new ItemStack((Item)FAItemRegistry.CALAMITES_SAPLING_FOSSIL), new ItemStack((Block)FABlockRegistry.CALAMITES_SAPLING));
        FAMachineRecipeRegistry.registerCultivate(new ItemStack((Item)FAItemRegistry.SIGILLARIA_SAPLING_FOSSIL), new ItemStack((Block)FABlockRegistry.SIGILLARIA_SAPLING));
        FAMachineRecipeRegistry.registerCultivate(new ItemStack((Item)FAItemRegistry.CORDAITES_SAPLING_FOSSIL), new ItemStack((Block)FABlockRegistry.CORDAITES_SAPLING));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.BROKEN_SWORD), new ItemStack((Item)FAItemRegistry.ANCIENT_SWORD), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.BROKEN_HELMET), new ItemStack((Item)FAItemRegistry.ANCIENT_HELMET), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.ANCIENT_SWORD), new ItemStack((Item)FAItemRegistry.ANCIENT_SWORD), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.ANCIENT_HELMET), new ItemStack((Item)FAItemRegistry.ANCIENT_HELMET), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.SCARAB_AXE), new ItemStack((Item)FAItemRegistry.SCARAB_AXE), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.SCARAB_PICKAXE), new ItemStack((Item)FAItemRegistry.SCARAB_PICKAXE), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.SCARAB_SWORD), new ItemStack((Item)FAItemRegistry.SCARAB_SWORD), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.SCARAB_HOE), new ItemStack((Item)FAItemRegistry.SCARAB_HOE), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.SCARAB_SHOVEL), new ItemStack((Item)FAItemRegistry.SCARAB_SHOVEL), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.WOODEN_JAVELIN), new ItemStack((Item)FAItemRegistry.WOODEN_JAVELIN), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.STONE_JAVELIN), new ItemStack((Item)FAItemRegistry.STONE_JAVELIN), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.IRON_JAVELIN), new ItemStack((Item)FAItemRegistry.IRON_JAVELIN), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.GOLD_JAVELIN), new ItemStack((Item)FAItemRegistry.GOLD_JAVELIN), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.DIAMOND_JAVELIN), new ItemStack((Item)FAItemRegistry.DIAMOND_JAVELIN), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Item)FAItemRegistry.ANCIENT_JAVELIN), new ItemStack((Item)FAItemRegistry.ANCIENT_JAVELIN), new ItemStack((Item)FAItemRegistry.RELIC_SCRAP));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Block)FABlockRegistry.KYLIX_VASE, 1, 0), new ItemStack((Block)FABlockRegistry.KYLIX_VASE, 1, 1), new ItemStack((Item)FAItemRegistry.POTTERY_SHARD));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Block)FABlockRegistry.VOLUTE_VASE, 1, 0), new ItemStack((Block)FABlockRegistry.VOLUTE_VASE, 1, 1), new ItemStack((Item)FAItemRegistry.POTTERY_SHARD));
        FAMachineRecipeRegistry.registerWorktable(new ItemStack((Block)FABlockRegistry.AMPHORA_VASE, 1, 0), new ItemStack((Block)FABlockRegistry.AMPHORA_VASE, 1, 1), new ItemStack((Item)FAItemRegistry.POTTERY_SHARD));
        for (i = 5; i <= 14; ++i) {
            FAMachineRecipeRegistry.registerWorktable(new ItemStack((Block)FABlockRegistry.FIGURINE, 1, i), new ItemStack((Block)FABlockRegistry.FIGURINE, 1, i - 5), new ItemStack((Item)FAItemRegistry.POTTERY_SHARD));
        }
        cultivateFuelValues.put(new ItemStack((Item)FAItemRegistry.BIO_GOO), 6000);
    }

    public static void registerAnalyzer(RecipeAnalyzer recipe) {
        analyzerRecipes.add(recipe);
    }

    public static void registerSifter(RecipeAnalyzer recipe) {
        sifterRecipes.add(recipe);
    }

    public static void registerCultivate(ItemStack input, ItemStack output) {
        cultivateRecipes.put(input, output);
    }

    public static void registerWorktable(ItemStack input, ItemStack output, ItemStack fuel) {
        worktableRecipes.add(new RecipeWorktable(input, output, fuel));
    }

    public static ItemStack getCultivateResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : cultivateRecipes.entrySet()) {
            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)entry.getKey(), (boolean)false)) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    public static RecipeWorktable getWorktableRecipeForItem(ItemStack stack) {
        for (RecipeWorktable recipe : worktableRecipes) {
            if ((!stack.func_77984_f() || stack.func_77973_b() != recipe.getInput().func_77973_b()) && !OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }

    public static RecipeAnalyzer getAnalyzerRecipeForItem(ItemStack stack) {
        for (RecipeAnalyzer recipe : analyzerRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }

    public static RecipeAnalyzer getSifterRecipeForItem(ItemStack stack) {
        for (RecipeAnalyzer recipe : sifterRecipes) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }

    public static void postInit() {
        Iterator<RecipeAnalyzer> itr = analyzerRecipes.iterator();
        while (itr.hasNext()) {
            RecipeAnalyzer recipe = itr.next();
            for (ItemStack stack : toBeRemovedAnalyzer) {
                if (!recipe.getInput().func_77969_a(stack)) continue;
                itr.remove();
            }
        }
        Iterator<RecipeAnalyzer> itr1 = sifterRecipes.iterator();
        while (itr1.hasNext()) {
            RecipeAnalyzer recipe = itr1.next();
            for (ItemStack stack : toBeRemovedSifter) {
                if (!recipe.getInput().func_77969_a(stack)) continue;
                itr1.remove();
            }
        }
        for (ItemStack cultivateStack : toBeRemovedCultivate) {
            cultivateRecipes.remove(cultivateStack);
        }
        Iterator<RecipeWorktable> itr3 = worktableRecipes.iterator();
        while (itr3.hasNext()) {
            RecipeWorktable recipe = itr3.next();
            for (ItemStack stack : toBeRemovedWorktable) {
                if (!recipe.getInput().func_77969_a(stack)) continue;
                itr3.remove();
            }
        }
    }
}

