/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.background.example.with_input_string;

import de.keksuccino.fancymenu.api.background.MenuBackground;
import de.keksuccino.fancymenu.api.background.MenuBackgroundType;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class ExampleMenuBackgroundForInputString
extends MenuBackground {
    private ExternalTextureResourceLocation imageLocation = null;

    public ExampleMenuBackgroundForInputString(@Nonnull MenuBackgroundType type, String imagePath) {
        super("unused_identifier", type);
        File imageFile = new File(imagePath);
        if (imageFile.exists() && (imageFile.getPath().toLowerCase().endsWith(".jpg") || imageFile.getPath().toLowerCase().endsWith(".jpeg") || imageFile.getPath().toLowerCase().endsWith(".png"))) {
            this.imageLocation = TextureHandler.getResource((String)imageFile.getPath());
            if (this.imageLocation != null) {
                this.imageLocation.loadTexture();
            }
        }
    }

    @Override
    public void onOpenMenu() {
    }

    @Override
    public void render(GuiScreen screen, boolean keepAspectRatio) {
        try {
            if (this.imageLocation != null && this.imageLocation.isReady()) {
                GlStateManager.func_179147_l();
                RenderUtils.bindTexture((ResourceLocation)this.imageLocation.getResourceLocation());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!keepAspectRatio) {
                    Gui.func_146110_a((int)0, (int)0, (float)1.0f, (float)1.0f, (int)screen.field_146294_l, (int)screen.field_146295_m, (float)screen.field_146294_l, (float)screen.field_146295_m);
                } else {
                    int w = this.imageLocation.getWidth();
                    int h = this.imageLocation.getHeight();
                    double ratio = (double)w / (double)h;
                    int wfinal = (int)((double)screen.field_146295_m * ratio);
                    int screenCenterX = screen.field_146294_l / 2;
                    if (wfinal < screen.field_146294_l) {
                        Gui.func_146110_a((int)0, (int)0, (float)1.0f, (float)1.0f, (int)screen.field_146294_l, (int)screen.field_146295_m, (float)screen.field_146294_l, (float)screen.field_146295_m);
                    } else {
                        Gui.func_146110_a((int)(screenCenterX - wfinal / 2), (int)0, (float)1.0f, (float)1.0f, (int)wfinal, (int)screen.field_146295_m, (float)wfinal, (float)screen.field_146295_m);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

