/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator;

import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMPopup;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public class AutoScalingPopup
extends FMPopup {
    private LayoutEditorScreen parent;
    private AdvancedButton cancelButton;
    private AdvancedButton doneButton;
    private AdvancedTextField widthTextField;
    private AdvancedTextField heightTextField;
    protected Consumer<Boolean> callback = null;

    public AutoScalingPopup(LayoutEditorScreen parent, @Nullable Consumer<Boolean> callback) {
        super(240);
        this.callback = callback;
        this.parent = parent;
        this.cancelButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.yesno.cancel", (String[])new String[0]), true, press -> this.onCancelButtonPressed());
        this.addButton(this.cancelButton);
        this.doneButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.done", (String[])new String[0]), true, press -> this.onDoneButtonPressed());
        this.addButton(this.doneButton);
        this.widthTextField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        this.widthTextField.func_146180_a("" + Minecraft.func_71410_x().field_71443_c);
        this.heightTextField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        this.heightTextField.func_146180_a("" + Minecraft.func_71410_x().field_71440_d);
        KeyboardHandler.addKeyPressedListener(this::onEnterPressed);
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
    }

    public void render(int mouseX, int mouseY, GuiScreen renderIn) {
        super.render(mouseX, mouseY, renderIn);
        float partial = Minecraft.func_71410_x().func_184121_ak();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int screenCenterX = renderIn.field_146294_l / 2;
        int screenCenterY = renderIn.field_146295_m / 2;
        this.func_73732_a(font, Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line1", (String[])new String[0]), screenCenterX, screenCenterY - 90, -1);
        this.func_73732_a(font, Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line2", (String[])new String[0]), screenCenterX, screenCenterY - 80, -1);
        this.func_73732_a(font, Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line3", (String[])new String[0]), screenCenterX, screenCenterY - 70, -1);
        this.func_73732_a(font, Locals.localize((String)"general.width", (String[])new String[0]), screenCenterX, screenCenterY - 50, -1);
        this.widthTextField.field_146209_f = screenCenterX - this.widthTextField.func_146200_o() / 2;
        this.widthTextField.field_146210_g = screenCenterY - 35;
        this.widthTextField.func_146194_f();
        this.func_73732_a(font, Locals.localize((String)"general.height", (String[])new String[0]), screenCenterX, screenCenterY - 5, -1);
        this.heightTextField.field_146209_f = screenCenterX - this.heightTextField.func_146200_o() / 2;
        this.heightTextField.field_146210_g = screenCenterY + 10;
        this.heightTextField.func_146194_f();
        this.func_73732_a(font, Locals.localize((String)"helper.creator.windowsize.currentwidth", (String[])new String[0]) + ": " + Minecraft.func_71410_x().field_71443_c, screenCenterX, screenCenterY + 45, -1);
        this.func_73732_a(font, Locals.localize((String)"helper.creator.windowsize.currentheight", (String[])new String[0]) + ": " + Minecraft.func_71410_x().field_71440_d, screenCenterX, screenCenterY + 55, -1);
        this.doneButton.field_146128_h = screenCenterX - this.doneButton.field_146120_f - 5;
        this.doneButton.field_146129_i = screenCenterY + 80;
        this.cancelButton.field_146128_h = screenCenterX + 5;
        this.cancelButton.field_146129_i = screenCenterY + 80;
        this.renderButtons(mouseX, mouseY);
    }

    protected void onDoneButtonPressed() {
        try {
            if (MathUtils.isInteger((String)this.widthTextField.func_146179_b()) && MathUtils.isInteger((String)this.heightTextField.func_146179_b())) {
                int w = Integer.parseInt(this.widthTextField.func_146179_b());
                int h = Integer.parseInt(this.heightTextField.func_146179_b());
                if (w > 0 && h > 0) {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    this.parent.autoScalingWidth = w;
                    this.parent.autoScalingHeight = h;
                    this.answerCallback(true);
                } else {
                    this.answerCallback(false);
                    LayoutEditorScreen.displayNotification(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.error", (String[])new String[0]), (String)"%n%"));
                }
            } else {
                this.answerCallback(false);
                LayoutEditorScreen.displayNotification(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.error", (String[])new String[0]), (String)"%n%"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDisplayed(false);
    }

    protected void onCancelButtonPressed() {
        this.answerCallback(false);
        this.setDisplayed(false);
    }

    protected void answerCallback(boolean b) {
        if (this.callback != null) {
            this.callback.accept(b);
        }
    }

    public void onEnterPressed(KeyboardData d) {
        if (d.keycode == 28 && this.isDisplayed() && this.doneButton != null && this.doneButton.field_146125_m) {
            this.onDoneButtonPressed();
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 1 && this.isDisplayed()) {
            this.onCancelButtonPressed();
        }
    }
}

