/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.playerentity;

import com.mojang.authlib.GameProfile;
import de.keksuccino.fancymenu.menu.fancy.DynamicValueHelper;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.DummyWorldFactory;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.PlayerEntityCache;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.SkinExternalTextureResourceLocation;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.SkinWebTextureResourceLocation;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelParrot;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderParrot;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class PlayerEntityCustomizationItem
extends CustomizationItemBase {
    public MenuPlayerEntity entity;
    public int scale = 30;
    public String playerName = null;
    public boolean autoRotation = true;
    public float bodyRotationX = 0.0f;
    public float bodyRotationY = 0.0f;
    public float headRotationX = 0.0f;
    public float headRotationY = 0.0f;
    private static final World DUMMY_WORLD = DummyWorldFactory.getDummyWorld();
    private static final MenuPlayerRenderer PLAYER_RENDERER = new MenuPlayerRenderer(false);
    private static final MenuPlayerRenderer SLIM_PLAYER_RENDERER = new MenuPlayerRenderer(true);

    public PlayerEntityCustomizationItem(PropertiesSection item) {
        super(item);
        String autoRot;
        String bodyrotY;
        String bodyrotX;
        String rotY;
        String rotX;
        String showName;
        String crouching;
        String parrot;
        String slim;
        ExternalTextureResourceLocation r;
        String cape;
        WebTextureResourceLocation wt;
        String capeUrl;
        ExternalTextureResourceLocation r2;
        String skin;
        WebTextureResourceLocation wt2;
        String scaleString = item.getEntryValue("scale");
        if (scaleString != null && MathUtils.isDouble((String)scaleString)) {
            this.scale = (int)Double.parseDouble(scaleString);
        }
        this.playerName = item.getEntryValue("playername");
        if (this.playerName != null) {
            this.playerName = DynamicValueHelper.convertFromRaw(this.playerName);
        }
        this.entity = new MenuPlayerEntity(this.playerName);
        String skinUrl = item.getEntryValue("skinurl");
        if (skinUrl != null && (wt2 = TextureHandler.getWebResource((String)(skinUrl = DynamicValueHelper.convertFromRaw(skinUrl)))) != null) {
            this.entity.skinLocation = wt2.getResourceLocation();
        }
        if ((skin = PlayerEntityCustomizationItem.fixBackslashPath(item.getEntryValue("skinpath"))) != null && this.entity.skinLocation == null && (r2 = TextureHandler.getResource((String)skin)) != null) {
            if (r2.getHeight() < 64) {
                String sha1;
                File f = new File(skin);
                if (f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (sha1 = PlayerEntityCache.calculateSHA1(f)) != null) {
                    if (!PlayerEntityCache.isSkinCached(sha1)) {
                        SkinExternalTextureResourceLocation sr = new SkinExternalTextureResourceLocation(skin);
                        sr.loadTexture();
                        PlayerEntityCache.cacheSkin(sha1, sr.getResourceLocation());
                        this.entity.skinLocation = sr.getResourceLocation();
                    } else {
                        this.entity.skinLocation = PlayerEntityCache.getSkin(sha1);
                    }
                }
            } else {
                this.entity.skinLocation = r2.getResourceLocation();
            }
        }
        if ((capeUrl = item.getEntryValue("capeurl")) != null && (wt = TextureHandler.getWebResource((String)(capeUrl = DynamicValueHelper.convertFromRaw(capeUrl)))) != null) {
            this.entity.capeLocation = wt.getResourceLocation();
        }
        if ((cape = PlayerEntityCustomizationItem.fixBackslashPath(item.getEntryValue("capepath"))) != null && this.entity.capeLocation == null && (r = TextureHandler.getResource((String)cape)) != null) {
            this.entity.capeLocation = r.getResourceLocation();
        }
        if ((slim = item.getEntryValue("slim")) != null && slim.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.setSlimSkin(true);
        }
        if ((parrot = item.getEntryValue("parrot")) != null && parrot.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.hasParrot = true;
        }
        if ((crouching = item.getEntryValue("crouching")) != null && crouching.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.crouching = true;
        }
        if ((showName = item.getEntryValue("showname")) != null && showName.replace(" ", "").equalsIgnoreCase("false")) {
            this.entity.showName = false;
        }
        if ((rotX = item.getEntryValue("headrotationx")) != null && MathUtils.isFloat((String)(rotX = rotX.replace(" ", "")))) {
            this.headRotationX = Float.parseFloat(rotX);
        }
        if ((rotY = item.getEntryValue("headrotationy")) != null && MathUtils.isFloat((String)(rotY = rotY.replace(" ", "")))) {
            this.headRotationY = Float.parseFloat(rotY);
        }
        if ((bodyrotX = item.getEntryValue("bodyrotationx")) != null && MathUtils.isFloat((String)(bodyrotX = bodyrotX.replace(" ", "")))) {
            this.bodyRotationX = Float.parseFloat(bodyrotX);
        }
        if ((bodyrotY = item.getEntryValue("bodyrotationy")) != null && MathUtils.isFloat((String)(bodyrotY = bodyrotY.replace(" ", "")))) {
            this.bodyRotationY = Float.parseFloat(bodyrotY);
        }
        if ((autoRot = item.getEntryValue("autorotation")) != null && autoRot.replace(" ", "").equalsIgnoreCase("false")) {
            this.autoRotation = false;
        }
        this.value = this.playerName != null ? this.playerName : "Player Entity";
        this.width = (int)(this.entity.field_70130_N * (float)this.scale);
        this.height = (int)(this.entity.field_70131_O * (float)this.scale);
    }

    @Override
    public void render(GuiScreen menu) throws IOException {
        try {
            if (this.shouldRender() && this.entity != null) {
                this.value = this.playerName != null ? this.playerName : "Player Entity";
                this.width = (int)(this.entity.field_70130_N * (float)this.scale);
                this.height = (int)(this.entity.field_70131_O * (float)this.scale);
                int mX = MouseInput.getMouseX();
                int mY = MouseInput.getMouseY();
                PlayerEntityCustomizationItem.renderPlayerEntity(this.getPosX(menu), this.getPosY(menu), this.scale, mX, mY, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void renderPlayerEntity(int posX, int posY, int scale, float mouseX, float mouseY, PlayerEntityCustomizationItem item) {
        float entityHeight = item.entity.field_70131_O * (float)item.scale;
        float rotationX = (float)Math.atan((mouseX - (float)item.getPosX(Minecraft.func_71410_x().field_71462_r)) / 40.0f);
        float rotationY = (float)Math.atan((mouseY - ((float)item.getPosY(Minecraft.func_71410_x().field_71462_r) - entityHeight / 2.0f)) / 40.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)1050.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)-1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)1000.0);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (!item.autoRotation) {
            GlStateManager.func_179114_b((float)(-((float)Math.atan(item.bodyRotationY)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            item.entity.field_70761_aq = item.bodyRotationX;
            item.entity.field_70125_A = item.headRotationY;
            item.entity.field_70759_as = item.headRotationX;
        } else {
            GlStateManager.func_179114_b((float)(-((float)Math.atan(rotationY)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            item.entity.field_70761_aq = Math.negateExact((long)(180.0f + rotationX * 20.0f));
            item.entity.field_70125_A = Math.negateExact((long)(-rotationY * 20.0f));
            item.entity.field_70759_as = Math.negateExact((long)(180.0f + rotationX * 40.0f));
        }
        PlayerEntityCustomizationItem.renderAsFancy(() -> item.renderEntityStatic(0.0, 0.0, 0.0, 0.0f, 1.0f));
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
    }

    private static void renderAsFancy(Runnable renderFancy) {
        boolean b = Minecraft.func_71375_t();
        if (b) {
            renderFancy.run();
        } else {
            GameSettings g = Minecraft.func_71410_x().field_71474_y;
            g.field_74347_j = true;
            renderFancy.run();
            g.field_74347_j = false;
        }
    }

    public void renderEntityStatic(double xIn, double yIn, double zIn, float rotationYawIn, float partialTicks) {
        try {
            Vec3d vector3d = this.entity.isSlimSkin() ? SLIM_PLAYER_RENDERER.getRenderOffset(this.entity, partialTicks) : PLAYER_RENDERER.getRenderOffset(this.entity, partialTicks);
            double d2 = xIn + vector3d.field_72450_a;
            double d3 = yIn + vector3d.field_72448_b;
            double d0 = zIn + vector3d.field_72449_c;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)d2, (double)d3, (double)d0);
            if (this.entity.isSlimSkin()) {
                SLIM_PLAYER_RENDERER.doRender(this.entity, xIn, yIn, zIn, rotationYawIn, partialTicks);
            } else {
                PLAYER_RENDERER.doRender(this.entity, xIn, yIn, zIn, rotationYawIn, partialTicks);
            }
            GlStateManager.func_179137_b((double)(-vector3d.field_72450_a), (double)(-vector3d.field_72448_b), (double)(-vector3d.field_72449_c));
            GlStateManager.func_179121_F();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSkinURL(String playerName) {
        String skinUrl = null;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    skinUrl = line.substring(1, line.length() - 2);
                    break;
                }
                if (line.contains("\"skin\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"url\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return skinUrl;
    }

    private static String getCapeURL(String playerName) {
        String capeUrl = null;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    capeUrl = line.substring(1, line.length() - 2);
                    break;
                }
                if (line.contains("\"cape\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"url\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return capeUrl;
    }

    private static boolean getIsSlimSkin(String playerName) {
        boolean slim = false;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    String slimString = line.substring(1, line.length() - 2);
                    if (!slimString.equalsIgnoreCase("true")) break;
                    slim = true;
                    break;
                }
                if (line.contains("\"textures\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"slim\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return slim;
    }

    public static class MenuPlayerParrotLayer
    implements LayerRenderer<MenuPlayerEntity> {
        private final ModelParrot parrotModel = new ModelParrot();
        private final RenderParrot parrotRenderer = new RenderParrot(Minecraft.func_71410_x().func_175598_ae());

        public void doRenderLayer(MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (playerEntity.hasParrot) {
                this.renderParrot(playerEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, 0);
            }
        }

        private void renderParrot(MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, int parrotVariant) {
            this.parrotRenderer.func_110776_a(RenderParrot.field_192862_a[parrotVariant]);
            GlStateManager.func_179094_E();
            float f = playerEntity.func_70093_af() ? -1.3f : -1.5f;
            float f1 = -0.4f;
            GlStateManager.func_179109_b((float)f1, (float)f, (float)0.0f);
            this.parrotModel.func_78086_a((EntityLivingBase)playerEntity, limbSwing, limbSwingAmount, partialTicks);
            this.parrotModel.func_78087_a(limbSwing, limbSwingAmount, 0.0f, netHeadYaw, headPitch, scale, (Entity)playerEntity);
            this.parrotModel.func_78088_a((Entity)playerEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179121_F();
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    public static class MenuPlayerCapeLayer
    implements LayerRenderer<MenuPlayerEntity> {
        private MenuPlayerRenderer render;

        public MenuPlayerCapeLayer(MenuPlayerRenderer menuPlayerRenderer) {
            this.render = menuPlayerRenderer;
        }

        public void doRenderLayer(MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (playerEntity.hasCape()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.render.func_110776_a(playerEntity.getCape());
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.125);
                double d0 = MathHelper.func_151238_b((double)partialTicks, (double)playerEntity.field_71091_bM, (double)playerEntity.field_71094_bP) - MathHelper.func_151238_b((double)partialTicks, (double)playerEntity.field_70169_q, (double)playerEntity.field_70165_t);
                double d1 = MathHelper.func_151238_b((double)partialTicks, (double)playerEntity.field_71096_bN, (double)playerEntity.field_71095_bQ) - MathHelper.func_151238_b((double)partialTicks, (double)playerEntity.field_70167_r, (double)playerEntity.field_70163_u);
                double d2 = MathHelper.func_151238_b((double)partialTicks, (double)playerEntity.field_71097_bO, (double)playerEntity.field_71085_bR) - MathHelper.func_151238_b((double)partialTicks, (double)playerEntity.field_70166_s, (double)playerEntity.field_70161_v);
                float f = playerEntity.field_70760_ar + (playerEntity.field_70761_aq - playerEntity.field_70760_ar);
                double d3 = MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
                double d4 = -MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
                float f1 = (float)d1 * 10.0f;
                f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
                float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)150.0f);
                float f4 = (float)MathHelper.func_151238_b((double)partialTicks, (double)playerEntity.field_71107_bF, (double)playerEntity.field_71109_bG);
                f1 += MathHelper.func_76126_a((float)((float)(MathHelper.func_151238_b((double)partialTicks, (double)playerEntity.field_70141_P, (double)playerEntity.field_70140_Q) * 6.0))) * 32.0f * f4;
                if (playerEntity.func_70093_af()) {
                    f1 += 25.0f;
                }
                GlStateManager.func_179114_b((float)(6.0f + f2 / 2.0f + f1), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.render.getMainModel().func_178728_c(0.0625f);
                GlStateManager.func_179121_F();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    public static class MenuPlayerEntity
    extends EntityPlayer {
        public volatile ResourceLocation skinLocation;
        public volatile ResourceLocation capeLocation;
        private volatile boolean capeChecked = false;
        private volatile boolean capeGettingChecked = false;
        private volatile boolean skinChecked = false;
        private volatile boolean skinGettingChecked = false;
        private volatile boolean slimSkin = false;
        private volatile boolean slimSkinChecked = false;
        private volatile boolean slimSkinGettingChecked = false;
        public boolean hasParrot = false;
        public boolean crouching = false;
        public boolean showName = true;
        public volatile String playerName;
        private volatile Runnable getSkinCallback;
        private volatile Runnable getCapeCallback;

        public MenuPlayerEntity(String playerName) {
            super(DUMMY_WORLD, new GameProfile(EntityPlayer.func_175147_b((String)MenuPlayerEntity.getRawPlayerName(playerName)), MenuPlayerEntity.getRawPlayerName(playerName)));
            if (playerName != null) {
                this.playerName = playerName;
            }
        }

        private static String getRawPlayerName(String playerName) {
            if (playerName == null) {
                return "steve";
            }
            return playerName;
        }

        public boolean func_175149_v() {
            return false;
        }

        public boolean func_184812_l_() {
            return false;
        }

        public boolean func_70093_af() {
            return this.crouching;
        }

        public ITextComponent func_145748_c_() {
            if (this.playerName != null) {
                return new TextComponentString(this.playerName);
            }
            return new TextComponentString("steve");
        }

        public void setSlimSkin(boolean slim) {
            this.slimSkin = slim;
            this.slimSkinChecked = true;
        }

        public boolean isSlimSkin() {
            if (this.playerName != null && !this.slimSkinChecked) {
                if (!PlayerEntityCache.isSlimSkinInfoCached(this.playerName)) {
                    if (!this.slimSkinGettingChecked) {
                        this.slimSkinGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    boolean b = PlayerEntityCustomizationItem.getIsSlimSkin(playerName);
                                    if (!slimSkinChecked) {
                                        slimSkin = b;
                                        PlayerEntityCache.cacheIsSlimSkin(playerName, b);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                slimSkinChecked = true;
                                slimSkinGettingChecked = false;
                            }
                        }).start();
                    }
                } else {
                    this.slimSkin = PlayerEntityCache.getIsSlimSkin(this.playerName);
                    this.slimSkinChecked = true;
                }
            }
            return this.slimSkin;
        }

        public boolean hasNonDefaultSkin() {
            return this.skinLocation != DefaultPlayerSkin.func_177335_a();
        }

        public boolean hasCape() {
            return this.getCape() != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ResourceLocation getSkin() {
            if (this.getSkinCallback != null) {
                this.getSkinCallback.run();
                this.getSkinCallback = null;
            }
            if (this.playerName != null) {
                if (this.skinLocation != null) return this.skinLocation;
                if (!this.skinChecked) {
                    if (!PlayerEntityCache.isSkinCached(this.playerName)) {
                        if (this.skinGettingChecked) return DefaultPlayerSkin.func_177335_a();
                        this.skinGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    final String skinUrl = PlayerEntityCustomizationItem.getSkinURL(playerName);
                                    if (skinLocation == null) {
                                        if (skinUrl == null) {
                                            skinLocation = DefaultPlayerSkin.func_177335_a();
                                            slimSkin = false;
                                            slimSkinChecked = true;
                                        } else if (getSkinCallback == null) {
                                            getSkinCallback = new Runnable(){

                                                @Override
                                                public void run() {
                                                    WebTextureResourceLocation wt = TextureHandler.getWebResource((String)skinUrl);
                                                    if (skinLocation == null) {
                                                        if (wt != null) {
                                                            if (wt.getHeight() < 64) {
                                                                wt = new SkinWebTextureResourceLocation(skinUrl);
                                                                wt.loadTexture();
                                                            }
                                                            skinLocation = wt.getResourceLocation();
                                                            PlayerEntityCache.cacheSkin(playerName, wt.getResourceLocation());
                                                        } else {
                                                            skinLocation = DefaultPlayerSkin.func_177335_a();
                                                            slimSkin = false;
                                                            slimSkinChecked = true;
                                                        }
                                                    }
                                                }
                                            };
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                skinChecked = true;
                                skinGettingChecked = false;
                            }
                        }).start();
                        return this.skinLocation;
                    } else {
                        this.skinLocation = PlayerEntityCache.getSkin(this.playerName);
                        this.skinChecked = true;
                    }
                    return this.skinLocation;
                } else {
                    this.skinLocation = DefaultPlayerSkin.func_177335_a();
                    this.slimSkin = false;
                    this.slimSkinChecked = true;
                }
                return this.skinLocation;
            } else {
                if (this.skinLocation != null) return this.skinLocation;
                this.skinLocation = DefaultPlayerSkin.func_177335_a();
                this.slimSkin = false;
                this.slimSkinChecked = true;
            }
            return this.skinLocation;
        }

        public ResourceLocation getCape() {
            if (this.getCapeCallback != null) {
                this.getCapeCallback.run();
                this.getCapeCallback = null;
            }
            if (this.playerName != null && this.capeLocation == null && !this.capeChecked) {
                if (!PlayerEntityCache.isCapeCached(this.playerName)) {
                    if (!this.capeGettingChecked) {
                        this.capeGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    final String capeUrl = PlayerEntityCustomizationItem.getCapeURL(playerName);
                                    if (!capeChecked && capeUrl != null && getCapeCallback == null) {
                                        getCapeCallback = new Runnable(){

                                            @Override
                                            public void run() {
                                                WebTextureResourceLocation wt = TextureHandler.getWebResource((String)capeUrl);
                                                if (wt != null) {
                                                    capeLocation = wt.getResourceLocation();
                                                    PlayerEntityCache.cacheCape(playerName, wt.getResourceLocation());
                                                }
                                            }
                                        };
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                capeGettingChecked = false;
                                capeChecked = true;
                            }
                        }).start();
                    }
                } else {
                    this.capeLocation = PlayerEntityCache.getCape(this.playerName);
                    this.capeChecked = true;
                }
            }
            return this.capeLocation;
        }
    }

    public static class MenuPlayerRenderer
    extends RenderLivingBase<MenuPlayerEntity> {
        public MenuPlayerRenderer(boolean useSmallArms) {
            super(Minecraft.func_71410_x().func_175598_ae(), (ModelBase)new ModelPlayer(0.0f, useSmallArms), 0.5f);
            this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
            this.func_177094_a(new MenuPlayerCapeLayer(this));
            this.func_177094_a((LayerRenderer)new LayerCustomHead(this.getMainModel().field_78116_c));
            this.func_177094_a(new MenuPlayerParrotLayer());
        }

        public Vec3d getRenderOffset(MenuPlayerEntity entityIn, float partialTicks) {
            return entityIn.func_70093_af() ? new Vec3d(0.0, -0.125, 0.0) : Vec3d.field_186680_a;
        }

        public void doRender(MenuPlayerEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
            boolean shouldSit;
            double d0 = y;
            if (entity.func_70093_af()) {
                d0 = y - 0.125;
            }
            this.setModelVisibilities(entity);
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            this.field_77045_g.field_78095_p = this.func_77040_d((EntityLivingBase)entity, partialTicks);
            this.field_77045_g.field_78093_q = shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
            this.field_77045_g.field_78091_s = entity.func_70631_g_();
            try {
                float f = this.func_77034_a(entity.field_70760_ar, entity.field_70761_aq, partialTicks);
                float f1 = this.func_77034_a(entity.field_70758_at, entity.field_70759_as, partialTicks);
                float f2 = f1 - f;
                if (shouldSit && entity.func_184187_bx() instanceof EntityLivingBase) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity.func_184187_bx();
                    f = this.func_77034_a(entitylivingbase.field_70760_ar, entitylivingbase.field_70761_aq, partialTicks);
                    f2 = f1 - f;
                    float f3 = MathHelper.func_76142_g((float)f2);
                    if (f3 < -85.0f) {
                        f3 = -85.0f;
                    }
                    if (f3 >= 85.0f) {
                        f3 = 85.0f;
                    }
                    f = f1 - f3;
                    if (f3 * f3 > 2500.0f) {
                        f += f3 * 0.2f;
                    }
                    f2 = f1 - f;
                }
                float f7 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
                this.func_77039_a((EntityLivingBase)entity, x, d0, z);
                float f8 = this.func_77044_a((EntityLivingBase)entity, partialTicks);
                this.applyRotations(entity, f8, f, partialTicks);
                float f4 = this.func_188322_c((EntityLivingBase)entity, partialTicks);
                float f5 = 0.0f;
                float f6 = 0.0f;
                if (!entity.func_184218_aH()) {
                    f5 = entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * partialTicks;
                    f6 = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
                    if (entity.func_70631_g_()) {
                        f6 *= 3.0f;
                    }
                    if (f5 > 1.0f) {
                        f5 = 1.0f;
                    }
                    f2 = f1 - f;
                }
                GlStateManager.func_179141_d();
                this.field_77045_g.func_78086_a((EntityLivingBase)entity, f6, f5, partialTicks);
                this.field_77045_g.func_78087_a(f6, f5, f8, f2, f7, f4, (Entity)entity);
                if (this.field_188301_f) {
                    if (!this.field_188323_j) {
                        this.func_77036_a((EntityLivingBase)entity, f6, f5, f8, f2, f7, f4);
                    }
                    if (!(entity instanceof EntityPlayer) || !entity.func_175149_v()) {
                        this.func_177093_a((EntityLivingBase)entity, f6, f5, partialTicks, f8, f2, f7, f4);
                    }
                } else {
                    this.func_77036_a((EntityLivingBase)entity, f6, f5, f8, f2, f7, f4);
                    GlStateManager.func_179132_a((boolean)true);
                    if (!(entity instanceof EntityPlayer) || !entity.func_175149_v()) {
                        this.func_177093_a((EntityLivingBase)entity, f6, f5, partialTicks, f8, f2, f7, f4);
                    }
                    GlStateManager.func_179132_a((boolean)false);
                }
                GlStateManager.func_179101_C();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
            if (!this.field_188301_f) {
                this.renderName(entity, x, d0, z);
            }
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        }

        public ModelPlayer getMainModel() {
            return (ModelPlayer)super.func_177087_b();
        }

        private void setModelVisibilities(MenuPlayerEntity clientPlayer) {
            ModelPlayer playermodel = this.getMainModel();
            playermodel.func_178719_a(true);
            playermodel.field_178720_f.field_78806_j = true;
            playermodel.field_178730_v.field_78806_j = true;
            playermodel.field_178733_c.field_78806_j = true;
            playermodel.field_178731_d.field_78806_j = true;
            playermodel.field_178734_a.field_78806_j = true;
            playermodel.field_178732_b.field_78806_j = true;
            playermodel.field_78117_n = clientPlayer.func_70093_af();
        }

        public ResourceLocation getEntityTexture(MenuPlayerEntity entity) {
            ResourceLocation l = entity.getSkin();
            if (l != null) {
                return l;
            }
            return DefaultPlayerSkin.func_177335_a();
        }

        protected boolean canRenderName(MenuPlayerEntity entity) {
            return entity.showName && entity.playerName != null;
        }

        public void renderName(MenuPlayerEntity playerEntity, double x, double y, double z) {
            if (playerEntity.showName) {
                boolean flag = playerEntity.func_70093_af();
                float f = Minecraft.func_71410_x().func_175598_ae().field_78735_i;
                float f1 = Minecraft.func_71410_x().func_175598_ae().field_78732_j;
                boolean flag1 = Minecraft.func_71410_x().field_71474_y.field_74320_O == 2;
                float f2 = playerEntity.field_70131_O + 0.5f - (flag ? 0.25f : 0.0f);
                int i = "deadmau5".equals(playerEntity.func_145748_c_().func_150254_d()) ? -10 : 0;
                EntityRenderer.func_189692_a((FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)playerEntity.func_145748_c_().func_150254_d(), (float)((float)x), (float)((float)y + f2), (float)((float)z), (int)i, (float)f, (float)f1, (boolean)flag1, (boolean)flag);
            }
        }

        protected void preRenderCallback(MenuPlayerEntity entitylivingbaseIn, float partialTickTime) {
            GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
        }

        protected void applyRotations(MenuPlayerEntity entityLiving, float p_77043_2_, float rotationYaw, float partialTicks) {
            if (entityLiving.func_70089_S() && entityLiving.func_70608_bn()) {
                GlStateManager.func_179114_b((float)entityLiving.func_71051_bG(), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)this.func_77037_a((EntityLivingBase)entityLiving), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (entityLiving.func_184613_cA()) {
                super.func_77043_a((EntityLivingBase)entityLiving, p_77043_2_, rotationYaw, partialTicks);
                float f = (float)entityLiving.func_184599_cB() + partialTicks;
                float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)(f1 * (-90.0f - entityLiving.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
                Vec3d vec3d = entityLiving.func_70676_i(partialTicks);
                double d0 = entityLiving.field_70159_w * entityLiving.field_70159_w + entityLiving.field_70179_y * entityLiving.field_70179_y;
                double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
                if (d0 > 0.0 && d1 > 0.0) {
                    double d2 = (entityLiving.field_70159_w * vec3d.field_72450_a + entityLiving.field_70179_y * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                    double d3 = entityLiving.field_70159_w * vec3d.field_72449_c - entityLiving.field_70179_y * vec3d.field_72450_a;
                    GlStateManager.func_179114_b((float)((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
                }
            } else {
                super.func_77043_a((EntityLivingBase)entityLiving, p_77043_2_, rotationYaw, partialTicks);
            }
        }
    }
}

