/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.util.Bounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRangeHood
extends BlockFurniture {
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final AxisAlignedBB[] COLLISION_VENTILATION = new Bounds(0.5, 0.0, 0.2, 1.0, 1.0, 0.8).getRotatedBounds();
    public static final AxisAlignedBB COLLISION_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockRangeHood(Material material, boolean powered) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185852_e);
        if (powered) {
            this.func_149715_a(0.5f);
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected List<AxisAlignedBB> getCollisionBoxList(IBlockState state, World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boxes.add(COLLISION_VENTILATION[facing.func_176736_b()]);
        if (!((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            boxes.add(COLLISION_BASE);
        }
        return boxes;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)world, pos), world, pos);
        for (AxisAlignedBB box : list) {
            BlockRangeHood.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)world, pos), world, pos)) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this == FurnitureBlocks.RANGE_HOOD) {
            worldIn.func_175656_a(pos, FurnitureBlocks.RANGE_HOOD_POWERED.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
        } else if (this == FurnitureBlocks.RANGE_HOOD_POWERED) {
            worldIn.func_175656_a(pos, FurnitureBlocks.RANGE_HOOD.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        if (downState.func_177230_c() instanceof BlockRangeHood && downState.func_177229_b((IProperty)FACING) == state.func_177229_b((IProperty)FACING)) {
            state = state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, DOWN});
    }
}

