/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.client.render.entity;

import com.google.common.collect.Maps;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoricSwimming;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.util.ResourceLocation;

public class RenderPrehistoric
extends RenderLiving<EntityPrehistoric> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();

    public RenderPrehistoric(ModelBase model) {
        super(Minecraft.func_71410_x().func_175598_ae(), model, 0.3f);
    }

    protected ResourceLocation getEntityTexture(EntityPrehistoric entity) {
        String s = entity.getTexture();
        ResourceLocation resourcelocation = LAYERED_LOCATION_CACHE.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            LAYERED_LOCATION_CACHE.put(s, resourcelocation);
        }
        return resourcelocation;
    }

    protected void preRenderCallback(EntityPrehistoric entity, float f) {
        float xRot = 0.0f;
        if (entity instanceof EntityPrehistoricSwimming) {
            EntityPrehistoricSwimming aquatic = (EntityPrehistoricSwimming)entity;
            xRot = aquatic.prevBreachPitch + (aquatic.getBreachPitch() - aquatic.prevBreachPitch) * f;
            GlStateManager.func_179114_b((float)xRot, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float scale = entity.getGender() == 1 ? entity.getMaleSize() * entity.getAgeScale() : 1.0f * entity.getAgeScale();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        this.field_76989_e = entity.field_70130_N * 0.45f;
    }

    protected float getDeathMaxRotation(EntityPrehistoric entity) {
        return entity.getDeathRotation();
    }
}

