/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.Revival;
import fossilsarcheology.server.api.BlockEntity;
import fossilsarcheology.server.api.DefaultRenderedItem;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.entity.TileEntityAnalyzer;
import fossilsarcheology.server.tab.FATabRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnalyzerBlock
extends BlockContainer
implements DefaultRenderedItem,
BlockEntity {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static boolean keepInventory = false;

    public AnalyzerBlock(boolean isActive) {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185852_e);
        if (isActive) {
            this.func_149715_a(0.9375f);
            this.func_149663_c("analyzer_active");
        } else {
            this.func_149663_c("analyzer");
            this.func_149647_a(FATabRegistry.BLOCKS);
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public static void setState(boolean isActive, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing facing = EnumFacing.NORTH;
        if (world.func_180495_p(pos).func_177230_c() instanceof AnalyzerBlock) {
            facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        }
        keepInventory = true;
        if (isActive) {
            world.func_175656_a(pos, FABlockRegistry.ANALYZER_ACTIVE.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing));
        } else {
            world.func_175656_a(pos, FABlockRegistry.ANALYZER.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing));
        }
        keepInventory = false;
        if (tile != null) {
            tile.func_145829_t();
            world.func_175690_a(pos, tile);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Item.func_150898_a((Block)FABlockRegistry.ANALYZER);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState north = world.func_180495_p(pos.func_177978_c());
            IBlockState south = world.func_180495_p(pos.func_177968_d());
            IBlockState west = world.func_180495_p(pos.func_177976_e());
            IBlockState east = world.func_180495_p(pos.func_177974_f());
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (facing == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
                facing = EnumFacing.SOUTH;
            } else if (facing == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
                facing = EnumFacing.NORTH;
            } else if (facing == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
                facing = EnumFacing.EAST;
            } else if (facing == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
                facing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)Revival.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile;
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s() && (tile = world.func_175625_s(pos)) instanceof TileEntityAnalyzer) {
            ((TileEntityAnalyzer)tile).setCustomName(stack.func_82833_r());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropInventory(world, pos);
        super.func_180663_b(world, pos, state);
    }

    private void dropInventory(World world, BlockPos pos) {
        if (!keepInventory || !(world.func_180495_p(pos).func_177230_c() instanceof AnalyzerBlock)) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity == null) {
                return;
            }
            if (entity instanceof TileEntityAnalyzer) {
                TileEntityAnalyzer analyzer = (TileEntityAnalyzer)entity;
                for (int i = 0; i < analyzer.func_70302_i_(); ++i) {
                    ItemStack stack = analyzer.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
                }
            }
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityAnalyzer();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_175625_s(pos)));
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)FABlockRegistry.ANALYZER);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public Class<? extends TileEntity> getEntity() {
        return TileEntityAnalyzer.class;
    }
}

