/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.server.api.DefaultRenderedItem;
import fossilsarcheology.server.tab.FATabRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class FourTallFlowerBlock
extends BlockBush
implements DefaultRenderedItem,
IGrowable {
    public static final PropertyInteger LAYER = PropertyInteger.func_177719_a((String)"layer", (int)0, (int)3);
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, 1.0, (double)0.7f);

    public FourTallFlowerBlock(String name) {
        super(Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LAYER, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149663_c(name);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(FATabRegistry.BLOCKS);
        this.func_149711_c(0.5f);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && (Integer)state.func_177229_b((IProperty)LAYER) == 0) {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        if (state.func_177230_c() == this && (Integer)state.func_177229_b((IProperty)LAYER) != 0) {
            IBlockState below = worldIn.func_180495_p(pos.func_177977_b());
            return below.func_177230_c() == this;
        }
        return this.func_185514_i(worldIn.func_180495_p(pos.func_177977_b()));
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.spreadAsBonemeal(worldIn, pos);
    }

    protected void func_176475_e(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            if ((Integer)state.func_177229_b((IProperty)LAYER) == 0) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_175623_d(pos.func_177981_b(2)) && worldIn.func_175623_d(pos.func_177981_b(3));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)LAYER, (Comparable)Integer.valueOf(0)), 2);
        worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)LAYER, (Comparable)Integer.valueOf(1)), 2);
        worldIn.func_180501_a(pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)LAYER, (Comparable)Integer.valueOf(2)), 2);
        worldIn.func_180501_a(pos.func_177981_b(3), this.func_176223_P().func_177226_a((IProperty)LAYER, (Comparable)Integer.valueOf(3)), 2);
    }

    private void spreadAsBonemeal(World world, BlockPos pos) {
        Random rand = new Random();
        if (world.field_72995_K) {
            world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)pos.func_177958_n() + (rand.nextDouble() - 0.5), (double)pos.func_177956_o() + rand.nextDouble(), (double)pos.func_177952_p() + (rand.nextDouble() - 0.5), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)pos.func_177958_n() + (rand.nextDouble() - 0.5), (double)pos.func_177956_o() + rand.nextDouble(), (double)pos.func_177952_p() + (rand.nextDouble() - 0.5), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)pos.func_177958_n() + (rand.nextDouble() - 0.5), (double)pos.func_177956_o() + rand.nextDouble(), (double)pos.func_177952_p() + (rand.nextDouble() - 0.5), 0.0, 0.0, 0.0, new int[0]);
        }
        int maxTries = rand.nextInt(3);
        int tries = 0;
        for (int timeout = 0; tries < maxTries && timeout < 101; ++timeout) {
            BlockPos tryPos = pos.func_177982_a(rand.nextInt(10) - 4, rand.nextInt(8) - 4, rand.nextInt(10) - 4);
            if (!world.func_175623_d(tryPos.func_177984_a()) || !world.func_175623_d(tryPos.func_177981_b(2)) || !world.func_175623_d(tryPos.func_177981_b(3)) || !world.func_175623_d(tryPos.func_177981_b(4)) || !this.func_185514_i(world.func_180495_p(tryPos))) continue;
            ++tries;
            if (world.field_72995_K) continue;
            world.func_180501_a(tryPos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)LAYER, (Comparable)Integer.valueOf(0)), 2);
            world.func_180501_a(tryPos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)LAYER, (Comparable)Integer.valueOf(1)), 2);
            world.func_180501_a(tryPos.func_177981_b(3), this.func_176223_P().func_177226_a((IProperty)LAYER, (Comparable)Integer.valueOf(2)), 2);
            world.func_180501_a(tryPos.func_177981_b(4), this.func_176223_P().func_177226_a((IProperty)LAYER, (Comparable)Integer.valueOf(3)), 2);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if ((Integer)state.func_177229_b((IProperty)LAYER) == 0) {
            worldIn.func_175655_b(pos, true);
            for (int i = 1; i < 3; ++i) {
                if (worldIn.func_180495_p(pos.func_177981_b(i)).func_177230_c() != this) continue;
                worldIn.func_175655_b(pos.func_177981_b(i), false);
            }
        } else {
            worldIn.func_175655_b(pos, false);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LAYER, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYER);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LAYER});
    }
}

