/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.compat.tinkers;

import fossilsarcheology.Revival;
import fossilsarcheology.server.block.FAFluidRegistry;
import fossilsarcheology.server.compat.tinkers.ModifierArcheology;
import fossilsarcheology.server.compat.tinkers.ModifierScarab;
import fossilsarcheology.server.compat.tinkers.TraitLightning;
import fossilsarcheology.server.entity.monster.EntityTarSlime;
import fossilsarcheology.server.item.FAItemRegistry;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTraits;
import slimeknights.tconstruct.tools.traits.TraitSlimey;

public class TinkersCompat {
    public static final Material ancientMetal = new Material("ancient_metal", 14686208);
    public static final Material tarSlime = new Material("tar_slime", 0x222222);
    public static final AbstractTrait lightningTrait = new TraitLightning();
    public static final AbstractTrait tarSlimeTrait = new TraitSlimey("tar", EntityTarSlime.class);
    private static final TinkersCompat INSTANCE = new TinkersCompat();
    public static AbstractTrait fossilModifier = new ModifierArcheology(true);
    public static AbstractTrait archeologistModifier = new ModifierArcheology(false);
    public static ModifierScarab scarabModifier = new ModifierScarab();
    private static boolean registered = false;

    static void register() {
        if (registered) {
            throw new RuntimeException("You can only call TinkersCompat.register() once");
        }
        registered = true;
        Revival.LOGGER.info("Started Tinkers integration for FossilsArcheology");
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        TinkersCompat.init();
    }

    static void init() {
        TinkerMaterials.materials.add(ancientMetal);
        TinkerMaterials.materials.add(tarSlime);
        TinkerRegistry.integrate((Material)ancientMetal).preInit();
        TinkerRegistry.integrate((Material)tarSlime).preInit();
        ancientMetal.addTrait((ITrait)lightningTrait);
        ancientMetal.addTrait((ITrait)TinkerTraits.crude);
        ancientMetal.addItem((Item)FAItemRegistry.BROKEN_SWORD, 1, 144);
        ancientMetal.addItem((Item)FAItemRegistry.BROKEN_HELMET, 1, 144);
        ancientMetal.setRepresentativeItem((Item)FAItemRegistry.BROKEN_SWORD);
        ancientMetal.setCraftable(true);
        ancientMetal.setCastable(false);
        TinkerRegistry.addMaterialStats((Material)ancientMetal, (IMaterialStats)new HeadMaterialStats(220, 5.0f, 4.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 10), new ExtraMaterialStats(25)});
        TinkerRegistry.addMaterialStats((Material)ancientMetal, (IMaterialStats)new BowMaterialStats(0.6f, 1.7f, 6.0f));
        tarSlime.addTrait((ITrait)tarSlimeTrait);
        tarSlime.setCastable(true);
        tarSlime.setCraftable(false);
        tarSlime.addItem((Item)FAItemRegistry.TARDROP, 1, 16);
        tarSlime.setRepresentativeItem((Item)FAItemRegistry.TARDROP);
        tarSlime.setFluid(FAFluidRegistry.TAR_FLUID);
        TinkerRegistry.registerMelting((Item)FAItemRegistry.TARDROP, (Fluid)FAFluidRegistry.TAR_FLUID, (int)16);
        TinkerRegistry.registerMelting((Item)Items.field_151044_h, (Fluid)FAFluidRegistry.TAR_FLUID, (int)16);
        TinkerRegistry.registerMelting((Item)FAItemRegistry.TAR_FOSSIL, (Fluid)FAFluidRegistry.TAR_FLUID, (int)16);
        TinkerRegistry.addMaterialStats((Material)tarSlime, (IMaterialStats)new HeadMaterialStats(800, 3.0f, 3.0f, 0), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.6f, 50), new ExtraMaterialStats(400)});
        TinkerRegistry.addMaterialStats((Material)tarSlime, (IMaterialStats)new BowMaterialStats(0.5f, 2.3f, 6.0f));
        fossilModifier.addItem((Item)FAItemRegistry.BIOFOSSIL);
        fossilModifier.addItem((Item)FAItemRegistry.TAR_FOSSIL);
        fossilModifier.addItem("fossil");
        fossilModifier.addItem("fossil", 1, 1);
        fossilModifier.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack((Item)FAItemRegistry.BIOFOSSIL)}));
        fossilModifier.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack((Item)FAItemRegistry.TAR_FOSSIL)}));
        archeologistModifier.addItem((Item)FAItemRegistry.RELIC_SCRAP);
        archeologistModifier.addItem("artifact");
        archeologistModifier.addItem("artifact", 1, 1);
        archeologistModifier.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack((Item)FAItemRegistry.RELIC_SCRAP)}));
        scarabModifier.addItem(FAItemRegistry.SCARAB_GEM);
        scarabModifier.addItem("gemScarab");
        scarabModifier.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack((Item)FAItemRegistry.SCARAB_GEM)}));
    }

    public static void post() {
        TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(new ItemStack((Item)FAItemRegistry.TAR_FOSSIL), RecipeMatch.of((String)"fossil"), FAFluidRegistry.TAR_FLUID, 16, true, false));
        TinkerRegistry.registerTableCasting((ItemStack)new ItemStack((Item)FAItemRegistry.TARDROP), (ItemStack)TinkerSmeltery.castNugget, (Fluid)FAFluidRegistry.TAR_FLUID, (int)16);
    }
}

