/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.entity.ai.DinoAIEatFeedersAndBlocks;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFollowOwner;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAIHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtTarget;
import fossilsarcheology.server.entity.ai.DinoAIRiding;
import fossilsarcheology.server.entity.ai.DinoAIWander;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.entity.ai.DinoMeleeAttackAI;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.IScaryDinosaur;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import fossilsarcheology.server.item.FAItemRegistry;
import java.util.function.Predicate;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityTyrannosaurus
extends EntityPrehistoric
implements IScaryDinosaur {
    public static final Animation ROAR_ANIMATION = Animation.create((int)100);

    public EntityTyrannosaurus(World world) {
        super(world, PrehistoricEntityType.TYRANNOSAURUS, 2.0, 14.0, 15.0, 82.0, 0.2, 0.3, 0.0, 7.0);
        this.setActualSize(1.3f, 1.25f);
        this.pediaScale = 40.0f;
        this.minSize = 0.2f;
        this.maxSize = 2.8f;
        this.teenAge = 5;
        this.developsResistance = true;
        this.breaksBlocks = true;
        this.nearByMobsAllowed = 2;
        this.ridingY = 1.625f;
        this.ridingXZ = -0.05f;
        this.field_70138_W = 1.0f;
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoMeleeAttackAI(this, 1.5, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIEatFeedersAndBlocks(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new DinoAIEatItems(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIRiding(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new DinoAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new DinoAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new DinoAIHurtByTarget(this));
        this.field_70715_bh.func_75776_a(4, new DinoAIHunt<EntityLivingBase>(this, EntityLivingBase.class, true, (Predicate<EntityLivingBase>)((com.google.common.base.Predicate)entity -> entity instanceof EntityLivingBase)));
    }

    @Override
    public float getTargetScale() {
        return 2.0f;
    }

    @Override
    public int getAttackLength() {
        return 30;
    }

    @Override
    public int getSpeakLength() {
        return 40;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAnimation() == this.ATTACK_ANIMATION && this.canReachPrey() && this.getAnimationTick() == 12 && this.func_70638_az() != null) {
            this.doAttack();
            this.doAttackKnockback(1.0f);
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.getAnimation() != this.ATTACK_ANIMATION) {
            this.setAnimation(this.ATTACK_ANIMATION);
        }
        return false;
    }

    @Override
    public void setSpawnValues() {
    }

    @Override
    public PrehistoricEntityTypeAI.Activity aiActivityType() {
        return PrehistoricEntityTypeAI.Activity.DIURINAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Attacking aiAttackType() {
        return PrehistoricEntityTypeAI.Attacking.DROP;
    }

    @Override
    public PrehistoricEntityTypeAI.Climbing aiClimbType() {
        return PrehistoricEntityTypeAI.Climbing.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Following aiFollowType() {
        return PrehistoricEntityTypeAI.Following.AGRESSIVE;
    }

    @Override
    public PrehistoricEntityTypeAI.Jumping aiJumpType() {
        return PrehistoricEntityTypeAI.Jumping.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Response aiResponseType() {
        return this.func_70631_g_() ? PrehistoricEntityTypeAI.Response.SCARED : PrehistoricEntityTypeAI.Response.AGRESSIVE;
    }

    @Override
    public PrehistoricEntityTypeAI.Stalking aiStalkType() {
        return PrehistoricEntityTypeAI.Stalking.STEALTH;
    }

    @Override
    public PrehistoricEntityTypeAI.Taming aiTameType() {
        return PrehistoricEntityTypeAI.Taming.GEM;
    }

    @Override
    public PrehistoricEntityTypeAI.Untaming aiUntameType() {
        return PrehistoricEntityTypeAI.Untaming.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Moving aiMovingType() {
        return PrehistoricEntityTypeAI.Moving.WALK;
    }

    @Override
    public PrehistoricEntityTypeAI.WaterAbility aiWaterAbilityType() {
        return PrehistoricEntityTypeAI.WaterAbility.NONE;
    }

    @Override
    public boolean doesFlock() {
        return false;
    }

    @Override
    public Item getOrderItem() {
        return FAItemRegistry.SKULL_STICK;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this.isSleeping() || this.field_70146_Z.nextInt(1500) != 0 || this.field_70170_p.field_72995_K || this.isSkeleton() || this.isActuallyWeak() || this.func_70906_o() || this.func_70638_az() != null || this.getAnimation() != NO_ANIMATION)) {
            this.setAnimation(ROAR_ANIMATION);
        }
        if (this.getAnimation() == ROAR_ANIMATION && this.getAnimationTick() == 10) {
            this.func_184185_a(FASoundRegistry.TYRANNOSAURUS_ROAR, this.func_70647_i(), this.func_70599_aP());
        }
    }

    private void triggerTamingAcheivement(EntityPlayer player) {
    }

    @Override
    public AxisAlignedBB getAttackBounds() {
        float size = this.func_70603_bj() * 0.25f;
        return this.func_174813_aQ().func_72314_b((double)(4.0f + size), (double)(2.0f + size), (double)(4.0f + size));
    }

    @Override
    public int getAdultAge() {
        return 12;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{this.SPEAK_ANIMATION, this.ATTACK_ANIMATION, ROAR_ANIMATION};
    }

    @Override
    public int getTailSegments() {
        return 3;
    }

    @Override
    public int getMaxHunger() {
        return 150;
    }

    @Override
    public void func_70645_a(DamageSource source) {
        if (source.func_76346_g() == null || source.func_76346_g() instanceof EntityPlayer) {
            // empty if block
        }
        super.func_70645_a(source);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.isWeak() ? FASoundRegistry.TYRANNOSAURUS_WEAK : FASoundRegistry.TYRANNOSAURUS_LIVING;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FASoundRegistry.TYRANNOSAURUS_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return FASoundRegistry.TYRANNOSAURUS_DEATH;
    }

    @Override
    public boolean canBeRidden() {
        return true;
    }

    @Override
    public float getProximityToNextPathSkip() {
        return (float)this.func_174813_aQ().func_72320_b() * 0.8f;
    }
}

