/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.api.Recipes;
import com.mrcrayfish.furniture.gui.containers.ContainerFreezer;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.tileentity.TileEntityFurniture;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityFreezer
extends TileEntityFurniture
implements ISidedInventory,
ITickable {
    private static final int[] slots_bottom = new int[]{2};
    private static final int[] slots_sides = new int[]{0, 1};
    private boolean freezing = false;
    public int progress = 0;
    public int timeRemaining = 0;
    public int fuelTime = 0;

    public TileEntityFreezer() {
        super("freezer", 3);
    }

    public void startFreezing() {
        if (this.canFreeze()) {
            if (this.timeRemaining == 0) {
                this.timeRemaining = this.fuelTime = TileEntityFreezer.getFuelTime((ItemStack)this.inventory.get(0));
                ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                if (((ItemStack)this.inventory.get(0)).func_190916_E() <= 0) {
                    this.func_70304_b(0);
                }
            }
            this.freezing = true;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
        }
    }

    public void stopFreezing() {
        this.freezing = false;
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
    }

    public boolean canFreeze() {
        if (this.inventory.get(0) == ItemStack.field_190927_a && this.timeRemaining == 0) {
            return false;
        }
        if (this.inventory.get(0) != ItemStack.field_190927_a && this.timeRemaining == 0 && !TileEntityFreezer.isFuel((ItemStack)this.inventory.get(0))) {
            return false;
        }
        if (this.inventory.get(1) != ItemStack.field_190927_a) {
            RecipeData data = Recipes.getFreezerRecipeFromInput((ItemStack)this.inventory.get(1));
            if (data == null) {
                return false;
            }
            if (this.inventory.get(2) == ItemStack.field_190927_a) {
                return true;
            }
            if (((ItemStack)this.inventory.get(2)).func_77973_b() != data.getOutput().func_77973_b()) {
                return false;
            }
            if (((ItemStack)this.inventory.get(2)).func_190916_E() < this.func_70297_j_() && ((ItemStack)this.inventory.get(2)).func_190916_E() < ((ItemStack)this.inventory.get(2)).func_77976_d()) {
                return true;
            }
        }
        return false;
    }

    public void freezeItem() {
        if (this.inventory.get(1) != ItemStack.field_190927_a) {
            RecipeData data = Recipes.getFreezerRecipeFromInput((ItemStack)this.inventory.get(1));
            if (data == null) {
                return;
            }
            if (this.inventory.get(2) == ItemStack.field_190927_a) {
                this.inventory.set(2, (Object)data.getOutput().func_77946_l());
            } else if (((ItemStack)this.inventory.get(2)).func_77973_b() == data.getOutput().func_77973_b() && ((ItemStack)this.inventory.get(2)).func_77952_i() == data.getOutput().func_77952_i()) {
                ((ItemStack)this.inventory.get(2)).func_190917_f(data.getOutput().func_77946_l().func_190916_E());
            }
            if (((ItemStack)this.inventory.get(1)).func_77973_b().func_77634_r()) {
                this.inventory.set(1, (Object)new ItemStack(((ItemStack)this.inventory.get(1)).func_77973_b().func_77668_q()));
            } else {
                ((ItemStack)this.inventory.get(1)).func_190918_g(1);
            }
            if (((ItemStack)this.inventory.get(1)).func_190916_E() <= 0) {
                this.func_70304_b(1);
            }
        }
    }

    public boolean isFreezing() {
        return this.freezing;
    }

    public static boolean isFuel(ItemStack stack) {
        return TileEntityFreezer.getFuelTime(stack) > 0;
    }

    private static int getFuelTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150403_cj)) {
            return 3000;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150432_aD)) {
            return 2000;
        }
        if (stack.func_77973_b() == FurnitureItems.COOL_PACK) {
            return 400;
        }
        return 0;
    }

    public void func_73660_a() {
        if (this.freezing) {
            if (!this.canFreeze()) {
                this.freezing = false;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                return;
            }
            ++this.progress;
            if (this.progress >= 200) {
                this.freezeItem();
                this.progress = 0;
            }
            --this.timeRemaining;
            if (this.timeRemaining <= 0) {
                if (this.inventory.get(0) != ItemStack.field_190927_a && TileEntityFreezer.isFuel((ItemStack)this.inventory.get(0))) {
                    this.timeRemaining = this.fuelTime = TileEntityFreezer.getFuelTime((ItemStack)this.inventory.get(0));
                    ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                    if (((ItemStack)this.inventory.get(0)).func_190916_E() <= 0) {
                        this.func_70304_b(0);
                    }
                } else {
                    this.timeRemaining = 0;
                    this.freezing = false;
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                }
            }
        } else if (this.progress > 0) {
            --this.progress;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.freezing = tagCompound.func_74767_n("Freezing");
        this.progress = tagCompound.func_74762_e("Progress");
        this.fuelTime = tagCompound.func_74762_e("FuelTime");
        this.timeRemaining = tagCompound.func_74762_e("Remaining");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("Freezing", this.freezing);
        tagCompound.func_74768_a("Progress", this.progress);
        tagCompound.func_74768_a("FuelTime", this.fuelTime);
        tagCompound.func_74768_a("Remaining", this.timeRemaining);
        return tagCompound;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return slots_bottom;
        }
        return slots_sides;
    }

    public boolean func_180462_a(int slotIn, ItemStack stack, EnumFacing side) {
        if (this.func_174893_q_()) {
            return false;
        }
        if (side != EnumFacing.DOWN) {
            if (slotIn == 0) {
                return TileEntityFreezer.isFuel(stack);
            }
            if (slotIn == 1) {
                return RecipeAPI.getFreezerRecipeFromInput(stack) != null;
            }
        }
        return false;
    }

    public boolean func_180461_b(int slotId, ItemStack stack, EnumFacing side) {
        return side == EnumFacing.DOWN && !this.func_174893_q_();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184281_d(playerIn);
        return new ContainerFreezer((IInventory)playerInventory, this);
    }
}

