/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle;

import com.mrcrayfish.vehicle.block.BlockVehicleCrate;
import com.mrcrayfish.vehicle.client.gui.GuiHandler;
import com.mrcrayfish.vehicle.common.CommonEvents;
import com.mrcrayfish.vehicle.common.entity.HeldVehicleDataHandler;
import com.mrcrayfish.vehicle.entity.CustomDataSerializers;
import com.mrcrayfish.vehicle.entity.EntityJack;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.trailer.EntityFertilizerTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityFluidTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntitySeederTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityStorageTrailer;
import com.mrcrayfish.vehicle.entity.trailer.EntityVehicleTrailer;
import com.mrcrayfish.vehicle.entity.vehicle.EntityATV;
import com.mrcrayfish.vehicle.entity.vehicle.EntityAluminumBoat;
import com.mrcrayfish.vehicle.entity.vehicle.EntityBath;
import com.mrcrayfish.vehicle.entity.vehicle.EntityBumperCar;
import com.mrcrayfish.vehicle.entity.vehicle.EntityCouch;
import com.mrcrayfish.vehicle.entity.vehicle.EntityDirtBike;
import com.mrcrayfish.vehicle.entity.vehicle.EntityDuneBuggy;
import com.mrcrayfish.vehicle.entity.vehicle.EntityGoKart;
import com.mrcrayfish.vehicle.entity.vehicle.EntityGolfCart;
import com.mrcrayfish.vehicle.entity.vehicle.EntityJetSki;
import com.mrcrayfish.vehicle.entity.vehicle.EntityLawnMower;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMiniBike;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMiniBus;
import com.mrcrayfish.vehicle.entity.vehicle.EntityMoped;
import com.mrcrayfish.vehicle.entity.vehicle.EntityOffRoader;
import com.mrcrayfish.vehicle.entity.vehicle.EntityShoppingCart;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySmartCar;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySofacopter;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySpeedBoat;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySportsPlane;
import com.mrcrayfish.vehicle.entity.vehicle.EntityTractor;
import com.mrcrayfish.vehicle.init.ModFluids;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.init.ModTileEntities;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.proxy.Proxy;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod(modid="vehicle", name="MrCrayfish's Vehicle Mod", version="0.44.1", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:obfuscate@[0.2.5,);after:cfm@[4.1.5,);after:controllable@[0.8.0,);required-after:forge@[14.23.4.2705,)")
public class VehicleMod {
    @Mod.Instance
    public static VehicleMod instance;
    @SidedProxy(clientSide="com.mrcrayfish.vehicle.proxy.ClientProxy", serverSide="com.mrcrayfish.vehicle.proxy.ServerProxy")
    public static Proxy proxy;
    public int nextEntityId;
    public static final CreativeTabs CREATIVE_TAB;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new CommonEvents());
        ModFluids.register();
        PacketHandler.init();
        CustomDataSerializers.register();
        HeldVehicleDataHandler.register();
        ModTileEntities.register();
        this.registerVehicles();
        VehicleProperties.register();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        proxy.init();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    private void registerVehicles() {
        this.registerVehicle("atv", EntityATV.class);
        this.registerVehicle("dune_buggy", EntityDuneBuggy.class);
        this.registerVehicle("go_kart", EntityGoKart.class);
        this.registerVehicle("shopping_cart", EntityShoppingCart.class);
        this.registerVehicle("mini_bike", EntityMiniBike.class);
        this.registerVehicle("bumper_car", EntityBumperCar.class);
        this.registerVehicle("jet_ski", EntityJetSki.class);
        this.registerVehicle("speed_boat", EntitySpeedBoat.class);
        this.registerVehicle("aluminum_boat", EntityAluminumBoat.class);
        this.registerVehicle("smart_car", EntitySmartCar.class);
        this.registerVehicle("lawn_mower", EntityLawnMower.class);
        this.registerVehicle("moped", EntityMoped.class);
        this.registerVehicle("sports_plane", EntitySportsPlane.class);
        this.registerVehicle("golf_cart", EntityGolfCart.class);
        this.registerVehicle("off_roader", EntityOffRoader.class);
        this.registerVehicle("tractor", EntityTractor.class);
        this.registerVehicle("mini_bus", EntityMiniBus.class);
        this.registerVehicle("dirt_bike", EntityDirtBike.class);
        if (Loader.isModLoaded((String)"cfm")) {
            this.registerVehicle("couch", EntityCouch.class);
            this.registerVehicle("bath", EntityBath.class);
            this.registerVehicle("sofacopter", EntitySofacopter.class);
        }
        this.registerVehicle("trailer", EntityVehicleTrailer.class);
        this.registerVehicle("storage_trailer", EntityStorageTrailer.class);
        this.registerVehicle("seeder_trailer", EntitySeederTrailer.class);
        this.registerVehicle("fertilizer_trailer", EntityFertilizerTrailer.class);
        this.registerVehicle("fluid_trailer", EntityFluidTrailer.class);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("vehicle", "jack"), EntityJack.class, (String)"vehicle.jack", (int)this.nextEntityId++, (Object)this, (int)256, (int)1, (boolean)true);
    }

    private void registerVehicle(String id, Class<? extends EntityVehicle> clazz) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("vehicle", id), clazz, (String)("vehicle." + id), (int)this.nextEntityId++, (Object)this, (int)256, (int)1, (boolean)true);
        BlockVehicleCrate.registerVehicle(id);
    }

    static {
        CREATIVE_TAB = new CreativeTabs("tabVehicle"){

            public ItemStack func_78016_d() {
                return new ItemStack(ModItems.SMALL_ENGINE);
            }

            public void func_78018_a(NonNullList<ItemStack> items) {
                super.func_78018_a(items);
                items.add((Object)FluidUtil.getFilledBucket((FluidStack)new FluidStack(ModFluids.BLAZE_JUICE, 1)));
                items.add((Object)FluidUtil.getFilledBucket((FluidStack)new FluidStack(ModFluids.ENDER_SAP, 1)));
                items.add((Object)FluidUtil.getFilledBucket((FluidStack)new FluidStack(ModFluids.FUELIUM, 1)));
            }
        };
        FluidRegistry.enableUniversalBucket();
    }
}

