/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.item;

import com.mrcrayfish.vehicle.VehicleMod;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemJerryCan
extends Item {
    private final DecimalFormat FUEL_FORMAT = new DecimalFormat("0.#%");
    private final int capacity;
    private final int fillRate;

    public ItemJerryCan(String id, int capacity, int fillRate) {
        this.func_77655_b(id.replace(":", "."));
        this.setRegistryName(id);
        this.func_77625_d(1);
        this.func_77637_a(VehicleMod.CREATIVE_TAB);
        this.capacity = capacity;
        this.fillRate = fillRate;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (GuiScreen.func_146272_n()) {
            String info = I18n.func_135052_a((String)(this.func_77658_a() + ".info"), (Object[])new Object[0]);
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 150));
        } else {
            String currentFuel = TextFormatting.RESET + this.FUEL_FORMAT.format((float)this.getCurrentFuel(stack) / (float)this.getCapacity(stack));
            tooltip.add(TextFormatting.AQUA + TextFormatting.BOLD.toString() + I18n.func_135052_a((String)(this.func_77658_a() + ".fuel"), (Object[])new Object[]{currentFuel}));
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0]));
        }
    }

    public int getCurrentFuel(ItemStack stack) {
        NBTTagCompound tagCompound;
        if (!stack.func_190926_b() && stack.func_77973_b() == this && (tagCompound = stack.func_77978_p()) != null) {
            return tagCompound.func_74762_e("fuel");
        }
        return 0;
    }

    public boolean isFull(ItemStack stack) {
        return this.getCurrentFuel(stack) == this.getCapacity(stack);
    }

    public int fill(ItemStack stack, int fuel) {
        int capacity = this.getCapacity(stack);
        int currentFuel = this.getCurrentFuel(stack);
        int newFuel = Math.min(currentFuel + fuel, capacity);
        NBTTagCompound tagCompound = ItemJerryCan.createTagCompound(stack);
        tagCompound.func_74768_a("fuel", newFuel);
        return Math.max(0, currentFuel + fuel - capacity);
    }

    public int drain(ItemStack stack, int maxAmount) {
        int currentFuel = this.getCurrentFuel(stack);
        int remainingFuel = Math.max(0, currentFuel - maxAmount);
        NBTTagCompound tagCompound = ItemJerryCan.createTagCompound(stack);
        tagCompound.func_74768_a("fuel", remainingFuel);
        return currentFuel - remainingFuel;
    }

    public static void setCurrentFuel(ItemStack stack, int fuel) {
        NBTTagCompound tagCompound = ItemJerryCan.createTagCompound(stack);
        tagCompound.func_74768_a("fuel", fuel);
    }

    public int getCapacity(ItemStack stack) {
        NBTTagCompound tagCompound;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemJerryCan && (tagCompound = stack.func_77978_p()) != null && tagCompound.func_150297_b("capacity", 3)) {
            int capacity = tagCompound.func_74762_e("capacity");
            return capacity > 0 ? capacity : this.capacity;
        }
        return this.capacity;
    }

    public int getFillRate(ItemStack stack) {
        NBTTagCompound tagCompound;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemJerryCan && (tagCompound = stack.func_77978_p()) != null && tagCompound.func_150297_b("fillRate", 3)) {
            int fillRate = tagCompound.func_74762_e("fillRate");
            return fillRate > 0 ? fillRate : this.fillRate;
        }
        return this.fillRate;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74776_a("fuel", (float)this.capacity);
            ItemStack stack = new ItemStack((Item)this);
            stack.func_77982_d(tagCompound);
            items.add((Object)stack);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            float fuel = tagCompound.func_74762_e("fuel");
            return fuel < (float)this.capacity;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            float fuel = tagCompound.func_74762_e("fuel");
            return 1.0 - (double)fuel / (double)this.capacity;
        }
        return 1.0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public static NBTTagCompound createTagCompound(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }
}

