/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.net.MessagePartialImage;
import de.maxhenkel.camera.proxy.CommonProxy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ScreenShotHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="camera", value={Side.CLIENT})
public class ImageTaker {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static boolean takeScreenshot;
    private static UUID uuid;
    private static boolean hide;

    public static void takeScreenshot(UUID id) {
        Minecraft mc = Minecraft.func_71410_x();
        hide = mc.field_71474_y.field_74319_N;
        mc.field_71474_y.field_74319_N = true;
        takeScreenshot = true;
        uuid = id;
        mc.func_147108_a(null);
    }

    @SubscribeEvent
    public static void onRenderTickEnd(TickEvent.RenderTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        if (!takeScreenshot) {
            return;
        }
        BufferedImage image = ScreenShotHelper.func_186719_a((int)ImageTaker.mc.field_71443_c, (int)ImageTaker.mc.field_71440_d, (Framebuffer)mc.func_147110_a());
        ImageTaker.mc.field_71474_y.field_74319_N = hide;
        takeScreenshot = false;
        new Thread(() -> ImageTaker.sendScreenshot(image), "ProcessScreenshotThread").start();
    }

    private static void sendScreenshot(BufferedImage image) {
        byte[] data;
        if (image.getWidth() > 1080) {
            float ratio = (float)image.getHeight() / (float)image.getWidth();
            int newHeight = (int)(1080.0f * ratio);
            image = ImageTools.resize(image, 1080, newHeight);
        }
        try {
            data = ImageTools.toBytes(image);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int size = data.length;
        if (size < 30000) {
            CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessagePartialImage(uuid, 0, size, data));
        } else {
            int bufferProgress = 0;
            byte[] currentBuffer = new byte[30000];
            for (int i = 0; i < size; ++i) {
                if (bufferProgress >= currentBuffer.length) {
                    CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessagePartialImage(uuid, i - currentBuffer.length, data.length, currentBuffer));
                    bufferProgress = 0;
                    currentBuffer = new byte[currentBuffer.length];
                }
                currentBuffer[bufferProgress] = data[i];
                ++bufferProgress;
            }
            if (bufferProgress > 0) {
                byte[] rest = new byte[bufferProgress];
                System.arraycopy(currentBuffer, 0, rest, 0, bufferProgress);
                CommonProxy.simpleNetworkWrapper.sendToServer((IMessage)new MessagePartialImage(uuid, size - rest.length, data.length, rest));
            }
        }
    }
}

